'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_imp_bugdoc.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:25 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**                                                                **
'** owner : helge.delfs@sun.com                                    **
'**                                                                **
'** short description : imports every Document from given path     **
'**                                                                **
'********************************************************************
'**                                                                **
' #1 tLoadAllDocuments (SourcePath as string )                     **
' #1 tLoadBugdoc
' #1 wwFileOpen                                                    **
'**                                                                **
'\*******************************************************************

sub tLoadAllDocuments ( SourcePath as string )
    Dim  i as integer, x as integer

    printlog "SourcePath: " & SourcePath
    Call GetAllFileList(SourcePath, "*.*" , SourceDocument())
    x = ListCount ( SourceDocument() )
    printlog "- " + x + " Documents will be loaded!"
    for i = 1 to x
        printlog "(" & i & "/" & x & "): " & SourceDocument(i)
        Call tLoadBugdoc(SourceDocument(i))
        Sleep 5
    next i
end sub


' ****************************************************************************************

testcase tLoadBugdoc ( SourceFile )
    Dim OnlyFileName as string, OnlyFileExtension as string, TempFileName as String
    Dim i as integer

    TempFileName = SourceFile
    OnlyFileName = DateiOhneExt(DateiExtract(SourceFile)
    OnlyFileExtension = GetExtention(TempFileName)
    printLog "- " + SourceFile + "(" + OnlyFileName + "." + OnlyFileExtension + ")"
    ' Maybe Filename is empty
    if OnlyFileName > "" then
        ' Some extensions make no sense to load
        if OnlyFileExtension <> "so" and OnlyFileExtension <> "tmp" then
            if wwFileOpen( SourceFile ) = TRUE then
                IsItLoaded
                if (hIsNamedDocLoaded (SourceFile)) then
                    printlog "-  loaded"
                    Sleep 15 ' TBO was 5 before... hope there are now less errors :-)
                    Call hCloseDocument
                else
                    warnlog OnlyFileName + " not loaded!"
                    printlog "second stage: " + SourceFile
                    if GetDocumentCount > 1 then
                        Do Until GetDocumentCount = 1
                            Call hCloseDocument
                        Loop
                    endif
                endif
            else
                warnlog OnlyFileName + " doc not loaded!"
                printlog "first stage: " + SourceFile
                if GetDocumentCount > 1 then
                    Do Until GetDocumentCount = 1
                        Call hCloseDocument
                    Loop
                endif
            endif
        else
            printlog "(" + OnlyFileName + "." + OnlyFileExtension + ") will not be loaded"
            if GetDocumentCount > 1 then
                Do Until GetDocumentCount = 1
                    Call hCloseDocument
                Loop
            endif
        endif
    endif
endcase

' ****************************************************************************************

function wwFileOpen ( DocName$, optional Verknuepft as Boolean  ) as boolean
    Dim SourceFile as String
    Dim Dummy as Boolean
    Dim isMis as Boolean

    SourceFile = ConvertPath ( DocName$ )

    isMis = FALSE

    Dummy = TRUE
    if hFileExists ( SourceFile ) = FALSE then
        Warnlog "hDateiOeffnen(): '" + SourceFile + "' does not exists!"
        Dummy = FALSE
    else
        if IsMissing ( Verknuepft ) = TRUE then
            Verknuepft = FALSE
            isMis = TRUE
        end if

        FileOpen
        sleep (1)
        Kontext "OeffnenDlg"
        Dateiname.SetText SourceFile
        sleep (3)
        Oeffnen.Click
        sleep (20)

        Kontext "AsciiFilterOptionen"
        if AsciiFilterOptionen.Exists then
            printlog "- Ascii Filter Dialog is up!"
            AsciiFilterOptionen.Ok
        endif

        Kontext "FilterAuswahl"
        if FilterAuswahl.Exists then
            printlog "- Filter Dialog is up!"
            FilterAuswahl.Close
        endif

        Kontext "Active"
        if Active.Exists(3) then
            if isMis = FALSE then
                PrintLog "hDateiOeffnen(): " + Active.GetText
            else
                Warnlog "hDateiOeffnen(): " + Active.GetText
            end if
            try
                Active.OK
            catch
                if Verknuepft = FALSE then
                    Active.No              ' z.B. Verknuepfungen werden nicht aktualisiert
                else
                    Active.Yes             ' z.B. Verknuepfungen werden aktualisiert
                end if
            endcatch
            Kontext "OeffnenDlg"
            if OeffnenDlg.Exists(1) then
                OeffnenDlg.Cancel
                Dummy = FALSE
                Warnlog "hDateiOeffnen(): The File-Open-Dialog is open!"
            end if
        end if
    end if

    if Dummy = TRUE then
        wwFileOpen = True
    else
        wwFileOpen = FALSE
    end if
end function
