'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_undo_history_1.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: hde $ $Date: 2005/10/06 14:07:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer Undo-History - Test ( Typing, Overwrite, Replace, Delete, Sort, Convert To table)
'*
'\***********************************************************************


sub w_undo_history_1

	' a < 20 characters long string
	Call tUndoHistory1		' Typing & Overwrite
	Call tUndoHistory2		' Replace
	Call tUndoHistory3		' Replace all & Delete
	Call tUndoHistory4		' Sort
	Call tUndoHistory5		' Text convert to table


end sub



testcase tUndoHistory1

	'/// new document
	Call hNewDocument
	'/// <U><B>CHECK: Typing</B></U>
	printlog "- TYPING"
	'/// write a < 20 characters long string: If20CharactersThere
	Call wDokSchreiben ( "If20CharactersThere" )
	'/// string in Undo list has to be: Typing: If20CharactersThere
	Call CheckUndoStringInUndoList ( 1, "'If20Char...rsThere'" )

	'/// <U><B>CHECK: Overwrite</B></U>
	printlog "- OVERWRITE"
	'/// press 'Home' key
	Call wDokSchreiben "<Home>"
	'/// press 'Ins' key
	Call wDokSchreiben "<Insert>"
	'/// write a < 20 characters long string: IsThatDifferent4You
	Call wDokSchreiben ( "IsThatDifferent4You" )
	'/// string in Undo list has to be: Overwrite: IsThatDifferent4You
	Call CheckUndoStringInUndoList ( 2, "'IsThatDifferent4You'" )	

	'/// CloseDocument	
	Call hCloseDocument
	
endcase	


testcase tUndoHistory2

	'/// new Document
	'/// <U><B>CHECK: Replace</B></U>
	printlog "- REPLACE"
	Call hNewDocument
	'/// write a < 20 characters long string: If20CharactersThere
	Call wDokSchreiben ( "If20CharactersThere" )
	'/// Select text
	Call wDokSchreiben ( "<Shift Home>" )
	'/// Edit / Find and Replace 	
	EditSearchAndReplace
	Kontext "FindAndReplace"
	'/// Type 'ThisReplacementText' in 'Replace with' field
	ReplaceWith.Settext "ThisReplacementText"
	'/// Choose Button 'Replace' and close dialog
	Replace.Click
	wait 500
	Kontext "Active"
	if Active.Exists then
		if Active.GetRT = 304 then
			try
				Active.Yes
			catch
				Active.Ok
			endcatch
		endif
	endif
	Kontext "FindAndReplace"
	FindAndReplace.Close
	Kontext "DocumentWriter"
	'/// string in Undo list has to be: Replace: 'IsThatDifferent4You' -> 'ThisReplacementText'
	Call CheckUndoStringInUndoList ( 3, "'If20CharactersThere' -> 'ThisReplacementText'" )
		
	'/// Close document
	Call hCloseDocument
	
endcase


testcase tUndoHistory3
	Dim CheckString as string
	
	'///  new document
	'/// <U><B>CHECK: Replace all</B></U>
	printlog "- REPLACE ALL"
	Call hNewDocument
	'/// Insert the dummy text and point cursor at the top of the document
	Call wBlindtextEinfuegen
	Call wDokSchreiben ( "<Mod1 Home>" )
	'/// Edit / Find and Replace 	
	EditSearchAndReplace
	Kontext "FindAndReplace"
	'/// Type 'and' in 'Search for' field
	SearchFor.Settext "and"
	'/// Type 'ThisReplacementText' in 'Replace with' field
	ReplaceWith.Settext "###"
	'/// Choose Button 'Replace' and close dialog
	ReplaceAll.Click
	wait 500
	Kontext "Active"
	if Active.Exists then
		if Active.GetRT = 304 then Active.Ok
	endif
	Kontext "FindAndReplace"
	FindAndReplace.Close
	
	Kontext "DocumentWriter"
	'/// string in Undo list has to be: Replace: '14 occurences of and'
	Call CheckUndoStringInUndoList ( 5, "14 occurences of 'and'" )
		
	'/// <U><B>CHECK: Delete</B></U>	
	'///  Backspace 4 times to delete characters
	Call wDokSchreiben "<Backspace>", 4
	'/// string in Undo list has to be: Delete: '###'
	printlog "- DELETE"
	Call CheckUndoStringInUndoList ( 4, "' ###'" )	 	

	
	'/// Close document
	Call hCloseDocument
	

endcase


testcase tUndoHistory4

	'/// new document
	Call hNewDocument
	'/// CHECK: Text sort
	printlog "- TEXT SORT"
	'/// Enter some text like "This<Return>is a<Return>test<Return>"
	Call wDokSchreiben ( "This" ) 
	Call wDokSchreiben ( "<Return>" ) 
	Call wDokSchreiben ( "is a" ) 
	Call wDokSchreiben ( "<Return>" )
	Call wDokSchreiben ( "test" )
	Call wDokSchreiben ( "<Return>" )
	'/// Select all and Tools -> Sort
	Call wDokSchreiben ( "<Mod1 A>" )
	ToolsSort
    Kontext "Sortieren"
    Sortieren.Ok
	
	'/// string in Undo list has to be: "Sort text"
	Call CheckUndoStringInUndoList ( 6, "Sort text" )
	
	'/// Close document
	Call hCloseDocument	

endcase


testcase tUndoHistory5

	'/// new document
	Call hNewDocument
	'/// CHECK: Text convert to table
	printlog "TEXT CONVERT TO TABLE"
	'/// Enter some text like "This<Return>is a<Return>test<Return>"
	Call wDokSchreiben ( "This" ) 
	Call wDokSchreiben ( "<Return>" ) 
	Call wDokSchreiben ( "is a" ) 
	Call wDokSchreiben ( "<Return>" )
	Call wDokSchreiben ( "test" )
	Call wDokSchreiben ( "<Return>" )
	'/// Select all and Tools - Text <> Table
	Call wDokSchreiben ( "<Mod1 A>" )
	ToolsTextInTable
	Kontext "TextInTabelleUmwandeln"
	Absatz.Check
	TextInTabelleUmwandeln.Ok
	'/// string in Undo list has to be: "Convert text -> table"
	Call CheckUndoStringInUndoList ( 7, "Convert text -> table" )
	
	'/// Close document
	Call hCloseDocument	

endcase
