'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_106c_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:28:26 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Level 1 - Tools - Menu
'*
'\***********************************************************************

sub w_106c_
   printLog Chr(13) + "---------   Level 1 - Tools - Menu (4)   ----------"

   Call tToolsSort1                         ' Text in one Column and 1 Key
   Call tToolsSort2                         ' Numbers in 1 Column and 1 Key
   Call tToolsSort3                         ' Text in several Columns and 3 Keys
   Call tToolsSort4                         ' Table with Header ( Text and Numbers mixed )
   Call tToolsSort5                         ' Table without Header ( Text and Numbers mixed )
   Call tToolsSort6                         ' Copy sorted table in another table
   Call tToolsCalculate1                    ' Calculating in Document
   Call tToolsCalculate2                    ' Calculating from Toolbar
   Call tToolsCalculate3                    ' Calculationg from Formula-Button

   Call tToolsUpdate1                       ' Update current Index Inhaltsverzeichnis
   Call tToolsUpdate2                       ' Update current Stichwortverzeichnis
   Call tToolsUpdate3                       ' Update current Benutzerverzeichnis
   Call tToolsUpdateAll                     ' Update all Indexes
   Call tToolsUpdateOrder                   ' Update Indexorder

end sub

' *******************************************************************

testcase tToolsSort1
  PrintLog "- Tools / Sort normal Text ( 1. Column )"

  Printlog "   - alphanumeric ascending ( Key 1 )"
   Call hNewDocument
   Call wDokSchreiben "Ohallo<Return>Ahallo<Return>Ghallo<Return>Zhallo<Return>Shallo<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Schluessel2.UnCheck
   Schluessel3.UnCheck
   Spalte1.SetText "1"
   Schluesseltyp1.Select 1
   Aufsteigend1.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( FALSE )

  Printlog "   - alphanumeric descending ( Key 1 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "1"
   Schluesseltyp1.Select 1
   Absteigend1.Check
   Sortieren.OK
   AbsteigendKontrollieren ( FALSE )

  Printlog "   - alphanumeric ascending ( Key 2 )"
   Call wDokSchreiben "<Mod1 a><Delete>"
   Sleep 1
   Call wDokSchreiben "Ohallo<Return>Ahallo<Return>Ghallo<Return>Zhallo<Return>Shallo<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel2.Check
   Schluessel1.Uncheck
   Schluessel3.UnCheck
   Spalte2.SetText "1"
   Schluesseltyp2.Select 1
   Aufsteigend2.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( FALSE )

  Printlog "   - alphanumeric descending ( Key 2 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Spalte2.SetText "1"
   Schluesseltyp2.Select 1
   Absteigend2.Check
   Sortieren.OK
   AbsteigendKontrollieren ( FALSE )

  Printlog "   - alphanumeric ascending ( Key 3 )"
   Call wDokSchreiben "<Mod1 a><Delete>"
   Sleep 1
   Call wDokSchreiben "Ohallo<Return>Ahallo<Return>Ghallo<Return>Zhallo<Return>Shallo<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel3.Check
   Schluessel1.UnCheck
   Schluessel2.UnCheck
   Spalte3.SetText "1"
   Schluesseltyp3.Select 1
   Aufsteigend3.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( FALSE )

  Printlog "   - alphanumeric descending ( Key 3 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel3.Check
   Schluessel1.Uncheck
   Schluessel2.UnCheck
   Spalte3.SetText "1"
   Schluesseltyp3.Select 1
   Absteigend3.Check
   Sortieren.OK
   Call AbsteigendKontrollieren ( FALSE )

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSort2
  PrintLog "- Tools / Sorting numbers ( 1. Column )"

  Printlog "   - numeric ascending ( Key 1 )"
   Call hNewDocument
   Call wDokSchreiben "43<Return>54<Return>23<Return>65<Return>56<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "1"
   Schluesseltyp1.Select 2
   Aufsteigend1.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( TRUE )

  Printlog "   - numeric descending ( Key 1 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "1"
   Schluesseltyp1.Select 2
   Absteigend1.Check
   Sortieren.OK
   Call AbsteigendKontrollieren ( TRUE )

  Printlog "   - numeric ascending ( Key 2 )"
   Call wDokSchreiben "<Mod1 a><Delete>"
   Sleep 1
   Call wDokSchreiben "43<Return>54<Return>23<Return>65<Return>56<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Uncheck
   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2
   Aufsteigend2.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( TRUE )

  Printlog "   - numeric descending ( Key 2 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Uncheck
   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2
   Absteigend2.Check
   Sortieren.OK
   Call AbsteigendKontrollieren ( TRUE )

  Printlog "   - numeric ascending ( Key 3 )"
   Call wDokSchreiben "<Mod1 a><Delete>"
   Sleep 1
   Call wDokSchreiben "43<Return>54<Return>23<Return>65<Return>56<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Uncheck
   Schluessel2.UnCheck
   Schluessel3.Check
   Spalte3.SetText "1"
   Schluesseltyp3.Select 2
   Aufsteigend3.Check
   Sortieren.OK
   Call AufsteigendKontrollieren ( TRUE )

  Printlog "   - numeric descending ( Key 3 )"
   Call wDokSchreiben "<Mod1 a>"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Uncheck
   Schluessel2.UnCheck
   Schluessel3.Check
   Spalte3.SetText "1"
   Schluesseltyp3.Select 2
   Absteigend3.Check
   Sortieren.OK
   Call AbsteigendKontrollieren ( TRUE )

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSort3
  Dim i as Integer : Dim Trennzeichen as String
  PrintLog "- Tools / Sorting text in several lines"

   for i=1 to 3
      select case i
         case 1: Printlog "  - Seperator is a tabulator"
         case 2: Printlog "  - Seperator is a semicolon"
                 Trennzeichen = ";"
         case 3: Printlog "  - Seperator is a '|'"
                 Trennzeichen = "|"
      end select
      if gApplication = "WRITER" then
       Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\st1_5.sxw" )
      else
       Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\st1_5.sxg" )
      endif
      if i <> 1 then TrennzeichenSetzen ( Trennzeichen )

     Printlog "     - alphanumeric ascending after 1.Column, followed by 4.Column and 3. Column"
      Call wDokSchreiben "<Mod1 a>"
      ToolsSort
      Kontext "Sortieren"
      Schluessel1.Check
      Spalte1.SetText "1"
      Schluesseltyp1.Select 1
      Aufsteigend1.Check

      Schluessel2.Check
      Spalte2.SetText "4"
      Schluesseltyp2.Select 1
      Aufsteigend2.Check

      Schluessel3.Check
      Spalte3.SetText "3"
      Schluesseltyp3.Select 1
      Aufsteigend3.Check

      if i=1 then
         Tabulator.Check
      else
         Zeichen.Check
         ZeichenText.SetText Trennzeichen
      end if
      Sortieren.OK
      Call AufSortierungPruefen(i)
      Call UndoRichtigBeiSortierung

     Printlog "     - alphanumeric descending 1.Column, followed by 4. column and 3. column"
      ToolsSort
      Kontext "Sortieren"
      Schluessel1.Check
      Spalte1.SetText "1"
      Schluesseltyp1.Select 1

      Schluessel2.Check
      Spalte2.SetText "4"
      Schluesseltyp2.Select 1

      Schluessel3.Check
      Spalte3.SetText "3"
      Schluesseltyp3.Select 1

      Absteigend1.Check
      Absteigend2.Check
      Absteigend3.Check
      if i=1 then
         Tabulator.Check
      else
         Zeichen.Check
         ZeichenText.SetText Trennzeichen
      end if
      Sortieren.OK
      Call AbSortierungPruefen(i)
      Call UndoRichtigBeiSortierung
      Call hCloseDocument
   next i

   'Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSort4
  PrintLog "- Tools / Sorting in table with header"

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\sortieren.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\sortieren.sxg" )
   endif
   Call wDokSchreiben "<Mod1 a>", 2
  Printlog "   - 3. column alphanum., 1. column num., 3. column alphanum. ascending"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "3"
   Schluesseltyp1.Select 1

   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2

   Schluessel3.Check
   Spalte3.SetText "2"
   Schluesseltyp3.Select 1
   Aufsteigend1.Check
   Aufsteigend2.Check
   Aufsteigend3.Check
   if Tabulator.IsEnabled then Warnlog "Tabs is active"
   if Zeichen.IsEnabled then Warnlog "Char is active"
   Sortieren.OK

  Printlog "   - Check"
   Call wDokSchreiben "<Mod1 a>", 3   ' Umstellung zur 5.0 Cursor steht nach Sortierung in der letzten Zelle, mit 3*Ctrl_A kommt man in die 1.
   wait 100
   EditCopy
   if GetClipboardText <> "1" then Warnlog "Header of the first column has been sorted"
   if ZelleRuntertesten("2") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("4") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("5") = FALSE then Warnlog "1/4 is wrong"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/5 is wrong"
   if ZelleRuntertesten("6") = FALSE then Warnlog "1/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "a" then Warnlog "Header of the 2. column has not been sorted"
   if ZelleRuntertesten("a") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/4 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/5 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "zz" then Warnlog "Header der 3. column has not been sorted"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/4 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/5 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/6 is wrong"

  Printlog "   - 3. column alphanum., 1. column num., 3. column alphanum. descending"
   Call wDokSchreiben "<Left Right>"
   Call wDokSchreiben "<Mod1 a>", 2
   Sleep 2
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "3"
   Schluesseltyp1.Select 1

   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2

   Schluessel3.Check
   Spalte3.SetText "2"
   Schluesseltyp3.Select 1
   Absteigend1.Check
   Absteigend2.Check
   Absteigend3.Check
   Sortieren.OK

  Printlog "   - check"
   Call wDokSchreiben "<up><Left>", 6
   Call wDokSchreiben "<Mod1 a>"
   wait 100
   EditCopy
   if GetClipboardText <> "1" then Warnlog "Header of the 1. column has been sorted"
   if ZelleRuntertesten("6") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("5") = FALSE then Warnlog "1/4 is wrong"
   if ZelleRuntertesten("4") = FALSE then Warnlog "1/5 is wrong"
   if ZelleRuntertesten("2") = FALSE then Warnlog "1/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "a" then Warnlog "Header of the 2. column has not been sorted"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/4 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/5 is wrong"
   if ZelleRuntertesten("a") = FALSE then Warnlog "2/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "zz" then Warnlog "Header of the 3. column has not been sorted"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/4 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/5 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/6 is wrong"
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSort5
  PrintLog "- Tools / Sorting in table without header"

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\sortieren.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\sortieren.sxg" )
   endif
   Call wDokSchreiben "<Down>", 20
   Call wDokSchreiben "<Up>", 6
   Call wDokSchreiben "<Mod1 a>", 2
  Printlog "   - 3. column alphanum., 1. column num., 2. column alphanum. ascending"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "3"
   Schluesseltyp1.Select 1

   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2

   Schluessel3.Check
   Spalte3.SetText "2"
   Schluesseltyp3.Select 1
   Aufsteigend1.Check
   Aufsteigend2.Check
   Aufsteigend3.Check
   if Tabulator.IsEnabled then Warnlog "'Tabs' is active when table is selected"
   if Zeichen.IsEnabled then Warnlog "'Character' is active when table is selected"
   Sortieren.OK

  Printlog "   - check"
   Call wDokSchreiben "<Down>", 7
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Mod1 a>"
   wait 100
   EditCopy

   if GetClipboardText <> "2" then Warnlog "1/1 is wrong!"
   if ZelleRuntertesten("4") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("5") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("1") = FALSE then Warnlog "1/4 is wrong"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/5 is wrong"
   if ZelleRuntertesten("6") = FALSE then Warnlog "1/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "a" then Warnlog "2/1 is wrong!"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("a") = FALSE then Warnlog "2/4 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/5 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "xx" then Warnlog "3/1 is wrong!"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/4 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/5 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/6 is wrong"


  Printlog "   - 3. column alphanum., 1. column num., 2. column alphanum. descending"
   Call wDokSchreiben "<Left><Right>"
   Call wDokSchreiben "<Mod1 a>", 2
   Sleep 2
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "3"
   Schluesseltyp1.Select 1

   Schluessel2.Check
   Spalte2.SetText "1"
   Schluesseltyp2.Select 2

   Schluessel3.Check
   Spalte3.SetText "2"
   Schluesseltyp3.Select 1
   Absteigend1.Check
   Absteigend2.Check
   Absteigend3.Check
   Sortieren.OK

  Printlog "   - check"
   Call wDokSchreiben "<Down>", 7
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Mod1 a>"
   wait 100
   EditCopy
   if GetClipboardText <> "6" then Warnlog "1/1 is wrong!"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("1") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("5") = FALSE then Warnlog "1/4 is wrong"
   if ZelleRuntertesten("4") = FALSE then Warnlog "1/5 is wrong"
   if ZelleRuntertesten("2") = FALSE then Warnlog "1/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "c" then Warnlog "2/1 is wrong!"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("a") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("c") = FALSE then Warnlog "2/4 is wrong"
   if ZelleRuntertesten("b") = FALSE then Warnlog "2/5 is wrong"
   if ZelleRuntertesten("a") = FALSE then Warnlog "2/6 is wrong"
   Call wDokSchreiben "<Right>"
   Call wDokSchreiben "<up>", 5
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "zz" then Warnlog "3/1 is wrong!"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/4 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/5 is wrong"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/6 is wrong"
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsSort6
  PrintLog "- Tools / Sort a sorted table and copy in another one"

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\st1_7.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\st1_7.sxg" )
   endif
   Call wDokSchreiben "<Mod1 a>", 2
  Printlog "   - Sort 1. column numeric descending"
   ToolsSort
   Kontext "Sortieren"
   Schluessel1.Check
   Spalte1.SetText "1"
   Schluesseltyp1.Select 2
   Absteigend1.Check
   Absteigend2.Check
   Absteigend3.Check
   Sortieren.OK

  Printlog "   - check"
   Call wDokSchreiben "<Mod1 a>", 3
   wait 100
   EditCopy
   if GetClipboardText <> "4" then Warnlog "Header of the 1. column has not been sorted"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("2") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("1") = FALSE then Warnlog "1/4 is wrong"
   Call wDokSchreiben "<Tab>"
   Call wDokSchreiben "<up>", 3
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "dd" then Warnlog "Header of the 2. column has not been sorted"
   if ZelleRuntertesten("cc") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("bb") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("aa") = FALSE then Warnlog "2/4 is wrong"
   Call wDokSchreiben "<Tab>"
   Call wDokSchreiben "<up>", 3
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "ww" then Warnlog "Header of the 3 column has not been sorted"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("yy") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/4 is wrong"

  Printlog "   - copy table"
   Call wDokSchreiben "<Left Right>"
   Call wDokSchreiben "<Mod1 a>", 2
   Sleep 1
   EditCopy
   Sleep 1
  Printlog "   - insert table"
   Call wDokSchreiben "<Down>", 10
   Call wDokSchreiben "<Up>", 4
   EditPaste
   Sleep 1

  Printlog "   - check"
   Call wDokSchreiben "<Mod1 a>"
   wait 100
   EditCopy
   if GetClipboardText <> "4" then Warnlog "Header of the 1. column has not been sorted"
   if ZelleRuntertesten("3") = FALSE then Warnlog "1/2 is wrong"
   if ZelleRuntertesten("2") = FALSE then Warnlog "1/3 is wrong"
   if ZelleRuntertesten("1") = FALSE then Warnlog "1/4 is wrong"
   Call wDokSchreiben "<Tab>"
   Call wDokSchreiben "<up>", 3
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "dd" then Warnlog "Header of the 2. column has not been sorted"
   if ZelleRuntertesten("cc") = FALSE then Warnlog "2/2 is wrong"
   if ZelleRuntertesten("bb") = FALSE then Warnlog "2/3 is wrong"
   if ZelleRuntertesten("aa") = FALSE then Warnlog "2/4 is wrong"
   Call wDokSchreiben "<Tab>"
   Call wDokSchreiben "<up>", 3
   Call wDokSchreiben "<Mod1 a>"
   Wait 100
   EditCopy
   if GetClipboardText <> "ww" then Warnlog "Header of the 3 column has not been sorted"
   if ZelleRuntertesten("xx") = FALSE then Warnlog "3/2 is wrong"
   if ZelleRuntertesten("yy") = FALSE then Warnlog "3/3 is wrong"
   if ZelleRuntertesten("zz") = FALSE then Warnlog "3/4 is wrong"
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsCalculate1
  Printlog "- Tools / calculation   base functionality formula bar"

  Printlog "   - Add"
   Call hNewDocument
   Call wDokSchreiben "2+3+4+5<Shift Home>"
   ToolsCalculate
   Call wDokSchreiben "<End> = "
   EditPaste
   if GetClipboardText <> "14" then Warnlog "Result of Add is not 14 but "+ GetClipboardText

  Printlog "   - Subtract"
   Call wDokSchreiben "<Return>101-3-4-155<Shift Home>"
   ToolsCalculate
   Call wDokSchreiben "<End> = "
   EditPaste
   if GetClipboardText <> "-61" then Warnlog "Result of Subtract is not -61 but "+ GetClipboardText

  Printlog "   - multiply"
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       wDokSchreiben "<Return>11*3*1,5<Shift Home>"
      else
       wDokSchreiben "<Return>11*3*1.5<Shift Home>"
      endif
   else
      wDokSchreiben "<Return>11*3*1,5<Shift Home>"
   end if
   ToolsCalculate
   Call wDokSchreiben "<End> = "
   EditPaste
   if iSystemSprache = 01 or iSprache = 01 then
     if iSprache = 33 then
      if GetClipboardText <> "49,50" and GetClipboardText <> "49,5" then Warnlog "Result of Multiply is not 49,50 but "+ GetClipboardText
     else
      if GetClipboardText <> "49.50" and GetClipboardText <> "49.5" then Warnlog "Result of Multiply is not 49.50 but "+ GetClipboardText
     endif
   else
     if GetClipboardText <> "49,50" and GetClipboardText <> "49,5" then Warnlog "Result of Multiply is not 49,50 but "+ GetClipboardText
   end if

  Printlog "   - Division"
   Call wDokSchreiben "<Return>111/3/2<Shift Home>"
   ToolsCalculate
   Call wDokSchreiben "<End> = "
   EditPaste
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       if GetClipboardText <> "18,50" and GetClipboardText <> "18,5" then Warnlog "Result of Division not 18,50 but "+ GetClipboardText
      else
       if GetClipboardText <> "18.50" and GetClipboardText <> "18.5" then Warnlog "Result of Division not 18.50 but "+ GetClipboardText
      endif
   else
      if GetClipboardText <> "18,50" and GetClipboardText <> "18,5" then Warnlog "Result of Division not 18,50 but "+ GetClipboardText
   end if

  Printlog "   - random with brackets"
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       Call wDokSchreiben "<Return>((12*2)/4,5+3)-1,5 <Shift Home>"
      else
       Call wDokSchreiben "<Return>((12*2)/4.5+3)-1.5 <Shift Home>"
      endif
   else
      Call wDokSchreiben "<Return>((12*2)/4,5+3)-1,5 <Shift Home>"
   end if
   ToolsCalculate
   Call wDokSchreiben "<End> = "
   EditPaste
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       if Left$(GetClipboardText,4) <> "6,83" then Warnlog "Result of mixed calculation not 6,83 but "+ GetClipboardText
      else
       if Left$(GetClipboardText,4) <> "6.83" then Warnlog "Result of mixed calculation not 6.83 but "+ GetClipboardText
      endif
   else
      if Left$(GetClipboardText,4) <> "6,83" then Warnlog "Result of mixed calculation not 6,83 but "+ GetClipboardText
   end if

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsCalculate2
  Printlog "- Tools / Calculate   Basic functionality"

  Printlog "   - Add"
   Call hNewDocument
   Call wDokSchreiben "<F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.SetText "2+3+4+5" : EingabeFeld.TypeKeys "<Return>"
   if ErmittleErgebnis ( "14" ) = FALSE then Warnlog "Result of Add not 14 but "+ GetClipboardText

  Printlog "   - Subtract"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.SetText "101-3-4-155" : EingabeFeld.TypeKeys "<Return>"
   if ErmittleErgebnis ( "-61" ) = FALSE then Warnlog "Result of Subtract not -61 but "+ GetClipboardText

  Printlog "   - Multiply"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       EingabeFeld.SetText "11*3*1,5" : EingabeFeld.TypeKeys "<Return>"
      else
       EingabeFeld.SetText "11*3*1.5" : EingabeFeld.TypeKeys "<Return>"
      endif
   else
      EingabeFeld.SetText "11*3*1,5" : EingabeFeld.TypeKeys "<Return>"
   end if
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       if ErmittleErgebnis ( "49,5" ) = FALSE then Warnlog "Result of Multiplication not 49,5 but "+ GetClipboardText
      else
       if ErmittleErgebnis ( "49.5" ) = FALSE then Warnlog "Result of Multiplication not 49.5 but "+ GetClipboardText
      endif
   else
      if ErmittleErgebnis ( "49,5" ) = FALSE then Warnlog "Result of Multiplication not 49,5 but "+ GetClipboardText
   end if

  Printlog "   - Division"
   Call wDokSchreiben "<End><Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.SetText "111/3/2" : EingabeFeld.TypeKeys "<Return>"
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       if ErmittleErgebnis ( "18,5" ) = FALSE then Warnlog "Result of Division not 18,5 but "+ GetClipboardText
      else
       if ErmittleErgebnis ( "18.5" ) = FALSE then Warnlog "Result of Division not 18.5 but "+ GetClipboardText
      endif
   else
      if ErmittleErgebnis ( "18,5" ) = FALSE then Warnlog "Result of Division not 18,5 but "+ GetClipboardText
   end if

  Printlog "   - random with brackets"
   Call wDokSchreiben "<End><Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       EingabeFeld.SetText "((12*2)/4,5+3)-1,5" : EingabeFeld.TypeKeys "<Return>"
      else
       EingabeFeld.SetText "((12*2)/4.5+3)-1.5" : EingabeFeld.TypeKeys "<Return>"
      endif
   else
      EingabeFeld.SetText "((12*2)/4,5+3)-1,5" : EingabeFeld.TypeKeys "<Return>"
   end if
   if iSystemSprache = 01 or iSprache = 01 then
      if iSprache = 33 then
       if ErmittleErgebnis ( "6,83" ) = FALSE then Warnlog "Result of mixed calculation not 6,83 but "+ GetClipboardText
      else
       if ErmittleErgebnis ( "6.83" ) = FALSE then Warnlog "Result of mixed calculation not 6.83 but "+ GetClipboardText
      endif
   else
      if ErmittleErgebnis ( "6,83" ) = FALSE then Warnlog "Result of mixed calculation not 6,83 but "+ GetClipboardText
   end if

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsCalculate3
 Dim Fehlermeldung as String

  Printlog "- Tools / Calculate   Basic functionality (formula button)"

   Call hNewDocument
  Printlog "   - Sum (6)"
   Call wDokSchreiben "<F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 1 )
   Sleep 1
   EingabeFeld.TypeKeys " (6)" : EingabeFeld.TypeKeys "<Return>"
   Sleep 1
   if ErmittleErgebnis ( "6" ) = FALSE then Warnlog "Result is not 6 but "+ GetClipboardText

  Printlog "   - Sum ( <a1:B2>|<b4:r3> )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 1 )
   Sleep 1
   EingabeFeld.TypeKeys " ( <a1:B2" : EingabeFeld.TypeKeys ">|<b4:r3" : EingabeFeld.TypeKeys "> )" : EingabeFeld.TypeKeys "<Return>"
   select case iSprache
     case 01   : Fehlermeldung = "** Expression is faulty **"
     case 03   : Fehlermeldung = "** Expresso errada **"
     case 31   : Fehlermeldung = "** Foutieve uitdrukking **"
     case 33   : Fehlermeldung = "** Expression errone **"
     case 34   : Fehlermeldung = "** Expresin errnea **"
     case 39   : Fehlermeldung = "** Errore nell'espressione **"
     case 45   : Fehlermeldung = "** Fejlagtigt udtryk **"
     case 46   : Fehlermeldung = "** Felaktigt uttryck **"
     case 48   : Fehlermeldung = "** Nieprawiedlowe wyralenie **"
     case 49   : Fehlermeldung = "** Fehlerhafter Ausdruck **"
     case else : Fehlermeldung = "** Errortext for this language not defined **"
   end select

   if ErmittleErgebnis ( Fehlermeldung ) = FALSE then Warnlog "Result is not " + Fehlermeldung + " but "+ GetClipboardText
  Printlog "   - 1323,3 round 1"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   if iSprache = 01 then
       EingabeFeld.TypeKeys "1323.345 "
   else
      EingabeFeld.TypeKeys "1323,345 "
   end if
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 2 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 1" : EingabeFeld.TypeKeys "<Return>"
   if iSprache = 01 then
      if ErmittleErgebnis ( "1323.3" ) = FALSE then Warnlog "Result is not 1323.3 but "+ GetClipboardText
   else
      if ErmittleErgebnis ( "1323,3" ) = FALSE then Warnlog "Result is not 1323,3 but "+ GetClipboardText
   end if

  Printlog "   - 10 + 20 PHD ( Percent )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "10 + 20 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 3 )
   Sleep 1
   EingabeFeld.TypeKeys "<End><Return>"
   if iSprache = 01 then
      if ErmittleErgebnis ( "10.2" ) = FALSE then Warnlog "Result is not 10.2 but "+ GetClipboardText
   else
      if ErmittleErgebnis ( "10,2" ) = FALSE then Warnlog "Result is not 10,2 but "+ GetClipboardText
   end if

  Printlog "   - SQRT 144 ( Square Root )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 4 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 144 <Return>"
   if ErmittleErgebnis ( "12" ) = FALSE then Warnlog "Result is not 12 but "+ GetClipboardText

  Printlog "   - 4 POW 8 ( Power )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "4 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 5 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 8 <Return>"
   if ErmittleErgebnis ( "65536" ) = FALSE then Warnlog "Result is not 65536 but "+ GetClipboardText

 Printlog "- Tools / Calculate   Operators with formula button"
  Printlog "   - 2 EQ 2 ( equal )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "2 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 2 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 2 <Return>"
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - 2 NEQ 2 ( not equal )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "2 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 3 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 2 <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

  Printlog "   - 2 LEQ 3 ( Less than or equal )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "2 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 4 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 3 <Return>"
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - 2 GEO 2,0 ( greater than or equal )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "2 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 5 )
   Sleep 1
   if iSprache = 01 then
      if iSprache = 33 then
       EingabeFeld.TypeKeys "<End> 2,0 <Return>"
      else
       EingabeFeld.TypeKeys "<End> 2.0 <Return>"
      endif
   else
      EingabeFeld.TypeKeys "<End> 2,0 <Return>"
   end if
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - 2 L 2 ( less )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "2 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 2 <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

  Printlog "   - 2,01 g 2 ( greater )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   if iSprache = 01 then
      EingabeFeld.TypeKeys "2.01 "
   else
      EingabeFeld.TypeKeys "2,01 "
   end if
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 7 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 2 <Return>"
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - 0 OR 0 ( Boolean or )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "0 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 0 <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

  Printlog "   - 0 XOR 1 ( Boolean XOR )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "0 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 9 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 1 <Return>"
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - 1 AND 0 ( Boolean And )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "1 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 10 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 0 <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

  Printlog "   - 0 NOT 0 ( Boolean Or )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   EingabeFeld.TypeKeys "0 "
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   Call hMenuSelectNr ( 11 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 0 <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

 Printlog "- Tools / Calculate   Statistical function with formula button"
  Printlog "   - mean 30|40|20 ( Mean )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 7 )
   Sleep 1
   Call hMenuSelectNr ( 1 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 30|40|20 <Return>"
   if ErmittleErgebnis ( "30" ) = FALSE then Warnlog "Result is not 30 but "+ GetClipboardText

  Printlog "   - min 1|1,01|1,001 ( Minimum )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 7 )
   Sleep 1
   Call hMenuSelectNr ( 2 )
   Sleep 1
   if iSprache = 01 then
      EingabeFeld.TypeKeys "<End> 1|1.01|1.001 <Return>"
   else
      EingabeFeld.TypeKeys "<End> 1|1,01|1,001 <Return>"
   end if
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - max 1|1,01|1,001 ( Maximum )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 7 )
   Sleep 1
   Call hMenuSelectNr ( 3 )
   Sleep 1
   if iSprache = 01 then
      EingabeFeld.TypeKeys "<End> 1|1.01|1.001 <Return>"
      if ErmittleErgebnis ( "1.01" ) = FALSE then Warnlog "Result is not 1.01 but "+ GetClipboardText
   else
      EingabeFeld.TypeKeys "<End> 1|1,01|1,001 <Return>"
      if ErmittleErgebnis ( "1,01" ) = FALSE then Warnlog "Result is not 1,01 but "+ GetClipboardText
   end if

 Printlog "- Tools / Calculate   Further functions"
  Printlog "   - sin (PI/2) ( Sine )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 1 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> (PI/2) <Return>"
   if ErmittleErgebnis ( "1" ) = FALSE then Warnlog "Result is not 1 but "+ GetClipboardText

  Printlog "   - cos (PI/2) ( Cosine )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 2 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> (PI/2) <Return>"
   if ErmittleErgebnis ( "0" ) = FALSE then Warnlog "Result is not 0 but "+ GetClipboardText

  Printlog "   - tan (PI/2 - 0,001) ( Tangent )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 3 )
   Sleep 1
   if iSprache = 01 then
      EingabeFeld.TypeKeys "<End> (PI/2 - 0.001) <Return>"
   else
      EingabeFeld.TypeKeys "<End> (PI/2 - 0,001) <Return>"
   end if
   if ErmittleErgebnis ( "1000" ) = FALSE then Warnlog "Result is not 1000 but "+ GetClipboardText

  Printlog "   - asin 1 ( Arc-Sine )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 4 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 1 <Return>"
   if ErmittleErgebnis ( Fehlermeldung ) = FALSE then Warnlog "Result is not " + Fehlermeldung + " but "+ GetClipboardText

  Printlog "   - acos 0 ( Arc-Cosine )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 5 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 0 <Return>"
   if iSprache = 01 then
      if ErmittleErgebnis ( "1.57" ) = FALSE then Warnlog "Result is not 1.57 but "+ GetClipboardText
   else
      if ErmittleErgebnis ( "1,57" ) = FALSE then Warnlog "Result is not 1,57 but "+ GetClipboardText
   end if

  Printlog "   - asin 1 ( Arc-Tangent )"
   Call wDokSchreiben "<End> <Return><F2>"
   Kontext "OL_SW_Rechenleiste"
   Formel.Click
   Sleep 1
   Call hMenuSelectNr ( 8 )
   Sleep 1
   Call hMenuSelectNr ( 6 )
   Sleep 1
   EingabeFeld.TypeKeys "<End> 1 <Return>"
   if iSprache = 01 then
      if ErmittleErgebnis ( "0.79" ) = FALSE then Warnlog "Result is not 0.79 but "+ GetClipboardText
   else
      if ErmittleErgebnis ( "0,79" ) = FALSE then Warnlog "Result is not 0,79 but "+ GetClipboardText
   end if

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsUpdate1
  printlog "- Tools / Update current index ( Table of contents )"
   if gApplication = "WRITER" then
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\verzeichnis\v_inhalt.sxw")
   else
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\v_inhalt.sxg")
   endif

  printlog " - insert new entry"
   InsertIndexesEntry
   Call MachMirDenEintrag ( 5,1,"Inhalt" )
   EinfuegenSchliessen.Click

   Call VerzeichnisUeberNavigator(1)

  printlog " - update current index"
   sleep 1
   ToolsUpdateCurrentIndex

  printlog " - check update"
   Call wDokSchreiben "<Down>", 2
   Call wDokSchreiben "<Shift Mod1 Right>"
   EditCopy
   if Left$(GetClipboardText,6) <> "MTH900" then Warnlog "Table of contents has not been updated"
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsUpdate2
  printlog "- Tools / Update current index ( Alphabetical index )"
   if gApplication = "WRITER" then
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\verzeichnis\v_stichw.sxw")
   else
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\v_stichw.sxg")
   endif

  printlog " - insert new entry"
   InsertIndexesEntry
   Call MachMirDenEintrag ( 5,1,"Stich" )
   EinfuegenSchliessen.Click

   Call VerzeichnisUeberNavigator(1)

  printlog " - update current index"
   sleep 1
   ToolsUpdateCurrentIndex

  printlog " - check update"
   Call wDokSchreiben "<Down>", 3
   Call wDokSchreiben "<Shift Mod1 Right>"
   EditCopy
   if Left$(GetClipboardText,6) <> "MTH900" then Warnlog "Alphabetical index has not been updated"
   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsUpdate3
  printlog "- Tools / Update current index ( User-defined )"
   if gApplication = "WRITER" then
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\verzeichnis\v_benutz.sxw")
   else
    Call hDateiOeffnen (gTesttoolpath + "writer\level1\input\masterdoc\verzeichnis\v_benutz.sxg")
   endif

   Sleep 5
  printlog " - insert new entry"
   InsertIndexesEntry
   Call MachMirDenEintrag(5, 1,"Benutz")
   EinfuegenSchliessen.Click

   Call VerzeichnisUeberNavigator(1)

  printlog " - update current index"
   Sleep 2
   ToolsUpdateCurrentIndex

  printlog " - check update"
   Call wDokSchreiben "<Down>", 7
   Call wDokSchreiben "<Shift Mod1 Right>"
   EditCopy
   if Left$(GetClipboardText,6) <> "MTH900" then
     if GetClipBoardtext = "" then
      Warnlog "Update index deletes content! (bug#101054)"
     else
      Warnlog "User-defined index has not been updated"
     endif
   endif
   Call hCloseDocument

endcase

' *******************************************************************

testcase tToolsUpdateAll
  printlog "- Tools / Update all indexes"
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gtesttoolpath + "writer\level1\input\verzeichnis\verzeichnisse.sxw"
   else
    Call hDateiOeffnen ( gtesttoolpath + "writer\level1\input\masterdoc\verzeichnis\verzeichnisse.sxg"
   endif
   ToolsUpdateAllIndexes
   Sleep 5

   printlog "- check alphabetical index"
    Call VerzeichnisUeberNavigator(2)
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Shift End>"
    EditCopy
   if GetClipBoardtext <> "Alphabetical Index" then
      Warnlog "- wrong index selected or index has been deleted"
   else
      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",5
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,8) <> "brauchte" then Warnlog "Entry 5 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",10
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,18) <> "Schlagiinstrumente" then Warnlog "Entry 15 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",3
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,6) <> "Sonnor" then Warnlog "Entry 18 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",6
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,14) <> "westfllischen" then Warnlog "Entry 24 not inserted"
   endif


   printlog "- check table of contents"
    Call VerzeichnisUeberNavigator(1)
    Call wDokSchreiben "<Shift End>"
    EditCopy
   if GetClipBoardtext <> "Table of Contents" then
      Warnlog "- wrong index selected or deleted after update"
   else
      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",2
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
       if Left$(GetClipboardText,4) <> "1975" then Warnlog "Entry 2 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>"
      Call wDokSchreiben "<Mod1 Shift Right>",2
      EditCopy
       if Left$(GetClipboardText,12) <> "Heute morgen" then Warnlog "Entry 3 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",13
      Call wDokSchreiben "<Mod1 Shift Right>",7
      EditCopy
      if Left$(GetClipboardText,25) <> "berschrift 2 auf Seite 7" then Warnlog "Entry 16 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Home><Down>",5
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,18) <> "Schlagzeugkataloge" then Warnlog "Entry 21 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",3
      Call wDokSchreiben "<Mod1 Shift Right>" ,7
      EditCopy
      if Left$(GetClipboardText,25) <> "berschrift 3 auf Seite 8" then Warnlog "Entry 24 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Home><Down>",6
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,12) <> "hergesstellt" then Warnlog "Entry 30 not updated"
   endif

   printlog "- check user-defined"
    Call VerzeichnisUeberNavigator(3)
    Call wDokSchreiben "<Shift End>"
    EditCopy
   if GetClipBoardtext <> "Benutzerverzeichnis" then
      Warnlog "- wrong index selected or deleted after update"
   else
      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>"
      Call wDokSchreiben "<Mod1 Shift Right>",7
      EditCopy
      if Left$(GetClipboardText,25) <> "berschrift 2 auf Seite 7" then Warnlog "Entry 1 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",2
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,7) <> "Trommel" then Warnlog "Entry 3 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>"
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,13) <> "Naturalfellen" then Warnlog "Entry 4 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>",7
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,7) <> "Hilight" then Warnlog "Entry 11 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>"
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,6) <> "Forrce" then Warnlog "Entry 12 not updated"

      Call wDokSchreiben "<Home>"
      Call wDokSchreiben "<Down>"
      Call wDokSchreiben "<Mod1 Shift Right>"
      EditCopy
      if Left$(GetClipboardText,8) <> "Designr" then Warnlog "Entry 12 not updated"
   endif

   Call hCloseDocument
endcase

' *******************************************************************

testcase tToolsUpdateOrder
  printlog "- Tools / Update ... : check order"

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\verzeichnis\verzeichnisse.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\verzeichnis\verzeichnisse.sxg" )
   endif
   Call VerzeichnisUeberNavigator(1)
   Call hCloseDocument

endcase
