'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_105a_.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************

sub w_105a_
   printLog Chr(13) + "---------   Level 1 - Format / Styles   ----------"

   Call tFormatStylesNewStyle
   Call tFormatStylesAllStyles

end sub



testcase tFormatStylesNewStyle
  Dim i, j, z
  Dim AlterWert$
  PrintLog "- Format / Styles / Catalg"
   '/// Format / Styles / Catalog ///

  AlterWert$ = ""

   Call hNewDocument
   '/// New writerdocument ///
   FormatStylesCatalog
   '/// Call Format / Styles / Catalog ///
  printlog "   - create a new style"
   Kontext "VorlagenKatalog"
   Neu.Click
   Kontext
   Active.SetPage TabVerwalten
   Kontext "TabVerwalten"
   '/// Create new style with name 'Testtool' ///
   VorlagenName.SetText "Testtool"
   Aktualisieren.Check

   Kontext
   Active.SetPage TabFont
   Kontext "TabFont"
   '/// Change style font ///
   try
    SizeWest.Select 18
   catch
    Size.Select 18
   endcatch
   TabFont.OK

  printlog "   - check new style"
   '/// Check style properties ///
   Kontext "VorlagenKatalog"
   Ansicht.TypeKeys "<Up>", 20
   for i=1 to 100
      Ansicht.TypeKeys "<Down>"
      if Ansicht.GetText = "Testtool" then
         i=101
         Aendern.Click
         Kontext
         Active.SetPage TabVerwalten
         Kontext "TabVerwalten"
         if VorlagenName.GetText <>"Testtool" then Warnlog "Name of created style is not 'Testtool'"
         if NOT Aktualisieren.IsChecked then Warnlog "Auto Update is not checked!"

         Kontext
         Active.SetPage TabFont
         Kontext "TabFont"
         try
          if SizeWest.GetSelIndex <> 18 then Warnlog "Wrong font size selected"
         catch
          if Size.GetSelIndex <> 18 then Warnlog "Wrong font size selected"
         endcatch
         TabFont.OK
         Kontext "VorlagenKatalog"
      else
         AlterWert$ = Ansicht.GetText
      end if
   next i

  printlog "   - delete created style"
   '/// delete created style ///
   Kontext "VorlagenKatalog"
   Ansicht.TypeKeys "<Up>", 20
   for i=1 to 100
      Ansicht.TypeKeys "<Down>"
      if Ansicht.GetText = "Testtool" then
         i=101
         Wait 500
         if Loeschen.IsEnabled then
          Loeschen.Click
         else
          Warnlog "- Button 'Delete is disabled. Unable to delete the Style " & Ansicht.Gettext
         endif
         Sleep 1
         Kontext "Active"
         if Active.Exists then
            Active.No
            Sleep 1
            Kontext "VorlagenKatalog"
            Ansicht.TypeKeys "<Home>"
            For j = 1 to 100
             if Ansicht.GetText = "Testtool" then
               j = 200
               wait 500
               if Not Loeschen.IsEnabled then
                 Warnlog "Confirm messagebox to delete style with 'No' -> Button 'delete is disabled'! (BUG:83298)"
                 Ansicht.TypeKeys "<Up>"
                 wait 500
                 Ansicht.TypeKeys "<Down>"
                try
                 Loeschen.Click
                 printlog "After selecting another style and reselect style 'Testtool', it can be deleted!"
                catch
                 Warnlog "After selecting another style and reselect style 'Testtool', it can't be deleted!"
                endcatch
               else
                 Loeschen.Click
               endif
               Sleep 1
               Kontext "Active"
               Active.Yes
               Sleep 1
               Kontext "VorlagenKatalog"
               Ansicht.TypeKeys "<Home>"
               for z = 1 to 100
                if Ansicht.GetText <> "Testtool" then
                  Ansicht.TypeKeys "<Down>"
                else
                 Warnlog "Entry has not been deleted"
                 z = 200
                endif
               next z
             else
               Ansicht.TypeKeys "<Down>"
               if j = 100 then Warnlog "Though the warnmessage has been confirmed with 'No', the entry has been deleted"
             end if
            next j
         else
            Warnlog "No warnmessage when select 'Delete'"
         end if

      else
         AlterWert$ = Ansicht.GetText
      end if
   next i

   Kontext "VorlagenKatalog"
   VorlagenKatalog.OK
   hCloseDocument
endcase

'--------------------------------------------------

testcase tFormatStylesAllStyles
  Dim i : Dim j : Dim k
  Dim AlterWert$
  Dim Nichtmachen as Boolean
  PrintLog "- Format / Styles / Catalog : call for every style -> modify "
   '/// Format / Styles / Catalog ///

  AlterWert$ = ""

   '/// New document ///
   Call hNewDocument
   '/// Select every style and call modify in styles catalog ///
   FormatStylesCatalog
   Kontext "VorlagenKatalog"

   try
      for i=1 to Vorlagen.GetItemCount
         Vorlagen.Select i

         for j=1 to Bereich.GetItemCount
            Bereich.Select j

' *** nichtansprechbare Vorlagenlisten rausnehmen ( leere Listen und Treelisten )
            Nichtmachen = FALSE
            if i=1 then
               if j=1  then Nichtmachen = TRUE         ' unansprechbare Treelistbox (Hierarchisch)
               if j=4  then Nichtmachen = TRUE         ' leere Benutzerliste
               'if j=11 then Nichtmachen = TRUE         ' nur ein Eintrag bekommt man nicht selektiert
               'if j=12 then Nichtmachen = TRUE         ' unansprechbare Treelistbox
            end if

            if i=2 OR i=3 OR i=5 then
               if j=1 then Nichtmachen = TRUE          ' leere Benutzerliste
               'if j=2 then Nichtmachen = TRUE          ' leere Benutzerliste
               if j=3 then Nichtmachen = TRUE          ' leere Benutzerliste
               if j=4 then Nichtmachen = TRUE          ' unansprechbare Treelistbox
            end if

            if i=4 then
               if j=1 then Nichtmachen = TRUE          ' leere Benutzerliste
               if j=3 then Nichtmachen = TRUE          ' leere Benutzerliste
               if j=4 then Nichtmachen = TRUE          ' unansprechbare Treelistbox
            end if

            if Nichtmachen = FALSE then
               Ansicht.TypeKeys "<PageUp>", 10
               Ansicht.TypeKeys "<Down><Up>"
               for k=1 to 100
                  Ansicht.TypeKeys "<Space>"
                  if Ansicht.GetText = AlterWert$ then
                     k=101
                  else
                     AlterWert$ = Ansicht.GetText
                     if Aendern.IsEnabled then
                        Aendern.Click
                        Kontext
                        Active.SetPage TabVerwalten
                        Kontext "TabVerwalten"
                        TabVerwalten.OK
                        Kontext "VorlagenKatalog"
                     else
                        wait 500
                        Printlog "Modify is disabled on style "+i+"  area "+j+" and Style "+AlterWert$
                     end if
                     Ansicht.TypeKeys "<Down>"
                  end if
               next k
           end if

        next j
     next i
   catch
      Exceptlog
      Warnlog "Styleart  "+ i +"  Area  "+j+"  Style  "+k+" has problems."
   endcatch

   Sleep 2
   Kontext "VorlagenKatalog"
   VorlagenKatalog.Close
   '/// close styles catalog ///
   Sleep 1
   '/// close document ///
   Call hCloseDocument
endcase
