#!/bin/bash

#*************************************************************************
#*
#*  OpenOffice.org - a multi-platform office productivity suite
#*
#*  $RCSfile: OOoTestRun_unix.sh,v $
#*
#*  $Revision: 1.10 $
#*
#*  last change: $Author: tbo $ $Date: 2005/09/08 08:51:36 $
#*
#*  The Contents of this file are made available subject to
#*  the terms of GNU Lesser General Public License Version 2.1.
#*
#*
#*    GNU Lesser General Public License Version 2.1
#*    =============================================
#*    Copyright 2005 by Sun Microsystems, Inc.
#*    901 San Antonio Road, Palo Alto, CA 94303, USA
#*
#*    This library is free software; you can redistribute it and/or
#*    modify it under the terms of the GNU Lesser General Public
#*    License version 2.1, as published by the Free Software Foundation.
#*
#*    This library is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#*    Lesser General Public License for more details.
#*
#*    You should have received a copy of the GNU Lesser General Public
#*    License along with this library; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*    MA  02111-1307  USA
#*
#########################################################################
#
# Owner : thorsten.bosbach@sun.com
#
# short description : run several testscripts on unix
#
#########################################################################

# set location of testscripts
# (the directory, where directory 'qatesttool' exists)
sLocation=/testtool

# set location of TestTool
# (full path including executable 'testtool')
sTestTool=/testtool/linux/testtool

# set location of close-office file
# (see cvs)
sExitOfficeBas="$sLocation/qatesttool/global/tools/closeoffice.bas"

# insert tests here
testList=("
   /qatesttool/framework/first/first.bas\
   /qatesttool/framework/first/topten.bas\
   /qatesttool/framework/update/f_updt_faxwizard.bas\
   /qatesttool/framework/update/f_updt_help.bas\
   /qatesttool/framework/update/f_updt_letterwizard.bas\
   /qatesttool/framework/update/f_updt_pkgmgr.bas\
   /qatesttool/framework/update/f_updt_spadmin.bas\
   /qatesttool/framework/update/f_updt_templates.bas\
   /qatesttool/framework/update/f_updt_toolbars.bas\
   /qatesttool/framework/update/f_updt_windowfuncs.bas\
   /qatesttool/writer/update/w_updt.bas\
   /qatesttool/math/update/m_updt.bas\
   /qatesttool/calc/update/c_updt.bas\
   /qatesttool/chart/update/ch_updt.bas\
   /qatesttool/graphics/update/i_updt.bas\
   /qatesttool/graphics/update/gallery.bas\
   /qatesttool/base/update/b_updt.bas\
   /qatesttool/base/update/xforms_updt.bas\
   /qatesttool/xml/update/xm_updt.bas\
   /qatesttool/writer/update/ww_updt.bas\
   /qatesttool/writer/update/ma_updt.bas\
   /qatesttool/graphics/update/d_updt.bas\
   /qatesttool/framework/basic/check_control_settings_calc.bas\
   /qatesttool/framework/basic/check_control_settings_graphics.bas\
   /qatesttool/framework/basic/check_control_settings_writer.bas\
   /qatesttool/framework/basic/f_basic.bas\
   /qatesttool/framework/basic/f_basic_modules.bas\
   /qatesttool/framework/basic/f_scripting_basics.bas\
   /qatesttool/framework/basic/input/resetregistration.bas\
   /qatesttool/framework/basic/pbrowser_controls.bas\
   /qatesttool/framework/basic/pbrowser_events.bas\
   /qatesttool/framework/extras/extras_autotext.bas\
   /qatesttool/framework/extras/extras_drawobjects.bas\
   /qatesttool/framework/extras/extras_fonts.bas\
   /qatesttool/framework/extras/extras_labels.bas\
   /qatesttool/framework/extras/extras_samplefileopen.bas\
   /qatesttool/framework/extras/extras_sampleopen.bas\
   /qatesttool/framework/extras/extras_samplepreview.bas\
   /qatesttool/framework/extras/extras_tableautoformat.bas\
   /qatesttool/framework/extras/extras_templateedit.bas\
   /qatesttool/framework/extras/extras_templatefileopen.bas\
   /qatesttool/framework/extras/extras_templateopen.bas\
   /qatesttool/framework/extras/extras_templatepreview.bas\
   /qatesttool/framework/filedlg/filedlg_attributes.bas\
   /qatesttool/framework/filedlg/filedlg_autocompletion.bas\
   /qatesttool/framework/filedlg/filedlg_cjkchars.bas\
   /qatesttool/framework/filedlg/filedlg_dialogtest.bas\
   /qatesttool/framework/filedlg/filedlg_filenames1.bas\
   /qatesttool/framework/filedlg/filedlg_filenames2.bas\
   /qatesttool/framework/filedlg/filedlg_filenames3.bas\
   /qatesttool/framework/filedlg/filedlg_folders.bas\
   /qatesttool/framework/filedlg/filedlg_ftpaccess.bas\
   /qatesttool/framework/filedlg/filedlg_ftpfolders.bas\
   /qatesttool/framework/filedlg/filedlg_passwords.bas\
   /qatesttool/framework/first/first.bas\
   /qatesttool/framework/first/topten.bas\
   /qatesttool/framework/help/help.bas\
   /qatesttool/framework/install/install.bas\
   /qatesttool/framework/install/integration.bas\
   /qatesttool/framework/level1/f_lvl1_autopilots.bas\
   /qatesttool/framework/level1/f_lvl1_loadsave.bas\
   /qatesttool/framework/level1/f_lvl1_ole.bas\
   /qatesttool/framework/level2/CJK/CJK_CollationDialogue.bas\
   /qatesttool/framework/level2/CJK/CJK_FeatureSwitch.bas\
   /qatesttool/framework/level2/CJK/CJK_GridLayout.bas\
   /qatesttool/framework/level2/CJK/CJK_RubyDialogueProposal.bas\
   /qatesttool/framework/level2/CJK/NewSortingAlgorithmForJapanese.bas\
   /qatesttool/framework/level2/benchmarq/f_benchmarq.bas\
   /qatesttool/framework/level2/slotscfg/slotscfg.bas\
   /qatesttool/framework/options/f_opt.bas\
   /qatesttool/framework/options/f_opt_loadsave.bas\
   /qatesttool/framework/options/f_opt_ooo.bas\
   /qatesttool/writer/level1/ma_lvl1.bas\
   /qatesttool/writer/level1/w_CJKCTLDependency.bas\
   /qatesttool/writer/level1/w_autotext.bas\
   /qatesttool/writer/level1/w_calculate.bas\
   /qatesttool/writer/level1/w_chinesetranslate.bas\
   /qatesttool/writer/level1/w_clipbrd.bas\
   /qatesttool/writer/level1/w_contextmenu.bas\
   /qatesttool/writer/level1/w_dropdownLB.bas\
   /qatesttool/writer/level1/w_fields.bas\
   /qatesttool/writer/level1/w_formatcharacter.bas\
   /qatesttool/writer/level1/w_formatpage.bas\
   /qatesttool/writer/level1/w_formatparagraph.bas\
   /qatesttool/writer/level1/w_hhConversion.bas\
   /qatesttool/writer/level1/w_insertgraphic.bas\
   /qatesttool/writer/level1/w_lvl1.bas\
   /qatesttool/writer/level1/w_menutools.bas\
   /qatesttool/writer/level1/w_navigator.bas\
   /qatesttool/writer/level1/w_numbering.bas\
   /qatesttool/writer/level1/w_opt.bas\
   /qatesttool/writer/level1/w_redlining.bas\
   /qatesttool/writer/level1/w_search.bas\
   /qatesttool/writer/level1/w_section.bas\
   /qatesttool/writer/level1/w_sorting.bas\
   /qatesttool/writer/level1/w_spellcheck.bas\
   /qatesttool/writer/level1/w_stylist.bas\
   /qatesttool/writer/level1/w_table.bas\
   /qatesttool/writer/level1/w_textframes.bas\
   /qatesttool/writer/level1/w_undo.bas\
   /qatesttool/writer/level1/w_undo_history.bas\
   /qatesttool/writer/level1/ww_opt.bas\
   /qatesttool/writer/loadsave/w_exp_bin.bas\
   /qatesttool/writer/loadsave/w_exp_xml1.bas\
   /qatesttool/writer/loadsave/w_exp_xml2.bas\
   /qatesttool/writer/loadsave/w_filter.bas\
   /qatesttool/writer/loadsave/w_imp_bin.bas\
   /qatesttool/writer/loadsave/w_imp_bugdoc.bas\
   /qatesttool/writer/loadsave/w_imp_xml1.bas\
   /qatesttool/writer/loadsave/w_imp_xml2.bas\
   /qatesttool/writer/regression/w_bugtracker_p2_101000.bas\
   /qatesttool/writer/regression/w_bugtracker_p2_102000.bas\
   /qatesttool/writer/regression/w_bugtracker_p2_103000.bas\
   /qatesttool/calc/level1/c_lvl1.bas\
   /qatesttool/calc/options/c_opt.bas\
   /qatesttool/calc/special/c_chinesetranslate.bas\
   /qatesttool/calc/special/c_clipboardtest.bas\
   /qatesttool/calc/special/c_namedrange.bas\
   /qatesttool/calc/special/c_printrange.bas\
   /qatesttool/calc/special/c_so7_pp1.bas\
   /qatesttool/calc/special/fkt_test.bas\
   /qatesttool/calc/special/keyboardaccessibility.bas\
   /qatesttool/calc/special/menu_2.bas\
   /qatesttool/calc/special/page_styles.bas\
   /qatesttool/calc/special/validity.bas\
   /qatesttool/chart/level1/ch_lvl1.bas\
   /qatesttool/chart/special/chart_types.bas\
   /qatesttool/math/level1/m_lvl1.bas\
   /qatesttool/graphics/level1/d_export_graphic.bas\
   /qatesttool/graphics/level1/g_accessability.bas\
   /qatesttool/graphics/level1/g_area.bas\
   /qatesttool/graphics/level1/g_arrangealign.bas\
   /qatesttool/graphics/level1/g_autocorrection.bas\
   /qatesttool/graphics/level1/g_character.bas\
   /qatesttool/graphics/level1/g_clipboard.bas\
   /qatesttool/graphics/level1/g_clipexport.bas\
   /qatesttool/graphics/level1/g_convertto.bas\
   /qatesttool/graphics/level1/g_crossfading.bas\
   /qatesttool/graphics/level1/g_dimensions.bas\
   /qatesttool/graphics/level1/g_edit.bas\
   /qatesttool/graphics/level1/g_export_html.bas\
   /qatesttool/graphics/level1/g_findreplace.bas\
   /qatesttool/graphics/level1/g_format.bas\
   /qatesttool/graphics/level1/g_group.bas\
   /qatesttool/graphics/level1/g_imagemap.bas\
   /qatesttool/graphics/level1/g_insert.bas\
   /qatesttool/graphics/level1/g_line.bas\
   /qatesttool/graphics/level1/g_load_save.bas\
   /qatesttool/graphics/level1/g_navigator.bas\
   /qatesttool/graphics/level1/g_paragraph.bas\
   /qatesttool/graphics/level1/g_print.bas\
   /qatesttool/graphics/level1/g_slidelayer.bas\
   /qatesttool/graphics/level1/g_spellcheck.bas\
   /qatesttool/graphics/level1/g_stylist.bas\
   /qatesttool/graphics/level1/g_toolbars.bas\
   /qatesttool/graphics/level1/g_tools.bas\
   /qatesttool/graphics/level1/g_zoom.bas\
   /qatesttool/graphics/level1/i_animation.bas\
   /qatesttool/graphics/level1/i_export_graphic.bas\
   /qatesttool/graphics/level1/i_headerfooter.bas\
   /qatesttool/graphics/level1/i_slideshow.bas\
   /qatesttool/graphics/level1/i_view.bas\
   /qatesttool/graphics/options/d_opt.bas\
   /qatesttool/graphics/options/i_opt.bas\
   /qatesttool/xml/level1/calc_xml_7_export.bas\
   /qatesttool/xml/level1/ch_xml_japanese_candlestick.bas\
   /qatesttool/xml/level1/docbook_losa.bas\
   /qatesttool/xml/level1/draw_xml_7_export.bas\
   /qatesttool/xml/level1/impress_xml_7_export.bas\
   /qatesttool/xml/level1/writer_xml_7_export.bas\
   /qatesttool/xml/level2/xc_perf.bas\
   /qatesttool/xml/level2/xi_perf.bas\
   /qatesttool/xml/level2/xw_perf.bas\
   /qatesttool/xml/special/mperform.bas\
   /qatesttool/base/level1/controls/b_lvl1_Control_Autopilot.bas\
   /qatesttool/base/level1/controls/b_lvl1_Control_Calc.bas\
   /qatesttool/base/level1/controls/b_lvl1_Control_Clipboard.bas\
   /qatesttool/base/level1/controls/b_lvl1_Control_General.bas\
   /qatesttool/base/level1/controls/b_lvl1_Control_Several.bas\
   /qatesttool/base/level1/controls/b_lvl1_Grid_Control.bas\
   /qatesttool/base/level1/controls/b_lvl1_Property_Browser.bas\
   /qatesttool/base/level1/controls/b_lvl1_Text_Control.bas\
   /qatesttool/base/level1/datasources/b_lvl1_ADO-Access.bas\
   /qatesttool/base/level1/datasources/b_lvl1_AdabasD.bas\
   /qatesttool/base/level1/datasources/b_lvl1_Addressbook.bas\
   /qatesttool/base/level1/datasources/b_lvl1_JDBC_MySQL.bas\
   /qatesttool/base/level1/datasources/b_lvl1_ODBC_MySQL.bas\
   /qatesttool/base/level1/datasources/b_lvl1_RegisterDatabase.bas\
   /qatesttool/base/level1/datasources/b_lvl1_Spreadsheet.bas\
   /qatesttool/base/level1/datasources/b_lvl1_Text.bas\
   /qatesttool/base/level1/datasources/b_lvl1_dBase.bas\
   /qatesttool/base/level1/datasources/b_lvl1_dBase_functions.bas\
   /qatesttool/base/level1/datasources/b_lvl1_hsqldb.bas\
   /qatesttool/base/level1/forms/b_lvl1_FormFilter.bas\
   /qatesttool/base/level1/forms/b_lvl1_Forms.bas\
   /qatesttool/base/level1/wizards/b_lvl1_Copy_Table_Autopilot.bas\
   /qatesttool/base/level1/wizards/b_lvl1_Database_Wizard.bas\
   /qatesttool/base/level1/wizards/b_lvl1_FormAutopilot.bas\
   /qatesttool/base/level1/wizards/b_lvl1_QueryAutopilot.bas\
   /qatesttool/base/level1/wizards/b_lvl1_ReportAutopilot.bas\
   /qatesttool/base/level1/wizards/b_lvl1_Table_Wizard.bas\
   /qatesttool/base/level1/xforms/xf_lvl1_submission.bas\
")

echo "****************************************************"
echo "************ STARTING ************"
echo "****************************************************"

for x in $testList ;
do
    echo $x
done

# check if there is a virtual display available

 echo "DISPLAY is set to: " $DISPLAY
 echo "My name is: " $USER
 i=0

        for x in $testList ;
        do
                 echo "Running soffices' prozesses: "
               # kill office, if exists
                  #killall -9 soffice.bin
                  pkill -9 soffice.bin
                ps -fe | grep $USER | grep "soffice.bin" | grep -v "grep"
        
                echo "****************************************************"
                echo "Will run: " $x

                sTest="$sLocation$x"
                for z in "1" "2" ;
                do
                        $sTestTool -run $sTest &
                        sleep 1
                        echo " "

                        ######### save the PID from the last BackGround job
                        testtoolpid=$!
                        echo "PID of Testtool: " $testtoolpid

                         if ps -p $testtoolpid > /dev/null ; then
                            echo " Sucksessfull started"
                         else
                            echo " There might be something wrong with starting the Testtool!"
                         fi

                        ######### wait until Testtool has finished & closed
                         while ps -p $testtoolpid > /dev/null ; 
                         do
                                    sleep 2
                                    i=$((i+2))
                         done

                         ####### for the second run use the office exit script!
                         sTest=$sExitOfficeBas
                done
        done

        echo "Duration:" $((i/60)) "min" $((i%60)) "sec " 

echo "****************************************************"
echo "************ FINISHED ************"
echo "****************************************************"
