'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_customize.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/02/08 11:26:08 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/******************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update Test for the Tools Customize Dialog
'*
'*******************************************************************************
'**
' #1 tUpdtCustomize ' Update Test for the Tools Customize Dialog
' #1 hUpdtToolsCustomizeToolbars ' Update test for Customize Toolbars
' #1 hUpdtToolsCustomizeMenu     ' Update test for Customize Menu
' #1 hUpdtToolsCustomizeEvents   ' Update test for Customize Events
' #1 hUpdtToolsCustomizeKeyboard ' Update test for Customize Keyboard
' #1 hUpdtToolsCustomizeScriptSelector ' Brief look at the ScriptSelector
'**
'\******************************************************************************

testcase tUpdtCustomize

    '///<H1>Update Test for the Tools Customize Dialog</H1>
    '///<ul>

    const CANCEL_BUTTON = 1

    dim brc as boolean
    dim cApp as string
    dim iApp as integer
    
    '///+<li>Cycle through all applications - Writer, Calc, Impress ...</li>
    '///<ol>
    for iApp = 0 to 8
    
        cApp = hNumericDocType( iApp )
        printlog( "" )
        printlog( cApp )
    
        '///+<li>Open a new document</li>
        brc = hCreateDocument()
    
        '///+<li>Open Tools Customize</li>
        brc = hToolsCustomizeOpen()
    
        '///+<li>Look at the Keyboard-Tabpage</li>
    
        hUpdtToolsCustomizeKeyboard()
       
        '///+<li>Look at the Menu-Tabpage</li>
        hUpdtToolsCustomizeMenu()
    
        '///+<li>Look at the Toolbars-Tabpage</li>
        hUpdtToolsCustomizeToolbars()
        
        '///+<li>Look at the Events-Tabpage</li>
        hUpdtToolsCustomizeEvents()
    
        '///+<li>Close Tools Customize</li>
        brc = hToolsCustomizeClose( CANCEL_BUTTON )
    
        '///+<li>Close the document</li>
        brc = hDestroyDocument
    
    next iApp
    '///<ol>
    
    '///+<li>Remove Database file, it is created when calling hNewDocument() with
    '///+ gApplication = &quot;INSIGHT&quot;
    printlog( "Try to delete database" )
    hDeleteFile( hGetWorkPath() & "New Database.odb" )    
    '///</ul>

endcase

'*******************************************************************************

function hUpdtToolsCustomizeMenu()

    '///<h3>Update test for the Tools/Customize - Menu-Tab</h3>
    '///<i>Starting point: Tools/Customize dialog</i><br>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hUpdtToolsCustomizeMenu::"
    dim brc as boolean

    dim iItems as integer
    dim iMenuListItems as integer
    dim iEntriesListItems as integer    
    
    printlog( "" )
    printlog( "Menu" )

    '///+<li>Access the Menu-Tabpage</li>
    brc = hToolsCustomizeSelectTab( "Menu" )
    call DialogTest( TabCustomizeMenu )
    
    '///+<li>Click &quot;New...&quot; to add a new menu</li>
    printlog( CFN & "Click New..." )
    kontext "TabCustomizeMenu"
    BtnNew.click()
    
    '///+<li>Have a look at the MenuOrganiser, close it</li>
    Kontext "MenuOrganiser"
    printlog( CFN & "MenuOrganiser" )
    call DialogTest( MenuOrganiser )
    
    '///+<li>Click &quot;Down&quot;</li>
    printlog( CFN & "Down..." )
    ButtonDown.click()
    
    '///+<li>Click &quot;Up&quot;</li>
    printlog( CFN & "Up..." )
    ButtonUp.click()    
    
    qaerrorlog( "#i60609# Undeclared listbox in menu organiser" )
    
    MenuOrganiser.cancel()
    
    '///+<li>Click the &quot;Add Commands...&quot; button</li>
    '///+<li>Check that the dialog is open, close it</li>
    hUpdtToolsCustomizeScriptSelector( 3 )
    
    '///+<li>Check the number of entries in SaveIn-Listbox (2)</li>
    printlog( CFN & "Check itemcount in SaveIn List" )
    kontext "TabCustomizeMenu"
    ' NOTE: All documents of a gApplication will be listed, this means
    ' that for gApplication = WRITER "The first doc!" appears as well
    select case gApplication
    case "WRITER"       :   brc = hToolsCustomizeTestSaveIn( 3 )
    case "INSIGHT"      :   brc = hToolsCustomizeTestSaveIn( 1 )
    case "BACKGROUND"   :   brc = hToolsCustomizeTestSaveIn( 1 )
    case else           :   brc = hToolsCustomizeTestSaveIn( 2 )
    end select
    if ( not brc ) then
        warnlog( "Incorrect itemcount in listbox, see above" )
    endif
    
    '///+<li>Click &quot;Down&quot;</li>
    printlog( CFN & "Down..." )
    BtnDown.click()
    
    '///+<li>Click &quot;Up&quot;</li>
    printlog( CFN & "Up..." )
    BtnUp.click()
    
    '///</ul>
    
end function

'*******************************************************************************

function hUpdtToolsCustomizeToolbars()

    '///<h3>Update test for the Tools/Customize - Toolbar-Tab</h3>
    '///<i>Starting point: Tools/Customize dialog</i><br>

    '///<u>Input</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Description</u>:<br>
    '///<ul>

    const CFN = "hUpdtToolsCustomizeToolbars::"
    dim brc as boolean
    
    printlog( "" )
    printlog( "Toolbars" )

    '///+<li>Access the toolbar tabpage</li>
    brc = hToolsCustomizeSelectTab( "Toolbars" )
    call DialogTest( TabCustomizeToolbars )
    
    '///+<li>Click &quot;New...&quot; to add a new toolbar</li>
    printlog( CFN & "Click New..." )
    kontext "TabCustomizeToolbars"
    BtnNew.click()
    
    '///+<li>Have a look at the New Toolbar dialog, close it</li>
    kontext "NewToolbar"
    printlog( CFN & "NewToolbar" )
    call DialogTest( NewToolbar )
    
    '///+<li>Check that the SaveIn control has the correct number of items</li>
    ' NOTE: All documents of a gApplication will be listed, this means
    ' that for gApplication = WRITER "The first doc!" appears as well
    select case gApplication
    case "WRITER"       :   brc = hToolsCustomizeTestSaveIn( 3 )
    case "INSIGHT"      :   brc = hToolsCustomizeTestSaveIn( 1 )
    case "BACKGROUND"   :   brc = hToolsCustomizeTestSaveIn( 1 )
    case else           :   brc = hToolsCustomizeTestSaveIn( 2 )
    end select
    if ( not brc ) then
        warnlog( "Incorrect itemcount in listbox, see above" )
    endif
    
    '///+<li>Cancel the dialog</li>
    printlog( CFN & "Cancel NewToolbar dialog" )
    NewToolbar.cancel()
       
    '///+<li>Click the &quot;Add Commands...&quot; button</li>
    '///+<li>Check that the dialog is open, close it</li>
    hUpdtToolsCustomizeScriptSelector( 2 )
    
    '///+<li>Check that the SaveIn control has two items</li>
    kontext "TabCustomizeToolbars"
    ' NOTE: All documents of a gApplication will be listed, this means
    ' that for gApplication = WRITER "The first doc!" appears as well
    select case gApplication
    case "WRITER"       :   brc = hToolsCustomizeTestSaveIn( 3 )
    case "INSIGHT"      :   brc = hToolsCustomizeTestSaveIn( 1 )
    case "BACKGROUND"   :   brc = hToolsCustomizeTestSaveIn( 1 )
    case else           :   brc = hToolsCustomizeTestSaveIn( 2 )
    end select
    if ( not brc ) then
        warnlog( "Incorrect itemcount in listbox, see above" )
    endif
    
    '///+<li>Click &quot;Down&quot;</li>
    printlog( CFN & "Down..." )
    BtnDown.click()
    
    '///+<li>Click &quot;Up&quot;</li>
    printlog( CFN & "Up..." )
    BtnUp.click()    

    '///</ul>

end function


'*******************************************************************************

function hUpdtToolsCustomizeEvents()

    '///<h3>Update test for the Tools/Customize - Events-Tab</h3>
    '///<i>Starting point: Tools/Customize dialog</i><br>

    '///<u>Input</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Description</u>:<br>
    '///<ul>

    const CFN = "hUpdtToolsCustomizeEvents::"
    dim brc as boolean

    printlog( "" )
    printlog( "Events" )
    
    '///+<li>Access the events tabpage</li>
    brc = hToolsCustomizeSelectTab( "events" )
    call DialogTest( TabCustomizeEvents )
    
    '///+<li>Click to assign a macro, close dialog with cancel</li>
    hUpdtToolsCustomizeScriptSelector( 1 )
    
    '///+<li>Check that the SaveIn control has two items</li>
    kontext "TabCustomizeEvents"
    select case gApplication
    case "INSIGHT"      :   brc = hToolsCustomizeTestSaveIn( 1 )
    case "BACKGROUND"   :   brc = hToolsCustomizeTestSaveIn( 1 )
    case else           :   brc = hToolsCustomizeTestSaveIn( 2 )
    end select
    if ( not brc ) then
        warnlog( "Incorrect itemcount in listbox, see above" )
    endif
    '///</ul>

end function

'*******************************************************************************

function hUpdtToolsCustomizeKeyboard() as boolean

    '///<h3>Update test for the Tools/Customize - Keyboard-Tab</h3>
    '///<i>Starting point: Tools/Customize dialog</i><br>

    '///<u>Input</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Returns</u>:<br>
    '///<ol>
    '///+<li>Nothing</li>
    '///</ol>

    '///<u>Description</u>:<br>
    '///<ul>

    const CFN = "hUpdtToolsCustomizeKeyboard::"
    dim brc as boolean
    
    printlog( "" )
    printlog( "Keyboard" )
   
    '///+<li>Access the keyboard tabpage</li>
    brc = hToolsCustomizeSelectTab( "keyboard" )
    if ( not brc and gApplication = "BACKGROUND" ) then
        qaerrorlog( "#i61765# TabTastatur is missing when called from Backing Window" )
        exit function
    endif
    
    call DialogTest( TabTastatur )
  
    '///+<li>Assign an item to *second* Entry in OpenOffice.org/Tastatur</li>
    ' no verification of functionality, this is an update test!
    StarOffice.check()
    hSelectNode( Tastatur , 2 )
    hSelectTopNode( bereich )
    Aendern.click()
    
    '///+<li>Reset</li>
    Zuruecksetzen.click()
    
    '///+<li>Assign an item to *second* Entry in OpenOffice.org/Tastatur</li>
    hSelectNode( Tastatur , 2 )
    Aendern.click()
       
    '///+<li>Delete</li>
    Loeschen.click()
    
    '///+<li>Click Save</li>
    Speichern.click()
    
    '///+<li>Close FileSave dialog</li>
    kontext "SpeichernDlg"
    SpeichernDlg.cancel()
    
    '///+<li>Click Load</li>
    kontext "TabTastatur"
    Laden.click()
    
    '///+<li>Close Fileopen dialog</li>
    kontext "OeffnenDlg"
    OeffnenDlg.cancel()   
    
    '///</ul>

end function

'*******************************************************************************

function hUpdtToolsCustomizeScriptSelector( iBtn as integer ) as boolean

    '///<h3>A brief look at the ScriptSelector via Tools/Customize</h3>
    '///<i>Starting point: Tools/Customize dialog (AddMacro/BtnNew)</i><br>
    '///<i>Uses: treelist_tools.inc</i><br>
    
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Button identifier (integer)</li>
    '///<ul>
    '///+<li>1: Click TabCustomizeEvents::AssignMacro</li>
    '///+<li>2: Click TabCustomizeToolbars::AddCommands</li>
    '///+<li>3: Click TabMenu::AddCommands</li>
    '///</ul>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstatus</li>
    '///<ul>
    '///+<li>TRUE: All ok</li>
    '///+<li>FALSE: Any other error</li>
    '///</ul>    
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hUpdtToolsCustomizeScriptSelector::"

    dim brc as boolean
        brc = true

    '///+<li>Select the correct button and context to execute</li>
    '///<ol>
    '///+<li>Events</li>
    '///+<li>Toolbars</li>
    '///+<li>Menu</li>
    '///</ol>
    '///+<li>Open the ScriptSelector</li>
    select case iBtn
    case 1 : kontext "TabCustomizeEvents"
             printlog( CFN & "Assign Macro... (1)" )
             AssignMacro.click()
    case 2 : kontext "TabCustomizeToolbars"
             printlog( CFN & "Add... (2)" )
             AddCommands.click()
    case 3 : kontext "TabCustomizeMenu"
             printlog( CFN & "Add... (3)" )
             AddCommands.click()
    case else
             warnlog( CFN & "Invalid function parameter" )
             brc = false
    end select
  
    '///+<li>Test the dialog (DialogTest)</li>
    if ( brc ) then
        kontext "ScriptSelector"
        call DialogTest( ScriptSelector )
        
        '///+<li>Cancel the ScriptSelector</li>
        kontext "ScriptSelector"
        ScriptSelector.cancel()
        
    endif
   
    '///+<li>Reset the context to the originating page</li>
    select case iBtn
    case 1 : kontext "TabCustomizeEvents"
    case 2 : kontext "TabCustomizeToolbars"
    case 3 : kontext "TabCustomizeMenu"
    end select    
    
    hUpdtToolsCustomizeScriptSelector() = brc
    '///</ul>
    
end function

'*******************************************************************************

function hToolsCustomizeTestSaveIn( iItems as integer ) as boolean

    '///<h3>Test number of entries in SaveIn Listbox (Tools/Customize)</h3>
    '///<u>Input</u>:
    '///<ol>
    '///+<li>Expected number of items (integer)</li>
    '///</ol>
    
    '///<u>Returns</u>:
    '///<ol>
    '///+<li>Errorstate (boolean)</li>
    '///<ul>
    '///+<li>TRUE: Correct number of items is present</li>
    '///+<li>FALSE: incorrect number of items is present</li>
    '///</ul>
    '///</ol>
    
    '///<u>Description</u>:
    '///<ul>
    
    const CFN = "hToolsCustomizeTestSaveIn::"
    dim iPresentItems as integer

    '///+<li>Get the number of items from the listbox</li>
    iPresentItems = SaveIn.getItemCount()
    
    '///+<li>Compare the number to the expected itemcount</li>
    if ( iPresentItems <> iItems ) then
        printlog( CFN & "Incorrect itemcount in SaveIn: " )
        printlog( CFN & "Expected: " & iItems )
        printlog( CFN & "Found...: " & iPresentItems )
        hToolsCustomizeTestSaveIn() = false
    else
        printlog( CFN & "Correct itemcount in SaveIn: " & iItems )
        hToolsCustomizeTestSaveIn() = true
    endif
    '///</ul>

end function


