'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_updt_basicorganizer.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/16 14:45:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Update test for the Basic Organizer dialog
'*
'*******************************************************************************
'**
' #1 tUpdtBasicOrganizer ' Update test for the Basic organizer and its dialogs
'**
'\******************************************************************************

testcase tUpdtBasicOrganizer

    '///<H1>Update test for the Basic organizer and its dialogs</H1>
    '///<ul>
    dim brc as boolean

    '///+<li>Open a new document</li>
    printlog( "Open a new document" )
    hCreateDocument()

    '///+<li>Open the Basic Macro-Organizer</li>
    printlog( "Open the Basic Macro Organizer" )
    ToolsMacro_uno

    kontext "Makro"
    if ( not makro.exists() ) then
        warnlog( "Macro Organizer is not open, aborting test" )
        brc = hDestroyDocument()
        goto endsub
    else
        printlog( "Successfully opened the MacroOrganizer" )
    endif

    '///+<li>Open the Libraries/Modules/Dialogs-Organizer</li>
    kontext "Makro"
    printlog( "Click <Organizer> to open the library/modules organizer" )
    if ( Verwalten.isEnabled() ) then
        Verwalten.click()
    else
        warnlog( "Cannot click the <Organize...> button" )
    endif
    
    ' Try to recover from previous error
    Kontext "TabModule"
    if ( not TabModule.exists() ) then
        printlog( "TabModule is not open, the test cannot continue" )
        kontext "Makro"
        Makro.cancel()
        brc = hDestroyDocument()
        goto endsub
    endif
        
    '///+<li>Open all dialogs on the Modules-Page</li>
    '///<ol>
    kontext 
    active.setPage TabModule

    kontext "TabModule"
    printlog( "Modules Tab" )
    call DialogTest( TabModule )

    '///+<li>Select first item in modules list</li>
    Modulliste.typeKeys( "<HOME>" )
    try
        '///+<li>Click to add a new module, cancel the dialog</li>
        printlog( "New Modules-dialog" )
        NeuesModul.click()
        kontext "NeuesModul"
        call DialogTest( NeuesModul )
        NeuesModul.cancel()
    catch
        warnlog( "There is a problem accessing the NewModule-dialog" )
    endcatch

    '///</ol>
    '///+<li>Open all dialogs on the Dialogs-Page</li>
    '///<ol>
    kontext
    active.setPage( TabDialogs )

    Kontext "TabDialogs"
    printlog( "Dialogs Tab" )
    call DialogTest( TabDialogs )

    '///+<li>Select first item in dialogs list</li>
    ModuleList.typeKeys( "<HOME>" )

    try
        '///+<li>Click to add a new dialog, cancel the dialog</li>
        printlog( "New Libraries-dialog" )
        NewDialog.click()
        kontext "NeuerDialog"
        call DialogTest( NeuerDialog )
        NeuerDialog.cancel()
    catch
        warnlog( "There is a problem accessing the NewModule-dialog" )
    endcatch

    '///</ol>
    '///+<li>Open all dialogs on the Libraries-Page</li>
    '///<ol>
    Kontext
    active.setPage( TabBibliotheken )

    Kontext "TabBibliotheken"
    printlog( "Libraries Tab" )
    call DialogTest( TabBibliotheken )

    '///+<li>Select first item in libraries list</li>
    Bibliotheksliste.typeKeys( "<HOME>" )

    kontext "TabBibliotheken" 

    try
        '///+<li>Click to add a new library, accept the proposed name, click OK</li>
        printlog( "New Library dialog" )
        Neu.click()
        kontext "NeueBibliothek"
        call DialogTest( NeueBibliothek )
        NeueBibliothek.ok()
    catch
        warnlog( "There is a problem accessing the New Libraries dialog" )
    endcatch

    kontext "TabBibliotheken" 

    try
        '///+<li>Click to set a password, cancel the dialog</li>
        printlog( "Password-Dialog" )
        passwort.click()
        kontext "PasswdDlg"
        PasswdDlg.cancel()
    catch
        warnlog( "There is a problem accessing the Passwords-dialog" )
    endcatch

    kontext "TabBibliotheken" 
    
    try
        '///+<li>Click &quot;Delete&quot;, accept with yes</li>
        printlog( "Delete" )
        Loeschen.click()
        Kontext "Active"
        Active.yes()
    catch
        warnlog( "Could not delete the library" )
    endcatch
    
    Kontext "TabBibliotheken"

    try
        '///+<li>Click &quot;Append&quot;, cancel dialog</li>
        printlog( "Append a new library" )
        Hinzufuegen.click()
        kontext "OeffnenDlg"
        call DialogTest( OeffnenDlg )
        OeffnenDlg.cancel()
    catch
        warnlog( "There is a problem appending a new library" )
    endcatch

    Kontext "TabBibliotheken"

    '///</ol>
    '///+<li>Close the Library/Modules/Dialogs-Organizer</li>
    printlog( "Cancel library/modules/dialogs organizer" )
    TabBibliotheken.cancel()

    '///+<li>Close the Macro-Organizer</li>
    printlog( "Cancel Macro Organizer" )
    Kontext "Makro"
    Makro.cancel()
    
    '///+<li>Close the document</li>
    printlog( "Close the document" )
    brc = hDestroyDocument()

    '///</ul>

endcase

