'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: pbrowser_tools.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:06:59 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Tools for working with the property browser for formcontrols
'*
'*******************************************************************************
'**
' #1 hOpenPropertyBrowser   ' somewhat safe method to open the Control Properties
' #1 hClosePropertyBrowser  ' close the propertybrowser
' #1 hSetControlName        ' Name the current control
' #1 hGetControlName        ' Get and compare the name of the current control
' #1 hCheckPropertyPresence ' Finds out whether a property should be available or not
' #1 hSetPBTabPage          ' Switches the TabPage Properties <--> Events
' #1 hCharsetButtonDialog   ' handles character-set button in property browser
' #1 hGraphicsChooserDialog ' handles graphicschooser button in property browser
' #1 hColorChooserDialog    ' handles colorchooser button in property browser
' #1 hFormatChooserDialog   ' handles formatchooser button in property browser
'**
'\******************************************************************************

function hOpenPropertyBrowser() as boolean

    '///<h3>Function to open the properties of a selected control</h3>
    '///The function verifies that the property browser is really open
    '///If - for some reason - the P-Browser already is open, a warning
    '///is written to the log but the test continues.
    
    dim brc as boolean
    dim iWait as integer
    
    'Printlog( "Opening Property-Browser" )
    
    ' in case the p-browser is already open, we live with that. But a warning
    ' is put to the log. Note that performing a "ControlPropertiesDialog.exists()"
    ' i very slow and might even fail completely so we look for TabGeneralControl
    ' instead.
    kontext "ControlPropertiesDialog"
    if ( TabGeneralControl.exists() ) then
        hOpenPropertyBrowser() = true
        warnlog( "The Property-Browser is already open." )
        exit function
    endif    

    ' Since the problem existed that the ToolsCollectionBar closed after usage,
    ' the test verifies that it is still present.
    ' A times there is a delay when repainting the ToolscollectionBar so 
    ' the OpenProperties Button might not be ready instantly, so we loop for
    ' max 5 seconds.     
    Kontext "ToolsCollectionBar"
    brc = false
    if ( ToolsCollectionBar.exists() ) then
        for iWait = 1 to 20
            if ( OpenProperties.isEnabled() ) then
                OpenProperties.Click()
                brc = true
                exit for
            else
                wait( 250 )
            endif
        next iWait
    endif
    
    if ( not brc ) then
        warnlog( "Could not open Properties, button is disabled." )
        hOpenPropertyBrowser() = false
        exit function
    endif
    
    ' Check for TabGeneralControl is what gives speed to the function,
    ' Testing the presence of ControlPropertiesDialog always returns false!   
    brc = false
    for iWait = 1 to 20
        kontext "ControlPropertiesDialog"
        if ( TabGeneralControl.exists() ) then
            brc = true
            exit for
        else
            wait( 250 )
        endif
    next iWait
    
    if ( brc ) then
        hOpenPropertyBrowser() = true
    else
        warnlog( "Could not open/access the Property-Browser" )
        hOpenPropertyBrowser() = false
    endif
    
    
    
end function

'*******************************************************************************

function hClosePropertyBrowser() as boolean

    '///<h3>A function that closes the Property-Browser</h3>
    '///Since the Property-Browser does not have a close button, it can only
    '///be closed by clicking on the OpenProperties Button on the 
    '///ToolsCollectionBar
    
    dim iWait as integer
    dim brc as boolean
    brc = false

    hClosePropertyBrowser() = true
    
    'printlog( "Closing Property-Browser" )
    
    ' Since the problem existed that the ToolsCollectionBar closed after usage,
    ' the test verifies that it is still present.
    ' A times there is a delay when repainting the ToolscollectionBar so 
    ' the OpenProperties Button might not be ready instantly, so we loop for
    ' max 5 seconds. 
    Kontext "ToolsCollectionBar"
    if ( ToolsCollectionBar.exists() ) then
        for iWait = 1 to 20 
            if ( OpenProperties.isEnabled() ) then
                OpenProperties.Click()
                brc = true
                exit for
            else
                wait( 250 )
            endif
        next iWait
    endif
    
    if ( brc ) then
        kontext "ControlPropertiesDialog"
        if ( ControlPropertiesDialog.exists() ) then
            hClosePropertyBrowser() = false
        endif  
    else
        warnlog( "Could not close the Property-Browser" )  
    endif
      
end function    

'*******************************************************************************

function hSetControlName( sControl as string ) as boolean
   
    kontext "TabGeneralControl"
    if ( NameText.exists() ) then
        NameText.setText( sControl )
        hSetControlName() = true
    else
        warnlog( "Unable to name the control." )
        hSetControlName() = false
    endif
    
end function

'*******************************************************************************

function hGetControlName( sControl as string ) as boolean

    dim cControlName as string
    
    kontext "TabGeneralControl"
    if ( NameText.exists() ) then
        cControlName = NameText.getText()
    else
        warnlog( "Unable to get the name from the control." )
        hGetControlName() = false
        exit function
    endif    
    
    if ( instr( cControlName, sControl ) <> 0 ) then
        'printlog( "The correct control is open: " & sControl )
        hGetControlName() = true
    else
        warnlog( "This is not the correct control." )
        hGetControlName() = false
    endif    
    
end function

'*******************************************************************************

function hCheckPropertyPresence ( cSetting as string , _
                             iPos as integer ) as boolean
                             
    '///<h3>Function to determine whether a property is available for a control or not</h3>
    '///This function takes a string (provided by controlcfg.dat) and looks for an 'x'
    '///If it is found at the expected position (iPos) TRUE is returned, else FALSE

    ' this function looks at a given position in the string cSetting for either
    ' a "x" or a "-".
    ' if "x" is found, the function returns true, else false.

   
    if ( mid( cSetting , iPos , 1 ) = "x" ) then
        hCheckPropertyPresence() = true
    else
        hCheckPropertyPresence() = false
    endif

end function

'*******************************************************************************

function hCharsetButtonDialog( _file as string )

   ' clicks on the button to open the font selection dialog, selects a font and
   ' closes the dialog. Focus back to property-browser.

   charactersetbutton.click()

   Kontext "TabFont"
   if ( bAsianLan = true ) then
      setEntryField( _file , "characterset" , fonteast , false )
   else
      setEntryField( _file , "characterset" , font , false )
   endif

   TabFont.OK()

   Kontext "TabGeneralControl"

end function

'*******************************************************************************

function hGraphicsChooserDialog( _file as string ) as boolean

   ' this function clicks on the graphics chooser dialog, selects a graphic
   ' and returns to the property browser. focus to property browser

   dim _graphic as string

   _graphic = gTesttoolPath + "global\input\graf_inp\baer.tif"
   _graphic = convertpath( _graphic )

   GraphicsButton.click()

   Kontext "GrafikEinfuegenDlg"
   Dateiname.SetText ( _graphic )
   DateiTyp.Select( 1 ) ' set the filter to 'all formats'

   Oeffnen.Click()

   Kontext "TabGeneralControl"

end function

'*******************************************************************************

function hColorChooserDialog( _file as string , _
                           control as object  ) as boolean

   ' this function clicks on the button to open the color chooser dialog.
   ' there some values are filled in the RGB-fields and the dialog is closed
   ' Focus back to proertybrowser

   control.click()

   Kontext "FarbeDlg"
   setEntryField( _file , "*" , rot , false )
   setEntryField( _file , "*" , gruen , false )
   setEntryField( _file , "*" , blau , false )

   FarbeDlg.OK()

   Kontext "TabGeneralControl"

end function

'*******************************************************************************

function hFormatChooserDialog( _file as string ) as boolean

   ' this function clicks on the format chooser button in the propertybrowser
   ' and enters some values. the format is then returned to the propertybrowser

   formatkeybutton.click()

   Kontext "Zahlenformat"
   setListBox( _file , "*" , formatkategorie )
   setListBox( _file , "*" , format )

   zahlenformat.OK()

   Kontext "TabGeneralControl"

end function

'*******************************************************************************

function hSetPBTabPage( iPage as integer ) as boolean

    '///<h3>A small helper to switch between tabpages in the property-browser</h3>
    
    dim brc as boolean
    dim iWait as integer

    const CFN = "hSetPBTabPage::"
    
    if ( ( iPage < 1 ) or ( iPage > 2 ) ) then
        warnlog( CFN & "Illegal argument passed: " & iPage )
        hSetPBTabPage() = false
        exit function
    endif
    
    kontext "ControlPropertiesTabControl"
    brc = false
    for iWait = 1 to 10
    
        select case iPage
        case 1  
            printlog( CFN & "Switching to TabGeneralControl" )
            ControlPropertiesTabControl.setPage TabGeneralControl
            kontext "TabGeneralControl"
            if ( TabGeneralControl.exists() ) then
                brc = true
                exit for
            else
                wait( 100 )
            endif
            
        case 2 
            printlog( CFN & "Switching to TabEventsControl" )
            ControlPropertiesTabControl.setPage TabEventsControl
            kontext "TabEventsControl"
            if ( TabEventsControl.exists() ) then
                brc = true
                exit for
            else
                wait( 100 )
            endif
            
        end select
        
    next iWait
    
    hSetPBTabPage() = brc
    
end function
    

