'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: key_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:07:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : tools for evaluation of key=value datalists
'*
'*******************************************************************************
' **
' #0 hGetDataPairAsString     ' retrieve key=value from a list
' #0 hGetValueForPairAsString ' retrieve value from a key=value as string
' #0 hGetValueForPairAsLong   ' retrieve value from a key=value as long
' #0 hGetValueForKeyAsInt     ' retrieve value for a specified key as integer
' #0 hGetKeyForPairAsString   ' retrieve key from key=value as string
' #0 hGetKeyForValueAsString  ' retrieve key for a specified value as string
' #0 hGetKeyForValueAsIntA    ' retrieve key for a specified value as int
' #0 hGetValueForKeyAsLong    ' retrieve value for a specified value as long
' #0 hGetIndexForKeyAsInt     ' retrieve the index for a key in a list
' #0 KeyCompare               ' compare two keys 
' **
'\******************************************************************************

' Some variables explained:
' 
' cComp is the KEY belonging to the VALUE above for reverse test
' 
' NOTE: Other related functions can be found in global/tools/inc/t_filters.inc

'*******************************************************************************

function hGetDataPairAsString( sKey as string, sVal as long ) as string

    '///<h3>Concatenate two strings and insert an = sign</h3>
    '///<ul>

   ' This function simply returns the concatenated string consisting of
   ' the key (usually the filename), an '=' sign and a value (typically the
   ' filesize). This is needed for listwrite which only takes a stringarray
   ' sVal (long) will be casted to char.

   '///+<li>Returns string1=string2</li>
   hGetDataPairAsString() = sKey & "=" & sVal

   '///</ul>
   
end function

'*******************************************************************************

function hGetValueForPairAsString( cLine as string ) as string

    '///<h3>Retrieve value from a key=value string</h3>
    '///<ul>

   ' This function takes a string that (hopefully) contains one '='
   ' and returns the substringstring to the right from the '=' char.

   dim iCharPos as integer

   '///+<li>Locate the equal sign</li>
   iCharPos = instr( cLine , "=" )
   iCharPos = len( cLine ) - iCharPos
   
   '///+<li>Isolate everything to the right of the equal sign</li>
   '///+<li>Return the value as string</li>
   hGetValueForPairAsString() = right( cLine , iCharPos )

   '///</ul>
   
end function

'*******************************************************************************

function hGetValueForPairAsLong( cLine as string ) as long

    '///<h3>Retrieve the value from a key=value pair as long</h3>
    '///<ul>

   ' This function takes a string that (hopefully) contains one '='
   ' and returns the value to the right from it, which must be a number..

   dim iCharPos as integer

   '///+<li>Locate the equal sign</li>
   iCharPos = instr( cLine , "=" )
   iCharPos = len( cLine ) - iCharPos
   
   '///+<li>Isolate and return the Value as long datatype</li>
   hGetValueForPairAsLong = val( right( cLine , iCharPos ))

   '///</ul>
   
end function

'*******************************************************************************

function hGetValueForKeyAsInt( lsList() as string, sKey as string ) as integer

    '///<h3>Retrieve the value of a key=value pair as integer</h3>
    '///<i>Prerequisite: Array compatible to listfuncs, known, valid key</i>
    '///<ul>

   ' This function returns the value of a key as string.
   ' The form of the input strings is 'key=value', the list is parsed
   ' The Value for the first occurrence of sKey is returned

   dim iItem as integer
   dim cString as string
   dim cComp as string

   hGetValueForKeyAsInt() = 0

   ' Scan through the list and look for sKey. If found, return the Value
   ' (everything to the right of the '=')
   '///+<li>Search the list for the key</li>
   for iItem = 1 to listcount( lsList() )
      if( instr( lsList( iItem ) , sKey ) <> 0 ) then
      
         '///+<li>Verify that this is really the correct key by reverse-checking</li>
         cComp = hGetKeyforPairAsString( lsList( iItem ) )
         
         '///+<li>Retrieve the value for the key as string</li>
         if( sKey = cComp ) then
            cString = hGetValueForPairAsString( lsList( iItem ) )
            iItem = listcount( lsList() ) + 1
         endif
         
      endif
   next iItem
   
   '///+<li>Convert the stringvalue to integer and return it</li> 
   hGetValueForKeyAsInt() = val( cString )

   '///</ul>
   
end function

'*******************************************************************************

function hGetKeyForPairAsString( cLine as string ) as string

    '///<h3>Retrieve the KEY from a key=value pair</h3>
    '///<ul>

   ' This function returns the string to the left of the '='

   dim iCharPos as integer

   iCharPos = instr( cLine , "=" )

   '///+<li>get the string to the left of the = char</li>
   if ( iCharPos > 0 ) then
      hGetKeyForPairAsString() = left( cLine , iCharPos -1 )
   else
      warnlog( "Invalid string passed to hGetKeyForPairAsString" )
      printlog( "It was: " & cLine )
   endif
   '///+<li>Return the key</li>
   '///</ul>
   
end function

'*******************************************************************************

function hGetKeyForValueAsString( lsList() as string, sVal as string ) as string

    '///<h3>Retrieve the KEY for a known VALUE from a key=value pair</h3>
    '///<i>Prerequisite: List compatible to listfuncs, known VALUE for pair</i><br>
    '///<ul>

   ' This function returns the value of a key as string.
   ' The form of the input strings is 'key=value', the list is parsed
   ' The key for the first occurrence of sVal is returned

   dim iCurrentValue as integer
   dim iListItems as integer
       iListItems = listcount( lsList() )
   dim cLine as string

   ' preset a default return string
   hGetKeyForValueAsString() = "Error: No matching KEY found for VALUE"

   '///+<li>scan through a list to find an entry that matches sKey. Return the Key.</li>
   for iCurrentValue = 1 to iListItems
   
      cLine = lsList( iCurrentValue )
      
      if( instr( cLine , sVal ) <> 0 ) then
         hGetKeyForValueAsString() = hGetKeyForPairAsString( cLine )
         iCurrentValue = iListItems + 1
      end if
      
   next iCurrentValue
   '///+<li>Return the key from the first matching value</li>
   '///</ul>
   
end function

'*******************************************************************************

function hGetKeyForValueAsInt( lsList() as string, sVal as string ) as integer

    '///<h3>Retrieve the KEY for a known VALUE from a key=value pair</h3>
    '///<i>Prerequisite: List compatible to listfuncs, known VALUE for pair</i><br>
    '///<ul>

    '///+<li>Use hgetKeyForValueAsString, convert result to integer, return it.</li>
    hGetKeyForValueAsInt() = val( hGetKeyForValueAsString( lsList() , sVal ) ) 
    '///</ul>
    
end function

'*******************************************************************************

function hGetValueForKeyAsLong( cLine as string ) as long

    '///<h3>Retrieve a VALUE for a key=value pair as long</h3>
    '///<ul>

   ' This function takes a string that (hopefully) contains one '='
   ' and returns the value to the right from it, which must be a number..
   dim iCharPos as integer

   '///+<li>Isolate the = sign</li>
   iCharPos = instr( cLine, "=" )
   iCharPos = len( cLine ) - iCharPos
   
   '///+<li>Isolate all to the right of the = and convert it to long</li>
   hGetValueForKeyAsLong  = val( right( cLine, iCharPos ))
   
   '///</ul>
   
end function

'*******************************************************************************

function hGetIndexForKeyAsInt( lsList() as string, sKey as string ) as integer

    '///<h3>Search a list of key=value pairs for a key and return its index</h3>
    '///<i>Prerequisite: List compatible to listfuncs, known VALUE for pair</i><br>
    '///<ul>    

   dim iItem as integer
   dim cComp as string

   hGetIndexForNamedKeyAsInt() = 0

   ' Scan through the list and look for sKey. If found, return the Value
   ' (everything to the right of the '=')
   '///+<li>Scan through the list for the KEY</li>
   for iItem = 1 to listcount( lsList() )
      if( instr( lsList( iItem ) , sKey ) <> 0 ) then
      
         '///+<li>if found, perform reverse checking</li>
         cComp = hGetKeyforValueAsString( lsList( iItem ) )
         
         '///+<li>get the index of the item</li>
         if( sKey = cComp ) then
            hGetIndexForKeyAsInt() = iItem
            iItem = listcount( lsList() ) + 1
         endif
         
      endif
   next iItem
   '///+<li>Return the index</li>
   '///</ul>

end function

'*******************************************************************************


function keycompare( found as string, expected as string, sKey as string, optional cBugID as string) as boolean

    '///<h3>Function to compare two keys with each other</h3>
    '///<u>Deprecated, do not use</u>

   if ( isMissing( cBugID ) ) then 
       cBugID = ""
   endif
   
   if ( lcase(found) = lcase(expected) ) then
      printlog( "     * '" & sKey & "': ok" )
      keycompare = true
   else
      warnlog( "#" + cBugID + "# Control has incorrect value: '" & sKey & "'")
      printlog( " > Found...: '" & found  & "'" )
      printlog( " > Expected: '" & expected & "'" )
      keycompare = false
   endif
   
end function


