'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: basicide_tools.inc,v $
'*
'*  $Revision: 1.23 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/05 13:07:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : tools for the property-browser test
' **
'*******************************************************************************
' **
' #1 hShowMacroControls ' tears off the ToolsCollectionBar
' #1 hGetBasicWorkFile  ' builds and returns the name of a workfile
' #1 hCreateBasicDialog ' Starts form the BASIC-IDE and creates a new dialog
' #1 hOpenBasicIde      ' Opens the BASIC-IDE from a plain document
' #1 hCloseBasicIde     ' Closes the BASIC-IDE (two attempts before fail)
' #1 hReopenBasicDialog ' Finds an existing BASIC-Dialog-Tab starting from a plain doc
' #1 hFindFirstDialog   ' Find the first dialog 
' #1 hSelectDialogPane  ' select the dialog pane in the dialogwindow
' #1 hCloseCollectionBar' close the ToolsCollectionBar if open
' #1 hInsertMacro       ' Insert a macro into the basic edit-window
' #1 hDeleteMacro       ' Delete all text from the basic edit-window
' #1 hIsEditWindowEmpty ' Find out whether there is text in the EditWindow or not
' #1 hTestMacro         ' Verify we have the correct module/tab open
' #1 hRenameTab         ' rename the tab in BASIC IDE
' #1 hGetTabNameFromOrganizer ' Get the tab-name using the Organizer
' #1 hNewDialog         ' create a new dialog
' #1 hNewModule         ' create a new module
' #1 hHideModule        ' hide the Basic module using the Organizer
' #1 hInitFormControls  ' Execute all functions to get to the formcontrols
' #1 hInitBasicIde      ' Execute all functions to get to the Basic-IDE
' #1 hCreateBasicWorkFiles ' Execute all steps to create a document with macros
' **
'\******************************************************************************

function hShowMacroControls() as boolean

    '///<h3>Tear off the ToolsCollectionBar from the MacroBar</h3>
    '///<i>Starting point: Basic dialog editor is open and has the focus</i>
    '///<ul>
    const CFN = "hShowMacroControls::"   

    dim iWait as integer
    dim brc as boolean

    
    '///+<li>Verify that the macro bar is available</li>
    Kontext "MacroBar"
    brc = false
    for iWait = 1 to 5
   
        if ( MacroBar.exists() ) then
            'printlog( CFN & "Macrobar is open (< " & iWait & "sec)." )
            brc = true
            exit for
        else
            sleep( 1 )
        endif
        
    next iWait
    
    '///+<li>Break the function if this is not the case, return false</li>
    if ( not brc ) then
        warnlog( CFN & "The Macrobar is not available" )
        hShowMacroControls() = false
        exit function
    endif
    
    '///+<li>Tear off the macro tools float, verify that it is open</li>
    Kontext "MacroBar"
    brc = false
    for iWait = 1 to 3 
    
        if ( controls.isEnabled() ) then
            printlog( CFN & "ToolsCollectionBar is open (<" & iWait & "sec)." )
            controls.click()
            controls.tearOff()
            brc = true
            exit for
        else
            sleep( 1 )
        endif
        
    next iWait
    
    if ( not brc ) then
        warnlog( CFN & "The Controls-button could not be accessed" )
        hShowMacroControls() = false
        exit function
    endif    
    
    '///+<li>Move the macro controls float to position x=50, y=50</li>
    Kontext "ToolsCollectionBar"
    ToolsCollectionBar.Move ( 50 , 50 )
    
    '///+<li>Return TRUE</li>
    hShowMacroControls() = true

    '///</ul>    
        
end function

'*******************************************************************************

function hGetBasicWorkFile( cMajorID as string ) as string

    '///<h3>Retrieve a filename, depending on gApplication and Build-ID</h3>
    '///<i>Structure: work-directory/basic[.suffix]</i>
    '///<ul>
    
    const CFN = "hGetBasicWorkFile::"
    
    dim sFile as string
    
    '///+<li>Build a path and a filename (path from UNO, Suffix from global-module)</li>
    sFile = hGetWorkPath() & "basic" & hGetSuffix( cMajorId )
    sFile = ConvertPath( sFile )
    
    printlog( CFN & sFile & " for " & gApplication & " (" & cMajorID & ")" )
        
    '///+<li>Return the path as string</li>
    hGetBasicWorkFile() = convertpath( sFile )
    
    '///</ul>

end function

'*******************************************************************************

function hCreateBasicDialog() as boolean

    '///<h3>Create a new BASIC dialog</h3>
    '///<i>Starting point: Basic IDE has focus, call CreateNewModuleForDoc in advance</i>
    '///<ul>
    const CFN = "hCreateBasicDialog::"

    '///+<li>Set context to Basic IDE</li>
    Kontext "BasicIDE"
    BasicIde.maximize()

    '///+<li>Open the context menu of the tabbar</li>
    Tabbar.OpenContextMenu
    sleep( 1 )
   
    '///+<li>Select the first item in the context menu - Insert</li>
    hMenuSelectNr( 1 )
    sleep( 1 )
   
    '///+<li>Select the secont item from the menu - New Dialog</li>
    hMenuSelectNr( 2 )

    '///+<li>verify that a new dialog window is open and has the focus, return TRUE on success</li>
    if ( not DialogWindow.Exists ( 2 ) ) then
        warnlog( CFN & "Dialog editor is not visible" )
        hCreateBasicDialog() = false
    else 
        printlog( CFN & "Dialog editor is visible" )
        hCreateBasicDialog() = true
    endif
    
    '///</ul>

end function

'*******************************************************************************

function hOpenBasicIDE() as boolean

    '///<h3>Open the Basic IDE for the last module listed in the Macro Organizer</h3>
    '///<i>Starting point: Basic Macro Organizer has focus</i>
    '///<ul>
    
    const CFN = "hOpenBasicIDE::"
    
    '///+<li>Select the last module in the treelist, verify that it can be edited</li>
    hSelectTheLastModule( true )
    
    '///+<li>Click the Edit-button</li>
    Bearbeiten.click()
    
    '///+<li>Maximize the Basic IDE (required to ensure proper operation of mousemovements)</li>
    sleep( 2 )
    kontext "BasicIde"
    BasicIde.maximize()
    
    '///+<li>Verify that the Basic IDE is open, return TRUE on success</li>
    if ( BasicIde.exists() ) then
       printlog( CFN & "Open Basic-IDE for existing module: success" )
       hOpenBasicIDE() = true
    else
       printlog( CFN & "Open Basic-IDE for existing module: failure" )
       hOpenBasicIDE() = false
    endif
    
    '///</ul>

end function

'*******************************************************************************

function hCloseBasicIDE() as boolean

    '///<h3>Close the BASIC-IDE trying file-menu, slot and hCloseDocument</h3>
    '///<i>Starting point: Basic IDE is open and has the focus</i>
    '///<ol>
    '///+<li>File-menu</li>
    '///+<li>Slot FileClose</li>
    '///+<li>hCloseDocument()/hDestroyDocument()</li>
    '///</ol>
    '///<ul>
    
    const CFN = "hCloseBasicIDE::"
    dim iDocCount as integer
    dim brc as boolean
    
    '///+<li>Get the current number of documents minus one for the Basic IDE</li>
    iDocCount = getDocumentCount() - 1

    '///+<li>Close the macro controls float</li>
    hCloseCollectionBar()

    '///+<li>Try to close the Basic IDE using the menu File/Close</li>
    '///<ul>
    Kontext "BasicIde"
    if ( BasicIDE.exists() ) then
    
        '///+<li>Access the menu</li>
        BasicIDE.useMenu()

        '///+<li>Select first entry (File)</li>
        hMenuSelectNr( 1 )
        sleep( 1 )

        '///+<li>Select fifth entry (Close)</li>
        hMenuSelectNr( 5 )
        sleep( 2 )
        
        '///+<li>On success: Leave the function, return TRUE</li>
        if ( getDocumentCount() = iDocCount ) then
            printlog( CFN & "File->Close via menu" )
            hCloseBasicIde() = true
            exit function
        endif
        '///</ul>
    endif
    
    '///+<li>On failure try second method: Slot FileClose</li>
    '///<ul>
    kontext "BasicIde"
    if ( BasicIDE.exists() ) then
    
        '///+<li>Use slot FileClose</li>
        FileClose
        
        '///+<li>On success: Leave the function, return TRUE</li>
        if ( getDocumentCount() = iDocCount ) then
            printlog( CFN & "Using slot FileClose" )
            hCloseBasicIde() = true
            exit function
        endif  
        '///</ul>
    endif

    '///+<li>On failure try third method (treat Basic IDE as any other document</li>
    brc = hDestroyDocument()
    if ( brc ) then
        qaerrorlog( CFN & "#i54135# Unknown document closed: Focus failed" )
        hCloseBasicIde = true
    else
        warnlog( CFN & "Unable to close Basic-IDE" )
        hCloseBasicIde() = false
    endif
    
    '///+<li>Return TRUE on success, FALSE on failure, warn about last method being used</li>
    '///</ul>


end function

'*******************************************************************************

function hReOpenBasicDialog() as boolean

    '///<h3>Open BASIC-IDE after loading a workfile with documentbound macro</h3>
    '///<i>Starting point: Focus on document containing at least one macro</i><br>
    '///<i>IMPORTANT: Errorhandling is incomplete, test may end up in undefined state</i>
    '///<ul>
    
    dim brc as boolean

    '///+<li>open the macro dialog, select the last module</li>
    brc = hSelectTheLastModule( true )
    if ( not brc ) then
        warnlog( "Could not open the last module for editing." )
        hReOpenBasicDialog() = false
        exit function
    endif

    '///+<li>edit the module</li>
    Bearbeiten.Click()

    '///+<li>find the dialog window.</li>
    kontext "BasicIDE"
    BasicIde.maximize()

    brc = hFindFirstDialog() 
    if ( not brc ) then
        warnlog( "Could not find any dialog" )
        hReOpenBasicDialog() = false
    else
        hReOpenBasicDialog() = true
    endif
    
    '///+<li>Return TRUE on success, FALSE on failure</li>
    '///</ul>

end function

'*******************************************************************************

function hFindFirstDialog() as boolean

    '///<h3>Find the first dialog in the BASIC-IDE</h3>
    '///<i>Starting point: Basic IDE must be open and has the focus</i>
    '///<ul>
    
    dim iPosOverTabbar as integer

    '///+<li>Set focus to Basic IDE, maximize it</li>
    kontext "BasicIde"
    BasicIde.maximize()
    

    hFindFirstDialog() = false

    '///+<li>move pointer over the tabbar and click until a dialog opens (hopefully)</li>
    for iPosOverTabbar = 1 to 20

        Tabbar.MouseDown ( 5 * iPosOverTabbar , 50 )
        Tabbar.MouseUp   ( 5 * iPosOverTabbar , 50 )

        if ( DialogWindow.Exists() ) then
            hFindFirstDialog() = true
            exit for
        endif

    next iPosOverTabbar
    
    '///+<li>Return TRUE on success, FALSE on failure</li>
    '///</ul>

end function

'*******************************************************************************

function hSelectDialogPane() as boolean

    '///<h3>Select the dialog pane in the Basic dialog editor</h3>
    '///<i>Starting point: Basic dialog editor is open and has the focus</i>
    '///<ul>

    dim brc as boolean
    
    '///+<li>Close the macro controls float, on failure: Return false and exit function</li>
    brc = hCloseCollectionBar()
    if ( not brc ) then
        warnlog( "Could not close ToolsCollectionBar" )
        hSelectDialogPane() = false
        exit function
    endif

    '///+<li>Select background dialog by rubberband</li>
    kontext "BasicIDE"
    
    DialogWindow.mouseDown( 10 , 10 )
    DialogWindow.mouseMove( 90 , 90 )
    DialogWindow.mouseUp( 90 , 90 )
    
    '///+<li>Return TRUE on success (not verified)</li>
    hSelectDialogPane() = true
    '///</ul>

end function

'*******************************************************************************

function hCloseCollectionBar() as boolean

    '///<h3>Close the ToolsCollectionBar (Macro Controls Float)</h3>
    '///<i>Starting point: Basic Dialog editor is open, ToolsCollectionBar is open</i>
    '///<ul>
    
    '///+<li>Try to close the ToolsCollectionBar (first attempt)</li>
    kontext "ToolsCollectionBar"
    if ( ToolsCollectionBar.exists() ) then
        printlog( "Closing ToolsCollectionBar" )
        ToolsCollectionBar.close()
    endif
    
    '///+<li>Retry, this should fail because no ToolsCollectionBar should be open</li>
    '///+<li>Return TRUE on success, FALSE on failure</li>
    kontext "ToolsCollectionBar"
    if ( ToolsCollectionBar.exists() ) then
        hCloseCollectionBar() = false
    else
        hCloseCollectionBar() = true
    endif    
    
    '///</ul>
    
end function

'*******************************************************************************

function hDeleteMacro() as boolean

    '///<h3>Delete all text in the Basic IDE editor</h3>
    '///<i>Starting point: Basic IDE is open, has focus, code can be edited</i>
    '///<ul>

    '///+<li>Verify all prerequisites are met (BasicIDE must be open)</li>
    kontext "BasicIDE"
    if ( not BasicIde.exists() ) then
        warnlog( "hDeleteMacro::BasicIDE is not visible/active. Aborting" )
        hDeleteMacro() = false
        exit function
    endif

    dim brc as boolean
    
    '///+<li>get the languagespecific accelerator for "Edit->Select All"</li> 
    dim cAccelerator as string
        cAccelerator = hGetAccel( "SelectAll" )
    
    printlog( "hDeleteMacro::Using Accel: " & cAccelerator )

    ' Common for all actions is that we delete the existing macro before
    ' inserting the new one. This fails if the accelerator for SelectAll
    ' is incorrect, we try to recover by doing this manually then.
    '///+<li>Delete the entire content of the Basic IDE editor</li>
    EditWindow.TypeKeys( cAccelerator )
    EditWindow.TypeKeys( "<Delete>" )

    ' Verify that the EditWindow is empty, if not use a method that
    ' should work for all languages/locales
    '///+<li>Verify that the editor window is indeed empty</li>
    brc = hIsEditWindowEmpty()
    if ( not brc ) then
        qaerrorlog( "#i52430# hDeleteMacro::Accelerator " & cAccelerator & " failed" )
        printlog( "hDeleteMacro::Trying alternative method" )
        EditWindow.TypeKeys( "<Mod1 Home>" )
        EditWindow.TypeKeys( "<Mod1 Shift End>" )
        EditWindow.TypeKeys( "<Delete>" )
        brc = hIsEditWindowEmpty()
    endif

    '///+<li>Return TRUE on success, FALSE on failure</li>
    hDeleteMacro() = brc
    '///</ul>

end function

'*******************************************************************************

function hIsEditWindowEmpty() as boolean

    '///<h3>Test if the Basic-EditWindow is empty</h3>
    '///<i>Starting point: Basic IDE editor is open and has the focus</i>
    '///<ul>
    
    '///+<li>Verify that prerequisites are met: Basic IDE must be open</li>
    kontext "BasicIDE"
    if ( not BasicIDE.exists() ) then
        warnlog( "hIsEditWindowEmpty::BasicIde is not open/visible" )
        hIsEditWindowEmpty() = false
        exit function
    endif

    '///+<li>Verify that the EditWindow is empty. EditCopy is disabled when empty</li>
    EditWindow.TypeKeys( "<Mod1 Home>" )
    EditWindow.TypeKeys( "<Mod1 Shift End>" )
    try
        EditCopy
        warnlog( "EditCopy should be enabled for empty Basic IDE editor" )
    catch
        setClipboard( "" )
    endcatch

    if ( getClipBoardText() <> "" ) then
        hIsEditWindowEmpty() = false
        printlog( "hIsEditWindowEmpty::no" )
    else
        hIsEditWindowEmpty() = true
        printlog( "hIsEditWindowEmpty::yes" )
    endif
    
    '///+<li>Return TRUE on success, FALSE on failure</li>
    '///</ul>

end function

'*******************************************************************************

function hRenameTab( cTabName as string ) as integer

    '///<h3>Rename the first tab in the Basic IDE Tabbar</h3>
    '///<i>Starting point: Basic IDE is open, at least one tab exists<br>
    '///Return values are:
    '///<ul>
    '///+<li>0 = Tab was correctly renamed</li>
    '///+<li>1 = Invalid name warning is displayed (handle outside of function)</li>
    '///+<li>2 = Unknown error / failed to rename the tab</i></li>
    '///</ul>
    '///Description
    '///<ul>
    
    const CFN = "hRenameTab::"
    
    dim cString as string
    dim iWait as integer

    cString = "<HOME><SHIFT END>" & cTabName & "<RETURN>" 
    
    '///+<li>Open the context menu of the tabbar</li>
    try
        kontext "basicide"
        Tabbar.OpenContextMenu
        
        '///+<li>Select to rename the tab</li>
        hMenuSelectNr( 3 )
        sleep( 2 )
        
        '///+<li>Overwrite the old name of the tab</li>
        '///+<li>Handle possible errors</li>
        kontext "basicide"
        Tabbar.TypeKeys( cString , true )
        hRenameTab() = 0
        printlog( CFN & "Renamed tab to: " & cTabName )
    catch
        hRenameTab() = 2
        warnlog(  CFN & "Failed to rename tab" )
    endcatch
    
    kontext "active"
    for iWait = 1 to 3
        sleep( 1 )
        if ( active.exists() ) then
            hRenameTab() = 1
            printlog( CFN & "Invalid name for tab: Warning is displayed" )
            exit for
        endif
    next iWait
    '///+<li>Return 0, 1 or 2</li>
    '///</ul>
    
end function

'*******************************************************************************

function hGetTabNameFromOrganizer() as string

    '///<h3>Retrieve the name of a tab from the Basic Library Organizer</h3>
    '///<i>Starting point: Basic IDE is open and has the focus</i>
    '///<ul>

    const CFN = "hGetTabNameFromOrganizer::"
    dim cReturnString as string

    '///+<li>Open the Basic Library Organizer</li>
    '///+<li>Go to the Module-Tab</li>
    '///+<li>Get the name of the currently selected item from the Module-list</li>
    '///+<li>Close the Macro Library Organizer</li> 
    if ( hOpenBasicObjectOrganizer( 1 ) ) then
        cReturnString = Modulliste.GetSelText()
        TabModule.Close()
        printlog( CFN & "Returning Tab-Name: " & cReturnString )
    else
        cReturnString = "Failure: Macro Organizer not open"
        warnlog( CFN & cReturnString )
        
    endif
    
    '///+<li>Return the name from the Module-list</li>
    hGetTabNameFromOrganizer() = cReturnString
    '///</ul>
   
end function

'*******************************************************************************

function hNewDialog() as boolean

    '///<h3>Create a new BASIC dialog</h3>
    '///<i>Starting point: Basic IDE is open</i>
    '///<ul>

    const CFN = "hNewDialog::"

    '///+<li>Open the context menu for the tabbar</li>
    kontext "basicide"
    Tabbar.OpenContextMenu
    
    '///+<li>Select the first item (insert)</li>
    hMenuSelectNr( 1 )
    sleep( 1 )
    
    '///+<li>Select the second item (new dialog)</li>
    hMenuSelectNr( 2 )
    sleep( 2 )
    
    '///+<li>Verify that a new dialog is opened and has the focus</li>
    if ( DialogWindow.Exists() ) then 
        printlog( CFN & "New dialog is open" )
        hNewDialog() = true 
    else
        warnlog( CFN & "New dialog is not open" )
        hNewDialog() = false
    endif
    '///+<li>Return TRUE on success, FALSE on failure</li>
    '///</ul>

end function

'*******************************************************************************

function hNewModule() as boolean

    '///<h3>Create a new BASIC module</h3>
    '///<i>Starting point: Basic IDE is open</i>
    '///<ul>

    const CFN = "hNewModule::"

    '///+<li>Open the context menu for the tabbar</li>
    kontext "basicide"
    Tabbar.OpenContextMenu
    
    '///+<li>Select the first item (insert)</li>
    hMenuSelectNr( 1 )
    sleep( 1 )
    
    '///+<li>Select the first item (new module)</li>
    hMenuSelectNr( 1 )
    sleep( 2 )
    
    '///+<li>Verify that a new module is opened and has the focus</li>
    if ( EditWindow.Exists() ) then 
        printlog( CFN & "New module is open" )
        hNewModule() = true 
    else
        warnlog( CFN & "New module is not open" )
        hNewModule() = false
    endif
    '///+<li>Return TRUE on success, FALSE on failure</li>
    '///</ul>

end function        

'*******************************************************************************

function hHideModule() as boolean

    '///<h3>Hide a Basic Module from the IDE</h3>
    '///<i>Starting point: Basic IDE is open and has the focus</i>
    '///<ul>

    const CFN = "hHideModule::"
    
    kontext "basicide"
    
    '///+<li>Open the context menu of the tabbar</li>
    try
       tabbar.openContextMenu
       
       '///+<li>Select the fourth entry (Hide)</li>
       hMenuSelectNr( 4 )
       sleep( 1 )
       hHideModule() = true
       printlog( CFN & "Success" )
    catch
       hHideModule() = false 
       warnlog( CFN & "Failure" )
    endcatch
    '///+<li>Return TRUE on success, FALSE on any other condition (not verified)</li>
    '///</ul>
   
end function   

'*******************************************************************************

function hInitFormControls( cModule as string ) as boolean

    '///<h3>Get from a new document to the Macro Controls Float in one go</h3>
    '///<i>Starting point: Plain document</i><br>
    '///This function performs following steps:
    '///<ol>
    '///+<li>Open the Basic Organizer</li>
    '///+<li>Create a new module for the current document</li>
    '///+<li>Open a new basic dialog</li>
    '///+<li>Open the Macro controls float</li>
    '///</ol>
    '///Description:
    '///<ul>
    
    const CFN = "hInitFormControls::"    
    dim brc as boolean
    '///+<li>Create and edit a new module for the current document</li>
    brc = hInitBasicIde( cModule )
    if ( not brc ) then
        warnlog( "Could not create new module" )
        hCloseBasicIde()
        hInitFormControls() = false
        exit function
    endif        

    '///+<li>Create a new dialog.</li>
    brc = hCreateBasicDialog()
    if ( not brc ) then
        warnlog( "Could not create Basic-Dialog" )
        hCloseBasicIde()
        hInitFormControls() = false
        exit function
    endif    
    
    '///+<li>Open the macro controls float.</li>
    brc = hShowMacroControls()
    if ( not brc ) then
        warnlog( CFN & "Could not tear off the macro controls float" )
        hCloseBasicIde()
        hInitFormControls() = false
        exit function            
    endif
    
    '///+<li>Return TRUE if all went well, FALSE on any other error</li>
    hInitFormControls() = true
    '///</ul>
    '///NOTE: The function will try to cleanup after itself in case of failure
    
end function

'*******************************************************************************

function hInitBasicIde( cModule as string ) as boolean

    '///<h3>Get from a new document to the Basic IDE in one go</h3>
    '///<i>Starting point: New, plain document</i>
    '///<uL>

    const CFN = "hInitBasicIde::"

    if ( cModule = "" ) then
        warnlog( CFN & "Invalid parameter passed to function" )
        hInitBasicIde() = false
        exit function
    endif        
    
    ' some multi-purpose return code 
    dim brc as boolean 
    
    '///+<li>Open the basic Organizer</li>
    brc = hOpenBasicOrganizerFromDoc()
    if ( not brc ) then
        warnlog( CFN & "Could not open the Basic Organizer, aborting" )
        hInitBasicIde() = false
        exit function
    endif

    '///+<li>Create a new module for the current document</li>
    brc = hCreateModuleForDoc( cModule )
    if ( not brc ) then
        warnlog( CFN & "The Basic-IDE is not open, aborting" )
        hInitBasicIde() = false
        
        kontext "Makro"
        if ( Makro.exists() ) then
            printlog( CFN & "Closed Macro Organizer" )
            Makro.cancel()
        endif
        exit function
    endif
    
    '///+<li>Verify that the Basic IDE is open, return TRUE on success, FASLE on failure</li>
    hInitBasicIde() = true
    '///</ul>
    '///NOTE: The function will try to to clean up after itself in case of any error    
    
end function 

'*******************************************************************************

function hInsertMacro( _id as integer ) as boolean

    '///<h3>Insert a macro into the Basic-IDE edit window by Index</h3>
    '///<i>Starting point: Basic IDE is open, has the focus</i>
    '///<ul>
    
    const CFN = "hInsertMacro::"
    dim brc as boolean
    
    if ( ( _id < 1 ) or ( _id > 3 ) ) then
        warnlog( CFN & "Invalid parameter passed to function: " & _id )
        hInsertMacro() = false
        exit function
    endif
    
    kontext "basicide"
    
    '///+<li>Delete the content of the edit window</li>
    brc = hDeleteMacro()
    if ( not brc ) then
        warnlog( CFN & "Content of Basic-IDE was not deleted" )
        hInsertMacro() = false
        exit function
    endif
        
    '///+<li>Insert a macro by index (passed as function parameter)</li>
    select case _id
    case 1 :
        ' this is a working macro that contains no errors
        EditWindow.TypeKeys( "'# TTMacro1: This is a short testscript for automated testing!<return><return>" )
        EditWindow.TypeKeys( "sub main<return><return>" )
        EditWindow.TypeKeys( "print " & Chr (34) + "hallo" & Chr (34) )
        EditWindow.TypeKeys( "<Return><Return>" )
        EditWindow.TypeKeys( "<Home>end sub<return>" )
        hInsertMacro() = true
        printlog( CFN & "Inserted: " & _id )
    case 2 :
        EditWindow.TypeKeys( "'# TTMacro2: a second module for automated testing!" )
        EditWindow.TypeKeys( "<Return><Return>" )
        hInsertMacro() = true
        printlog( CFN & "Inserted: " & _id )
    case 3 :
        EditWindow.TypeKeys( "'# TTMacro3: Bring up a messagebox<return><return>" )
        EditWindow.TypeKeys( "sub main<return><return>" )
        EditWindow.TypeKeys( "    msgbox " & Chr (34) + "TTMacro3" & Chr (34) )
        EditWindow.TypeKeys( "<Return><Return>" )
        EditWindow.TypeKeys( "<Home>end sub<return>" )
        hInsertMacro() = true  
        printlog( CFN & "Inserted: " & _id )
    end select
   
    '///</ul>
    
end function

'*******************************************************************************

function hTestMacro( _id as integer ) as integer

    '///<h3>Verify that the correct macro is visible in the IDE edit Window</h3>
    '///<i>Starting point: Basic IDE is open and has focus</i>
    '///<ul>
    
    const CFN = "hTestMacro::"

    kontext "basicide"

    '///+<li>Copy the first line in the editwindow to clipboard</li>  
    EditWindow.TypeKeys( "<Mod1 Home>" )
    EditWindow.TypeKeys( "<Home><Shift End>" ) 
    EditCopy
    
    '///+<li>Compare the string to a unique substring for the macro</li>
    select case _id
    case 1 :
        if ( Instr ( GetClipboardText, "TTMacro1" ) <> 0 ) then
            printlog( CFN & "The correct macro is displayed in the editwindow" )
            htestMacro() = 1
            exit function
        endif
    case 2 :
        if ( Instr ( GetClipboardText, "TTMacro2" ) <> 0 ) then
            printlog( CFN & "The correct macro is displayed in the editwindow" )
            htestMacro() = 2
            exit function
        endif
    case 3 :
        if ( Instr ( GetClipboardText, "TTMacro3" ) <> 0 ) then
            printlog( CFN & "The correct macro is displayed in the editwindow" )
            htestMacro() = 3
            exit function
        endif        
    end select
    
    hTestMacro() = 0
    '///</ul>
    
end function

'*******************************************************************************

function hCreateBasicWorkFiles() as string

    '///<H3>Create a macro, attach it to a file, save the file</H3>
    '///<i>Starting point: The first doc or any other plain document</i>
    '///<ul>
    const CFN = "hCreateBasicWorkFiles::"
    const CMACRO = "TestMacro"
    
    ' some returncodes
    dim brc as boolean
    dim irc as integer
    dim crc as string
    
    dim sFile as string
        sFile = hGetBasicWorkFile( "CURRENT" )
        
    '///+<li>Delete the workfile if it exists</li>
    brc = hDeleteFile( sFile )
    
    '///+<li>Open a new document</li>
    call hCreateDocument()
    
    '///+<li>Change the document (to save it)</li>
    crc = hChangeDoc()
    printlog( CFN & crc )
    
    '///+<li>Open Basic-Organizer, select the document and create a module</li>
    brc = hInitBasicIde( CMACRO )
    if ( not brc ) then
        printlog( CFN & "Unable to create a module, aborting" )
        call hDestroyDocument()
        hCreateBasicWorkFiles() = ""
        exit function
    endif
    
    '///+<li>Insert a macro that triggers a messagebox</li>
    brc = hInsertMacro( 3 )
    if ( not brc ) then
        printlog( CFN & "Unable to insert macro, aborting" )
        hCloseBasicIde()
        call hDestroyDocument()
        hCreateBasicWorkFiles() = ""
        exit function
    endif
    
    '///+<li>Close the Basic-IDE</li>
    brc = hCloseBasicIde()
    
    '///+<li>Save the file without autoextension to a new file</li>
    brc = hSaveFile( sFile , "" , false , false )
    if ( not brc ) then
        printlog( CFN & "Unknown error while saving the file. Resetting" )
        call ExitRestartTheOffice
        hCreateBasicWorkFiles() = ""
        exit function
    endif
    
    '///+<li>Close the document</li>
    call hDestroyDocument()
    
    '///</ul>
    
end function
