'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: l1_ole_ctrl.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : Level 1 test for OLE objects (save/load/activate ...) 
'*
'*******************************************************************************
' **
' #0 l1_ole_first           ' first quick OLE test
' #0 l1_OLE_ctrl_basics     ' basic OLE tasks
' #0 l1_ole_ctrl_writer     ' OLE in Writer
' #0 l1_ole_ctrl_calc       ' OLE in Calc
' #0 l1_ole_ctrl_impress    ' OLE in Impress
' #0 l1_ole_ctrl_draw       ' OLE in Draw
' #0 l1_ole_ctrl_globaldoc  ' OLE in Global-Document
' **
'\******************************************************************************

global OLEApp as string ' used to communicate the current type of OLE
                        ' object to be inserted. 

'*******************************************************************************

sub l1_ole_first

   PrintLog "******  OLE  ******" + Chr(13)
   Call tOLEWriter
   Call tOLECalc
   Call tOLEDraw
   Call tOLEImpress

end sub

'*******************************************************************************

sub l1_ole_ctrl_basics

   call ClosePresentationfloat() 'closes the presentation float. hopefully

   Call GetOLEDefaultNames

   PrintLog Chr(13) + "*******  insert OLE-Objects  *******"
   PrintLog "************  OLE2/3.INC  ***********" + Chr(13)

   Call tCheckTheOLEObjectDialog

   Call hSetToStandardView ( "WRITER" )
   Call hSetToStandardView ( "GLOBALDOC" )
   
end sub

'*******************************************************************************

sub l1_ole_ctrl_writer

   gApplication = "WRITER"
   PrintLog Chr(13) + "  documenttype :" + gApplication
   Call tCalc_as_OLE_Object
   Call tDRAW_as_OLE_Object
   Call tImpress_as_OLE_Object
   Call tChart_Math_as_OLE_Object ( "CHART" )
   Call tChart_Math_as_OLE_Object ( "MATH" )
   
end sub

'*******************************************************************************

sub l1_ole_ctrl_calc

   gApplication = "CALC"
   PrintLog Chr(13) + "  documenttype :" + gApplication
   Call tDraw_as_OLE_Object
   Call tImpress_as_OLE_Object
   Call tWriter_as_OLE_Object
   Call tChart_Math_as_OLE_Object ( "CHART" )
   Call tChart_Math_as_OLE_Object ( "MATH" )
   
end sub

'*******************************************************************************

sub l1_ole_ctrl_impress

   gApplication = "IMPRESS"
   PrintLog Chr(13) + "  documenttype :" + gApplication
   Call tCalc_as_OLE_Object
   Call tDraw_as_OLE_Object
   Call tWriter_as_OLE_Object
   Call tChart_Math_as_OLE_Object ( "CHART" )
   Call tChart_Math_as_OLE_Object ( "MATH" )
   
end sub

'*******************************************************************************

sub l1_ole_ctrl_draw

   gApplication = "DRAW"
   PrintLog Chr(13) + "  documenttype :" + gApplication
   Call tCalc_as_OLE_Object
   Call tImpress_as_OLE_Object
   Call tWriter_as_OLE_Object
   Call tChart_Math_as_OLE_Object ( "CHART" )
   Call tChart_Math_as_OLE_Object ( "MATH" )
   
end sub

'*******************************************************************************

sub l1_ole_ctrl_globaldoc

   'warnlog( ".sgl files are loaded as Math-files, BUGID: #112432 'API: fwl.TypeDetection::XTypeDetection', skipping GLOBALDOC" )
   gApplication = "GLOBALDOC"
   PrintLog Chr(13) + "  documenttype :" + gApplication
   Call tCalc_as_OLE_Object
   Call tDRAW_as_OLE_Object
   Call tImpress_as_OLE_Object
   Call tChart_Math_as_OLE_Object ( "CHART" )
   Call tChart_Math_as_OLE_Object ( "MATH" )

end sub

