'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: l1_ole2.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/11/24 16:30:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : thorsten.bosbach@sun.com
'*
'* short description : global-level-1-test -> insert all OLE-Objects out of OLE-dialog into all doc-types
'*
'*******************************************************************************
' **
' #1 tCheckTheOLEObjectDialog ' test the OLE selection dialog
' #1 tWriter_as_OLE_Object    ' insert a writer document via ole
' #1 tImpress_as_OLE_Object   ' insert an impress document via ole
' **
'\******************************************************************************


testcase tCheckTheOLEObjectDialog
'///check in all applications ( Writer/Calc/Draw/Impress/Masterdocument ) the names of all OLE-Objects in the OLE-Dialog

   Dim lListe (10) as String : Dim lListSoll (10) as String
   Dim i, j as Integer
   Dim iCount, sCount as Integer

   for i=1 to 5
   
      select case i
         case 1 : gApplication = "WRITER"
         case 2 : gApplication = "CALC"
         case 3 : gApplication = "IMPRESS"
         case 4 : gApplication = "DRAW"
         case 5 : gApplication = "GLOBALDOC"
      end select
      
      lListe ( 0 ) = 0 : lListSoll ( 0 ) = 0
      printlog "check OLE-Object-Dialog for " + gApplication
      
      '///file / new / .sxw or .sxc, .sxd, .sxi, .sxm 
      Call hNewDocument
      
      '///+insert / objects / OLE-objects
      InsertObjectOLEObject

      Kontext "OLEObjektEinfuegen"
      if ( not OLEObjektEinfuegen.exists() ) then
        warnlog( "cannot access the OLE object dialog" )
      endif
      
      '///+select 'create new'
      NeuErstellen.Check
      Sleep (1)
      
      '///+check all names in the list with a comparison list in [TesttoolPath]\global\input\olenames\ole_[lang-code].txt
      for j=1 to ObjektTyp.GetItemCount
         ObjektTyp.Select j
         ListAppend ( lListe(), ObjektTyp.GetSelText )
      next j
      
      ListSort ( lListe() )
      iCount = ListCount ( lListe() )
      
      select case gApplication
         case "WRITER"    : ListAppend ( lListSoll (), gOLECalc )
                            ListAppend ( lListSoll (), gOLEImpress )
                            ListAppend ( lListSoll (), gOLEDraw )
                            ListAppend ( lListSoll (), gOLEChart )
                            ListAppend ( lListSoll (), gOLEMath )
         case "CALC"      : ListAppend ( lListSoll (), gOLEWriter )
                            ListAppend ( lListSoll (), gOLEImpress )
                            ListAppend ( lListSoll (), gOLEDraw )
                            ListAppend ( lListSoll (), gOLEChart )
                            ListAppend ( lListSoll (), gOLEMath )
         case "DRAW"      : ListAppend ( lListSoll (), gOLECalc )
                            ListAppend ( lListSoll (), gOLEImpress )
                            ListAppend ( lListSoll (), gOLEWriter )
                            ListAppend ( lListSoll (), gOLEChart )
                            ListAppend ( lListSoll (), gOLEMath )
         case "IMPRESS"   : ListAppend ( lListSoll (), gOLECalc )
                            ListAppend ( lListSoll (), gOLEDraw )
                            ListAppend ( lListSoll (), gOLEWriter ) 
                            ListAppend ( lListSoll (), gOLEChart )
                            ListAppend ( lListSoll (), gOLEMath )
         case "GLOBALDOC" : ListAppend ( lListSoll (), gOLECalc ) 
                            ListAppend ( lListSoll (), gOLEImpress )
                            ListAppend ( lListSoll (), gOLEDraw ) 
                            ListAppend ( lListSoll (), gOLEChart )
                            ListAppend ( lListSoll (), gOLEMath )
      end select
      
      if gPlatgroup = "w95" then 
         ListAppend ( lListSoll (), gOLEOthers )
         endif
         
      ListSort ( lListSoll () )
      sCount = ListCount ( lListSoll () )
      
      if iCount <> sCount then
         Warnlog "Expected: " + sCount + "   Found: " + iCount
      else
         for j=1 to sCount
            if lListe (j) <> lListSoll (j) then 
               Warnlog "Expected: '" + lListSoll (j) + "'   Found: '" + lListe (j) +"'"
               endif
         next j
      end if
      
      '///+cancel the dialog
      OLEObjektEinfuegen.Cancel
      '///+close the document and repeat it for each application
      hCloseDocument()
   next i
endcase


' ******************************************************************************

testcase tWriter_as_OLE_Object
'///Test a Writer-OLE-Object in Calc / Impress / Draw

   Dim Pfad$ : Dim sDatei : Dim Extention$

   PrintLog "    Writer as OLE-Object"

   '///open a new document ( Calc / Impress / Draw )
   Call hNewDocument
   
'///+insert / object / OLE-object
   PrintLog "    - insert"
   InsertObjectOLEObject
   
   Kontext "OLEObjektEinfuegen"
   
   '///+select 'create new'
   NeuErstellen.Check
   
   '///+select the text-OLE-object 
   '( you can find the name for each language at 
   '[TesttoolPath]/global/input/olenames/ole_[lang-code].txt )
   ObjektTyp.Select gOLEWriter
   
   '///+click 'OK'
   OLEObjektEinfuegen.OK

   '///+click into the document to deactivate the edit-mode for the OLE-Object
   Sleep ( 5 )
   if gApplication = "DRAW" then gMouseClick ( 1, 1 )
   if gApplication = "IMPRESS" then gMouseClick ( 1, 1 )
   if gApplication = "HTMLDOKUMENT" then gMouseClick ( 99, 99 )
   if gApplication = "CALC" then
       Kontext "DocumentCalc"
       DocumentCalc.TypeKeys "<Escape>"
   end if

   '///+file / save -> in a local directory
   PrintLog "    - save"
   FileSave
   
   Kontext "SpeichernDlg"
   If AutomatischeDateinamenserweiterung.IsChecked then 
      AutomatischeDateinamenserweiterung.Uncheck
      endif

   select case gApplication
      case "DRAW"         : Extention$ = ".sxd"
      case "IMPRESS"      : Extention$ = ".sxi"
      case "CALC"         : Extention$ = ".sxc"
      case "MATH"         : Extention$ = ".sxm"
   end select
   
   sDatei = ConvertPath ( gOfficePath + "user\work\ole_text" + Extention$ )
   if app.Dir ( sDatei ) <> "" then app.kill sDatei
   Dateiname.SetText sDatei
   Speichern.Click

   Kontext "Active"
   try
      If Active.Exists then Active.Yes
   catch
      If Active.Exists then Active.Ok
   endcatch
   Sleep ( 3 )

   '///+file / close
   PrintLog "    - close"
   Call hCloseDocument

   '///+file / open => the saved document
   PrintLog "    - open"
    hDateiOeffnen(sDatei)
   
   '///+activate the OLE-Object with a doubleclick
   '///+and deactivate the Editmode with 'Escape'
   PrintLog "    - activate OLE-Object"
   
   if gApplication = "DRAW" then
      Kontext "DocumentDraw"
      DocumentDraw.MouseDoubleClick ( 50, 50 )
      Sleep 10
      gMouseClick ( 1, 1 )
   end if

   if gApplication = "IMPRESS" then
      Kontext "DocumentImpress"
      DocumentImpress.MouseDoubleClick ( 50, 50 )
      Sleep 10
      gMouseClick ( 1, 1 )
   end if

   if gApplication = "CALC" then
      gMouseClick ( 2, 2 )
      DocumentCalc.MouseDoubleClick ( 50, 50 )
      Sleep 10
      DocumentCalc.TypeKeys "<Escape>"
   end if

   '///+close the document
   Sleep 5
   Call hCloseDocument
endcase

'*******************************************************************************

testcase tImpress_as_OLE_Object
   '///Test a Impress-OLE-Object in Writer / Calc / Draw / Masterdocument
   Dim Pfad$
   Dim sDatei
   Dim Extention$
   
   PrintLog "    Impress as OLE-Object"
   '///open a new document ( Writer / Calc / Draw / Masterdocument )
   Call hNewDocument
   PrintLog "    - insert"
   '///+insert / object / OLE-object
   InsertObjectOLEObject
   
   Kontext "OLEObjektEinfuegen"
   if OLEObjektEinfuegen.exists(5) then
       '///+select 'create new'
       NeuErstellen.Check
       '///+select the impress-OLE-object ( you can find the name for each language at [TesttoolPath]/global/input/olenames/ole_[lang-code].txt )
       ObjektTyp.Select gOLEImpress
       '///+click 'OK'
       OLEObjektEinfuegen.OK
   else
       warnlog ("OLE Object insert dialog is not available")
   endif
   Sleep ( 5 )
   
   '///+click into the document to deactivate the edit-mode for the OLE-Object
   select case gApplication
      case "WRITER"    : printlog "      Select " + gApplication
                         gMouseClick ( 1, 1 )
      case "GLOBALDOC" : printlog "      Select " + gApplication
                         Kontext "DocumentMasterDoc"
                         DocumentMasterDoc.MouseDoubleClick ( 1, 1 )
      case "DRAW"      : printlog "      Select " + gApplication
                         gMouseClick ( 99, 99 )
      case "CALC"      : printlog "      Select " + gApplication
                         try
                             Kontext "DocumentCalc"
                             DocumentCalc.TypeKeys "<Escape>"
                         catch
                            Warnlog "Cannot switch to Calc-document, retrying"
                            Sleep ( 5 )
                            Kontext "DocumentCalc"
                            gMouseClick( 99 , 99 )
                            DocumentCalc.TypeKeys "<Escape>"
                         endcatch
   end select

   '///+file / save -> in a local directory
   PrintLog "    - save"
   FileSave

   Kontext "SpeichernDlg"
   If AutomatischeDateinamenserweiterung.IsChecked then 
       AutomatischeDateinamenserweiterung.Uncheck
   endif
   select case gApplication
      case "WRITER"       : Extention$ = ".sxw"
      case "DRAW"         : Extention$ = ".sxd"
      case "CALC"         : Extention$ = ".sxc"
      case "MATH"         : Extention$ = ".sxm"
      case "GLOBALDOC"    : Extention$ = ".sgl"
   end select
   sDatei = ConvertPath ( gOfficePath + "user\work\ole_impr" + Extention$ )
   if app.Dir ( sDatei ) <> "" then app.kill sDatei
   Dateiname.SetText sDatei
   Speichern.Click

   Kontext "Active"
   if Active.Exists(5) then
       try
           Active.Yes
       catch
           Active.Ok
       endcatch
   endif

   '///+file / close
   PrintLog "    - close"
   Call hCloseDocument

   '///+file / open => the saved file
   PrintLog "    - open"
    hDateiOeffnen(sDatei)

   '///+activate the OLE-Object with a doubleclick
   '///+and deactivate the Editmode with 'Escape'
   ' Requires special treatment for each application.
   PrintLog "    - activate OLE-Object"
   
   select case gApplication 
   
      case "WRITER"    : printlog "      Activate OLE in " + gApplication
                         Kontext "DocumentWriter"
                         DocumentWriter.MouseDoubleClick ( 50, 50 )
                         sleep ( 10 )
                         gMouseClick ( 1, 1 )
      case "CALC"      : printlog "      Activate OLE in " + gApplication
                         gMouseClick ( 20, 20 )
                         DocumentCalc.MouseDoubleClick ( 20, 20 )
                         
                         try
                            Sleep ( 10 )
                            DocumentCalc.TypeKeys "<Escape>"
                         catch
                            Warnlog "Cannot switch to Calc Document, retrying"
                            Sleep ( 5 )
                            gMouseClick( 99 , 99 )
                            DocumentCalc.TypeKeys "<Escape>"
                         endcatch
                         
      case "DRAW"      : printlog "      Activate OLE in " + gApplication
                         Kontext "DocumentDraw"
                         DocumentDraw.MouseDoubleClick ( 50, 50 )
                         Sleep ( 10 )
                         gMouseClick ( 1, 1 )
      case "GLOBALDOC" : printlog "      Activate OLE in " + gApplication
                         if isOleAvailable() then
                             Kontext "DocumentMasterDoc"
                             DocumentMasterDoc.MouseDown( 50 , 50 , 1 )
                             DocumentMasterDoc.MouseUp( 50 , 50 , 1 )
                             try
                                 EditObjectEdit
                             catch
                                 qaerrorlog "needed some more time 1"
                                 sleep 5
                                 try
                                     EditObjectEdit
                                 catch
                                     warnlog "Still no success on edit->object->edit"
                                 endcatch
                             endcatch
                             sleep ( 10 )
                             Kontext "DocumentMasterDoc"
                             DocumentMasterDoc.MouseDoubleClick ( 1, 1 )
                         else
                             qaErrorLog "#i44725# OLE Object not saved in Master Document"
                         endif
   end select
   '///+close the document
   Sleep ( 5 )
   Call hCloseDocument()
endcase
