'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/19 12:55:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tHelpRessourceTest  ' travels through the index and loads all pages.
' **
'\******************************************************************************

testcase tHelpRessourceTest( iCurrentAboutItem as integer )

   const ICWAIT as Integer = 1
   dim iTopicCount as integer
   dim iAboutItems as integer
   dim iCurrentTopic as integer
   dim cCurrentTopic as integer
   dim cCurrentAboutItem as string
   dim brc as boolean
   
   '///<h1>Ressourcetest for OpenOffice.org help viewer</h1>
   '///<h2>help.bas::tHelpRessourceTest</h2>
   '///<ul>
   '///<li>Open help</li>
   brc = hOpenHelp()
   if ( not brc ) then
       warnlog( "Unable to open Help Browser, aborting test" )
       goto endsub
   endif
   brc = hSelectHelpTab( "index" )
   Kontext "IndexPage"

   '///<li>set and printout the current application for which to display the index</li>
   HelpAbout.select( iCurrentAboutItem )
   sleep( ICWAIT * 3 )

   '///<li>retrieve the text from the Multilistbox</li>
   cCurrentAboutItem = HelpAbout.getSelText()
   printlog( " " )
   printlog( " * Current Application: " & cCurrentAboutItem )

   '///<li>get number of entries in combo-box (help topics)</li>
   iTopicCount = SearchIndex.getItemcount()
   printlog( "Viewing " & iTopicCount & " entries" )
   printlog( " " )

   '///<li>open every item in the index, one by one</li>
   for iCurrentTopic = 1 to iTopicCount 

      try
         '///<li>select one item from the list</li>
         SearchIndex.Select( iCurrentTopic )
      catch
         warnlog( "Failed to select entry at " & iCurrentTopic )
         exit for
      endcatch

      wait( 500 )
      cCurrentTopic = SearchIndex.getItemText()

      '///<li>press the "Display" button</li>
      DisplayIndex.click()

   next iCurrentTopic

   '///<li>close help</li>
   brc =  hCloseHelp()
   
   call ExitRestartTheOffice()
   '///</ul>
   
endcase


