'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: FTPServer_tools.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:08:13 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( extended tests )
'*
'*******************************************************************************
'**
' #1 FTPLoadFileExpectSuccess   ' try to load a file - success expected
' #1 FTPLoadFileExpectFailure   ' try to read a file - failure expected
' #1 FTPSaveFileExpectSuccess   ' try to save a file - success expected
' #1 FTPSaveFileExpectFailure   ' try to save a file - failure expected
' #1 FTPDeleteFileExpectSuccess ' Delete a file/directory - success expected
' #1 FTPDeleteFileExpectFailure ' Delete a file/directory - failure expected
' #1 FTPCreateNewDirectory      ' create a new directory using FileOpen
' #0 DisableProxies             ' set proxy to NONE 
' #0 EnableProxies              ' re-enable proxies disabled by DisableProxies
' #0 FTPServerConnect           ' Try to open a ftp-url
' #1 FTPEnterValidPassword      ' Enter a valid password for an user
' #1 FTPEnterInvalidPassword    ' Enter an invalid password for an user
' #0 FTPCancelPasswordDialog    ' Just cancel the password dialog
' #0 CancelFileOpen             ' Just cancel the FileOpen dialog
' #0 CancelFileClose            ' Just cancel the FileSave dialog
'**
'\******************************************************************************

sub FTPLoadFileExpectSuccess( fpath as string )  

   const ICWAIT as Integer = 1

   printlog( CHR$(13) + " * Trying: " + fpath )
   printlog( " * This file is expected to load correctly" )
   'printlog( " - open FileOpen dialog" )
   FileOpen

   'printlog( " - type the filepath/name into the entryfield" )
   Kontext "OeffnenDLG"
   DateiName.setText( fpath )
   
   'printlog( " - click 'Open'" )
   Oeffnen.click()
   
   'printlog( " - wait for the file to get loaded" )
   wait( 10 ) 'it can take quite some time...
   IsItLoaded
   
   ' handle unexpected errormessage
   Kontext "Active"
   if ( Active.Exists() ) then
      warnlog( "An unexpected messagebox came up and will be closed:" )
      printlog( Active.getText() )
      Active.OK()
      call CancelFileSave()
      exit sub
   endif
   
   ' try to recover in case of failure so the test can continue.
   'printlog( " - Check for inconsistent state / wrong kontext" )
   Kontext "OeffnenDLG"
   if ( OeffnenDLG.exists() ) then
      warnlog( "The file was not opened, it doesn't appear to exist" )
      call CancelFileSave()
      exit sub
   endif

   '///+Close the document
   printlog( " - close the document" )
   hCloseDocument

end sub

'*******************************************************************************

sub FTPSaveFileExpectSuccess( fPath as string )

   ' This sub saves a file to a FTP-Server. Successful completion expected.
   ' fPath is the fully qualified path to the ftp server including
   ' loginname and password separated by a colon, the servername (separated
   ' by '@' and the path to the file. Directory separator is '/'
   ' You may replace the servername by an IP Address.
   ' Wildcards are not allowed. Files have to be specified including suffix. 
   ' This sub does not alter fPath.
   '
   ' Example: ftp://thomas:gnuRp2t@myserver.germany/mydir/somefile.sxw

   const ICWAIT as Integer = 1 
   
   '///+Open a new document
   printlog( CHR$(13) + " - Open a new document" )
   hNewDocument
   
   printlog( " * Trying: " + fPath  )
   printlog( " * Saving this file is expected to succeed" )
   'printlog( " - Open FileSave dialog" )
   FileSaveAs
   
   'printlog( " - Enter filename" )
   Kontext "SpeichernDlg"
   Dateiname.setText( fPath )
   
   'printlog( " - uncheck automatic filename extension" )
   automatischedateinamenserweiterung.uncheck()

   'printlog( " - Press 'Save'" )
   speichern.click()
   
   sleep( ICWAIT * 2 )

   'printlog( " - Check for 'File Exists' warning" )
   Kontext "Active"
   if ( active.exists() ) then
      printlog( " - overwriting file" )
      active.yes()
   endif

   'printlog( " - Check for unexpected errormessage" )
   Kontext "Active"
   if ( active.exists() ) then
      warnlog( "Unexpected errormessage displayed, closing" )
      printlog( active.getText() )
      active.ok()
   endif
   
   '///+Close the document
   printlog( " - Close the document" + CHR$(13))
   hCloseDocument
   
   
end sub

'*******************************************************************************

sub DisableProxies()

   ' Disable proxies via Tools/Options

   '///+Open a new document
   'printlog( CHR$(13) + " - Open a new document" )
   hNewDocument
   
   ' open tools->options
   'printlog( " - Open Tools/Options" )
   ToolsOptions
   
   ' go to the proxy page, set kontext
   'printlog( " - Select Internet/Proxies page" )
   hToolsOptions( "Internet", "Proxy" )
   
   ' select Proxy="None"
   'printlog( " - Select Proxy=None" )
   ProxyServer.Select( 1 )
   
   Kontext "ExtrasOptionenDlg"
   'printlog( " - Close Tools/Options with OK" )
   ExtrasOptionenDlg.ok()
   
   '///+Close the document
   'printlog( " - Close the document" )
   hCloseDocument
   
end sub

'*******************************************************************************

sub EnableProxies()

   ' Enable proxies via Tools/Options

   '///+Open a new document
   'printlog( CHR$(13) + " - Open a new document" )
   hNewDocument
   
   ' open tools->options
   'printlog( " - Open Tools/Options" )
   ToolsOptions
   
   ' go to the proxy page, set kontext
   'printlog( " - Select Internet/ Proxy page" )
   hToolsOptions( "Internet", "Proxy" )
   
   'printlog( " - Select proxy 'manual'" )
   ProxyServer.Select( 2 )
   HttpProxy.setText( "so-webcache" )
   httpPort.setText( "3128" )
   FtpProxy.setText( "so-webcache" )
   FtpPort.setText( "3128" )
   NoProxy.setText( "" )
   
   'printlog( " - Close Tools/Options with OK" )
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.ok()
   
   '///+Close the document
   'printlog( " - Close the document" + CHR$(13) )
   hCloseDocument
   
end sub

'*******************************************************************************

sub FTPDeleteFileExpectSuccess( cPath as string , cFile as String )

   ' This sub deletes a file. You need to specify the path and the filename
   ' separately. No wildcards are allowed. This sub is intended to work with
   ' FTP servers only, cPath has to end with a '/'

   dim iItems as integer
   dim iCounter as integer

   printlog( " - Delete file using 'File Save As': " + cPath + cFile )
   'printlog( " - Open FileSave As" )
   FileSaveAs
   
   'printlog( " - Insert the path" )
   Kontext "SpeichernDLG"
   Dateiname.setText( cPath )
   
   'printlog( " - Click 'save'" )
   speichern.click()

   'printlog( " - Activate the list and get the number of files" )
   Kontext "SpeichernDLG"
   iItems = DateiAuswahl.getItemCount()
   
   'printlog( " - Select file to delete from the list" ) 
   for iCounter = 1 to iItems
   
      if ( DateiAuswahl.getItemText( iCounter ) = cFile ) then
         DateiAuswahl.Select( iCounter )
         DateiAuswahl.TypeKeys( "<DELETE>" )
         
         printlog( " - Confirm delete" )
         Kontext "ConfirmDelete"
         Delete.click()
         iCounter = iItems + 1
      endif

   next iCounter
   
   'overwritewarning or i/o error
   Kontext "Active"
   if ( active.exists() ) then
      warnlog( "Unexpected Dialog is displayed: " + active.getText() )
      try
         active.ok()
      catch
         active.yes()
      endcatch
      
      Kontext "Active"
      if ( active.exists() ) then
         warnlog( "Unexpected Dialog is displayed:" )
         printlog( active.getText() )
         try
            active.ok()
         catch
            active.yes()
         endcatch
      endif
   endif
   
   call CancelFileSave()
   printlog( "" )

end sub

'*******************************************************************************

sub FTPSaveFileExpectFailure( fpath as string )

   ' TODO! This one is nonsense in its current state!

   const ICWAIT as Integer = 1 

   '///+Open a new document
   printlog( CHR$(13) + " - Open a new document" )
   hNewDocument
   
   printlog( " * Trying: " + fpath  )
   'printlog( " * Saving this file is expected to fail!" )
   'printlog( " - Open FileSave dialog" )
   FileSaveAs
   
   sleep( ICWAIT )
   
   'printlog( " - Enter filename" )
   Kontext "SpeichernDlg"
   Dateiname.setText( fpath )
   
   'printlog( " - Unchecking automatic filename extension" )
   automatischedateinamenserweiterung.uncheck()
   
   'printlog( " - Press 'Save'" )
   speichern.click()
   
   sleep( ICWAIT )

   'printlog( " - Check for expected overwrite-warning" )
   Kontext "Active"
   if ( active.exists() ) then
      printlog( " - Closing 'Unable to save...-warning'" )
      active.ok()
   else
      warnlog( "Errormessage 'Unable to save ...' is missing" )
   endif

   '///+Close the document
   printlog( " - Close the document" + CHR$(13))
   hCloseDocument
   

end sub

'*******************************************************************************

sub FTPCreateDirectoryExpectSuccess( location as string , dirname as string )

   'printlog( CHR$(13) + "Create a directory on a FTP Server" + CHR$(13))
   'printlog( " - File/Open" )
   
   const ICWAIT as integer = 1
   
   FileOpen
   sleep( ICWAIT )

   Kontext "OeffnenDlg"

   printlog( " - Enter path to directory where the new dir will be created" )
   dateiname.setText( location )
   sleep( ICWAIT )

   printlog( " - Click 'Open'" )
   oeffnen.click()
   sleep( ICWAIT )

   printlog( " - Click 'New Folder'" )
   NeuerOrdner.click()
   sleep( ICWAIT )

   printlog( " - Name the folder" )
   Kontext "NeuerOrdner"
   OrdnerName.setText( dirname )
   sleep( ICWAIT )
   
   NeuerOrdner.OK()
   sleep( ICWAIT )

   printlog( " - Close the warning" )
   Kontext "Active"
   Active.yes()
   sleep( ICWAIT )

   printlog( " - Check for second warning (unable to ...)" )
   Kontext "Active"
   if ( Active.Exists() ) then
      warnlog( "Unexpected dialog: " + active.getText() )
      printlog( " - Close active" )
      Active.OK()
      sleep( ICWAIT )

      'Check if the "Name Folder" dialog is open
      Kontext "NeuerOrdner"
      if( NeuerOrdner.exists() ) then
         qaerrorlog( "Foldername was recognized as invalid." )
         NeuerOrdner.Cancel()
      endif

      'close the file-open dialog
       call CancelFileOpen()
       
      'on error the sub is exited here
      exit sub

   endif

   printlog( " - Open the newly created folder" )
   Kontext "OeffnenDlg"
   dateiname.setText( dirname )
   oeffnen.click()

   printlog( " - Close the File/Open dialog" )
   call CancelFileOpen()

end sub

'*******************************************************************************

sub FTPDeleteFileExpectFailure( cPath as string , cFile as String )

   ' This sub deletes a file. You need to specify the path and the filename
   ' separately. No wildcards are allowed. This sub is intended to work with
   ' FTP servers only, cPath has to end with a '/'
   ' When deleting a file/directory a general i/o error is expected.

   dim iItems as integer
   dim iCounter as integer
   const ICWAIT as integer = 1

   printlog( " - Delete file using 'File Save As': " + cPath + cFile )
   printlog( " - Open FileSave As" )
   FileSaveAs
   sleep( ICWAIT )
   
   printlog( " - Insert the path" )
   Kontext "SpeichernDLG"
   Dateiname.setText( cPath )
   sleep( ICWAIT )

   printlog( " - Click 'save'" )
   speichern.click()
   sleep( ICWAIT )

   printlog( " - Activate the list and get the number of files" )
   Kontext "SpeichernDLG"
   iItems = DateiAuswahl.getItemCount()

   printlog( " - Select file to delete from the list" ) 
   for iCounter = 1 to iItems

      sleep( ICWAIT )

      if ( DateiAuswahl.getItemText( iCounter ) = cFile ) then
         DateiAuswahl.Select( iCounter )
         DateiAuswahl.TypeKeys( "<DELETE>" )
         
         printlog( " - Confirm delete" )
         Kontext "ConfirmDelete"
         Delete.click()
         sleep( ICWAIT )
         iCounter = iItems + 1
      endif

   next iCounter

   Kontext "Active"
   if Active.Exists() then
      printlog( "  At this point a general i/o error is expected" )
      printlog( "  Text: " + Active.getText() )
      Active.OK()
   else
      warnlog( "Expected general i/o error is missing" )
   endif

   printlog( " - Close the FileSave-dialog" )
   call CancelFileSave()

end sub

'*******************************************************************************

sub FTPServerConnect( cFTPServer as string , bValidLogin as boolean )

   ' This sub just opens the file-open dialog and enters a valid ftp-server-url
   ' into the entryfield. Then it presses the Open-Button.
   ' If bValidLogin is TRUE it is expected that the sub ends on the FileOpen
   ' dialog, displaying the directory on the FTP-Server.
   ' If bValidLogin is FALSE the sub ends with the Password dialog open - 
   ' if there is no "access denied" messagebox up instead. In this case the 
   ' msgbox is closed and the FileOpen dialog is closed. (Basestate)

   const ICWAIT as Integer = 1

   ' Open the file-open dialog
   call FileOpen()
   sleep( ICWAIT )

   ' Enter the servername + loginname without password
   kontext "OeffnenDlg"
   Dateiname.setText( cFTPServer )
   sleep( ICWAIT )

   call oeffnen.click()

   sleep( ICWAIT )

   ' This one usually comes up if the acount is invalid (access denied).
   ' This happens when connecting to a server that does not allow anonymous 
   ' access
   Kontext "Active"
   if Active.Exists() then

      if ( bValidLogin = FALSE ) then
         printlog( " - closing msgbox: " + active.getText())
         endif 

      Active.OK()
      sleep( ICWAIT )

      call CancelFileOpen()

   endif
   
end sub


'*******************************************************************************

sub FTPEnterValidPassword( cPassword as string )

   const ICWAIT as Integer = 1
   
   '///+Enter a password (e.g. "somebody@nowhere.com")
   Kontext "FTPLoginDialog"
   if ( FTPLoginDialog.exists() = TRUE ) then
      FTPSavePassword.uncheck()
      FTPPassword.setText( cPassword )
      sleep( ICWAIT )
      FTPLoginDialog.ok()
   else
      warnlog( "For some reason the login dialog is not open" )
   endif
   sleep( ICWAIT )

   '///+Close the file open dialog. 
   call CancelFileOpen()
   
end sub

'*******************************************************************************

sub FTPEnterInValidPassword( cPassword as string )

   const ICWAIT as Integer = 1
   
   '///+Enter a password (e.g. "somebody@nowhere.com")
   Kontext "FTPLoginDialog"
   if ( FTPLoginDialog.exists( ICWAIT*2 ) = TRUE ) then
      FTPSavePassword.uncheck()
      FTPPassword.setText( cPassword )
      sleep( ICWAIT )
      FTPLoginDialog.ok()
   else
      warnlog( "For some reason the login dialog is not open" )
   endif

   '///+Close the Password-dialog using cancel
   call FTPCancelPasswordDialog( TRUE )
   
   '///+Close the file open dialog. 
    call CancelFileOpen()   
   'Hopefully we are back to the originating document with no dialogs open
   
end sub

'*******************************************************************************

sub FTPCancelPasswordDialog( bShouldExist as boolean )

   ' if dialog = present + should exist     = true : close it
   ' if dialog = present + should not exist = true : close it, warn
   ' if dialog = absent + should exist      = true : warn
   ' if dialog = absent + should not exist  = true : do nothing

   const ICWAIT as Integer = 1

   kontext "FTPLoginDialog"
   if ( FTPLoginDialog.exists( ICWAIT * 1 )) then

      if ( bShouldExist = TRUE ) then
         printlog( " - cancelling password dialog" )
         FTPLoginDialog.cancel()
         sleep( ICWAIT )
      else
         warnlog( "The Password dialog is not expected at this time" )
         FTPLoginDialog.cancel()
         sleep( ICWAIT )
      endif        

   else

      if ( bShouldExist = TRUE ) then
         warnlog( "The Password dialog is expected at this point" )
      endif        

   endif

   ' We should be back on the FileOpen-dialog.

end sub

'*******************************************************************************

sub CancelFileOpen()

   const ICWAIT as Integer = 1
   
      Kontext "OeffnenDlg"
      if ( OeffnenDlg.exists() ) then
         Oeffnendlg.cancel()
         sleep( ICWAIT )
      else
         warnlog( "Kontext error on close of the file-open dialog" )
      endif
      
end sub

'*******************************************************************************

sub CancelFileSave()

   const ICWAIT as Integer = 1
   
      Kontext "SpeichernDlg"
      if ( SpeichernDlg.exists() ) then
         SpeichernDlg.cancel()
         sleep( ICWAIT )
      else
         warnlog( "Kontext error on close of the file-save dialog" )
      endif
      
end sub
