'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: extras_table_autoformat.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsk $ $Date: 2005/09/14 12:45:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.co
'*
'*  short description : Test the autoformat-feature for tables
'*
'*******************************************************************************
'**
' #1 tCheck_NamesOfTableAutoformat ' Test the autoformat-feature for tables
'**
'\******************************************************************************

testcase tCheck_NamesOfTableAutoformat

    Dim i
    Dim lsListe(50) as String
    '///<h1>This test checks all names of table formats in writer and calc</h1>
    '///<ul>
    printlog "check all names for table formats in writer ( 'Format/Autoformat' in a table )"
    gApplication = "WRITER"
    '///<li>open a writer-doc</li>
    Call hNewDocument
    '///<li>create a table</li>
    Call hTabelleEinfuegen
    '///<li>Format/Autoformat</li>
    FormatAutoformat

    kontext "autoformattabelle"
    lsListe(0) = 0
    '///<li>verify all names against a list ( [TesttoolPath]\setup\allinst\input\tables\table_[LanguageID]..txt ) - list depends on the language</li>

    for i=1 to FormatBox.GetItemCount
        ListAppend ( lsListe(), FormatBox.GetItemText (i) )
    next i

    AutoformatTabelle.OK
    hCompareStylesAndFormats ( lsListe(), 7, 1 )
    '///<li>close the writer-doc</li>
    call hCloseDocument()
    printlog "check all names for table formats in calc ( 'Format/Autoformat' in a table )"
    gApplication = "CALC"
    '///<li>open a calc-doc</li>
    '///<li>select some cells</li>
    Call hNewDocument

    kontext "documentcalc"
    DocumentCalc.TypeKeys "<Shift Right>", 5
    DocumentCalc.TypeKeys "<Shift Down>", 3
    '///<li>Format/Autoformat</li>
    FormatAutoFormat

    kontext "autoformatcalc"
    lsListe(0) = 0
    '///<li>verify all names against the same list ( ..\input\setup\tables\table...txt )</li>

    for i=1 to FormatListe.GetItemCount
        ListAppend ( lsListe(), FormatListe.GetItemText (i)  )
    next i

    AutoformatCalc.OK
    hCompareStylesAndFormats ( lsListe(), 7, 1 )
    '///<li>close the calc-doc</li>
    '///</ul>
    call hCloseDocument()
    
endcase
