'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_104_.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:42 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Chart Level 1 test - section INSERT
'*
'************************************************************************
'*
' #1 CH_104_     ' Initial routine
' #1 tInsertTitle
' #1 tInsertLegend
' #1 tInsertDatalabels
' #1 tInsertAxesandGrids
' #1 tInsertStatistics
'*
'\***********************************************************************

sub CH_104_

printLog Chr(13) + "---------  CH_104_     ----------"

   call tInsertTitle
   call tInsertLegend
   call tInsertDatalabels
   call tInsertAxesandGrids
   call tInsertStatistics

end sub
'
'-----------------------------------------------------------
'
testcase tInsertTitle
'/// This test check all possibilities to modify the main- and subtitles in a chart

'/// At first create a chart which based on datas in a calc document
  Call basedocument ("CHART")
  EditObjectEdit
  Kontext "Diagrammdaten"
    if Diagrammdaten.exists then EditChartData
'/// Set the chart type to 3D to enable the z-axis title too
       FormatChartType
       Kontext "Diagrammtyp"
       DreiD.Check
       Diagrammtyp.OK
'/// Insert a title check main- and subtitle and the text for the axes
'/// Then insert a text for each of them
       InsertTitle
       Kontext "Titel"
       Haupttitel.check
       HaupttitelText.settext "Haupt"
       Untertitel.check
       UntertitelText.settext "Unter"
       XAchse.check
       XAchseText.settext "X-Achse"
       YAchse.check
       YAchseText.settext "Y-Achse"
       ZAchse.check
       ZAchseText.settext "Z-Achse"
       Titel.Ok
'/// Check if the made settings has been taken over
   InsertTitle
   Kontext "Titel"
     if HaupttitelText.gettext = "Haupt" then
        if Haupttitel.ischecked then
           Printlog "Main title on and text OK"
           Haupttitel.uncheck
        else
           Warnlog "Main title on but text not OK"
        end if
     else
        if Haupttitel.ischecked then
           Warnlog "Main title on but wrong text"
           Haupttitel.uncheck
        else
           Warnlog "Main title off and wrong text"
        end if
     end if
     if UntertitelText.gettext = "Unter" then
        if Untertitel.ischecked then
           Printlog "Sub title on and text OK"
           Untertitel.uncheck
        else
           Warnlog "Sub title off but text OK"
        end if
     else
        if Untertitel.ischecked then
           Warnlog "Sub title on but wrong text"
           Untertitel.uncheck
        else
           Warnlog "Sub title off and wrong text"
        end if
     end if
     if XAchseText.gettext = "X-Achse" then
        if Xachse.ischecked then
           Printlog "X-Axis on and text OK"
           Xachse.uncheck
        else
           Warnlog "X-Axis off but text OK"
        end if
     else
        if Xachse.ischecked then
           Warnlog "X-Axis on but wrong text"
           Xachse.uncheck
        else
           Warnlog "X-Axis off and wrong text"
        end if
     end if
     if yAchseText.gettext = "Y-Achse" then
        if yachse.ischecked then
           Printlog "Y-Axis on and text OK"
           Yachse.uncheck
        else
           Warnlog "Y-Axis off but text OK"
        end if
     else
        if Yachse.ischecked then
           Warnlog "Y-Axis on but wrong text"
           Yachse.uncheck
        else
           Warnlog "Y-Axis off and wrong text"
        end if
     end if
     if ZAchseText.gettext = "Z-Achse" then
        if Zachse.ischecked then
           Printlog "Z-Axis on and text OK"
           Zachse.uncheck
        else
           Warnlog "Z-Axis off but text OK"
        end if
     else
        if Zachse.ischecked then
           Warnlog "Z-Axis on but wrong text"
           Zachse.uncheck
        else
           Warnlog "Z-Axis off and wrong text"
        end if
     end if
     Titel.Ok
'/// Then check, if the maintitle could be copy and paste
     InsertTitle
     Kontext "Titel"
       Haupttitel.check
       Titel.Ok
   Kontext
     DocumentChart.mouseDoubleclick 50,8
     DocumentChart.Typekeys "<SHIFT END>"
     EditCopy
     try
       EditPaste
     catch
       warnlog "Menu item 'Edit|Paste' isn't available"
     endcatch
     try
       EditPaste
     catch
       warnlog "Menu item 'Edit|Paste' isn't available"
     endcatch
   Kontext "DocumentChart"
     DocumentChart.mousedown 1,99
     DocumentChart.mouseup 1,99
     InsertTitle
     Kontext "Titel"
       if Haupttiteltext.gettext = "HauptHaupt" then
          Printlog "Modification in main title is OK"
       else
          Warnlog "Modification in main title failed"
       end if
       Haupttitel.uncheck
       Titel.Ok
'/// Do the same with the subtitle and the text for each axis
     InsertTitle
     Kontext "Titel"
       Untertitel.check
       Titel.Ok
   Kontext
     DocumentChart.mouseDoubleclick 50,8
     DocumentChart.Typekeys "<SHIFT END>"
     EditCopy
     try
       EditPaste
       EditPaste
     catch
       warnlog "Menu item 'Edit|Paste' isn't available"
     endcatch
   Kontext "DocumentChart"
     DocumentChart.mousedown 1,99
     DocumentChart.mouseup 1,99
     InsertTitle
       Kontext "Titel"
       if Untertiteltext.gettext = "UnterUnter" then
          Printlog "Modification of sub title was applied"
       else
          Warnlog "Modification of sub title wasn't applied"
       end if
       Untertitel.uncheck
       Titel.Ok
       InsertTitle
       Kontext "Titel"
         XAchse.check
         Titel.Ok
   Kontext "DocumentChart"
     DocumentChart.mouseDoubleclick 40,95
   Kontext "DocumentChart"
     DocumentChart.Typekeys "<SHIFT END>"
     EditCopy
     try
       EditPaste
       EditPaste
     catch
       warnlog "Menu item 'Edit|Paste' isn't available"
     endcatch
   Kontext "DocumentChart"
     DocumentChart.mousedown 1,1
     DocumentChart.mouseup 1,1
     InsertTitle
     Kontext "Titel"
       if XAchsetext.gettext = "X-AchseX-Achse" then
          Printlog "Modification in X-Axis text was applied"
       else
           Warnlog "Modification in X-Axis text wasn't applied"
       end if
       XAchse.uncheck
      Titel.Ok
      InsertTitle
      Kontext "Titel"
        YAchse.check
      Titel.Ok
      Kontext
        DocumentChart.mouseDoubleclick 2,50
        DocumentChart.Typekeys "<SHIFT END>"
        EditCopy
      try
        EditPaste
        EditPaste
      catch
        warnlog "Menuitem 'Edit|Paste' isn't available"
      endcatch
   Kontext "DocumentChart"
     DocumentChart.mousedown 99,1
     DocumentChart.mouseup 99,1
     InsertTitle
     Kontext "Titel"
       if YAchsetext.gettext = "Y-AchseY-Achse" then
          Printlog "Modification in Y-Axis text was applied"
       else
          Warnlog "Modification in Y-Axis text wasn't applied"
       end if
       YAchse.uncheck
       Titel.Ok
     InsertTitle
     Kontext "Titel"
      ZAchse.check
      Titel.Ok
   Kontext
     DocumentChart.mouseDoubleclick 80,90
     DocumentChart.Typekeys "<SHIFT END>"
     EditCopy
     try
       EditPaste
       EditPaste
     catch
       warnlog "Menu item 'Edit|Paste' isn't available"
     endcatch
   Kontext "DocumentChart"
     DocumentChart.mousedown 1,99
     DocumentChart.mouseup 1,99
     InsertTitle
     Kontext "Titel"
       if ZAchsetext.gettext = "Z-AchseZ-Achse" then
          Printlog "Modification in Z-Axis text was applied"
       else
          Warnlog "Modification in Z-Axis text wasn't applied"
       end if
       ZAchse.uncheck
       Titel.Ok
   Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
     call hCloseDocument
endcase
'
'--------------------------------------------------------------
'
testcase tInsertLegend
'/// This test check the available modifies with the legend in a chart
   dim Lager
'/// First insert a chart which based on datas in a calc document
   Call basedocument ("CHART")
   EditObjectEdit
   Kontext "Diagrammdaten"
     if Diagrammdaten.exists then AnsichtDiagrammdaten
'/// Disable all titles and axes in this chart
     InsertTitle
     Kontext "Titel"
       Haupttitel.uncheck
       Untertitel.uncheck
       XAchse.uncheck
       YAchse.uncheck
       Titel.Ok
'/// Insert a legend with alignment left
   Kontext "DocumentChart"
     DocumentChart.mouseDown 1,1
     DocumentChart.mouseUp 1,1
     InsertLegend
     Kontext "Legende"
       Links.check
       Legende.ok
   Kontext "DocumentChart"
     DocumentChart.mouseDown 8,50
     DocumentChart.mouseUp 8,50
     DocumentChart.mouseDown 8,50
     DocumentChart.mouseUp 8,50
'/// Check if the alignment of the legend is left
     try
       FormatLegend
       Kontext
         active.setpage TabAnordnungLegende
         Kontext "TabAnordnungLegende"
           if Links.ischecked then
              Printlog "Legend is on the left Ok"
           else
              Warnlog "Legend is on the left but tab order doesn't show it"
           end if
           TabAnordnungLegende.cancel
     catch
       Warnlog "Tab order not found"
     endcatch
'/// modify the alignment of the legend to top
     InsertLegend
     Kontext "Legende"
       Oben.check
       Legende.ok
   Kontext "DocumentChart"
     DocumentChart.mouseDown 50,8
     DocumentChart.mouseUp 50,8
     DocumentChart.mouseDown 50,8
     DocumentChart.mouseUp 50,8
'/// Check if the alignment of the legend is top
     try
       FormatLegend
       Kontext
         active.setpage TabAnordnungLegende
         Kontext "TabAnordnungLegende"
         if Oben.ischecked then
            Printlog "Legend is on top OK"
         else
            Warnlog "Legend is on top but tab order doesn't show it"
         end if
         TabAnordnungLegende.cancel
     catch
       Warnlog "Tab order not found"
     endcatch
'/// Do the same with alignment bottom and right
     InsertLegend
     Kontext "Legende"
       Rechts.check
       Legende.ok
   Kontext "DocumentChart"
     DocumentChart.mouseDown 92,50
     DocumentChart.mouseUp 92,50
     DocumentChart.mouseDown 92,50
     DocumentChart.mouseUp 92,50
     try
       FormatLegend
       Kontext
         active.setpage TabAnordnungLegende
         Kontext "TabAnordnungLegende"
           if Rechts.ischecked then
              Printlog "Legend is on the right OK"
           else
              Warnlog "Legend is on the right but tab order doesn't show it"
           end if
         TabAnordnungLegende.cancel
      catch
        Warnlog "TabOrder not found"
      endcatch
      InsertLegend
      Kontext "Legende"
        Unten.check
        Legende.ok
    Kontext "DocumentChart"
      DocumentChart.mouseDown 50,92
      DocumentChart.mouseUp 50,92
      DocumentChart.mouseDown 50,92
      DocumentChart.mouseUp 50,92
    try
      FormatLegend
      Kontext
        active.setpage TabAnordnungLegende
        Kontext "TabAnordnungLegende"
          if Unten.ischecked then
             Printlog "Legend is on the bottom OK"
          else
              Warnlog "Legend is on the bottom but tab order doesn't show it"
          end if
        TabAnordnungLegende.cancel
     catch
       Warnlog "tab order not found"
     endcatch
     InsertLegend
     Kontext "Legende"
       Anzeigen.uncheck
       Legende.ok
       try
         FormatLegend
         Kontext
           active.setpage TabAnordnungLegende
           Kontext "TabAnordnungLegende"
             TabAnordnungLegende.cancel
             Warnlog "There was a Legend"
        catch
          Printlog "OK no Legend"
        endcatch
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
    call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tInsertDatalabels
'/// This test check all possibility settings
   dim Lager
'/// First insert a chart which based on datas of a calcdocument
   Call basedocument ("CHART")
   EditObjectEdit
'/// Then insert datalabels with showed values and datalabels
   InsertDataLabels
   Kontext "Datenbeschriftung"
     WertAnzeigen.check
     Datenbeschriftung.Ok
'/// Check if the made settings has been taken over
   try
     InsertDataLabels
     Kontext "Datenbeschriftung"
       if AlsZahl.ischecked then
          Printlog "Show value is OK"
       else
          Warnlog "Show value doesn't work"
       end if
       Datenbeschriftung.Cancel
   catch
     Warnlog "Page not found"
   endcatch
'/// Check the option 'show value as percentage'
   InsertDataLabels
   Kontext "Datenbeschriftung"
     AlsProzent.check
     LegendensymbolNebenBeschriftung.check
     Datenbeschriftung.Ok
'/// and check if this has been taken over
   try
     InsertDataLabels
     Kontext "Datenbeschriftung"
       if AlsProzent.ischecked then
          Printlog "Show value as percent is Ok"
       else
          Warnlog "Show value as percent doesn't work"
       end if
       if LegendensymbolNebenbeschriftung.ischecked then
          Printlog "Show legend symbol is OK"
       else
          Warnlog "Show legend symbol doesn't work"
       end if
       Datenbeschriftung.Cancel
   catch
     Warnlog "Page not found"
   endcatch
'/// Check the option 'show legend icon with label'
   InsertDataLabels
   Kontext "Datenbeschriftung"
     BeschriftungAnzeigen.check
     if LegendensymbolNebenBeschriftung.ischecked then
        Printlog "Show legend symbol is OK"
        LegendensymbolNebenBeschriftung.uncheck
     else
        Warnlog "Show legend symbol doesn't work"
     end if
     Datenbeschriftung.Ok
'/// and check if this has been taken over
   Kontext
   try
     InsertDataLabels
     Kontext "Datenbeschriftung"
       if BeschriftungAnzeigen.ischecked then
          Printlog "Show inscription is OK"
       else
          Warnlog "Show inscription doesn't work"
       end if
       if LegendensymbolNebenBeschriftung.ischecked then
          Warnlog "Switch off show legend symbol doesn't work"
      else
         Printlog "Switch off show legend symbol is OK"
      end if
      Datenbeschriftung.Cancel
   catch
     Warnlog "Page not found"
   endcatch
   InsertDataLabels
   Kontext "Datenbeschriftung"
     AlsProzent.check
     Datenbeschriftung.Ok
     try
       InsertDataLabels
       Kontext "Datenbeschriftung"
         if AlsProzent.ischecked then
            Printlog "Show inscription and percent is Ok"
         else
            Warnlog "Show inscription and percent doesn't work"
         end if
         Datenbeschriftung.Cancel
   catch
     Warnlog "Page not found"
   endcatch
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   call hCloseDocument

endcase
'
'--------------------------------------------------------------
'
testcase tInsertAxesandGrids
'/// This test check all possibility settings of the axies dialog
'/// First create a chart which based on datas of a calc document

   Call basedocument ("CHART")
   EditObjectEdit
'/// Then call the axis dialog and attempt to check the z-axis (it mustn't be available)
   InsertAxes
   Kontext "Achsen"
     try
       zAchsePrim.check
       Warnlog "Z-axis is enabled in 2D-chart"
     catch
       Printlog "OK, z-axis is disabled in 2D-chart"
     endcatch
     Achsen.Cancel
'/// Then set the chart type to 3D
   FormatChartType
   Kontext "Diagrammtyp"
     DreiD.Check
     Diagrammtyp.OK
     Kontext "Diagrammdaten"
       if Diagrammdaten.exists then AnsichtDiagrammdaten
   Kontext "DocumentChart"
     DocumentChart.mousedown 1,1
     DocumentChart.mouseup 1,1

'X-axis
'/// Set all available possibilities in the axis dialog and the grids dialog
'/// and check these settings.
'/// Do this for all axis
     printlog "* Check adjustments of x-axis *"
     call axset (1,0,0)
     call gridset (1,0,0,0,0,0)
     call chkadjustment ("xp","xp")

     call axset (1,0,0)
     call gridset (0,0,0,1,0,0)
     call chkadjustment ("xp","xs")

'Y-axis
     printlog "* Check adjustments of y-axis *"
     call axset (0,1,0)
     call gridset (0,1,0,0,0,0)
     call chkadjustment ("yp","yp")

     call axset (0,1,0)
     call gridset (0,0,0,0,1,0)
     call chkadjustment ("yp","ys")

'Z-axis
     printlog "* Check adjustments of z-axis *"
     call axset (0,0,1)
     call gridset (0,0,1,0,0,0)
     call chkadjustment ("zp","zp")

     call axset (0,0,1)
     call gridset (0,0,0,0,0,1)
     call chkadjustment ("zp","zs")

   Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tInsertStatistics
'/// This test check all possibility modifies of the statistic dialog.
'/// First a chart is created which based on datas of a calc document.

   Call basedocument ("CHART")
   EditObjectEdit
'/// Call the menuitem 'InsertStatistics'
   InsertStatistics
   Kontext "StatistikChart"
'/// Check and uncheck all available settings and check, if they are taken over
     Mittelwert.check
     keineFunktion.check
     StatistikChart.Ok
     call wasisnuan(1,1,0,0,0)
'/// Make this settings for the variance, standard deviation, percentage, error margin and constant value
   'Varianz
   InsertStatistics
   Kontext "StatistikChart"
     Mittelwert.uncheck
     Varianz.check
     StatistikChart.Ok
     call wasisnuan(0,2,1,0,0)

   'Standardabweichung und Mittelwert
   InsertStatistics
   Kontext "StatistikChart"
     Mittelwert.check
     Standardabweichung.check
     StatistikChart.Ok
     call wasisnuan(1,3,1,0,0)

   'Prozentual
   InsertStatistics
   Kontext "StatistikChart"
     Mittelwert.uncheck
     Prozentual.check
     ProzentualWert.settext "13"
     StatistikChart.Ok
     call wasisnuan(0,4,1,0,0)

   'GroessterFehler
   InsertStatistics
   Kontext "StatistikChart"
     Mittelwert.uncheck
     GroessterFehler.check
     GroessterFehlerWert.settext "13"
     StatistikChart.Ok
     call wasisnuan(0,5,1,0,0)

   'konstanterWert
   InsertStatistics
   Kontext "StatistikChart"
     Mittelwert.uncheck
     konstanterWert.check
     konstanterWertPlus.settext "13"
     konstanterWertMinus.settext "13"
     StatistikChart.Ok
     call wasisnuan(0,6,1,0,0)
   FormatChartType
   Kontext "Diagrammtyp"
     typ.typekeys "<LEFT><DOWN>"
     Diagrammtyp.OK
     kontext
       if active.exists then Active.YES
       call wasisnuan(0,6,1,1,0)
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   call hCloseDocument
endcase

