'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_004_.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: pj $ $Date: 2006/01/09 12:14:19 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Check all resources for menuitem Insert - Part 1
'*
'*************************************************************************************************
'*
' #1 C_004_ ' Inital routine
' #1 tInsertManualBreakRowBreak
' #1 tInsertManualBreakColumnBreak
' #1 tInsertCells
' #1 tInsertRows
' #1 tInsertColumns
' #1 tInsertSheet
' #1 tInsertSheetFromFile
' #1 tInsertLinkToExternalData
' #1 tInsertFunction
' #1 tInsertFunctionList 
' #1 tInsertNamesDefine
' #1 tInsertNamesInsert
' #1 tInsertNamesCreate
' #1 tInsertNamesLabels
' #1 tInsertNote
' #1 tInsertSpecialCharacter
' #1 tInsertHyperlink
' #1 tInsertGraphicFromFile
' #1 tInsertMovieAndSound
' #1 tInsertChart
' #1 tInsertFormula
' #1 tInsertFrame
' #1 tInsertObjectOLE
' #1 tInsertObjectPlugin
' #1 tInsertObjectApplet
'*
'\************************************************************************************************

sub C_004_

Printlog "--------- C_004_ ---------"

    Call tInsertManualBreakRowBreak
    Call tInsertManualBreakColumnBreak
    Call tInsertCells
    Call tInsertRows
    Call tInsertColumns
    Call tInsertSheet
    Call tInsertLinkToExternalData
    call tInsertSheetFromFile
    Call tInsertFunction
    Call tInsertFunctionList 
    Call tInsertNamesDefine
    Call tInsertNamesInsert
    Call tInsertNamesCreate
    Call tInsertNamesLabels
    Call tInsertNote
    Call tInsertSpecialCharacter
    call tInsertHyperlink
    call tInsertGraphicFromFile
    call tInsertMovieAndSound
    Call tInsertChart
    Call tInsertFormula
    Call tInsertFrame
    Call tInsertObjectOLE
    Call tInsertObjectPlugin
    Call tInsertObjectApplet

end sub

'
'-----------------------------------------------------------
'
testcase tInsertManualBreakRowBreak
'///<u><b>Insert::Manual Break::RowBreak</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call hNewDocument
    '///<li>Move three rows down</li>///
    DocumentCalc.Typekeys "<Down><Down><Down>"
    '///<li>Insert::Manual Break::RowBreak</li>///
    InsertManuelBreakRowBreak
    wait 50
    '///<li>Edit::Delete Manual Break::Row Break</li>///
    EditRemoveManualBreakRowBreak
    wait 50
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tInsertManualBreakColumnBreak
'///<u><b>Insert::Manual Break::ColumnBreak</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Move three columns right</li>///
    DocumentCalc.Typekeys "<Right><Right><Right>"
    '///<li>Insert::Manual Break::ColumnBreak</li>///
    InsertManuelBreakColumnBreak
    wait 50
    '///<li>Edit::Delete Manual Break::Column Break</li>///
    EditRemoveManualBreakColumnBreak
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertCells
'///<u><b>Insert::Cells...</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    call  hNewDocument
    '///<li>Insert::Cells...</li>///
    InsertCells
    Kontext "ZellenEinfuegen"
    '///<li>Check dialog 'Insert Cells'</li>///
    Call DialogTest ( ZellenEinfuegen )
    '///<li>Quit dialog</li>///
    ZellenEinfuegen.Cancel
    '///<li>Close document</li>///
    call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tInsertRows
'///<u><b>Insert::Rows...</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Insert::Rows<br>Note: In an empty nothing special happens</li>///
    InsertRowsCalc
    Kontext
    DocumentCalc.TypeKeys "<Return>"
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tInsertColumns
'///<u><b>Insert::Columns...</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Insert::Columns<br>Note: In an empty nothing special happens</li>///
    InsertColumnsCalc
    Kontext
    DocumentCalc.TypeKeys "<Return>"
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSheet
'///<u><b>Insert::Sheet...</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Insert::Sheet...</li>///
    InsertSheetCalc
    Kontext "TabelleEinfuegenCalc"
    '///<li>Check first state of 'Insert Sheet' dialog</li>///
    DialogTest2 ( TabelleEinfuegenCalc, 1  )
    AusDateiErstellen.Check
    '///<li>Check second state of 'Insert Sheet' dialog</li>///
    DialogTest2 ( TabelleEinfuegenCalc, 2  )
    Neuerstellen.check
    '///<li>Quit dialog</li>///
    TabelleEinfuegenCalc.Cancel
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSheetFromFile
'///<u><b>Insert::Sheet...</b></u>///
    dim sInsertThisFile as STRING
        sInsertThisFile = convertpath ( gTesttoolPath & "calc/update/input/c_001/all_features.sxc" )
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Insert::Sheet...</li>///
    InsertSheetFromFile
    '///<li>Test 'File Open' dialog, don't close it at the end</li>///
    subTestFileOpenDialog ( FALSE )
    sleep (2)
    '///<li>Set file name '.../calc/update/input/c_001/all_features.sxc'</li>///
    Dateiname.setText ( sInsertThisFile )
    '///<li>Click 'Insert'</li>///
    Oeffnen.Click
    sleep (5)
    Kontext "TabelleEinfuegenCalc"
    call DialogTest ( TabelleEinfuegenCalc )
    '///<li>Check if the selected file has 44 sheets</li>///
    if Auswahl.getItemCount <> 44 then
        warnlog "Unexpected number of of sheets detected in selected file -> Check this out!"
    else
        printlog "Number of detected sheet in slected file is OK."
    endif
    '///<li>Quit dialog</li>///
    TabelleEinfuegenCalc.Cancel
    '///<li>Close document</li>///
    call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertLinkToExternalData

        call hNewDocument

        InsertLinkToExternalData
        Kontext "ExternalData"
        call Dialogtest (ExternalData)
        FileChoose.Click
        Kontext "OeffnenDlg"
        call Dialogtest (OeffnenDlg)
        OeffnenDlg.close
        Kontext "ExternalData"
        ExternalData.close

        call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunction
    Call  hNewDocument

    InsertFunction
    Kontext "Funktionsautopilot"
      dim functionCount as integer
      dim functionIndex as integer
      
      functionCount = Funktion.getItemCount
      
      for functionIndex = 1 To functionCount
        Kategorie.Select(2)
        Funktion.Select(functionIndex)
        sleep 1
        call DialogTest2 ( Funktionsautopilot,1 )
      next functionIndex
      for functionIndex = 1 To functionCount
        Kategorie.Select(2)
        Funktion.Select(functionIndex)
        Weiter.Click
        call DialogTest2 ( Funktionsautopilot,2 )
        Formel.typekeys "<MOD1 A><DELETE>", true
      next functionIndex
      
    Kontext "FunktionsautopilotTabControl"
      FunktionsautopilotTabControl.setpage TabFunktionsautopilotStruktur
    Kontext "Funktionsautopilot"
      call DialogTest2 ( FunktionsAutopilot,3 )
      Funktionsautopilot.Cancel

    Call hCloseDocument
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunctionList

  dim categoryCount as Integer
  dim categoryIndex as Integer
  dim listLength as Integer
  dim listIndex as Integer
  call hNewDocument

  Kontext "FunctionsCalc"
  if FunctionsCalc.Exists(2) then
    printlog "Functions List was already open"
  else
    InsertFunctionList
    printlog "Functions list will now be invoked"
  end if
  
  Kontext "FunctionsCalc"
  
    if FunctionsCalc.IsDocked then
      printlog "Found Functions docked - now undocking"
      FunctionsCalc.Undock
      sleep 2
    else
      printlog "Functions was already undocked"
    end if
    
    categoryCount = Category.GetItemCount
    printlog "Categories: " & categoryCount 
    
    for categoryIndex = 1 to categoryCount
      Category.Select(categoryIndex)
      listlength = FunctionList.GetItemCount
      printlog "There are: " & listLength & " Items in category: " & Category.GetSelText
      for listIndex = 1 to listlength
        FunctionList.Select(listIndex)
        call Dialogtest ( FunctionsCalc )
      next listIndex
    next categoryIndex  
    
    FunctionsCalc.Dock
    InsertFunctionList
  
  call hCloseDocument

endcase   
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesDefine

      Call  hNewDocument

      InsertNamesDefine
      Kontext "NamenFestlegen"
      Zusaetze.Click
      DialogTest ( NamenFestlegen )
      NamenFestlegen.Cancel

      Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesInsert

    Call  hNewDocument

    InsertNamesInsert
    Kontext "NamenEinfuegen"
    Call DialogTest ( NamenEinfuegen )
    NamenEinfuegen.Cancel

    Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesCreate

    Call  hNewDocument

    InsertNameCreate
    Kontext "NamenErzeugen"
    DialogTest ( NamenErzeugen )
    NamenErzeugen.Cancel

    Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNamesLabels

    Call  hNewDocument

    InsertNamesLabels
    Kontext "BeschriftungsbereichFestlegen"
    DialogTest ( BeschriftungsbereichFestlegen )
    BeschriftungsbereichFestlegen.Cancel

    Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertNote

    Call  hNewDocument

    InsertNoteCalc
    Kontext
    DocumentCalc.TypeKeys "Energie"
    DocumentCalc.MouseDoubleClick 50,50

    Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertSpecialCharacter

    Call  hNewDocument
    printlog "*** If the test crashes by calling the menuitem 'InsertSpecialCharacterCalc', it is bug:98975"

    InsertSpecialCharacterCalc
    Kontext "Sonderzeichen"
    DialogTest ( Sonderzeichen )
    Sonderzeichen.Cancel

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertHyperlink
'///<u><b>Insert::Hyperlink</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    call hNewDocument
    '///<li>Insert::Hyperlink</li>///
    InsertHyperlink
    Kontext "Hyperlink"
    '///<li>Go to 'New Document' option</li>///
    Auswahl.TypeKeys "<END>"
    Kontext "TabHyperlinkNeuesDokument"
    '///<li>Check visibility of 'New Document' option</li>///
    Call DialogTest ( TabHyperlinkNeuesDokument )
    '///<li>Click 'Select file' button</li>///
        Pfad.Click
        '///<li>Check visibility of 'File Open' dialog</li>///
        call subTestFileOpenDialog
    '///<li>Go to 'Document' option</li>///
    Kontext "Hyperlink"
    Auswahl.TypeKeys "<Up>"
    '///<li>Check visibility of 'Document' option</li>///
    Kontext "TabHyperlinkDokument"
    Call DialogTest ( TabHyperlinkDokument )
    '///<li>Click 'Select file' button</li>///
        DateiOeffnen.Click
        '///<li>Check visibility of 'File Open' dialog</li>///
        call subTestFileOpenDialog
    Kontext "TabHyperlinkDokument"
    '///<li>Click 'Target' button</li>///
        Target.Click
        Kontext "ZielImDokument"
        '///<li>Check visibility of 'Target' dialog</li>///
            Call DialogTest ( ZielImDokument )
            '///<li>Close 'Target' dialog</li>///
            ZielImDokument.Close
    '///<li>Go to 'Internet' option</li>///
    Kontext "Hyperlink"
    Auswahl.TypeKeys "<Up>", 2
    
    Kontext "TabHyperlinkInternet"
    '///<li>Check visibility of 'Internet' option</li>///
    Call DialogTest ( TabHyperlinkInternet )
    '///<li>Check 'Web' radio button</li>///
        Internet.Check
        ''///<li>Click 'Browser' button</li>///
        'WWWBrowser.Click
        '///<li>Click 'Target' button</li>///
        Target.Click
        sleep ( 2 )
        Kontext "ZielImDokument"
        '///<li>Check visibility of 'Target' dialog</li>///
            Call DialogTest ( ZielImDokument )
            '///<li>Close 'Target' dialog</li>///
            ZielImDokument.Close
    Kontext "TabHyperlinkInternet"
    '///<li>Check 'FTP' radio button</li>///
        FTP.Check
        '///<li>Ckeck 'Anonymous user'</li>///
        AnonymerBenutzer.Check
    '///<li>Go to 'Mail & News' option</li>///
    Kontext "Hyperlink"
    Auswahl.TypeKeys "<DOWN>"

    Kontext "TabHyperlinkMailUndNews"
    '///<li>Check visibility of 'Mail & News' option</li>///
    Call DialogTest ( TabHyperlinkMailUndNews )
    '///<li>Click 'Data Source Browser' button</li>///
    '///<li>Note: The 'Data Source Browser' should be visible in Calc Document now</li>///
        Adressbuch.Click
        '///<li>Quit dialog</li>///
        TabHyperlinkMailUndNews.Cancel
    '///<li>Check visibility of 'Data Source Browser' in Document</li>///
    Kontext "DocumentCalc"
    Kontext "DatabaseBeamer"
    if DatabaseBeamer.exists(2) then
        printlog "OK, Found data source beamer"
        ViewDataSources
    else
        warnlog "Data source beamer was expected to be visible! -> Check this out!"
    endif
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>    
endcase


'
'-----------------------------------------------------------
'
testcase tInsertGraphicFromFile

    Call  hNewDocument

    InsertGraphicsFromFile
    Kontext "GrafikEinfuegenDlg"
    Link.Check
    Preview.Check
    Dateiname.Settext convertpath(gTesttoolpath + "global\input\graf_inp\krokodil.wmf")
    Oeffnen.click

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertMovieAndSound
'///<u><b>Insert::Movie and Sound...</b></u>///
'///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>Insert::Movie and Sound...</li>///
    InsertMovieAndSound
    '///<li>Check file open dialog and Close it (TRUE)</li>///
    call subTestFileOpenDialog ( TRUE )
    '///<li>Close document</li>///
    Call hCloseDocument
'///</ul>
endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertChart

    Call  hNewDocument

    try 
      InsertChartCalc
      Kontext "AutoFormatDiagrammBeginn"
      Call DialogTest ( AutoformatDiagrammBeginn )
      Weiter.Click
      printlog "First dialog passed"
      Kontext "AutoFormatDiagramm2"
      Call DialogTest2 ( AutoformatDiagramm2,1 )
      Weiter.Click
      printlog "Second dialog passed"
      Kontext "AutoFormatDiagramm3"
      Call DialogTest2 ( AutoformatDiagramm3,2 )
      Weiter.Click
      printlog "Third dialog passed"
      Kontext "AutoFormatDiagramm4"
      call DialogTest2 ( AutoformatDiagramm4,3 )
      AutoformatDiagramm4.Cancel
      printlog "Fourth dialog passed"
    catch
      warnlog "#i35390# should be the reason for this failture (CDE only!)"
      goto endsub
    endcatch

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertFormula

    Call  hNewDocument

    InsertObjectFormulaCalc
    Kontext "DocumentCalc"
    DocumentCalc.MouseDoubleClick 50,50

    Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tInsertFrame

    Call  hNewDocument

    InsertFloatingFrame
    Kontext "TabEigenschaften"
    Dialogtest (TabEigenschaften)
    TabEigenschaften.Cancel

    Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectOLE

    call hNewDocument

    InsertObjectOLEObject
    Kontext "OLEObjektEinfuegen"
    if Objekttyp.getitemcount < 0 then warnlog "There are no OLE-Objects in the listbox"
    NeuErstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 1)
    AusDateierstellen.Check
    Call DialogTest2 (OLEObjektEinfuegen, 2)
    OLEObjektEinfuegen.Cancel

    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectPlugin

    call hNewDocument

    InsertObjectPlugIn
    Kontext "PlugInEinfuegen"
    Call DialogTest (PlugInEinfuegen)
    DurchSuchen.Click
    Kontext "OeffnenDLG"
    UebergeordneterOrdner.click
    Standard.click
    OeffnenDlg.Cancel
    Kontext "PluginEinfuegen"
    PlugInEinfuegen.Cancel

    call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertObjectApplet

    call hNewDocument

    InsertObjectApplet
    Kontext "AppletEinfuegen"
    Call DialogTest (AppletEinfuegen)
    Suchen.Click
    Kontext "OeffnenDLG"
    call Dialogtest (OeffnenDlg)
    OeffnenDLG.Cancel
    Kontext "AppletEinfuegen"
    AppletEinfuegen.Cancel

    call hCloseDocument

endcase

