'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_001_.inc,v $
'*
'*  $Revision: 1.50 $
'*
'*  last change: $Author: pj $ $Date: 2005/11/08 14:13:03 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description  :  Resource test section file
'*
'**************************************************************************
'**
' #1 C_001_    ' Initial routine  
' #1 tFileNewSpreadsheet
' #1 tFileNewTemplatesAndDocuments
' #1 tFileOpen
' #1 tFileRecentDocuments
' #1 tFileOpenCSV
' #1 tFileWizardsDocumentConverter
' #1 tFileWizardsEuroConverter
' #1 tToolbarEuroConverter
' #1 tFileClose
' #1 tFileSave
' #1 tFileSaveWithPassword
' #1 tFileSaveAs
' #1 tFileSaveAsExcel
' #1 tFileSaveAsCSV
' #1 tFileSaveAsDIF
' #1 tFileSaveAsDBF
' #1 tFileSaveAll
' #1 tFileReload
' #1 tFileVersions
' #1 tFileExport
' #1 tmFileExportAsPDF
' #1 tFileSendDocumentAsEmail
' #1 tmFileSendDocumentAsPDF
' #1 tmExportAsPDF
' #1 tFileProperties
' #1 tFileTemplatesOrganize
' #1 tFilePagepreview
' #1 tFilePrint
' #1 tFilePrinterSettings
'**
'\************************************************************************


sub C_001_

Printlog Chr(13) + "--------- C_001_ ---------"


    call tFileNewSpreadsheet
    Call tFileNewTemplatesAndDocuments
    Call tFileOpen
    call tFileRecentDocuments
    call tFileOpenCSV
    call tFileWizardsDocumentConverter
    call tFileWizardsEuroConverter
    call tToolbarEuroConverter
    Call tFileClose
    Call tFileSave
    Call tFileSaveWithPassword
    Call tFileSaveAs
    Call tFileSaveAsExcel
    call tFileSaveAsCSV
    call tFileSaveAsDIF
    call tFileSaveAsDBF
    Call tFileSaveAll
    call tFileReload
    call tFileVersions
    call tFileExport
    Call tmFileExportAsPDF
'    call tFileSendDocumentAsEmail
'    Call tmFileSendDocumentAsPDF
    Call tmExportAsPDF
    Call tFileProperties
    Call tFileTemplatesOrganize
    Call tFilePagepreview
    Call tFilePrint
    Call tFilePrinterSettings

end sub

'
'-----------------------------------------------------------
' PJ: 2004-08-09
testcase tFileNewSpreadsheet
'///<u><b>File::New::Spreadsheet</b></u>///

  '///<ul>
  '///<li>open new document</li>
  call hNewDocument
  Kontext "DocumentCalc"
  '///<li>open new document with menu</li>
  DocumentCalc.UseMenu
  sleep(2)
  hMenuSelectNr(1)
  sleep(2)
  hMenuSelectNr(1)
  sleep(2)
  hMenuSelectNr(2)
  sleep(2)
  Kontext "DocumentCalc"
  '///<li>check for Calc Document</li>
  Call DialogTest (DocumentCalc)
  '///<li>close two documents</li>
  call hCloseDocument
  call hCloseDocument
  '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileNewTemplatesAndDocuments
'///<u><b>File::New::From Template</b></u>///

  '///<ul>
  '///<li>open new document</li>
  call hNewDocument

    '///<li>invoke template dialog {File::New::From Template}</li>
    FileNewFromTemplate
    Kontext "TemplateAndDocuments"
      '///<li>check for Template dialog</li>
      Call DialogTest (TemplateAndDocuments)
      TemplateAndDocuments.Cancel

  '///<li>close document</li>
  call hCloseDocument
  '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileOpen
'///<u><b>File::Open</b></u>///

  '///<ul>
  '///<li>open new document</li>
  call hNewDocument
  '///<li>invoke file open dialog</li>
    FileOpen
    Kontext "OeffnenDlg"
      '///<li>click "Up one level"</li>
      UebergeordneterOrdner.Click
      '///<li>Click "Default directory"</li>
      Standard.Click
      '///<li>Check "Read only"</li>
      NurLesen.check
      '///<li>Check if dialog exists</li>
      Call DialogTest ( OeffnenDlg )
      '///<li>Cancel dialog</li>
      OeffnenDlg.Cancel
      
  '///<li>close document</li>
  call hCloseDocument
  '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileRecentDocuments
'///<u><b>File::Recent Documents</b></u>///

  dim sTestFile$
   
  sTestFile$ = convertpath(gTesttoolPath & "calc/update/input/c_001/fileRecentDocuments.ods")
  '///<ul>
  '///<li>open Test File "calc/update/input/c_001/fileRecentDocuments.oos"</li>
  call hDateiOeffnen(sTestFile$)
  sleep(3)
  '///<li>Closing the document again</li>
  '///<li><b>Now a item in "Recent Documents" should exist</b></li>
  call hCloseDocument()
  sleep(2)
  '///<li>Reopen Document using the menu "File::Recent Documents"</li>
  Kontext "DocumentCalc"
  DocumentCalc.UseMenu
  sleep(2)
  hMenuSelectNr(1)
  sleep(2)
  hMenuSelectNr(3)
  sleep(2)
  hMenuSelectNr(1)
  '///<li>Goto Cell B3</li>
  call cGotoCell("B3")
  Kontext "DocumentCalc"
  '///<li>Cell content B3 -> Clipboard</li>
  DocumentCalc.typekeys "<F2><MOD1 A><MOD1 C><ESCAPE>"
  sleep(2)
  '///<li>Verify string in clipboard</li>
  if getClipboard() = "Check this out" then
     printlog "Loading most recent Document seems to work"
  else
     warnlog "Loading most recent Document seems to fail -> CHECK IT OUT!"
  endif
  '///<li>close document</li>
  call hCloseDocument
  '///</ul>
   
endcase
'
'-----------------------------------------------------------
'
testcase tFileOpenCSV
'///<u><b>File::Open (Load a CSV file)</b></u>///
    dim FileFilter as String
    dim k as integer
    dim kMax as integer

    '///<ul>
    '///<li>Invoke file open dialog</li>///
    printlog "Test the import dialog for CSV files"
    FileOpen
    Kontext "OeffnenDlg"
    '///<li>Change to one folder up</li>///
      UebergeordneterOrdner.Click
      '///<li>Change to default folder</li>///
      Standard.Click
        k = 1
        kMax = Dateityp.GetItemCount
        Dateityp.select k
        '///<li>Determine CSV filter entry</li>///
        while right(Dateityp.getSelText, 13) <> "(*.csv;*.txt)"
          printlog "Filetype: " & Dateityp.getSelText
          k = k + 1
          if k > kMax then
             warnlog "CSV filter entry not found"
             '///<li>(Throw warn log if CSV was not found)</li>///
             OeffnenDlg.Close
             goto endsub
          endif
          Dateityp.select k
        wend
        '///<li>Open file "calc\update\input\c_001\import.tst"</li>///
        Dateiname.settext convertpath(gtesttoolpath & "calc\update\input\c_001\import.tst")
        Oeffnen.Click
        Kontext "DocumentWriter"
        if DocumentWriter.exists(2) then
           warnlog "Filter detection is broken. Text file opened in writer although CSV filter was selected."
           call hCloseDocument
           goto endsub
        endif
        '///<li>Check existence of CSV import dialog</li>///
        Kontext "TextImport"
        call Dialogtest (TextImport)
          if TextImport.exists(2) then
             TextImport.ok
          else
             warnlog "CSV Import failed"
          endif
    
    Kontext "DocumentCalc"
    '///<li>Close document</li>///
    call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
' PJ: 2004-08-10
testcase tFileWizardsDocumentConverter
'///<u><b>File::Autopilot::Document Converter</b></u>///

   if gBuild < 8867 then
      warnlog "#i40880# - Testcase disabled"
      goto endsub
   endif
   
   '///<ul>
   '///<li>Open new document</li>///
   call hNewDocument
   '///<li>Invoke document converter</li>///
   if ActivateAutoPilot ( "DocumentConverter" ) = TRUE then
      Kontext "DocumentConverter"
      '///<li>Check existence of document converter dialog</li>///
      Call DialogTest ( DocumentConverter )
      '///<li>Choose spreadsheet as application in dialog</li>///
      spreadsheet.check
      '///<li>Click continue button</li>///
'      try 
          continueButton.Click
'          qaErrorLog "Remove catch for #i40880#"
'      catch
'          warnlog "#i40880# - Continue Button seem to be diabled!"
'          qaErrorLog "Using 'ExitRestartTheOffice' as hard work-around to get rid of the dialog!"
'          call hNewDocument
'          ExitRestartTheOffice
'          goto endsub
'      endcatch

      '///<li>Check if proceeding works</li>///
      if template.isVisible then
         printlog " + Proceeding (Step 1) in 'Document Converter' seems to work"
      else
         warnlog " + Proceeding (Step 1) in 'Document Converter' doesn't seem to work"
      endif

      '///<li><b>Check four times for file open dialog</b></li>///
      '///<li>for "Import from Template"</li>///
      '///<li><ol>
      ImportFormTemplatesSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///<li>for "Save to Template"</li>///
      SaveToTemplatesSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///<li>for "Import from Document"</li>///
      ImportFormDocumentSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      '///<li>for "Save to document"</li>///
      '///</ol></li>
      SaveToDocumentSearch.Click
      Kontext "OeffnenDLG"
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "DocumentConverter"
      
      '///<li>Click continue button</li>///
      continueButton.Click
      '///<li>Check if proceeding works</li>///
      if template.isVisible then
         warnlog " + Proceeding (Step 2) in 'Document Converter' doesn't seem to work"
      else         
         printlog " + Proceeding (Step 2) in 'Document Converter' seems to work"
      endif
      '///<li>Cancel dialog</li>///
      CancelButton.Click
   else
      warnlog "Starting the 'Document Converter' seems to have failed"
   endif
   '///<li>Close document</li>///
   call hCloseDocument
   '///</ul>
endcase
'
'-----------------------------------------------------------
' PJ: 2004-08-10
testcase tFileWizardsEuroConverter
'///<u><b>File::Autopilot::Euro Converter</b></u>///
   if gBuild < 8867 then
      warnlog "#i40880# - Testcase disabled"
      goto endsub
   endif

   Dim sDirectory$
   sDirectory$ = convertpath(gOfficePath & "user" )

   '///<ul>
   '///<li>Open new document</li>///
   call hNewDocument
   '///<li>Invoke euro converter</li>///
   if ActivateAutoPilot ( "EuroConverter" ) = TRUE then
      Kontext "AutoPilotEuroKonverter"
      '///<li>Check existence of euro converter dialog</li>///
      Call DialogTest ( AutoPilotEuroKonverter )

      '///<li>Invoke source directory dialog</li>///
      QuelleSuchen.Click
      Kontext "OeffnenDLG"
      '///<li>Check if file open dialog does exist</li>///
      Call Dialogtest (OeffnenDlg)
      '///<li>Cancel file open dialog</li>///
      OeffnenDLG.Cancel
      Kontext "AutoPilotEuroKonverter"
      '///<li>Invoke target directory</li>///
      ZielSuchen.Click
      Kontext "OeffnenDLG"
      '///<li>Check if file open dialog does exist</li>///
      Call Dialogtest (OeffnenDlg)
      OeffnenDLG.Cancel
      Kontext "AutoPilotEuroKonverter"
      
      '///<li>Set source directory</li>///
      Quelle.setText (sDirectory$)
      '///<li>Select random item if there isn't a preselection e.g. CJK</li>///
      if Waehrungen.GetSelIndex = 0 then
          Waehrungen.select 1
      endif
      '///<li>Click "Convert"</li>///
      konvertieren.Click
      '///<li>Check if proceeding did work</li>///
      if quelle.isVisible then
         warnlog " + Proceeding in 'Euro Converter' doesn't seem to work"
      else
         printlog " + Proceeding in 'Euro Converter' seems to work"
      endif
      '///<li>Cancel dialog</li>///
      abbrechen.Click
   else
      warnlog "Starting the 'Euro Converter' seems to have failed"
   endif
   '///<li>Close document</li>///
   call hCloseDocument
   '///</ul>
endcase
'
'-----------------------------------------------------------
' PJ: 2004-08-10
testcase tToolbarEuroConverter
'///<u><b>Toolbar::Euro Converter</b></u>///
   if gBuild < 8867 then
      warnlog "#i40880# - Testcase disabled"
      goto endsub
   endif

   '///<ul>
   '///<li>Open new document</li>///
   Call  hNewDocument
   '///<li>Inovke 'recent document' euro converter</li>///
   SpreadsheetEuroConverter
   Kontext "AutoPilotEuroKonverter"
   '///<li>check existence of euro converter</li>///
   Call DialogTest (AutoPilotEuroKonverter)
   '///<li>Cancel euro converter</li>///
   abbrechen.Click
   '///<li>Close document</li>///
   call hCloseDocument
   '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileClose
'///<u><b>File::Close</b></u>///


     '///<ul>
     '///<li>Open new document</li>///
     Call  hNewDocument
     '///<li>Edit random stuff to obtain a 'dirty' document</li>///
     EditCopy
     EditPaste
     '///<li>Invoke file::close</li>///
     '///<li>(Save|Discard|Cancel MsgBox should come up)</li>///
     FileClose
     Kontext
     '///<li>MsgBox: Cancel</li>///
     Active.Cancel
     '///<li>Invoke file::close</li>///
     FileClose
     '///<li>MsgBox: Save</li>///
     Kontext
     Active.Yes
     '///<li>Check for file open dialog</li>///
     Kontext "SpeichernDlg"
     '///<li>Cancel file open dialog</li>///
     SpeichernDlg.Cancel
     '///<li>Invoke file::close</li>///
     FileClose
     Kontext
     '///<li>MsgBox: Discard</li>///
     Active.No
     '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileSave
'///<u><b>File:Save</b></u>///


   '///<ul>
   '///<li>Open new document</li>///
   Call  hNewDocument

      '///<li>Edit random stuff to obtain a 'dirty' document</li>///
      EditCopy
      EditPaste
      '///<li>File::Save</li>///
      FileSave
      '///<li>Save dialog should be visible now</li>///
      Kontext "SpeichernDlg"
        '///<li>Click 'folder up'</li>///
        UebergeordneterOrdner.click
        '///<li>Click 'default folder'</li>///
        Standard.Click
        '///<li>Select default file format</li>///
        try
           Dateityp.Select FileFormat
        catch
           warnlog "#i48382# - wrong filternames"
        endcatch
        '///<li>Check if save dialog exists</li>///
        Call DialogTest (SpeichernDlg)
        '///<li>Cancel save dialog</li>///
   SpeichernDlg.Cancel
   
   '///<li>Close document</li>///
    call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveWithPassword
'///<u><b>File::Save (with password)</b></u>///

    '///<ul>
    Dim Datei$ : Datei$ = convertpath(gOfficePath & "user/work/password" & Ext)
    if Dir(Datei$) <> "" then kill Datei$
    Dim Datei1$ : Datei1$ = convertpath(gOfficePath & "user/work/test" & Ext)
    if Dir(Datei1$) <> "" then kill Datei1$

    '///<li>Open new document</li>///
    Call hNewDocument
    sleep(2)
    '///<li>Add random content</li>///
      DocumentCalc.TypeKeys "Random stupid content<Return>"
      '///<li>File::Save</li>///
      FileSave
      Kontext "SpeichernDlg"
        printlog "FileFormat: " & FileFormat
        '///<li>Select default format filter</li>///
        try
           Dateityp.Select FileFormat
        catch
           warnlog "#i48382# - wrong filternames"
        endcatch
        try
        '///<li>Check password box</li>///
           Passwort.Check
           printlog "Password checked"
        catch
           warnlog "If it is not possible to check or uncheck the password it's a bug."
        endcatch
        '///<li>Click 'one folder up'</li>///
        UebergeordneterOrdner.Click
        '///<li>Click 'default folder'</li>///
        Standard.Click
        '///<li>Check if passwordbox is still checked</li>///
        if NOT passwort.ischecked then
          try
             passwort.check
             warnlog "Password was lost by changign the directory"
          catch
             warnlog "If it is not possible to check or uncheck the password it's a bug."
          endcatch
        end if
        '///<li>Set file name (user/work/password.{Extension})</li>///
        Dateiname.settext Datei$
        '///<li>Deselect 'automatic file name extension'</li>///
        if AutomatischeDateinamenserweiterung.ischecked then AutomatischeDateinamenserweiterung.uncheck
        '///<li>Click save button</li>///
        Speichern.Click

        '///<li>Check for overwrite warning</li>///
        Kontext "Active"
          if Active.Exists(2) then
             Active.Yes
          endif
          '///<li>(Password dialog should be visible now)</li>///
          Kontext "Passwort"
          '///<li>Check existence of password dialog</li>///
          Call DialogTest ( Passwort )
          printlog "1st test - wrong confirmation"
          '///<li>Set password</li>///
          PasswortName.settext "Tiberius"
          '///<li>Set wrong conformation of password</li>///
          PasswortBestaetigen.SetText "12345678"
          '///<li>Confirm dialog</li>///
          Passwort.Ok
          sleep(15)

          '///<li>(MsgBox warning for wrong password confirmation should be visible)</li>///
          Kontext
          if active.exists then
            '///<li>Confirm warning</li>///
            active.ok
            Kontext "Passwort"
              printlog "2nd test - correct confirmation"
              '///<li>Set password again</li>///
              PasswortName.settext "Tiberius"
              '///<li>Now enter right confirmation</li>///
              PasswortBestaetigen.SetText "Tiberius"
              '///<li>OK</li>///
              Passwort.Ok
          else
            warnlog "Wrong confirming wasn't noticed -> BUG"
          end if

        '///<li>Close file</li>///
        FileClose
        sleep(5)
      
      '///<li>Try to reopen file</li>///
      FileOpen
      sleep(2)
      Kontext "OeffnenDlg"
        Dateiname.settext Datei$
        Oeffnen.Click
      '///<li>(Password input dialog should be visible now)</li>///
        Kontext "PasswordFileOpen"
          printlog "reopening file"
          '///<li>Enter wrong password</li>///
          PasswortName.settext "Suirebit"
          '///<li>OK</li>///
          PasswordFileOpen.Ok

      Kontext
      '///<li>(Warning appears)</li>///
        if active.exists then
        '///<li>OK</li>///
          active.ok
          '///<li>Reopen file</li>///
     FileOpen
          Kontext "OeffnenDlg"
            Dateiname.settext Datei$
            Oeffnen.Click
            Kontext "PasswordFileOpen"
            '///<li>Enter right password</li>///
              PasswortName.settext "Tiberius"
              '///<li>OK</li>///
              PasswordFileOpen.Ok
        else
          warnlog "Wrong password wasn't noticed by loading the document"
        end if
   
      '///<li>Save file again</li>///
      sleep(2)
      FileSaveAs
      Kontext "SpeichernDlg"
        Dateiname.Settext Datei1$
        '///<li>Deselect password option</li>///
        if AutomatischeDateinamenserweiterung.ischecked then AutomatischeDateinamenserweiterung.uncheck
        if Passwort.isChecked then Passwort.unCheck
        '///<li>Save</li>///
        Speichern.Click
        Kontext "Active"
        '///<li>Confirm overwrite warning if exists</li>///
          if Active.Exists(2) then
             Active.Yes
          endif
        call hCloseDocument
    
      '///<li>Reopen file (NO password dialog should appear now!)</li>///
      FileOpen
      Kontext "OeffnenDlg"
        Dateiname.settext Datei1$
        Oeffnen.Click
        Kontext "PasswordFileOpen"
          printlog "Test if a later deselection of password works."
          '///<li>Check if password dialog exists</li>///
          if PasswortName.exists then
            '///<li>-> Throw warning if it does</li>///
            warnlog "Despite of saving the document with another name it was required a password:-> Bug!"
            PasswortName.settext "Tiberius"
            '///<li>Close document</li>///
            call hCloseDocument
          else
            Kontext "Active"
            '///<li>If password dialog doesn't come up check for other unexpected stuff</li>///
              if Active.Exists then
                WarnLog " MessageBox : " + Active.GetText
                Active.OK
              else
                hCloseDocument
              end if
          end if
          '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAs
'///<u><b>File::Save As...</b></u>///

     '///<ul>
     '///<li>Open new document</li>///
     Call  hNewDocument

     '///<li>File::Save As...</li>/// 
     FileSaveAs
      Kontext "SpeichernDlg"
        UebergeordneterOrdner.Click
        Standard.Click
        '///<li>Check for existence of file open dialog</li>///
        Call DialogTest ( SpeichernDlg )
        '///<li>Cancel dilaog</li>///
        SpeichernDlg.Cancel
    '///<li>Close document</li>///
    call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsExcel
'///<u><b>File::Save As... (Excel)</b></u>///
   '///<ul>
   '///<li>Open test document "calc/update/input/c_001/all_features.sxc"</li>///
   call hDateiOeffnen convertpath(gTesttoolPath & "calc/update/input/c_001/all_features.sxc")
   sleep(60)
   '///<li>File::Save as...</li>///
   FileSaveAs
   '///<li>(File open dialog should be visible now)</li>///
   Kontext "SpeichernDlg"
   '///<li>Enter target file name</li>///
     Dateiname.setText convertpath(gOfficePath & "user/work/all_features")
     '///<li>Select filter #7 (should be Excel97/2000/XP)</li>///
     Dateityp.select 7
     '///<li>Check if assumption was right</li>///
     if instr(Dateityp.getSelText,"xls") AND instr(Dateityp.getSelText,"XP") then
        printlog "Excel97/2000/XP filter was selected"
     else
        '///<li>+ Throw warning and exit if selecting Excel97/2000/XP filter failed</li>///
        warnlog "Excel97/2000/XP filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '///<li>Select 'automatic file name extention</li>///
     AutomatischeDateinamenserweiterung.check
     printlog "Filetype: " & Dateityp.getSelText
     '///<li>Click save button</li>///
     Speichern.click
     '///<li>Check for overwrite warning</li>///
     'qaErrorLog "#118517# On Unix/Linux systems a crash can happen. No sucess in try/catch yet."
     sleep(1)
     Kontext "Active"
       if Active.exists(2) then
          '///<li>-> Commit if exists</li>///
             Active.YES
       endif
     '///<li>Check for alien file format warning</li>///
     Kontext "AlienWarning"
       if AlienWarning.exists(2) then
          '///<li>-> Commit if exists</li>///
          AlienWarning.OK
       else 
          warnlog "Alien file format warning is missing -> Check this out!"
       endif
     sleep 60 ' necessary because it takes some time to save! (especially on a nonpro)
       '///<li>Check for unexpected MsgBox</li>///
     Kontext "Active"
       if Active.exists(2) then
          warnlog "An unexpected MsgBox seems to be in the way"
          goto endsub
       endif
       '///<li>Close file</li>///
     FileClose
       '///<li>Check for unexpected MsgBox</li>///
     Kontext "Active"
       if Active.exists(2) then
          warnlog "Saving to MS office formats seems to enable the change flag"
          active.yes
       endif
     sleep(2)
   '///<li>Reopen Excel file</li>///
'   try
    call hDateiOeffnen convertpath(gOfficePath & "user/work/all_features.xls")
 '  catch 'UGLY HACK
'       sleep(300)
 '      warnlog "#i42572# was caught by an ugly hack ;-)"
   '///<li>Close document</li>///
'   endcatch
   sleep (2)
   FileClose
   sleep(2)
   '///<li>Check for unexpected MsgBox</li>///
     Kontext "Active"
       if Active.exists(2) then
          qaErrorLog "#i46837# (Target: OOo 2.0.1) - Save button enabled immediately after loading excel document"
          active.no
       endif
     sleep(2)
     '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsCSV
'/// Check CSV export dialog
'///<u><b>File::Save as... (CSV)</b></u>///

   '///<ul>
   '///<li>Open new document</li>///
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Edit some random stuff</li>///
   DocumentCalc.typeKeys ("1<return>")
   '///<li>File::Save As... (CSV)</li>///
   FileSaveAs
   Kontext "SpeichernDlg"
   '///<li>Set target file name "user/work/saveCSV"</li>///
     Dateiname.setText convertpath(gOfficePath & "user/work/saveCSV")
     '///<li>Select filter #20 (should be the CSV filter)</li>///
     Dateityp.select 20 
     '///<li>Check if assumption was right</li>///
     if instr(Dateityp.getSelText,"csv") then
        printlog "CSV filter was selected"
     else
        '///<li>+ Throw warning and exit if selecting CSV filter failed</li>///
        warnlog "CSV filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '///<li>Select 'automatic file extention'</li>///
     AutomatischeDateinamenserweiterung.check
     printlog "Filetype: " & Dateityp.getSelText
     '///<li>Click Save</li>///
     Speichern.click
     '///<li>Check for overwrite warning</li>///
     sleep(1)
     Kontext "Active"
       if Active.exists(2) then
          '///<li>-> Commit if exists</li>///
             Active.YES
       endif
     sleep(2)
     '///<li>Check alien file format warning</li>///
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '///<li>-> Commit if exists</li>///
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '///<li>Check existence of export encoding dialog</li>///
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '///<li>Cancel dialog</li>///
     ExportCalc.Cancel

   '///<li>Close document</li>///
   Call hCloseDocument
   '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsDIF
'///<u><b>File::Save as... (DIF)</b></u>///

   '///<ul>
   '///<li>Open new document</li>///
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Edit some random stuff (e.g. 1|Return)</li>///
   DocumentCalc.typeKeys ("1<return>")
   '///<li>File::Save as...</li>///
   FileSaveAs
   Kontext "SpeichernDlg"
     '///<li>Enter file name "user/work/saveDIF"</li>///
     Dateiname.setText convertpath(gOfficePath & "user/work/saveDIF")
     '///<li>Select filter #5 (should be DIF)</li>///
     Dateityp.select 5
     '///<li>Check if above assumption is right</li>///
     if instr(Dateityp.getSelText,"dif") then
        printlog "DIF filter was selected"
     else
        '///<li>+ Throw warning and exit if selecting DIF filter failed</li>///
        warnlog "DIF filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '///<li>Check 'automatic file name extention'</li>///
     AutomatischeDateinamenserweiterung.check
     printlog "Filetype: " & Dateityp.getSelText
     '///<li>Click Save</li>///
     Speichern.click
     sleep(2)
     '///<li>Commit overwrite warning if file already exists</li>///
     Kontext
     if Active.exists(2) then
        Active.Yes
     endif
     '///<li>Check alien file format warning</li>///
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '///<li>-> Commit if exists</li>///
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '///<li>Check existence of export encoding dialog</li>///
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '///<li>Cancel dialog</li>///
     ExportCalc.Cancel

   '///<li>Close document</li>///
   Call hCloseDocument
   '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAsDBF
'///<u><b>File:Save as... (DBF)</b></u>///

   '///<ul>
   '///<li>Open new document</li>///
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Edit random stuff to obtain 'dirty' document</li>///
   DocumentCalc.typeKeys ("1<return>")
   '///<li>File::Save as ...</li>///
   FileSaveAs
   Kontext "SpeichernDlg"
   '///<li>Enter target file name "user/work/saveDBF"</li>///
     Dateiname.setText convertpath(gOfficePath & "user/work/saveDBF")
     '///<li>Select filter #6 (should be DBF)</li>///
     Dateityp.select 6
     '///<li>+ Check if assumption was correct</li>///
     if instr(Dateityp.getSelText,"dbf") then
        printlog "DBF filter was selected"
     else
       '///<li>Throw warning and exit is selecting DBF filter failed</li>/// 
       warnlog "DBF filter not available or moved in filter list!"
        SpeichernDlg.Cancel
        Call hCloseDocument
        goto endsub
     end if
     '///<li>Check 'automatic file name extention'</li>///
     AutomatischeDateinamenserweiterung.check
     printlog "Filetype: " & Dateityp.getSelText
     '///<li>Click 'save'</li>///
     Speichern.click
     sleep(2)
     '///<li>Commit overwrite warning if file already exists</li>///
     Kontext
     if Active.exists(2) then
        Active.Yes
     endif
     '///<li>Check alien file format warning</li>///
     Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '///<li>-> Commit if exists</li>///
        AlienWarning.OK
     else 
        warnlog "Alien file format warning is missing -> Check this out!"
     endif
     '///<li>Check existence of export encoding dialog</li>///
     Kontext "ExportCalc"
     Call DialogTest (ExportCalc)
     '///<li>Cancel dialog</li>///
     ExportCalc.Cancel

     '///<li>Close document</li>///
   call hCloseDocument
   '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileSaveAll
'///<u><b>File::Save all...</b></u>///

     '///<ul>
     '///<li>Open new document</li>///
     Call  hNewDocument
       '///<li>Edit random stuff to enable Save Button</li>///
       EditCopy
       EditPaste
      
     '///<li>Open another new document</li>///
     Call  hNewDocument
       '///<li>Edit random stuff to enable Save Button</li>///
       EditCopy
       EditPaste

       '///<li>File::Save all...</li>///
       FileSaveAll
       '///<li>Cancel 'Save' for the first document</li>///
       Kontext "SpeichernDlg"
       SpeichernDlg.Cancel

       '///<li>Cancel 'Save' for the second document</li>///
       Kontext "SpeichernDlg"
       SpeichernDlg.Cancel

       try
       '///<li>Try to cancel 'Save' for the third document (This is expected)</li>///
          Kontext "SpeichernDlg"
          SpeichernDlg.Cancel
       catch
          '///<li>+ (After a earlier crash only two save dialogs may appeared)</li>///
          qaErrorLog "Alternative result: Only two Save dialogs closed."
          qaErrorLog "This happens sometime if a earlier testcase crashed OOo."
          goto skipNextTry
       endcatch

       try
       '///<li>Try to cancel 'Save' a fourth (Unexpected)</li>///
          Kontext "SpeichernDlg"
          SpeichernDlg.Cancel
          '///<li>+ Throw warning if four save dialogs appeared</li>///
          warnlog "Unexpected result: Four Save dialogs closed"
       catch
          printlog "Expected result: Three Save dialogs closed"
       endcatch

skipNextTry:
      '///<li>Close two documents</li>///
      Call hCloseDocument
      Call hCloseDocument
      '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileReload
'///<u><b>File::Reload</b></u>///

  dim sTestFile$
   
  sTestFile$ = convertpath(gTesttoolPath & "calc/update/input/c_001/fileReload.ods")
  '///<ul>
  '///<li>open Test File "calc/update/input/c_001/fileReload.oos"</li>
  call hDateiOeffnen(sTestFile$)
  sleep(3)
  Kontext "DocumentCalc"
  '///<li>Goto cell A1</li>
  call cGotoCell("A1")
  Kontext "DocumentCalc"
  '///<li>Edit random stuff</li>///
  DocumentCalc.typekeys "3<RETURN>"
  '///<li>File;;reload</li>///
  FileReload
  '///<li>Look for reload warning</li>///
  Kontext "Active"
  if Active.Exists(2) then
     call Dialogtest(Active)
     printlog "MsgBox appeared: " & Active.GetText
     '///<li>+ Commit if warning exists (desired behaviour)</li>///
     Active.Yes
     sleep(5)
  else
     '///<li>+ Throw warning if MsgBox doesn't exist</li>///
     warnlog "OOPS, a warning should appear here -> CHECK IT OUT!"
  endif
  Kontext "DocumentCalc"
  '///<li>Goto cell A1</li>
  call cGotoCell("A1")
  '///<li>Check if reload restored original content of cell A1</li>///
  Kontext "DocumentCalc"
  DocumentCalc.typekeys "<F2><MOD1 A><MOD1 C><ESCAPE>"
  sleep(2)
  '///<li>Verify string in clipboard</li>
  if getClipboard() = "1" then
     printlog "Reload seems to work as expected"
  else
     warnlog "Reload doesn't seem to work as expected -> CHECK IT OUT!"
  endif

  '///<li>close document</li>
  call hCloseDocument
  '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileVersions
'///<u><b>File::Versions ...</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    call hNewDocument
    '///<li>Save document as "user/work/version.{ext}"</li>///
    call hSpeichernUnterKill convertpath(gOfficePath & "user/work/version" & Ext)
    '///<li>File::Version...</li>///
    FileVersions
    Kontext "Versionen"
      '///<li>Check existence of versions dialog</li>///
      call Dialogtest (Versionen)
      '///<li>Click 'save' button</li>///
      Speichern.click
        Kontext "VersionskommentarEingeben"
          '///<li>Check existence of comments dialog</li>///
          call DialogTest(VersionskommentarEingeben)
          '///<li>Cancel comments dialog</li>///
          VersionskommentarEingeben.Cancel
    Kontext "Versionen"
       '///<li>Close versions dialog</li>///
       Versionen.close

    '///<li>Close document</li>///    
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFileExport
'///<u><b>File::Export...</b></u>///
   dim outputFile$
   '///<ul>
   '///<li>Define output file as "user/work/tFileExport"</li>///
   outputFile$ = convertpath(gOfficePath & "user/work/tFileExport")
   '///<li>Kill older version of output file</li>///
   if Dir(outputFile$) <> "" then 
      kill outputFile$
   endif

   '///<li>Open new document</li>///
   call hNewDocument
   sleep(2)
   Kontext "DocumentCalc"
   '///<li>Edit some random stuff to obtain a 'dirty' file</li>///
   DocumentCalc.typeKeys ("1<return>")
   '///<li>File::Export...</li>///
   FileExport
   Kontext "ExportierenDLG"
   '///<li>Check if export dialog exists</li>///
   call Dialogtest (ExportierenDLG)
   '///<li>Click 'one level up' button</li>///
   UebergeordneterOrdner.Click
   '///<li>Click 'default folder' button</li>///
   Standard.Click
   '///<li>Click 'new folder' button</li>///
   NeuerOrdner.Click
   kontext "NeuerOrdner"
   '///<li>Cancel 'name new folder' dialog -> back to export dialog</li>///
   NeuerOrdner.cancel
   Kontext "ExportierenDLG"
   '///<li>Enter output file name -> "user/work/tFileExport"</li>///
   Dateiname.SetText outputFile$
   '///<li>Select filter #3 (should be XHTML)</li>///
   Dateityp.select 3
   AutomatischeDateinamenserweiterung.UnCheck
   Speichern.Click
   '///<li>Check alien file format warning</li>///
   Kontext "AlienWarning"
     if AlienWarning.exists(2) then
        '///<li>-> Commit if exists</li>///
        AlienWarning.OK
        warnlog "#i41983# Alien file format warning shouldn't pop up for export"
     endif
   '///<li>Check for MsgBox (none expected)</li>///
   Kontext
   if Active.exists(2) then
      try 
         Active.OK
         if Active.exists(2) then
            Active.OK
            '///<li>+ If Java isn't installed two MsgBoxes should appear</li>///
            qaErrorLog "Probably XHTML export failed due to lack of a JRE -> Please check it!"
         else
            warnlog "At this point a second MsgBox is expected to follow the first one -> Check it out!"
         endif
      catch
         Active.YES
         '///<li>+ Throw warning if unexpected MsgBox appears</li>///
         warnlog "Unexpected kind of MsgBox found -> Please check!"
      endcatch
   endif
   sleep(2)
   '///<li>Close document</li>///
   Call hCloseDocument
   '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tmFileExportAsPDF
'///<u><b>FILE::Export as PDF ...</b></u>///

   dim sPDF as string
   dim sTemp as string

   sPDF = "PDF - Portable Document Format (.pdf)"

   '/// open application ///'
   Call hNewDocument
   sleep(2)
   hTypeKeys ("a<return>")

   '/// File->Export As PDF... ///'
   FileExportAsPDF
      ' the 'Export as PDF' dialog has to come up, with the only 'File type' 'PDF - Portable Document Format'
      kontext "ExportAsPDFDlg"
        sTemp = Dateityp.GetSelText
        if (sTemp <> sPDF) then
          Warnlog "filter for PDF export is missing :-( '" + sPDF + "'"
        endif
        '/// set Textbox 'File name' to "abc" ///'
        Dateiname.SetText convertpath(gOfficePath & "user/work/abc")
        '/// uncheck the checkbox 'Automatic file name extension' ///'
        AutomatischeDateinamenserweiterung.UnCheck
        '--33013: CHECKBOX: Selection   HID_FILESAVE_SELECTION
        '/// check if Checkbox 'Selection' is disabled, it HAS to! ///'
        if Selektion.IsEnabled then
           Warnlog "Selection is enabled :-("
        endif
        '/// use the cursor keys in the filebrowser ///'
        DateiAuswahl.TypeKeys "<home><down>"
        '/// click on the button 'Up one level' ///'
        UebergeordneterOrdner.Click
        '/// click on the button 'Create New Directory' ///'
        try
           NeuerOrdner.Click
           kontext "NeuerOrdner"
             '/// in the dialog $Foldername set textfield 'New' to 'abc' ///'
             OrdnerName.SetText "abc"
             '/// cancel dialog $Foldername ///'
             NeuerOrdner.cancel
        catch
           warnlog "New folder button is not active"
        endcatch
      kontext "ExportAsPDFDlg"
        '/// click on the button 'Default Directory' ///'
        Standard.Click
        '/// click on the button 'Export...' ///'
        Export.Click

        ' if file exists, there is a message...
        kontext
          if messagebox.exists then
             messagebox.Yes ' to go on ....
          endif
        '/// Check alien file format warning///
        Kontext "AlienWarning"
        if AlienWarning.exists(2) then
           '///+ -> Commit if exists///
           AlienWarning.OK
           warnlog "#i41983# Alien file format warning shouldn't pop up for export"
        endif
        kontext "PDFOptions"
          '/// check radiobutton 'All' ///'
          RangeAll.Check
          '/// check radiobutton 'Pages' ///'
          RangePages.Check
          '/// set textbox '' to '123' ///'
          RangePagesEdit.SetText "123"
          '/// check radiobutton 'Selection' (not enabled in math!) ///'
          if RangeSelection.IsEnabled then
             'Warnlog "RangeSelection is enabled in math ???"
             RangeSelection.Check
          else
             Warnlog "RangeSelection is not enabled :-("
          endif

      '///+ - check radiobutton 'Lossless Compression' ///'
      LosslessCompression.Check
      '///+ - check radiobutton 'Jpeg Compression' ///'
      JpegCompression.Check
      '///+ - check box 'Reduce Image Resolution' ///'
      ReduceImageResolution.Check
      '///+ - increase 'Quality' by 2///'
      ImagesQuality.more (2)
      '///+ - decrease 'Quality'///'
      ImagesQuality.less
      '///+ - select last item in list box 'Reduce Image Resolution'///'
      ReduceImageResolutionDPI.select (5)
      '///+ - uncheck check box 'Reduce Image Resolution' ///'
      ReduceImageResolution.uncheck
      '///+ - check radiobutton 'Lossless Compression' ///'
      LosslessCompression.Check
      '///+ - check box 'Tagged PDF' ///'
      TaggedPDF.check
      '///+ - check box 'Export Notes' ///'
      ExportNotes.check
      '///+ - check if 'Transition Effects' is disabled ///'
      if TransitionEffects.isEnabled then
         warnlog "Transition Effects should have been disabled"
      else
         printlog "OK, transition Effects is disabled"
      endif
      '///+ - select last item in list box 'submit forms in format'///'
      FormsFormat.select(4)

          '/// cancel dialog 'PDF Options' ///'
          PDFOptions.Cancel

   '/// close application ///'
   Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileSendDocumentAsEmail
'///<u><b>File::Send::Document as E-Mail...</b></u>///

  '///<ul>
  '///<li>Open new document</li>///
  Call hNewDocument
  Kontext "DocumentCalc"
  '///<li>Edit random stuff to obtain 'dirty' document</li>///
  DocumentCalc.typekeys "1<RETURN>"
  '///<li>File::Send::Document as E-Mail...</li>///
  FileSendDocumentAsEmail
  Kontext "Active"
  '///<li>Check for MsgBox the indicates unconfigured E-Mail settings</li>///
  if Active.Exists then
     if Active.GetRT = 304 then 
     '///<li>+ Test this box if it exists</li>///
        printlog "Probably no configuration for E-Mail found. See error message below:"
        printlog Active.GetText
        Active.OK
     else
        warnlog "Active Dialog has wrong resource type -> Check this out!"
     endif
   else   
     qaErrorLog "In case of correct E-Mail configuration the e-mail client should be visible now!"
     qaErrorLog "BTW, it's correct that nothing happens in OOo!"
  endif
  
   Call hCloseDocument
  '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tmFileSendDocumentAsPDF
'///<u><b>File::Send::Document as PDF</b></u>///
   '/// open application ///'
   Call hNewDocument
   sleep(2)
   hTypeKeys ("a<return>")

   '/// File->Send->Document As PDF Attachment... ///'
   FileSendDocumentAsPDF
   '/// on the dialog 'PDF Options' ///
   kontext "PDFOptions"
      '///+ - check radiobutton 'All' ///'
      RangeAll.Check
      '///+ - check radiobutton 'Pages' ///'
      RangePages.Check
      '///+ - - set textbox '' to '123' ///'
      RangePagesEdit.SetText "123"
      '///+ - check radiobutton 'Selection' (not enabled in math!) ///'
      if RangeSelection.IsEnabled then
         'Warnlog "RangeSelection is enabled in math ???"
         RangeSelection.Check
      else
         Warnlog "RangeSelection is not enabled :-("
      endif

      '///+ - check radiobutton 'Lossless Compression' ///'
      LosslessCompression.Check
      '///+ - check radiobutton 'Jpeg Compression' ///'
      JpegCompression.Check
      '///+ - check box 'Reduce Image Resolution' ///'
      ReduceImageResolution.Check
      '///+ - increase 'Quality' by 2///'
      ImagesQuality.more (2)
      '///+ - decrease 'Quality'///'
      ImagesQuality.less
      '///+ - select last item in list box 'Reduce Image Resolution'///'
      ReduceImageResolutionDPI.select (5)
      '///+ - uncheck check box 'Reduce Image Resolution' ///'
      ReduceImageResolution.uncheck
      '///+ - check radiobutton 'Lossless Compression' ///'
      LosslessCompression.Check
      '///+ - check box 'Tagged PDF' ///'
      TaggedPDF.check
      '///+ - check box 'Export Notes' ///'
      ExportNotes.check
      '///+ - check if 'Transition Effects' is disabled ///'
      if TransitionEffects.isEnabled then
         warnlog "Transition Effects should have been disabled"
      else
         printlog "OK, transition Effects is disabled"
      endif
      '///+ - select last item in list box 'submit forms in format'///'
      FormsFormat.select(4)

      '///+ - cancel dialog 'PDF Options' ///'
      PDFOptions.Cancel
      Kontext "Active"
      if Active.Exists(2) then
         if Active.GetRT = 304 then
            printlog "Probably no configuration for E-Mail found. See error message below:"
            printlog Active.GetText
            Active.OK
         else 
            warnlog "Unexpected dialog detected!"
         end if
      else
         qaErrorLog "With correct configured E-Mail settings nothing happens in OOo!"
         qaErrorLog "E-Mail client should be visible now!"
      end if

   '/// close application ///'
   Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tmExportAsPDF
'///<u><b>Button::Export as PDF ...</b></u>///

   dim sPDF as string
   dim sTemp as string

   sPDF = "PDF - Portable Document Format (.pdf)"

   '/// open application ///'
   Call hNewDocument
   sleep(2)
   hTypeKeys ("a<return>")

   '/// click the button 'Export Directly as PDF' on the Functionbar ///'
   kontext "Standardbar"
     ExportAsPDF.click
     ' the 'Export as PDF' dialog has to come up, with the only 'File type' 'PDF - Portable Document Format'
     kontext "ExportAsPDFDlg"
       sTemp = Dateityp.GetSelText
       if (sTemp <> sPDF) then
          Warnlog "filter for PDF export is missing :-( should: '" + sPDF + "'; is: '" +  + "'"
       endif
       '///+ - set Textbox 'File name' to "abc" ///'
       Dateiname.SetText convertpath(gOfficePath & "user/work/abc")
       '///+ - uncheck the checkbox 'Automatic file name extension' ///'
       AutomatischeDateinamenserweiterung.UnCheck
       '--33013: CHECKBOX: Selection   HID_FILESAVE_SELECTION
       '/// check if Checkbox 'Selection' is disabled, it HAS to! ///'
       if Selektion.IsEnabled then
          Warnlog "Selection is enabled :-("
       endif
       '///+ - use the cursor keys in the filebrowser ///'
       DateiAuswahl.TypeKeys "<home><down>"
       '///+ - click on the button 'Up one level' ///'
       UebergeordneterOrdner.Click
       '///+ - click on the button 'Create New Directory' ///'
       try
          NeuerOrdner.Click
          kontext "NeuerOrdner"
            '///+ - - in the dialog $Foldername set textfield 'New' to 'abc' ///'
            OrdnerName.SetText "abc"
            '///+ - - cancel dialog $Foldername ///'
            NeuerOrdner.cancel
       catch
          warnlog "New folder button is not active"
       endcatch
     kontext "ExportAsPDFDlg"
       '///+ - click on the button 'Default Directory' ///'
       Standard.Click
       '///+ - click on the button 'Export...' ///'
       Export.Click
       sleep(2)
       ' if file exists, there is a message...
       kontext
       sleep(2)
         if messagebox.exists then
            sleep(2)
            messagebox.Yes ' to go on ....
            sleep(2)
         endif
        '///+ -Check alien file format warning///
        Kontext "AlienWarning"
        if AlienWarning.exists(2) then
           '///+ - Commit if exists///
           AlienWarning.OK
           warnlog "#i41983# Alien file format warning shouldn't pop up for export"
        endif
         
   '/// close application ///'
   Call hCloseDocument
endcase
'
'-----------------------------------------------------------
'
testcase tFileProperties
'///<u><b>File::Properties...</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call hNewDocument

    '///<li>File::Properties</li>///
    FileProperties
    Kontext
      '///<li>Goto tabpage 'decription'</li>///
      active.SetPage TabDokumentinfo
      Kontext "TabDokumentinfo"
      '///<li>Check existence of tabpage 'decription'</li>///
        Call DialogTest ( TabDokumentinfo )

    Kontext
      '///<li>Goto tabpage 'General'</li>///
      active.SetPage TabDokument
      '///<li>Check existence of tabpage 'general'</li>///
      Kontext "TabDokument"
        Call DialogTest ( TabDokument )

    Kontext
      '///<li>Goto tabpage 'User defined'</li>///
      active.SetPage TabBenutzer
      Kontext "TabBenutzer"
      '///<li>Check existence of tabpage 'User defined'</li>///
        Call DialogTest ( TabBenutzer )
        '///<li>Click 'Info fields' button</li>///
        Infofelder.Click
        Kontext "InfonamenBearbeiten"
          '///<li>Check existence of dialog 'Edit field names'</li>///
          Call DialogTest ( InfonamenBearbeiten )
          InfonamenBearbeiten.Close

    Kontext
      '///<li>Goto tabpage 'Statistics'</li>///
      active.SetPage TabStatistikCalc
      Kontext "TabStatistikCalc"
        '///<li>Check existence of tabpage 'Statistics'</li>///
        Call DialogTest ( TabStatistikCalc )

    Kontext
      '///<li>Goto tabpage 'Internet'</li>///
      active.SetPage TabInternet
      Kontext "TabInternet"
        '///<li>Check existence of tabpage 'Internet'</li>///
        Call DialogTest ( TabInternet )
        '///<li>Check 'redirect from this document'</li>///
        RedirectFromThisDocument.check
        '///<li>Try to change to tab 'statistics'</li>///
        try
        Kontext
          active.SetPage TabStatistikCalc
          '///<li>-> A warning regarding the unspecified 'redirect URL' should hinder this</li>///
          Kontext "Active"
          '///<li>Check if the MsgBox is the one we expect</li>///
          if Active.Exists(2) then
             if Active.GetRT = 304 then
                printlog "MsgBox has expected Resource type."
                printlog "OK. Probably a warning to enter a redirect URL poped up:"
                printlog Active.GetText
             else
                warnlog "MsgBox has unexpected Resource type! -> Check this out"
             endif
             '///<li>Commit MsgBox</li>///
             '///<li>(The testttol triggers the MsgBox three times, this doesn't happen in reality)</li>///
             while Active.Exists(1) 
               Active.OK
             wend
          else
          '///<li>+ Throw a warning if there wasn't a MsgBox</li>///
             warnlog "A warning to enter a URL for redirection was expected -> Check it out!"
          endif
          catch
          endcatch
        '///<li>Check if we are still on tab 'Internet' (expected)</li>///
        Kontext "TabInternet"
        if TabInternet.exists(2) then
           printlog "Staying on tab 'internet' as expected"
        else
           warnlog "Changing the tabpage shouldn't happen here!"
           Kontext  
           active.SetPage TabInternet
        endif
        '///<li>Continue test of tab Internet</li>///
        Kontext "TabInternet"
        '///<li>Click browse button</li>///
        BrowseURL.Click
        '///<li>(File open dialog should be visible now)</li>///
        Kontext "OeffnenDlg"
          '///<li>Check if dialog exists</li>
          Call DialogTest ( OeffnenDlg )
          '///<li>click "Up one level"</li>
          UebergeordneterOrdner.Click
          '///<li>Click "Default directory"</li>
          Standard.Click
          '///<li>Cancel dialog</li>
          OeffnenDlg.Cancel
          '///<li>Select bottom entry (should be #5) of 'Frame' listbox</li>///
        Kontext "TabInternet"
        frame.select(5)
        '///<li>Cancel dialog</li>///
        TabInternet.Cancel
        
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFileTemplatesOrganize
'///<u><b>File::Templates::Organize...</b></u>///
qaErrorLog "File::Templates::* testcases should be added!"
'TODO: File::Templates::* testcases should be added
    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument

    '///<li>File::Templates::Organize...</li>///
    FileTemplatesOrganize
    Kontext "DVVerwalten"
    '///<li>Check existence of template dialog</li>///
      Call DialogTest (DVVerwalten)
      '///<li>Move one up in right list</li>///
      ListeRechts.Typekeys("<UP>")
      '///<li>Click 'File...' button</li>///
      WelcheDatei.Click
      '///<li>Check existence of file open dialog</li>///
      Kontext "OeffnenDLG"
        Call Dialogtest (OeffnenDlg)
        '///<li>Cancel File open dialog</li>///
        OeffnenDLG.Cancel
        '///<li>Close template dialog</li>///
      Kontext "DVVerwalten"
        DVVerwalten.Close
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFilePagepreview
'///<u><b>File::Page Preview</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call hNewDocument
    sleep(2)
    '///<li>Add random content to obtain at least one page of output</li>///
    Call hTypeKeys ( "13<Return>" )
    '///<li>File::Page preview...</li>///
    try 
        FilePageView
    catch
        warnlog "#i44073# - Page preview crashes under certain circumstances"
        goto endsub
    endcatch
    Kontext "Previewbar"
    '///<li>Close page previes with button in toolbar</li>///
      Seitenansicht.Click
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>

endcase
'
'-----------------------------------------------------------
'
testcase tFilePrint
'///<u><b>File::Print ...</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>File::Print...</li>///
    FilePrint
    '///<li>Look for warning regarding missing printer configured first</li>///
    '///<li>-> If configuration is missing only this MsgBox is tested</li>///
    Kontext
      if Active.Exists(2) then
         if Active.GetRT = 304 then
            printlog Active.GetText
            QAErrorLog "No printer is configured for this system"
            Active.OK
         end if
      else
         Kontext "DruckenDLG"
         '///<li>Check existence of print dilaog</li>///
           call DialogTest ( DruckenDLG )
         '///<li>Invoke the print options dialog</li>///
         Kontext "DruckenDLG"
           Zusaetze.Click
           Kontext "TabPrintCalcOptions"
           '///<li>Check existence of print options dilaog</li>///
             call DialogTest ( TabPrintCalcOptions )
             '///<li>Cancel print options dialog</li>///
             TabPrintCalcOptions.Cancel
         '///<li>Check option 'Print to file'</li>///         
         Kontext "DruckenDLG"
           AusdruckInDatei.check
           '///<li>Commit print dilaog</li>///
           DruckenDLG.OK
           '///<li>(Save file dialog should be visible now)</li>///
           Kontext "SpeichernDLG"
           '///<li>Check existence of save dilaog</li>///
             call DialogTest ( SpeichernDLG )
             '///<li>Cancel save dialog</li>///
             SpeichernDLG.Cancel
      end if
      
    '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFilePrinterSettings
'///<u><b>File::Printer settings ...</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    Call  hNewDocument
    '///<li>File::Printer Settings...</li>///
    FilePrintersettings
    '///<li>Catch MsgBox in case no printer is configured on system (test exits)</li>///
    Kontext
      if Active.Exists(2) then
         if Active.GetRT = 304 then
            printlog Active.GetText
            Active.OK
         end if
      else
      '///<li>Else Check existence of printer settings dilaog (default behaviour)</li>///
         Kontext "DruckerEinrichten"
         Call DialogTest ( DruckerEinrichten )
         '///<li>Cancel printer settings</li>///
         DruckerEinrichten.Cancel
      end if
      '///<li>Close document</li>///
    Call hCloseDocument
    '///</ul>
endcase
'
'-----------------------------------------------------------
'
testcase tFileExit
'///<u><b>File::Exit</b></u>///

    '///<ul>
    '///<li>Open new document</li>///
    call hNewDocument
    sleep(2)

    Kontext "DocumentCalc"
    '///<li>Add random content</li>///
      DocumentCalc.typekeys ("Bye<RETURN>")
      '///<li>File::Exit</li>///
      FileExit
      '///<li>Close to files (discard MsgBoxes) on the way</li>///
      try
         Kontext "Active"
           if active.exists then
              printlog active.GetText
              active.no
              Kontext "Active"
                if active.exists then
                   printlog active.GetText
                   active.no
                end if
           else
              Warnlog "The modified document was closed without warning"
              FileClose
              Kontext "Active"
              if active.exists then active.no
           end if
      catch
      endcatch
      sleep(3)
      
    '///<li>Restart OOo</li>///
    call hStartTheOffice
    '///</ul>

endcase

