'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: basedoc.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:33 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner              :  peter.junge@sun.com
'*
'* short description  :  Basedoc for chartand calc tests
'*
'**************************************************************************************************
'*
' #1 basedocument
'*
'\************************************************************************************************


sub basedocument (App as String)

   dim range as string
   dim file as string

   select case App
      case "CALC" :  file = convertpath(gtesttoolpath & "calc/level1/input/basetable.sxc")
      case "CHART" : file = convertpath(gtesttoolpath & "chart/level1/input/basetable.sxc")
   end select

   range = "$Tabelle1.$A$1:$D$6"
   
   try
     printlog "** loading basedocument **"
     call hDateiOeffnen file
   catch
     warnlog "Opening basedoc failed"
     exit sub
   endcatch
   
   try
     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<Mod1 Home>"
     DocumentCalc.TypeKeys "<down>", 9
     'call cgotocell ("A10")
     InsertChartCalc
     Kontext "AutoFormatDiagrammBeginn"
     Bereich.Settext range
     Fertigstellen.Click
     Kontext "DocumentChart"
     DocumentChart.TypeKeys "<Escape>"
   catch
     warnlog "Insert Chart in basedoc failed"
     exit sub
   endcatch
   
   try
     FormatPositionAndSize
     Kontext
     Active.setpage TabPositionAndSize
     Kontext "TabPositionAndSize"
     KeepRatio.Check
     Width.More 50
     TabPositionAndSize.OK
   catch
     warnlog "Resizing chart in basedoc failed"
     exit sub
   endcatch

end sub
