'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility2.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: jsi $ $Date: 2006/01/18 14:39:45 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Resize object and Multi Selection
'*
'************************************************************************
'*
' #1 tResizeObject1
' #1 tResizeObject2
' #1 tResizeObject3
' #1 tResizeObject4
' #1 tResizeObject5
' #1 tResizeObject6
' #1 tResizeObject7
' #1 tMultiSelection1
' #1 tMultiSelection2
' #1 tMultiSelection3
' #1 tMultiSelection4
' #1 tSelectArrayFormula1
' #1 tSelectArrayFormula2
' #1 tSelectTables1
' #1 tSelectTables2
' #1 tSelectTables3
' #1 tSelectTables4
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_2

   printLog Chr(13) + "=== Keyboard_Accessibility 2 ==="

   printLog Chr(13) + "-- Resize Objects , including graphic,  chart and draw objects"
      Call tResizeObject1      'Check if Ctrl+TAB travels left to right and top to bottom through the handles
      Call tResizeObject2      'Check for every handle if the object can be resized pixel by pixel using ALT+arrow keys
      Call tResizeObject3      'Check if Shift+Ctrl+TAB travels right to left and bottom to bottom through the handles
      Call tResizeObject4      'Check if escape unselects the current handle
      Call tResizeObject5      'Check if a new selection of the object puts the focus on the previous handle
      Call tResizeObject6      'Check if Ctrl+TAB still work when the point is in 'edit point' mode
      Call tResizeObject7      'Check if we can set the corner radius with this handle using the arrow key

   printLog Chr(13) + "-- Check Multi selection of Cells using Keyboard"
      Call tMultiSelection1      'Check exchange mode from STD to EXT (F8)
      Call tMultiSelection2      'Check exchange mode from STD to ADD(Shift F8)
      Call tMultiSelection3      'Check change mode from EXT to ADD (Shift F8)
      Call tMultiSelection4      'Check change mode from ADD to EXT (F8)

   printLog Chr(13) + "-- Check Keyboard shortcut to select array formula"
      Call tSelectArrayFormula1  'Check when cell cursor is on a part of the array
      Call tSelectArrayFormula2  'Check when cell cursor isn't on the array

   printLog Chr(13) + "-- Check Select tables with keyboard"
      Call tSelectTables1       'Check SHIFT + CTRL + PAGEDOWN
      Call tSelectTables2       'Check SHIFT + CTRL + PAGEUP   after 'SHIFT + CTRL + PAGEDown'
      Call tSelectTables3       'Check SHIFT + CTRL + PAGEUP
      Call tSelectTables4       'Check SHIFT + CTRL + PAGEDOWN after 'SHIFT + CTRL + PAGEUp'

end sub

'***********************************************************************

testcase tResizeObject1

  printLog "Check if Ctrl+TAB travels left to right and top to bottom through the handles"
  printLog " and check  every handle can be resized by arrow keys"
  '/// Check if Ctrl+TAB travels left to right and top to bottom through the handles
  '/// + and check  every handle can be resized by arrow keys"
  '/// There are 8 handles in rectangle object. Set them from A to H
  '/// A   B   C
  '/// D       E
  '/// F   G   H
  '/// after the handle is set ,
  '/// - A : move to right, and down --> A(x) change ,   A(y) change    , Width change    , Height change
  '/// - B : move to right, and down --> A(x) no change ,A(y) change    , Width no change , Height change
  '/// - C : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change
  '/// - D : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height no change
  '/// - E : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height no change
  '/// - F : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height change
  '/// - G : move to right, and down --> A(x) no change ,A(y) no change , Width no change , Height change
  '/// - H : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "graphic.sxc"   , _
                   "draw.sxc"      , _
                   "chart.sxc"     , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1
     
     select case i
            case 0 : sObjectType = "graphics"
            case 1 : sObjectType = "drawing objects"
            case 2 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as A , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
      sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
      sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
      sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
      sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point A is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as B , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4"  + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2"  + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "7"  + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point B is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as C , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point C is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as D , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point D is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as E , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point E is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as F , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point F is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as G , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point G is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as H , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
        sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
        sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
        sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
        sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point H is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject2

  printLog "Check for every handle if the object can be resized pixel by pixel using ALT+arrow keys"
  '/// Check for every handle if the object can be resized pixel by pixel using ALT+arrow keys
  '/// There are 8 handles in rectangle object. Set them from A to H
  '/// A   B   C
  '/// D       E
  '/// F   G   H
  '/// after the handle is set ,
  '/// - A : move to right, and down --> A(x) change ,   A(y) change    , Width change    , Height change
  '/// - B : move to right, and down --> A(x) no change ,A(y) change    , Width no change , Height change
  '/// - C : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change
  '/// - D : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height no change
  '/// - E : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height no change
  '/// - F : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height change
  '/// - G : move to right, and down --> A(x) no change ,A(y) no change , Width no change , Height change
  '/// - H : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "graphic.sxc"   , _
                   "draw.sxc"      , _
                   "chart.sxc"     , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1

     select case i
            case 0 : sObjectType = "graphics"
            case 1 : sObjectType = "drawing objects"
            case 2 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as A , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
      sPositionX          = "4" + gSeperator + "04" + gMeasurementUnit
      sPositionY          = "2" + gSeperator + "04" + gMeasurementUnit
      sWidth              = "9" + gSeperator + "96" + gMeasurementUnit
      sHeight             = "7" + gSeperator + "96" + gMeasurementUnit
     printLog "-- Point A is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as B , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "04" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "96" + gMeasurementUnit
     printLog "-- Point B is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as C , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "04" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "04" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "96" + gMeasurementUnit
     printLog "-- Point C is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as D , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "04" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "96" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point D is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as E , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "04" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point E is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as F , and move Right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "04" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "96" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "04" + gMeasurementUnit
     printLog "-- Point F is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as G , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "04" + gMeasurementUnit
     printLog "-- Point G is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as H , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<MOD2 Right>" , 2
     DocumentCalc.TypeKeys "<MOD2 Down>"  , 2
        sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
        sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
        sWidth              = "10" + gSeperator + "04" + gMeasurementUnit
        sHeight             = "8" + gSeperator + "04" + gMeasurementUnit
     printLog "-- Point H is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject3

  printLog "Check if Shift+Ctrl+TAB travels right to left and bottom to up through the handles, "
  printLog " and check  every handle can be resized by arrow keys"
  '/// Check if Shift+Ctrl+TAB travels right to left and bottom to up through the handles
  '/// + and check  every handle can be resized by arrow keys
  '/// There are 8 handles in rectangle object. Set them from A to H
  '/// A   B   C
  '/// D       E
  '/// F   G   H
  '/// after the handle is set ,
  '/// - A : move to right, and down --> A(x) change ,   A(y) change    , Width change    , Height change
  '/// - B : move to right, and down --> A(x) no change ,A(y) change    , Width no change , Height change
  '/// - C : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change
  '/// - D : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height no change
  '/// - E : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height no change
  '/// - F : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height change
  '/// - G : move to right, and down --> A(x) no change ,A(y) no change , Width no change , Height change
  '/// - H : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "graphic.sxc"   , _
                   "draw.sxc"      , _
                   "chart.sxc"     , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1

     select case i
            case 0 : sObjectType = "graphics"
            case 1 : sObjectType = "drawing objects"
            case 2 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"

    '/// Press Shift+Ctrl+Tab to set handle as H , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
        sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
        sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
        sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
        sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point H is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as G , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point G is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as F , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point F is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as E , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point E is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as D , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point D is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as C , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point C is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as B , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point B is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Shift+Ctrl+Tab to set handle as A , and move right and down
     DocumentCalc.TypeKeys "<SHIFT MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
      sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
      sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
      sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
      sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point A is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject4

  printLog "Check if escape unselects the current handle"
  '/// Check if escape unselects the current handle

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "graphic.sxc"   , _
                   "draw.sxc"      , _
                   "chart.sxc"     , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1

     select case i
            case 0 : sObjectType = "graphics"
            case 1 : sObjectType = "drawing objects"
            case 2 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as A , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
      sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
      sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
      sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
      sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Check if Point A is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press ESCAPE to unselects the current handle
     DocumentCalc.TypeKeys "<ESCAPE>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Check if pressing ESC unselect the current handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject5

  printLog "Check if a new selection of the object puts the focus on the previous handle"
  '/// Check if a new selection of the object puts the focus on the previous handle

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "graphic.sxc"   , _
                   "draw.sxc"      , _
                   "chart.sxc"     , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1

     select case i
            case 0 : sObjectType = "graphics"
            case 1 : sObjectType = "drawing objects"
            case 2 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
    '/// Set B as handle
     DocumentCalc.TypeKeys "<MOD1 TAB>"  , 2
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX   = "4"  + gSeperator + "00" + gMeasurementUnit
       sPositionY   = "2"  + gSeperator + "20" + gMeasurementUnit
       sWidth       = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight      = "7"  + gSeperator + "80" + gMeasurementUnit
     printLog "-- Check if Point B is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

    '/// Set the focus out of object
     Call gMouseClick(80,80)
     Sleep 2

    '/// check if the focus is out of the object
     try
        Call fPositionAndSize("TabPositionAndSize")
        TabPositionAndSize.OK
        Kontext "DocumentCalc"
        Warnlog "Something wrong when focus is out of the object ..." + testFile(i)
     catch
     endcatch

    '/// Set the focus on the object again
     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Sleep 1
     Kontext "DocumentCalc"
    '/// Check if Point B is still as the handle
     DocumentCalc.TypeKeys "<Right>" , 2
     DocumentCalc.TypeKeys "<Down>"  , 2
       sPositionX   = "4"  + gSeperator + "00" + gMeasurementUnit
       sPositionY   = "2"  + gSeperator + "20" + gMeasurementUnit
       sWidth       = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight      = "7"  + gSeperator + "80" + gMeasurementUnit
     printLog "-- Check if B is still as the handle..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject6

  printLog "Check if Ctrl+TAB still work when the point is in 'edit point' mode"
  '/// Check if Ctrl+TAB still work when the point is in 'edit point' mode

  '/// There are 8 handles in rectangle object. Set them from A to H
  '/// A   B   C
  '/// D       E
  '/// F   G   H
  '/// after the handle is set ,
  '/// - A : move to right, and down --> A(x) change ,   A(y) change    , Width change    , Height change
  '/// - B : move to right, and down --> A(x) no change ,A(y) change    , Width no change , Height change
  '/// - C : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change
  '/// - D : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height no change
  '/// - E : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height no change
  '/// - F : move to right, and down --> A(x) change ,   A(y) no change , Width change    , Height change
  '/// - G : move to right, and down --> A(x) no change ,A(y) no change , Width no change , Height change
  '/// - H : move to right, and down --> A(x) no change ,A(y) no change , Width change    , Height change

  Dim sPositionX , sPositionY   as String
  Dim sWidth     , sHeight      as String
  Dim sObjectType               as STRING
  Dim testFile()                as String
  Dim i , j                     as Integer

  sPositionX  = "4" + gSeperator + "00" + gMeasurementUnit
  sPositionY  = "2" + gSeperator + "00" + gMeasurementUnit
  sWidth      = "10"+ gSeperator + "00" + gMeasurementUnit
  sHeight     = "8" + gSeperator + "00" + gMeasurementUnit

  testFile = Array( _
                   "draw.sxc"      , _
                    )

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1

     select case i
'            case 1 : sObjectType = "graphics"
            case 0 : sObjectType = "drawing objects"
'            case 3 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif
     
     Kontext "DocumentCalc"
     FormatGroupUngroup
     DocumentCalc.TypeKeys "<TAB>"
     
     Call fPositionAndSize("TabPositionAndSize")
       PositionX.Settext sPositionX
       PositionY.Settext sPositionY
       Width.Settext     sWidth
       Height.Settext    sHeight
     TabPositionAndSize.OK

     Kontext "DocumentCalc"
    '/// Enter the edit point mode with Format/EditPoints
     FormatEditPoints
     Sleep 1

     DocumentCalc.TypeKeys "<MOD1 TAB>" , 2

    '/// Press Ctrl+Tab to set handle as A , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
      sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
      sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
      sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
      sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point A is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as B , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point B is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as C , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "20" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "7" + gSeperator + "80" + gMeasurementUnit
     printLog "-- Point C is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as D , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point D is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as E , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "00" + gMeasurementUnit
     printLog "-- Point E is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as F , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "20" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "9" + gSeperator + "80" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point F is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as G , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
       sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
       sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
       sWidth              = "10" + gSeperator + "00" + gMeasurementUnit
       sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point G is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Sleep 1
     Kontext "DocumentCalc"
    '/// Press Ctrl+Tab to set handle as H , and move right and down
     DocumentCalc.TypeKeys "<MOD1 TAB>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
     DocumentCalc.TypeKeys "<Down>"
     Sleep 1
        sPositionX          = "4" + gSeperator + "00" + gMeasurementUnit
        sPositionY          = "2" + gSeperator + "00" + gMeasurementUnit
        sWidth              = "10" + gSeperator + "20" + gMeasurementUnit
        sHeight             = "8" + gSeperator + "20" + gMeasurementUnit
     printLog "-- Point H is handle ..." + testFile(i)
     Call fTestPosition( sPositionX , sPositionY , sWidth , sHeight )

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tResizeObject7

  printLog "Check if we can set the corner radius with this handle using the arrow key"
  '/// Check if we can set the corner radius with this handle using the arrow key

  Dim sRadius      as String
  Dim testFile()   as String
  Dim sObjectType  as STRING
  Dim i , j        as Integer

  sRadius = "0" + gSeperator + "20" + gMeasurementUnit

  testFile = Array( _
                   "draw.sxc"      , _
                    )


'                   "graphic.sxc"   , _
'                   "chart.sxc"     , _

  j = UBound(testFile)

  For i = 0 to j

    'Open test file
     Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile(i) )
     Sleep 1
     select case i
'            case 1 : sObjectType = "graphics"
            case 0 : sObjectType = "drawing objects"
'            case 3 : sObjectType = "ole objects"
     end select

     if NOT fNavigatorSelectObject ( sObjectType , 1 ) then 
         qaErrorLog "fNavigatorSelectObject() returned with warning -> Testcase will be quit"
     endif

     Kontext "DocumentCalc"
     FormatGroupUngroup
     DocumentCalc.TypeKeys "<TAB>"
    '/// Enter the edit point mode with Format/EditPoints
     FormatEditPoints
     Sleep 1

     DocumentCalc.TypeKeys "<MOD1 TAB>" , 2
     Sleep 1
    '/// Check if we can set the corner radius with this handle using the arrow key
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     DocumentCalc.TypeKeys "<Right>"
     Sleep 1
     Call fPositionAndSize("TabSchraegstellen")
       if Radius.GetText <> sRadius then Warnlog "Radius is wrong, should be " +sRadius+ " bug get " +Radius.GetText
     TabSchraegstellen.Cancel

     Call hCloseDocument
     Sleep 1

    next i

endcase

'-------------------------------------------------------------------------

testcase tMultiSelection1

  printLog "Check exchange mode from STD to EXT (F8)"
  '/// Check exchange mode from STD to EXT (F8)

   call  hNewDocument

   Kontext "DocumentCalc"

    printLog "Press F8 to EXT mode"
   '/// Press F8 to EXT mode
    DocumentCalc.TypeKeys "<F8>"
    Sleep 1

    printLog "Press Right and Down"
   '/// Press Right and Down
    DocumentCalc.TypeKeys "<Right><Down>"
    Sleep 1

    if wobinich <> "A1:B2" then warnlog "Do NOT work in EXT mode, get " & wobinich & "instead of A1:B2"

    Kontext "DocumentCalc"

    printLog "Press F8 to STD mode"
   '/// Press F8 to STD mode
    DocumentCalc.TypeKeys "<F8>"
    Sleep 1

    printLog "Press Right and Down"
   '/// Press Right and Down
    DocumentCalc.TypeKeys "<Right><Down>"
    Sleep 1

    if wobinich <> "C3" then warnlog "Do NOT work in STD mode, get " & wobinich & "instead of C3"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tMultiSelection2

  printLog "Check exchange mode from STD to ADD (Shift F8)"
  '/// Check exchange mode from STD to ADD (Shift F8)

  Dim  testFile  as  String
  testFile  = "multiSelection-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\multiSelection-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\multiSelection-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    Sleep 1

    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift F8 to ADD mode"
   '/// Press Shift F8 to ADD mode
    DocumentCalc.TypeKeys "<Shift F8>"
    Sleep 1

   '/// Do a multi selection (A1 and A2 and C2 and C3)
    printLog "Press Shift + Down"
   '/// Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1
    printLog "Press Right twice"
   '/// Press Right twice
    DocumentCalc.TypeKeys "<Right>" , 2
    Sleep 1
    printLog "Press Shift + Down"
   '/// Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1

   '/// Check one -- After multi selection should not do Edit/Copy
    try
      EditCopy
      Warnlog "Should NOT do Edit/Copy after Multi selection!"
    catch
    endcatch

   '/// Check two -- After multi seleciton, the selected cells can be deleted
   '/// Press delete key
    DocumentCalc.TypeKeys "<DELETE>"

    Kontext "InhalteLoeschen"
    Alles.Check
    InhalteLoeschen.OK
    Sleep 1

    Kontext "DocumentCalc"
    printLog "Press Shift F8 to STD mode"
   '/// Press Shift F8 to STD mode
    DocumentCalc.TypeKeys "<Shift F8>"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    Sleep 1

    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell A1 should be NULL"

    DocumentCalc.TypeKeys "<Down>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell A2 should be NULL"

    DocumentCalc.TypeKeys "<Right>"
    EditCopy
    if GetClipboardText <> "B2" then Warnlog "Cell B2 should be 'B2'"

    DocumentCalc.TypeKeys "<Right>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell C2 should be NULL"

    DocumentCalc.TypeKeys "<Down>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell C3 should be NULL"

    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + Down"
   '/// Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1
    printLog "Press Right twice"
   '/// Press Right twice
    DocumentCalc.TypeKeys "<Right>" , 2
    Sleep 1
    printLog "Press Shift + Down"
   '/// Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1

   '/// Check one -- In STD mode ,should do Edit/Copy
    try
      EditCopy
    catch
      Warnlog "In STD mode ,should do Edit/Copy !"
    endcatch

   '/// Check two -- check if the selection area is C2:C3
    if wobinich <> "C2:C3" then warnlog "Get " & wobinich & " instead of C3"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tMultiSelection3

  printLog "Check change mode from EXT to ADD (Shift F8)"
  '/// Check change mode from EXT to ADD (Shift F8)

  Dim  testFile  as  String
  testFile  = "multiSelection-test.sxc"

    printLog "Open test file calc\special\input\keyboardaccessibility\multiSelection-test.sxc"
   '/// Open test file calc\special\input\keyboardaccessibility\multiSelection-test.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
    Sleep 1

   Kontext "DocumentCalc"

    printLog "Press F8 to EXT mode"
   '/// Press F8 to EXT mode
    DocumentCalc.TypeKeys "<F8>"
    Sleep 1

    printLog "Press Shift + F8 to ADD mode"
   '/// Press Shift + F8 to ADD mode
    DocumentCalc.TypeKeys "<Shift F8>"
    Sleep 1

   '/// Do a multi selection (A1 and A2 and C2 and C3)
    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1
    printLog "Press Right twice"
   '/// --Press Right twice
    DocumentCalc.TypeKeys "<Right>" , 2
    Sleep 1
    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1

   '/// Check one -- After multi selection should not do Edit/Copy
    try
      EditCopy
      Warnlog "Should NOT do Edit/Copy after Multi selection!"
    catch
    endcatch

   '/// Check two -- After multi seleciton, the selected cells can be deleted
   '/// Press delete key
    DocumentCalc.TypeKeys "<DELETE>"

    Kontext "InhalteLoeschen"
    Alles.Check
    InhalteLoeschen.OK
    Sleep 1

    Kontext "DocumentCalc"
    printLog "Press Shift F8 to STD mode"
   '/// Press Shift F8 to STD mode
    DocumentCalc.TypeKeys "<Shift F8>"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    Sleep 1

    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell A1 should be NULL"

    DocumentCalc.TypeKeys "<Down>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell A2 should be NULL"

    DocumentCalc.TypeKeys "<Right>"
    EditCopy
    if GetClipboardText <> "B2" then Warnlog "Cell B2 should be 'B2'"

    DocumentCalc.TypeKeys "<Right>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell C2 should be NULL"

    DocumentCalc.TypeKeys "<Down>"
    EditCopy
    if Len(GetClipboardText) <> 0 then Warnlog "Cell C3 should be NULL"

    DocumentCalc.TypeKeys "<MOD1 HOME>"

    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1
    printLog "Press Right twice"
   '/// --Press Right twice
    DocumentCalc.TypeKeys "<Right>" , 2
    Sleep 1
    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1

   '/// Check one -- In STD mode ,should do Edit/Copy
    try
      EditCopy
    catch
      Warnlog "In STD mode ,should do Edit/Copy !"
    endcatch

   '/// Check two -- check if the selection area is C2:C3
    if wobinich <> "C2:C3" then warnlog "Get " & wobinich & " instead of C3"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tMultiSelection4

  printLog "Check change mode from ADD to EXT (F8)"
  '/// Check change mode from ADD to EXT (F8)

   call  hNewDocument

   Kontext "DocumentCalc"

    printLog "Press Shift +F8 to ADD mode"
   '/// Press Shift F8 to ADD mode
    DocumentCalc.TypeKeys "<Shift F8>"
    Sleep 1

    printLog "Press F8 to EXT mode"
   '/// Press F8 to ADD mode
    DocumentCalc.TypeKeys "<F8>"
    Sleep 1

    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1
    printLog "Press Right twice"
   '/// --Press Right twice
    DocumentCalc.TypeKeys "<Right>" , 2
    Sleep 1
    printLog "Press Shift + Down"
   '/// --Press Shift + Down
    DocumentCalc.TypeKeys "<Shift Down>"
    Sleep 1

   '/// Check if the select area is A1:C3
    if wobinich <> "A1:C3" then warnlog "Get " & wobinich & " instead of A1:C3"

   Call hCloseDocument

endcase

'------------------------------------------------------------------------

testcase tSelectArrayFormula1

  printLog "Check when cell cursor is on a part of the array formula"
  '/// Check when cell cursor is on a part of the array formula

  Dim  testFile  as  String
  testFile  = "Matrixformula_and_Notes.sxc"

  printLog "Open test file calc\special\input\keyboardaccessibility\Matrixformula_and_Notes.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\Matrixformula_and_Notes.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

    printLog "Set cursor to D8 which is a part of the array formula "
   '/// Set cursor to D8 which is a part of the array formula
    Call cgotoCell("D8")
    Sleep 1

    try
        EditCut
        Warnlog "Edit/Cut should be only available when whole matrix is selected ."
    catch
    endcatch

   '/// Press Ctrl+ "/"
    DocumentCalc.TypeKeys "<MOD1 DIVIDE>"
    Sleep 1

    try
        EditCut
    catch
        Warnlog "Edit/Copy should be available when whole matrix is selected ."
    endcatch

    if Len(cZellwert("D6"))  <> 0  then  Warnlog "D6 should be NULL , but get " + cZellwert("D7")
    if Len(cZellwert("D7"))  <> 0  then  Warnlog "D7 should be NULL , but get " + cZellwert("D7")
    if Len(cZellwert("D8"))  <> 0  then  Warnlog "D8 should be NULL , but get " + cZellwert("D8")
    if Len(cZellwert("D9"))  <> 0  then  Warnlog "D9 should be NULL , but get " + cZellwert("D9")
    if Len(cZellwert("D10")) <> 0  then  Warnlog "D10 should be NULL , but get " + cZellwert("D10")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSelectArrayFormula2

  printLog "Check when cell cursor isn't on the array formular"
  '/// Check when cell cursor isn't on the array formular

  Dim  testFile  as  String
  Dim  sB8       as  String

  testFile  = "Matrixformula_and_Notes.sxc"
  sB8       = "28"

  printLog "Open test file calc\special\input\keyboardaccessibility\Matrixformula_and_Notes.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\Matrixformula_and_Notes.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

    printLog "Set cursor to B8 which is out of the array formula "
   '/// Set cursor to B8 which is out of the array formula
    Call cgotoCell("B8")
    Sleep 1

    Kontext "DocumentCalc"
   '/// Press Ctrl + /
    DocumentCalc.TypeKeys "<MOD1 DIVIDE>"
    Sleep 1

    EditCopy
    Call cgotoCell("E6")
    Sleep 1

    EditPaste
    Sleep 1

   '/// Ctrl + / should do nothing
    if cZellwert("E6")       <> sB8  then  Warnlog "D6 should be NULL , but get " + cZellwert("D7")
    if Len(cZellwert("E7"))  <> 0    then  Warnlog "D7 should be NULL , but get " + cZellwert("D7")
    if Len(cZellwert("E8"))  <> 0    then  Warnlog "D8 should be NULL , but get " + cZellwert("D8")
    if Len(cZellwert("E9"))  <> 0    then  Warnlog "D9 should be NULL , but get " + cZellwert("D9")
    if Len(cZellwert("E10")) <> 0    then  Warnlog "D10 should be NULL , but get " + cZellwert("D10")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSelectTables1

  printLog "Check SHIFT + CTRL + PAGEDown "
  '/// Check SHIFT + CTRL + PAGEDown

  Dim  testFile                          as  String
  Dim  sA1Sheet1 , sA1Sheet2 , sA1Sheet3 as  String

  testFile  = "SelectTables.sxc"
  sA1Sheet1 = "1"
  sA1Sheet2 = "2"
  sA1Sheet3 = "3"

  printLog "Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

   '/// Press SHIFT + CTRL + PAGEDown
    DocumentCalc.TypeKeys "<Shift MOD1 PageDown>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEDown again
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEDown>"
    Sleep 1

    EditCopy
    Sleep 1

    Call cgotoCell("B1")
    Sleep 1

    EditPaste
    Sleep 1

    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    DocumentCalc.TypeKeys "<MOD1 PAGEDown>"

   '/// Check if sheet1:B1 is 1 , sheet2:B1 is 2 and sheet3:B1 is 3
    if cZellwert("B1")  <> sA1Sheet3  then  Warnlog "sheet3:B1 should be " + sA1Sheet3   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageUp>"
    if cZellwert("B1")  <> sA1Sheet2  then  Warnlog "sheet2:B1 should be " + sA1Sheet2   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageUp>"
    if cZellwert("B1")  <> sA1Sheet1  then  Warnlog "sheet1:B1 should be " + sA1Sheet1   + " but get " + cZellwert("B1")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSelectTables2

  printLog "Check SHIFT + CTRL + PAGEUP   after 'SHIFT + CTRL + PAGEDown'"
  '/// Check SHIFT + CTRL + PAGEUP   after 'SHIFT + CTRL + PAGEDown'

  Dim  testFile  as  String
  Dim  sA1Sheet2 as  String

  testFile  = "SelectTables.sxc"
  sA1Sheet2 = "2"

  printLog "Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

   '/// Press SHIFT + CTRL + PAGEDown
    DocumentCalc.TypeKeys "<Shift MOD1 PageDown>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEDown again
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEDown>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEUp
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    Sleep 1

    EditCopy
    Sleep 1

    Call cgotoCell("B1")
    Sleep 1

    EditPaste
    Sleep 1

   '/// Check if sheet1:B1 is null , sheet2:B1 is 2 and sheet3:B1 is null
    if cZellwert("B1")  <> sA1Sheet2  then  Warnlog "sheet2:B1 should be " + sA1Sheet2   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageUp>"
    if Len(cZellwert("B1"))  <> 0     then  Warnlog "sheet1:B1 should be null, but get " + cZellwert("B1")
    DocumentCalc.TypeKeys "<MOD1 PageDown>" , 2
    if Len(cZellwert("B1"))  <> 0     then  Warnlog "sheet3:B1 should be null, but get " + cZellwert("B1")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSelectTables3

  printLog "Check SHIFT + CTRL + PAGEUp"
  '/// Check SHIFT + CTRL + PAGEUp

  Dim  testFile                          as  String
  Dim  sA1Sheet1 , sA1Sheet2 , sA1Sheet3 as  String

  testFile  = "SelectTables.sxc"
  sA1Sheet1 = "1"
  sA1Sheet2 = "2"
  sA1Sheet3 = "3"

  printLog "Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

    DocumentCalc.TypeKeys "<MOD1 PageDown>" , 2
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEUp
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEUp again
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    Sleep 1

    EditCopy
    Sleep 1

    Call cgotoCell("B1")
    Sleep 1

    EditPaste
    Sleep 1

    DocumentCalc.TypeKeys "<Shift MOD1 PAGEDown>"
    DocumentCalc.TypeKeys "<MOD1 PAGEUp>"

   '/// Check if sheet1:B1 is 1 , sheet2:B1 is 2 and sheet3:B1 is 3
    if cZellwert("B1")  <> sA1Sheet1  then  Warnlog "sheet1:B1 should be " + sA1Sheet1   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageDown>"
    if cZellwert("B1")  <> sA1Sheet2  then  Warnlog "sheet2:B1 should be " + sA1Sheet2   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageDown>"
    if cZellwert("B1")  <> sA1Sheet3  then  Warnlog "sheet3:B1 should be " + sA1Sheet3   + " but get " + cZellwert("B1")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tSelectTables4

  printLog "Check SHIFT + CTRL + PAGEUP   after 'SHIFT + CTRL + PAGEUp'"
  '/// Check SHIFT + CTRL + PAGEUP   after 'SHIFT + CTRL + PAGEUp'

  Dim  testFile  as  String
  Dim  sA1Sheet2 as  String

  testFile  = "SelectTables.sxc"
  sA1Sheet2 = "2"

  printLog "Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc"
  '/// Open test file calc\special\input\keyboardaccessibility\SelectTables.sxc
   Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )
   Sleep 1

   Kontext "DocumentCalc"

    DocumentCalc.TypeKeys "<MOD1 PageDown>" , 2
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEDown
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEDown again
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEUp>"
    Sleep 1

   '/// Press SHIFT + CTRL + PAGEUp
    DocumentCalc.TypeKeys "<Shift MOD1 PAGEDown>"
    Sleep 1

    EditCopy
    Sleep 1

    Call cgotoCell("B1")
    Sleep 1

    EditPaste
    Sleep 1

   '/// Check if sheet1:B1 is null , sheet2:B1 is 2 and sheet3:B1 is null
    if cZellwert("B1")  <> sA1Sheet2  then  Warnlog "sheet2:B1 should be " + sA1Sheet2   + " but get " + cZellwert("B1")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 PageUp>"
    if Len(cZellwert("B1"))  <> 0     then  Warnlog "sheet1:B1 should be null, but get " + cZellwert("B1")
    DocumentCalc.TypeKeys "<MOD1 PageDown>" , 2
    if Len(cZellwert("B1"))  <> 0     then  Warnlog "sheet3:B1 should be null, but get " + cZellwert("B1")

   Call hCloseDocument

endcase

