'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: un_redo.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:24 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description	:	Complete Test for the undo/redo function 
'*
'*********************************************************************************
'*
' #1 un_redo      ' Innitial subroutine
' #1 tFormat_Cell ' Apply all cell attributes - Undo/Redo - Check correct settings
'*
'\*********************************************************************************

sub un_redo

Printlog Chr(13) + "--------- FormatCell ---------"

        call tFormat_Cell

end sub

'**************************************************************************************************

testcase tFormat_Cell
'/// This test check completely the un/redo-functionality from the cell attributes

	dim stat as boolean
	dim str_editfield as string
	dim lng_id as integer
	stat = true
'/// First call a new calc document and insert '100' in cell 'A1'
	call hNewDocument

	Kontext "DocumentCalc"
	DocumentCalc.TypeKeys "<Mod1 Home> 100 <Return><up>"
	printlog "*** Format Cell"
	printlog ""
	printlog "* TabPage Numbers"
'/// call the menuitem 'FormatCells', goto tabpage 'NumberFormat' and set the category to '5'
	FormatCells
	Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
	Kategorie.select 5
	Kontext
	Zahlenformat.OK

'/// Check if the numberformat has been taken over
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Kategorie.GetSelIndex <> 5 then
   	stat = false
        	warnlog "Numberformat wasn't set into Currency"
	else
   	printlog "OK, the numberformat was set into Currency"
	end if
   Kontext
   Zahlenformat.Cancel

'/// Check if the undo-function work
	EditUndo
	FormatCells
	Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Kategorie.GetSelIndex <> 3 then
   	warnlog "Numberformat wasn't reset into number"
      stat = false
	else
   	printlog "OK, the numberformat was reset into number"
	end if
   Kontext
   Zahlenformat.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Kategorie.GetSelIndex <> 5 then
   	stat = false
      warnlog "Numberformat wasn't redo into Current"
	else
   	printlog "OK, redo works"
	end if
   Kontext
   Zahlenformat.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// call the menuitem 'FormatCells', goto tabpage 'NumberFormat' and set the language to '33'
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   lng_id = Sprache.GetSelIndex
   Sprache.select 33
   Kontext
   Zahlenformat.OK

'/// Check if the language has been taken over
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Sprache.GetSelIndex <> 33 then
   	warnlog "Language wasn't set to number 33"
   	stat = false
   else
   	printlog "OK, the language was set to nr 33"
   end if
   Kontext
   Zahlenformat.Cancel
'/// Check if the undo-function works

   EditUndo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Sprache.GetSelIndex <> lng_id then
   	warnlog "Language wasn't reset system"
   	stat = false
   else
   	printlog "OK, the language was reset to system"
   end if
   Kontext
   Zahlenformat.Cancel
'/// Check if the redo-function works

   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Sprache.GetSelIndex <> 33 then
   	warnlog "Language wasn't redo to number 33"
   	stat = false
   else
   	printlog "OK, redo works"
   end if
   Kontext
   Zahlenformat.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'NumberFormat' and set the formatcode
'/// to any name you like
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   str_editfield = FormatCode.GetText
   FormatCode.SetText str_editfield & chr(34) & "Holzdollar" & chr(34)
   Zahlenformat.OK
   ' check if the format has been taken over
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if FormatCode.GetText <> str_editfield & chr(34) & "Holzdollar" & chr(34) then
   	warnlog "FormatCode hasn't been taken over"
   	stat = false
   else
   	printlog "OK, the formatcode has been taken over"
   end if
   Zahlenformat.Cancel

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if FormatCode.GetText <> str_editfield then
   	warnlog "FormatCode hasn't been reset to current"
   	stat = false
   else
   	printlog "OK, the formatcode has been reset to current"
   end if
   Zahlenformat.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if FormatCode.GetText <> str_editfield & chr(34) & "Holzdollar" & chr(34) then
   	warnlog "FormatCode hasn't been redone"
   	stst = false
   else
   	printlog "OK, redo works"
   end if
   Zahlenformat.Cancel
	EditUndo
	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'NumberFormat' and set decimal places to '3'
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   Nachkommastellen.more 3
   if right(FormatCode.GetText, 3) <> "000" then
   	warnlog "The numberformat hasn't been modified"
   	stat = false
   else
   	printlog "OK, the numberformat has latest three zeros"
   end if
   Kontext
   Zahlenformat.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if  right(FormatCode.GetText, 3) = "000" then
   	warnlog "the numberformat hasn't been reset to current"
   	stat = false
   else
   	printlog "OK, the numberformat has been reset to current"
   end if
   Zahlenformat.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if  right(FormatCode.GetText, 3) <> "000" then
   	warnlog "the numberformat hasn't been redone"
   	stat = false
   else
   	printlog "OK, redo works"
   end if
   Zahlenformat.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Numbers' and set leading zeros to '3'
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   FuehrendeNullen.More 3
   if left(FormatCode.GetText, 4) <> "0000" then
   	warnlog "the leading zeros hasn't been taken over"
   	stat = false
   else
   	printlog "OK, leading zeros has been taken over "
   end if
   Zahlenformat.OK

'/// Check if the undo-function work
   EditUndo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
	if left(FormatCode.GetText, 4) = "0000" then
   	warnlog "leading zeros hasn't been reset to current"
   	stat = false
   else
   	printlog "OK, leading zeros has been reset to current "
   end if
   Zahlenformat.Cancel

'/// check if the redo-function work
   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if left(FormatCode.GetText, 4) <> "0000" then
   	warnlog "leading zeros hasn't been reset to current"
   	stat = false
   else
   	printlog "OK, redo works"
   end if
   Zahlenformat.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Numbers' and check negative numbers in red
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   NegativInRot.Check
   dim i as integer
   For i = 1 to len(FormatCode.GetText)
   	str_editfield = mid(FormatCode.GetText, i, 1)
   	if str_editfield = "[" then
   		printlog "OK, the function neg-in-red works"
   		goto out
   	else
   		if i = len(FormatCode.GetText)  then
   			warnlog "The function neg-in-red doesn't work"
   		end if
   	end if
   Next i
out:
	Kontext
	Zahlenformat.OK

'/// Check if the undo-function work
	EditUndo
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if NegativInRot.IsChecked then
   	warnlog "The undo-function doesn't work"
   else
   	printlog "OK, the undo-function works"
   end if
	Kontext
	Zahlenformat.Cancel

'/// Check if the redo-function work
   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if NegativInRot.IsChecked then
   	printlog "OK, redo works"
   else
   	warnlog "The redo-function doesn't work"
   end if
   Kontext
   Zahlenformat.Cancel
   EditUndo

   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Numbers' and check thousands separator
	FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   Tausenderpunkt.Check
   if left(FormatCode.GetText, 1) <> "#" then
   	warnlog "The thousand separator doesn't work"
   else
   	printlog "OK, the thousand separator works"
   end if
   Kontext
   Zahlenformat.OK

'/// Check if the undo-function work
	EditUndo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if Tausenderpunkt.IsChecked then
   	warnlog "The undo-function doesn't work"
   else
   	printlog "OK, the undo-function work"
   end if
   Kontext
   Zahlenformat.Cancel

'/// Check if the redo-function work
   EditRedo
   FormatCells
   Kontext
   active.setpage Zahlenformat
   Kontext "Zahlenformat"
   if NOT Tausenderpunkt.IsChecked then
   	warnlog "The redo-function doesn't work"
   else
   	printlog "OK, redo works"
   end if
   Kontext
   Zahlenformat.Cancel
   sleep 3
   EditUndo
'/// Close the document and open a new one

   call hCloseDocument
'====================================================================================================
   call hNewDocument

	Printlog ""
	Printlog "* TabPage Font"
'/// Call the menuitem 'FormatCells', goto tabpage 'Font' and select the font nr '5'
	dim font_id as integer
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
           font_id = FontWest.GetSelIndex
           FontWest.Select 5
	catch
           font_id = Font.GetSelIndex
           Font.Select 5
	endcatch
	Kontext
	TabFont.OK

'/// Check if the modifying has been taken over
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if FontWest.GetSelIndex = 5 then
	      printlog "OK, the font has been changed"
	   else
	    	warnlog "The font hasn't been changed"
	   end if
	catch
           if Font.GetSelIndex = 5 then
	      printlog "OK, the font has been changed"
	   else
	      warnlog "The font hasn't been changed"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the undo-function work
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if FontWest.GetSelIndex = font_id then
	      printlog "OK, the font has been reset to current"
	   else
	      warnlog "The font hasn't been reset to current"
	   end if
	catch
	   if Font.GetSelIndex = font_id then
	      printlog "OK, the font has been reset to current"
	   else
	      warnlog "The font hasn't been reset to current"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the redo-function work
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if FontWest.GetSelIndex = 5 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	catch
	   if Font.GetSelIndex = 5 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	endcatch
	Kontext
	TabFont.Cancel
	EditUndo
	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Font' and select the fontstyle nr '3'
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	dim style_id as integer
	try
	    style_id = StyleWest.GetSelIndex
	    StyleWest.select 3
	catch
	    style_id = Style.GetSelIndex
	    Style.select 3
	endcatch
	Kontext
	TabFont.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if StyleWest.GetSelIndex = 3 then
	      printlog "OK, the style has been changed"
	   else
	      warnlog "The style hasn't been changed"
	   end if
	catch
	   if Style.GetSelIndex = 3 then
	      printlog "OK, the style has been changed"
	   else
	      warnlog "The style hasn't been changed"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if StyleWest.GetSelIndex = style_id then
	      printlog "OK, the style has been reset to current"
	   else
	      warnlog "The style hasn't been reset to current"
	   end if
	catch
	   if Style.GetSelIndex = style_id then
	      printlog "OK, the style has been reset to current"
	   else
	      warnlog "The style hasn't been reset to current"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if StyleWest.GetSelIndex = 3 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	catch
	   if Style.GetSelIndex = 3 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	endcatch
	Kontext
	TabFont.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Font' and select the fontsize nr '10'
   FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	dim size_id as integer
	try
	   size_id = SizeWest.GetSelIndex
	   SizeWest.select 25
	catch
	   size_id = Size.GetSelIndex
	   Size.select 25
	endcatch
	Kontext
	TabFont.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if SizeWest.GetSelIndex = 25 then
	      printlog "OK, the size has been changed"
	   else
	      warnlog "The size hasn't been changed"
	   end if
	catch
	   if Size.GetSelIndex = 25 then
	      printlog "OK, the size has been changed"
	   else
	      warnlog "The size hasn't been changed"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if SizeWest.GetSelIndex = size_id then
	      printlog "OK, the size has been reset to current"
	   else
	      warnlog "The size hasn't been reset to current"
	   end if
	catch
	   if Size.GetSelIndex = size_id then
	      printlog "OK, the size has been reset to current"
	   else
	      warnlog "The size hasn't been reset to current"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if SizeWest.GetSelIndex = 25 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	catch
	   if Size.GetSelIndex = 25 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	endcatch
	Kontext
	TabFont.Cancel
	EditUndo
	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Font' and select the language nr 10
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	dim language_id as integer
	try
	   language_id = LanguageWest.GetSelIndex
	   LanguageWest.select 10
	catch
	   language_id = Language.GetSelIndex
	   Language.select 10
	endcatch

	Kontext
	TabFont.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if LanguageWest.GetSelIndex = 10 then
	      printlog "OK, the language has been changed"
	   else
	      warnlog "The language hasn't been changed"
	   end if
	catch
	   if Language.GetSelIndex = 10 then
	      printlog "OK, the language has been changed"
	   else
	      warnlog "The language hasn't been changed"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if LanguageWest.GetSelIndex = language_id then
	      printlog "OK, the language has been reset to current"
	   else
	      warnlog "The language hasn't been reset to current"
	   end if
	catch
	   if Language.GetSelIndex = language_id then
	      printlog "OK, the language has been reset to current"
	   else
	      warnlog "The language hasn't been reset to current"
	   end if
	endcatch
	Kontext
	TabFont.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFont
	Kontext "TabFont"
	try
	   if LanguageWest.GetSelIndex = 10 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	catch
	   if Language.GetSelIndex = 10 then
	      printlog "OK, redo works"
	   else
	      warnlog "The redo-function doesn't work"
	   end if
	endcatch
	Kontext
	TabFont.Cancel
	EditUndo
'/// Close this document and open a new one to check the next properties
	call hCloseDocument
	'____________________________________________________________________________________________

	call hNewDocument
'/// Call the menuitem 'FormatCells#, goto tabpage 'FontEffects' and select fontcolor nr '10'
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	dim color_id as integer
	color_id = FontColor.GetSelIndex
	FontColor.select 10
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if FontColor.GetSelIndex = 10 then
		printlog "OK, the fontcolor has been changed"
	else
		warnlog "The fontcolor hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if FontColor.GetSelIndex = color_id then
		printlog "OK, the fontcolor has been reset to current"
	else
		warnlog "The fontcolor hasn't been reset to current"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if FontColor.GetSelIndex = 10 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo
'/// Close the document and open a new one to check the next properties
	call hCloseDocument
	'____________________________________________________________________________________________

	call hNewDocument
'/// Call the menuitem 'FormatCells', goto tabpage 'FontEffects' and check outline
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	Outline.Check
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Outline.IsChecked then
		printlog "OK, the outline has been changed"
	else
		warnlog "The outline hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if NOT Outline.IsChecked then
		printlog "OK, the outline has been reset to current"
	else
		warnlog "The outline hasn't been changed to current"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Outline.IsChecked then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo
	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'FontEffects' and check shadow
   FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	Shadow.Check
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Shadow.IsChecked then
		printlog "OK, the shadow has been changed"
	else
		warnlog "The shadow hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if NOT Shadow.IsChecked then
		printlog "OK, the shadow has been reset to current"
	else
		warnlog "The shadow hasn't been changed to current"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Shadow.IsChecked then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'FontEffects' and select underline nr '2'
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	Underline.Select 2
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Underline.GetSelIndex = 2 then
		printlog "OK, the underline has been changed"
	else
		warnlog "The underline hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Underline.GetSelIndex = 1 then
		printlog "OK, the underline has been reset to current"
	else
		warnlog "The underline hasn't been changed to current"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Underline.GetSelIndex = 2 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'FontEffects' and select strikethrough nr '2'
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	StrikeThrough.Select 2
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex = 2 then
		printlog "OK, the strikethrough has been changed"
	else
		warnlog "The strikethrough hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex = 1 then
		printlog "OK, the strikethrough has been reset to current"
	else
		warnlog "The strikethrough hasn't been changed to current"
	end if
	Kontext
	TabFontEffects.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if StrikeThrough.GetSelIndex = 2 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabapge 'FontEffects' and select relif nr '2'
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	dim relief_id as integer
	relief_id = Relief.GetSelIndex
	Relief.select 2
	Kontext
	TabFontEffects.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Relief.GetSelIndex = 2 then
		printlog "OK, the relief has been changed"
	else
		warnlog "The relief hasn't been changed"
	end if
	Kontext
	TabFontEffects.Cancel

'// Check if the undo-function works
	try
		EditUndo
		FormatCells
		Kontext
		active.setpage TabFontEffects
		Kontext "TabFontEffects"
		if Relief.GetSelIndex = relief_id then
			printlog "OK, the relief has been reset to current"
		else
			warnlog "The relief hasn't been reset to current"
		end if
		Kontext
		TabFontEffects.Cancel
	catch
		warnlog "Undo doesn't work, because the setting hasn't been taken over"
	endcatch

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabFontEffects
	Kontext "TabFontEffects"
	if Relief.GetSelIndex = 2 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabFontEffects.Cancel
	EditUndo
'/// Close this document, open a new one and check the next properties
	call hCloseDocument

'====================================================================================================
	call hNewDocument

	Printlog ""
	Printlog "* TabPage Alignment"
'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select alignment nr '2'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeHAusrichtung.select 2
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 2 then
		printlog "OK, the alignmentLeft has been changed"
	else
		warnlog "The alignmentLeft hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex <> 2 then
		printlog "OK, the alignmentLeft has been reset to current"
	else
		warnlog "The alignmentLeft hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 2 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

	dim indent_current as string
'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select nr '2'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeHAusrichtung.select 2
	indent_current = Einzug.GetText
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 2 then
		printlog "OK, the alignmentLeft has been changed"
	else
		warnlog "The alignmentLeft hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Modify the indent
   dim indent_txt as string
   FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	Einzug.More 4
	indent_txt = Einzug.GetText
	Kontext
	TabAusrichtung.OK

'/// Check if these modifying has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if Einzug.GetText = indent_txt then
		printlog "OK, the indent has been changed"
	else
		warnlog "The indent hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if Einzug.GetText = indent_current then
		printlog "OK, the indent has been reset to current"
	else
		warnlog "The indent hasn't been reset to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if Einzug.GetText = indent_txt then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo
        EditUndo
	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select nr '4'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeHAusrichtung.select 4
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 4 then
		printlog "OK, the alignmentRight has been changed"
	else
		warnlog "The alignmentRight hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex <> 4 then
		printlog "OK, the alignmentRight has been reset to current"
	else
		warnlog "The alignmentRight hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 4 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select nr '3'
   FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeHAusrichtung.select 3
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 3 then
		printlog "OK, the alignmentCenter has been changed"
	else
		warnlog "The alignmentCenter hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex <> 3 then
		printlog "OK, the alignmentCenter has been reset to current"
	else
		warnlog "The alignmentCenter hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 3 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select alignment nr '5'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeHAusrichtung.select 5
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 5 then
		printlog "OK, the alignmentJustify has been changed"
	else
		warnlog "The alignmentJustify hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex <> 5  then
		printlog "OK, the alignmentJustify has been reset to current"
	else
		warnlog "The alignmentJustify hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeHAusrichtung.getSelIndex = 5  then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select alignment nr '2'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeVAusrichtung.select 2
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 2 then
		printlog "OK, the verticalTop has been changed"
	else
		warnlog "The verticalTop hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex <> 2 then
		printlog "OK, the verticalTop has been reset to current"
	else
		warnlog "The verticalTop hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 2 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select alignment nr '4'
   FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeVAusrichtung.select 4
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 4 then
		printlog "OK, the verticalBottom has been changed"
	else
		warnlog "The verticalBottom hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex <> 4 then
		printlog "OK, the verticalBottom has been reset to current"
	else
		warnlog "The verticalBottom hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 4  then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and select alignment nr '3'
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	ListeVAusrichtung.select 3
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 3 then
		printlog "OK, the verticalMiddle has been changed"
	else
		warnlog "The verticalMiddle hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex <> 3 then
		printlog "OK, the verticalMiddle has been reset to current"
	else
		warnlog "The verticalMiddle hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if ListeVAusrichtung.getSelIndex = 3 then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	'____________________________________________________________________________________________

	dim grad_str, grad_current as string
'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and increase degree by 10 times
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   grad_current = Grad.GetText
   Kontext "TabAusrichtung"
   Grad.more 10
   grad_str = Grad.GetText
   if Grad.GetText= grad_str then
   	printlog "OK, the direction has been modified"
   else
   	warnlog "The direction hasn't been modified"
   end if
   Kontext
   TabAusrichtung.OK

'/// Check if the undo-function works
   EditUndo
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   if Grad.GetText =  grad_current then
   	printlog "OK, the direction has been reset to current"
   else
   	warnlog "The direction hasn't been reset to current"
   end if
   Kontext
   TabAusrichtung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   if Grad.GetText = grad_str then
   	printlog "OK, redo works"
   else
   	warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabAusrichtung.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and click on text direction
	FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   Gestapelt.Click
   Kontext
   TabAusrichtung.OK

'/// Check, if the spinfield degree is enabled (it must not be)
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   if NOT Grad.IsEnabled then
   	printlog "OK, the button 'ABCD' is pushed down"
   else
   	warnlog "The button 'ABCD'isn't pushed down"
   end if
   Kontext
   TabAusrichtung.Cancel

'/// Check if the undo-function works (now the spinfield must be enabled)
   EditUndo
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   if Grad.IsEnabled then
   	printlog "OK, the button 'ABCD' has been reset to current"
   else
   	warnlog "The button 'ABCD' hasn't been reset to current"
   end if
   Kontext
   TabAusrichtung.Cancel

'/// Check if the redo-function works
   EditRedo
   FormatCells
   Kontext
   active.setpage TabAusrichtung
   Kontext "TabAusrichtung"
   if NOT Grad.IsEnabled then
   	printlog "OK, redo works"
   else
   	warnlog "The redo-function doesn't work"
   end if
   Kontext
   TabAusrichtung.Cancel
   EditUndo
   '____________________________________________________________________________________________

'/// Call the menuitem 'FormatCells', goto tabpage 'Alignment' and check line break
   FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	Zeilenumbruch.Check
	Kontext
	TabAusrichtung.OK

'/// Check if the modify has been taken over
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if Zeilenumbruch.IsChecked then
		printlog "OK, the lineBreak has been changed"
	else
		warnlog "The lineBreak hasn't been changed"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the undo-function works
	EditUndo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if NOT Zeilenumbruch.IsChecked then
		printlog "OK, the lineBreak has been reset to current"
	else
		warnlog "The lineBreak hasn't been changed to current"
	end if
	Kontext
	TabAusrichtung.Cancel

'/// Check if the redo-function works
	EditRedo
	FormatCells
	Kontext
	active.setpage TabAusrichtung
	Kontext "TabAusrichtung"
	if Zeilenumbruch.IsChecked then
		printlog "OK, redo works"
	else
		warnlog "The redo-function doesn't work"
	end if
	Kontext
	TabAusrichtung.Cancel
	EditUndo

	call hCloseDocument
endcase

