'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: addin.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:22 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Detailed test part for new AddInn functions
'*
'************************************************************************
'*
' #1 addin          ' initial routine
' #0 checkvalues    ' routine to check correct cell content
' #1 tAddin_new     ' check correct results in AddInn functions
' #1 tConvert       ' check results that the convert_add function delivers
'*
'\***********************************************************************


sub addin

Printlog Chr(13) + "--------- addin_test ---------"

        call tAddin_new
        call tConvert

End Sub

'****************************************************************************************************************

testcase tAddin_new
'/// This testcase load a document with all new calc addins and check if the results of the functions
'/// are correct. First the document i sloaded, than a hard recalc is executed. Then the document is
'/// saved as excel '97/2000 document and reloaded. Then the result are checked again.

    dim addin_new as String, addin_excel as String, addin_sxc as String

    addin_new = convertpath(gTesttoolpath & "calc\special\input\addin_new.sxc")
    addin_sxc =  convertpath(gOfficePath & "user\work\addin_sxc.sxc")
    addin_excel =  convertpath(gOfficePath & "user\work\addin_excel.xls")
    
    Call hDateioeffnen addin_new
    call checkvalues("E3", 1, 3, 92)
    printlog "Save Document as excel file, close it, reload it and check results again"
    call hSpeichernUnterMitFilterKill (addin_excel, "Microsoft Excel 97/2000/XP (.xls)")
    call hCloseDocument
    
    call hDateioeffnen addin_excel
    call checkvalues("E3", 1, 3, 92)
    printlog "Save Document again as sxc file, close it, reload it and check results again"
    try
       if NOT hSpeichernUnterMitFilterKill (addin_sxc, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           exit sub
       endif
    catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText addin_sxc
       DateiTyp.Select 1
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
    endcatch
    call hCloseDocument
    
    call hDateioeffnen addin_sxc
    call checkvalues("E3", 1, 3, 92)
    call hCloseDocument

endcase

testcase tConvert
'/// This test load the a document with all of the measurementunits which could be converted
'/// into other units of the same category. The convertation is circular executed which means
'/// that at least the last convert unit convert it's value to the first unit which with the
'/// value line is started. Therefore this value must be the same as the first value.

     dim convertfile as String

     convertfile = convertpath(gTesttoolPath & "calc\special\input\convert.sxc")

     Call hDateiOeffnen convertfile
     call checkvalues("Y2", 2, 2, 24)

     Call hCloseDocument

endcase

sub checkvalues (caddress as String, stepwidth as integer, begin as integer, finish as integer )

     dim i as integer
     dim cell as String
     Kontext
       Printlog "Execute hard Recalc..."
       Kontext "DocumentCalc"
         DocumentCalc.typekeys "<MOD1 SHIFT F9>"
         Printlog "... and look, if all values are zero"
         Kontext
           cgotocell (caddress)
           For i = begin to finish step stepwidth
               cell = left(caddress, 1)  & i
               call checkcellwert(cell, 0)
           next i
end sub
