'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_105b.inc,v $
'*
'*  $Revision: 1.9 $
'*
'*  last change: $Author: pj $ $Date: 2005/11/24 11:57:27 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Detailed test of the functions in the Format menu - Part 2
'*
'************************************************************************
'*
' #1 C_105b     ' Initial routine
' #1 tFormatLine
' #1 tFormatText
' #1 tFormatArea
' #1 tFormatPositionAndSize_1
' #1 tFormatPositionAndSize_2
' #1 tFormatGroup
' #1 tFormatPositionAndSize_3
' #1 tFormatAnchor
' #1 tFormatStandard
'*
'\***********************************************************************

sub C_105b

   Printlog Chr(13) + "---  Formatmenu for DrawingObjects  ---"

   call tFormatLine
   call tFormatText
   call tFormatArea
   call tFormatPositionAndSize_1
   call tFormatPositionAndSize_2
   call tFormatGroup
   Printlog Chr(13) + "---  Formatmenu for Controls  ---"
   qaErrorLog "tFormatPositionAndSize_3 and tFormatAnchor are skipped due to redesign"
 '  call tFormatPositionAndSize_3
 '  call tFormatAnchor

   Printlog Chr(13) + "---  ContextFormatmenu for cellcontents  ---"
   call tFormatStandard

end sub
'
'---------------------------------------------------------------------------
'
testcase tFormatLine
'/// In this testcase a line is painted on a calcdocument. Then some properties of this line ///
'/// are modified and the document is saved. After reload the document it is checked, if ///
'/// the made modifies are taken over. ///

   dim vwert2 as Integer
   dim sTestFile
   dim modLine as string, currLine as string

   sTestFile = convertpath(gOfficePath & "user/work/tFormatLine" & Ext)

      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Linie.click
      call gMouseMove (10,10,60,60)

      call gMouseClick (1,1)        ' deselect
      Sleep 1
      call gMouseClick (20,20)      ' select
      Sleep 1

      FormatLine
   printlog "Adjustments"
   printlog "Line values"
      kontext
      active.setpage TabLinie
      Sleep 2
      Kontext "TabLinie"
      Stil.Select 2
      currLine = Breite.GetText
      Breite.More 2
      modLine = Breite.GetText
      Farbe.Select 3

   printlog "Line style"
      kontext
      active.setpage TabLinienstile
      Sleep 2
      Kontext "TabLinienstile"
      try
         Linienstil.select 7
   catch
      warnlog "Line styles aren't available!?"
   endcatch
   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      try
      Liste.Select 8
      catch
         warnlog "Line ends aren't available"
      endcatch
      Kontext "TabLinienenden"
      TabLinienenden.OK

      call gMouseClick (70,70)      ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1

      FormatLine
   printlog "Check line values"
      kontext
      active.setpage TabLinie
      Kontext "TabLinie"
      if Breite.GetText <> modLine then Warnlog "Width isn't anymore " + modLine + " but " + Breite.GetText
      if Farbe.GetSelIndex <> 3 then
         Warnlog "Color isn't the 3. but the " + Farbe.GetSelIndex +"." & "Bug?!"
      end if

   printlog "linestyle"
      kontext
      active.setpage TabLinienstile
      Kontext "TabLinienstile"
      if Linienstil.GetSelIndex <> 7 then Warnlog "Adjusted Line Style isn't the 7. but " + Linienstil.GetSelIndex + "."

   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      vwert2 = Liste.GetSelIndex
      if vwert2 <> 8 then
      if vwert2 = 1 then
         Warnlog "Bug 70203 : The current Style from the line ends isn't shown"
         else
         Warnlog "Adjusted line ends aren't the 8. but " + Liste.GetSelIndex + "."
         end if
      end if
      TabLinienenden.OK
   printlog "Save, close and reload document and check adjustments a second time."
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      FileClose
      Call hDateiOeffnen sTestFile
      sleep 2
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep 2
      Kontext "DocumentCalc"
      call gMouseClick (20,20)      ' selektieren
      sleep 2
      FormatLine

   printlog "Line values"
      kontext
      active.setpage TabLinie
      Kontext "TabLinie"
      if Breite.GetText <> modLine then Warnlog "Width isn't " + modLine + " but " + Breite.GetText
      if Farbe.GetSelIndex <> 3 then
         Warnlog "Color isn't the 3. but " + Farbe.GetSelIndex +"." & "Bug:99163"
      end if

   printlog "Line style"
      kontext
      active.setpage TabLinienstile
      Kontext "TabLinienstile"
      if Linienstil.GetSelIndex <> 7 then Warnlog "Adjusted line style isn't the 7. but " + Linienstil.GetSelIndex + "."

   printlog "Line ends"
      kontext
      active.setpage TabLinienenden
      try
         Kontext "Linienstil"
         if Linienstil.exists then
            warnlog "Dialog 'Linienstil' has appeared"
            Linienstil.Cancel
         end if
      catch
      endcatch
      Kontext "TabLinienenden"
      if vwert2 <> 1 then
      if Liste.GetSelIndex <> 8 then Warnlog "Adjusted line ends aren't the 8. but " + Liste.GetSelIndex + "."
      end if
      TabLinienenden.OK
      sleep 5
      call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatText
'/// This and the following tests are run after the same pattern. A document is opened, ///
'/// a drawing object is created, the object properties are modified, the document is ///
'/// saved, the document is reload an it is checked if the properties from the object ///
'/// are taken over ///

   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormatText" & Ext)
      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Textobjekt.click

      call gMouseMove (5,5,25,15)
      DocumentCalc.typeKeys ("Quod errat demonstrandum")
      Kontext "DocumentCalc"
      DocumentCalc.MouseDown 70,70
      DocumentCalc.MouseUp 70,70
      'call gMouseClick (70,70)
      sleep 5
      DocumentCalc.MouseDown 70,70
      DocumentCalc.MouseUp 70,70
      Kontext "DocumentCalc"
      DocumentCalc.MouseDown 15,15
      DocumentCalc.MouseUp 15,15
      'call gMouseClick (15,15)
      sleep 7

      FormatTextCalc
      sleep 5
   printlog "Adjustments"
   printlog "Text"
      Kontext
      Active.SetPage TabText
      Kontext "TabText"
      BreiteAnTextAnpassen.Uncheck
      HoeheAnTextAnpassen.Uncheck
      AmRahmenAnpassen.Check

   printlog "Running Letters"
      Kontext
      Active.SetPage TabLauftext
      Kontext "TabLauftext"
      Effekt.Select 4
      Endlos.Uncheck
      TabLauftext.OK

   printlog "Save, close and reload document and check adjustments a second time."
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      FileClose
      Call hDateiOeffnen sTestFile
      Kontext "DocumentCalc"

   DocumentCalc.MouseDown 10, 10
   DocumentCalc.MouseUp 10, 10
      'call gMouseClick (20, 20)        ' selektieren
    sleep 5
   printlog "Text"
      FormatTextCalc
      Kontext
      Active.SetPage TabText
      Kontext "TabText"
      if AmRahmenAnpassen.IsEnabled = FALSE then
      Warnlog "'Fit to size' isn't enabled anymore"
      else
      if AmRahmenAnpassen.IsChecked = FALSE then Warnlog "'Fit to size' isn't checked anymore"
      end if

   printlog "Text Animation"
      Kontext
      Active.SetPage TabLauftext
      Kontext "TabLauftext"
      if Effekt.GetSelIndex <> 4 then warnlog "The Text Animation style isn't anymore  the 4. but " + Effekt.GetSelIndex + "."
      if Endlos.IsChecked then warnlog "Continuous is checked."
      TabLauftext.OK

      call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatArea
'/// See above descriptions ///


   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormatArea" & Ext)
      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Rechteck.click

      call gMouseMove (10,10,60,60)
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1

      FormatArea
   printlog "Einstellungen"
   printlog "Area"
      kontext
      active.setpage TabArea
      Kontext "TabArea"
      FillOptions.Select (3)
   printlog "Shadow"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      Anzeigen.Check
   printlog "Transparency"
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      Transparenzverlauf.Check
      TransparenzverlaufTyp.Select 4
      TabTransparenz.OK
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (20,20)      ' selektieren
      Sleep 1
   printlog "Check settings"
   printlog "Area"
      FormatArea
      kontext
      active.setpage TabArea
      Kontext "TabArea"
      if FillOptions.GetSelIndex <> 3 then
          Warnlog "Gradient should be selected in ListBox"
      endif
   printlog "Shadow"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      if Anzeigen.IsChecked = FALSE then Warnlog "Shadow isn't switched on anymore"
   printlog "Transparency"
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      if Transparenzverlauf.IsChecked = FALSE then
      Warnlog "Transparence Gradient isn't switched on anymore"
      else
      if TransparenzverlaufTyp.GetSelIndex <> 4 then Warnlog "The Gradient isn't the 4. entry but the " + TransparenzverlaufTyp.GetSelIndex + "."
      end if
      TabTransparenz.OK
   printlog "Save, close and reload document and check adjustments a second time."
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      sleep 5
      FileClose
      sleep 5
      Call hDateiOeffnen sTestFile
      call gMouseClick (20,20)      ' selektieren
      FormatArea
   printlog "Area"
      kontext
      active.setpage TabArea
      Kontext "TabArea"
     if FillOptions.GetSelIndex <> 3 then
          Warnlog "Gradient should be selected in ListBox"
      endif
   printlog "  Schatten"
      kontext
      active.setPage TabSchatten
      Kontext "TabSchatten"
      if Anzeigen.IsChecked = FALSE then Warnlog "Shadow isn't switched on anymore"
   printlog "Transparency"
   sleep 10
      kontext
      active.setPage TabTransparenz
      Kontext "TabTransparenz"
      if Transparenzverlauf.IsChecked = FALSE then
      Warnlog "Transparency Gradient isn't switched on anymore"
      else
      if TransparenzverlaufTyp.GetSelIndex <> 4 then Warnlog "The Gradient type isn't on the 4. entry but on the " + TransparenzverlaufTyp.GetSelIndex + "."
      end if
      TabTransparenz.OK
      call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatPositionAndSize_1
'/// See above descriptions ///

   Dim vw1, vw2, vw3, vw4, vw5, vw6, vw7, vw8
   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormat_1" & Ext)

   call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
   Rechteck.click
   call gMouseMove (10,10,60,60)
   sleep 2
   call gMouseClick (1,1)        ' deselektieren
   Sleep 1
   call gMouseClick (20,20)      ' selektieren
   Sleep 5

   ContextPositionAndSize
   printlog "Adjustments - modify positions"
   printlog "TabPositionAndSize"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      PositionX.SetText "1"
      PositionY.SetText "2"
      vw1 = PositionX.GetText
      vw2 = PositionY.GetText
      vw3 = Width.GetText
      vw4 = Height.GetText
      TabPositionAndSize.OK
      FormatPositionAndSize
      printlog "Rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      vw5 = PositionX.GetText
      vw6 = PositionY.GetText
   printlog "Slant"
      Kontext
      Active.SetPage TabSchraegstellen
      Kontext "TabSchraegstellen"
      vw7 = Radius.GetText
      vw8 = Winkel.GetText
      TabSchraegstellen.OK

      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      'call selectFirstOLE      ' selektieren
      QAErrorLog "Selecting with mouse may not always work. Work around for #i32284#!"
      call gMouseClick (20,50)      ' selektieren
      Sleep 1
   printlog "Check settings"
      FormatPositionAndSize
   printlog "Position"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if PositionX.GetText <> vw1 then Warnlog "X-value has been modified. Current : " + vw1 + "   Actual : " + PositionX.GetText
      if PositionY.GetText <> vw2 then Warnlog "Y-value has been modified. Current : " + vw2 + "   Actual : " + PositionX.GetText
      if Width.GetText <> vw3 then Warnlog "Width has been modified. Current : " + vw3 + "   Actual : " + Width.GetText
      if Height.GetText <> vw4 then Warnlog "Height has been modified. Current : " + vw4 + "   Actual : " + Height.GetText

   printlog "Rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      ' First set the rotationpoint similar to the basepoint from PositionAndSize. Then we can compare
      ' the settings
      'Drehpunkt.TypeKeys "<SHIFT UP>"
      ' Drehpunkt.TypeKeys "<SHIFT LEFT>"
      if PositionX.GetText <> vw5 then Warnlog "X-value has been modified. Current : " + vw5 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw6 then Warnlog "Y-value has been modified. Current : " + vw6 + "    Actual  : " + PositionX.GetText
   printlog "Incline"
      Kontext
      Active.SetPage TabSchraegstellen
      Kontext "TabSchraegstellen"
      if Radius.GetText <> vw7 then Warnlog "Radius has been modified. Current : " + vw7 + "    Actual  : " + Radius.GetText
      if Winkel.GetText <> vw8 then Warnlog "Degree has been modified. Current : " + vw8 + "    Actual  : " + Winkel.GetText
      TabSchraegstellen.OK
   printlog "Save document, close it, load it again and check adjustments"
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      FileClose
      Call hDateiOeffnen sTestFile
      call gMouseClick (20,50)      ' selektieren
      ContextPositionAndSize
   printlog "Position"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if PositionX.GetText <> vw1 then Warnlog "X-value has been modified. Current : " + vw1 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw2 then Warnlog "Y-value has been modified. Current : " + vw2 + "    Actual  : " + PositionX.GetText
      if Width.GetText <> vw3 then Warnlog "Width has been modified. Current : " + vw3 + "    Actual  : " + Width.GetText
      if Height.GetText <> vw4 then Warnlog "Height has been modified. Current : " + vw4 + "    Actual  : " + Height.GetText

   printlog "Rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      if PositionX.GetText <> vw5 then Warnlog "X-value has been modified. Current : " + vw5 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw6 then Warnlog "Y-value has been modified. Current : " + vw6 + "    Actual  : " + PositionX.GetText
   printlog "Incline"
   sleep 3
      Kontext
      Active.SetPage TabSchraegstellen
   sleep 3
      Kontext "TabSchraegstellen"
      if Radius.GetText <> vw7 then Warnlog "Radius has been modified. Current : " + vw7 + "    Actual  : " + Radius.GetText
      if Winkel.GetText <> vw8 then Warnlog "Degree has been modified. Current : " + vw8 + "    Actual  : " + Winkel.GetText
      TabSchraegstellen.OK
   sleep 5
      Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatPositionAndSize_2
'/// See above descriptions ///

   Dim vw1, vw2, vw3, vw4, vw5
   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormat_2" & Ext)

      call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Legende.click

      call gMouseMove (5,5,15,15)
      sleep(2)
      DocumentCalc.typekeys "<ESCAPE>"
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (17,17)      ' selektieren
      Sleep 5
   Printlog "Modify size"
      ContextPositionAndSize
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      Width.Less 4
      Height.More 4
      vw1 = Width.GetText
      vw2 = Height.GetText
      vw3 = PositionX.GetText
      vw4 = PositionY.GetText
      'TabPositionAndSize.OK

   Printlog "Modify Legend"
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      Ansatz.Select 3
      vw5 = Abstand.GetText
      TabLegende.OK
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (17,17)      ' selektieren
      Sleep 5
   Printlog "Check"
      ContextPositionAndSize
   Printlog "Size"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "Width has been modified. Current : " + vw1 + "    Actual  : " + Width.GetText
      if Height.GetText <> vw2 then Warnlog "Heigth has been modified. Current : " + vw2 + "    Actual  : " + Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value has been modified. Current : " + vw3 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value has been modified. Current : " + vw4 + "    Actual  : " + PositionX.GetText
   Printlog "Legend"
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      if Abstand.GetText <> vw5 then Warnlog "Distance has been modified. Current : " + vw5 + "    Actual  : " + Abstand.GetText
      if Ansatz.GetSelIndex <> 3 then Warnlog "Beginning isn't anymore the 3. entry but" + Ansatz.GetSelIndex
      TabLegende.OK

   printlog "Save document, close, load it anf check the settings again."
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      FileClose
      Call hDateiOeffnen sTestFile
      Kontext "DocumentCalc"
      sleep 3
    call gMouseClick (17,17)      ' selektieren
    Kontext "DocumentCalc"
    Sleep 1
    Printlog "Check"
    try
      ContextPositionAndSize
      Printlog "TabPositionAndSize"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "Width has been modified. Current : " + vw1 + "    Actual  : " + Width.GetText
      if Height.GetText <> vw2 then Warnlog "Height has been modified. Current : " + vw2 + "    Actual  : " + Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value has been modified. Current : " + vw3 + "    Actual  : " + PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value has been modified. Current : " + vw4 + "    Actual  : " + PositionX.GetText
      printlog "Legend"
      sleep 20
      Kontext
      Active.SetPage TabLegende
      Kontext "TabLegende"
      if Abstand.GetText <> vw5 then Warnlog "Distance has been modified. Current : " + vw5 + "    Actual  : " + Abstand.GetText
      if Ansatz.GetSelIndex <> 5 then Warnlog "Beginning isn't anymore 3 but" + Ansatz.GetSelIndex
      TabLegende.OK
    catch
      warnlog "Bug?!"
    endcatch

   Kontext "DocumentCalc"

   Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatPositionAndSize_3
'/// See above descriptions ///

   Dim vw1, vw2, vw3, vw4, vw5
   Dim sTestFile
   sTestFile = convertpath(gOfficePath & "user/work/tFormat_3" & Ext)
    PrintLog "format|position and size for one control"

      call hNewDocument
      Kontext "Toolbar"
      ShowFormFunctions.TearOff
      Kontext "Formsbar"
      Formsbar.Move 20, 20
      Pushbutton.click

      Kontext "DocumentCalc"
      call gMouseMove (10,10,20,20)
      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (15,15)      ' selektieren
      Sleep 1

      Kontext "Formsbar"
      Formsbar.Close

   Printlog "adjustments modify size"
      ContextPositionAndSize
   Printlog "TabPositionAndSize"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      Width.More 4
      Height.Less 4
      vw1 = Width.GetText
      vw2 = Height.GetText
      vw3 = PositionX.GetText
      vw4 = PositionY.GetText

   printlog "rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      if PositionX.IsEnabled then Warnlog "the tabpage rotation is activ,it must be inactiv for the rotation"
   printlog "skew"
      Kontext
      Active.SetPage TabSchraegstellen
      Kontext "TabSchraegstellen"
      if Radius.IsEnabled then Warnlog "the tabpage skew is activ,it must be inactiv for the controls"
      TabSchraegstellen.OK

      call gMouseClick (1,1)        ' deselektieren
      Sleep 1
      call gMouseClick (15,15)      ' selektieren
      Sleep 1

   Printlog "check"
      ContextPositionAndSize
   Printlog "size"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "the spreads was modified, current : " & vw1 & " actual : " & Width.GetText
      if Height.GetText <> vw2 then Warnlog "the height was modified, current: " & vw2 & " actual : " & Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value was modified, current : " & vw3 & " actual : " & PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value was modified, current : " & vw4 & " actual : " & PositionX.GetText
   printlog "rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      if PositionX.IsEnabled then Warnlog "the tabpage rotation is activ, it must be inactiv for the controls!"

   printlog "skew"
      Kontext
      Active.SetPage TabSchraegstellen
      Kontext "TabSchraegstellen"
      if Radius.IsEnabled then Warnlog "the tabpage skew is activ, it must be inactiv for the controls!"
      TabSchraegstellen.OK

   printlog "save, close and load the document and check the adjustments again!"
      Call hSpeichernUnterMitFilterKill sTestFile, FileFormat
      FileClose
      Call hDateiOeffnen sTestFile

      call gMouseClick (15,15)      ' select
      Sleep 1
   Printlog "check"
   try
      ContextPositionAndSize
   catch
      'enable the edit mode
         Kontext "Toolbar"
         ShowFormFunctions.TearOff
         Kontext "Formsbar"
         Formsbar.Move 20, 20
         DesigneModus.Click
         call gMouseClick (15,15)      ' select
         Sleep 1
      Printlog "Edit Mode was not enabled. Enable it now and check again"
      ContextPositionAndSize
      endcatch
   Printlog "TabPositionAndSize"
      Kontext
      Active.SetPage TabPositionAndSize
      Kontext "TabPositionAndSize"
      if Width.GetText <> vw1 then Warnlog "the spreads was modified, current: " & vw1 & " Actual : " & Width.GetText
      if Height.GetText <> vw2 then Warnlog "the height was modified, current : " & vw2 & "  Actual  : " & Height.GetText
      if PositionX.GetText <> vw3 then Warnlog "X-value was modified, current : " & vw3 & " actual : " & PositionX.GetText
      if PositionY.GetText <> vw4 then Warnlog "Y-value was modified, current : " & vw4 & " actual : " & PositionX.GetText
   printlog "rotation"
      Kontext
      Active.SetPage TabDrehung
      Kontext "TabDrehung"
      if PositionX.IsEnabled then Warnlog "the tabpage rotation is activ, it must be inactiv for the controls!"
   printlog "skew"
   sleep 5
      Kontext
      Active.SetPage TabSchraegstellen
   sleep 5
      Kontext "TabSchraegstellen"
      if Radius.IsEnabled then Warnlog "the tabpage skew is activ, it must be inactiv for the controls!"
      TabSchraegstellen.OK
   sleep 10

      Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatGroup
'/// See above descriptions ///

   call hNewDocument
      Kontext "Drawbar"
      if Not DrawBar.Exists then
         Call hToolbarSelect("Drawing", true)
      end if
      sleep(2)
      Kontext "Drawbar"
      Rechteck.click

   call gMouseMove (10,10,60,60)
   call gMouseMove (10,65,50,80)
   sleep(2)
   DocumentCalc.typekeys "<ESCAPE>"

   gMouseClick ( 1, 1 )
   Kontext "Drawbar"
   Auswahl.click
   call gMouseMove (5,5,65,90)
   PrintLog "- Format/Gruppe/Gruppieren"
   sleep 5
   FormatGroupGroup
   Sleep 1
   printLog "- Format/Gruppe/Betreten"
   FormatGroupEditGroupCalc
   Sleep 1

   try
      FormatGroupEditGroupCalc
   catch
   endcatch

   PrintLog "Format|LeaveGroup"
   FormatExitGroupDraw
   Sleep 1

   PrintLog "Format|Ungroup"
   FormatUngroupDraw
   Sleep 1
   Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatAnchor
'/// See above descriptions ///

   PrintLog "Format|PositionAndSize for controls"

   call hNewDocument
   Kontext "Toolbar"
   ShowFormFunctions.TearOff
   Kontext "Formsbar"
   Formsbar.Move 20, 20
   Pushbutton.click

   Kontext "DocumentCalc"
   call gMouseMove (10,10,20,20)

   call gMouseClick (1,1)        ' deselektieren
   Sleep 1
   call gMouseClick (15,15)      ' selektieren
   Sleep 1
   Kontext "Formsbar"
   Formsbar.Close
   PrintLog "- Format/Verankerung/Seite"
   FormatAnchorToPageCalc
   Sleep 1

   PrintLog "- Format/Verankerung/Zelle"
   FormatAnchorToCell
   Sleep 1
   PrintLog "- Format/Verankerung/Seite"
   FormatAnchorToPageCalc
   Sleep 1

   Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
testcase tFormatStandard
'/// Because of bug:97226, there must be checked the default standard setting
'/// of characters in cells.
'/// A new document is opened, and then a number is inserted. Next this number
'/// is marked by pressing <F2>. With the contextmenu, the standard character
'/// format is called, and it is checked if it is OK.

    dim nid as integer
   call hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    DocumentCalc.TypeKeys "1000000000 <RETURN>"
    DocumentCalc.TypeKeys "<UP>"
    DocumentCalc.TypeKeys "<F2>"
    DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
    sleep 3
    printlog "First, check, if the default font(-size) is set."
    DocumentCalc.MouseMove 1, 1
    DocumentCalc.OpenContextMenu
   sleep 3  'test the contextmenu
      nid = MenuGetItemID (7)
      sleep 2
      MenuSelect nid
      sleep 2
      Kontext
      sleep 2
         Active.SetPage TabFont
            sleep 2
            Kontext "TabFont"
            if asian then
               if FontWest.getselText = "Albany" and SizeEast.getselText = "10" then
                  printlog "OK the font is Albany ant it's size is 10"
               else
                  if iSprache = 82 then
                     QAErrorLog "Korean is behaving different. We're checking recently if this is a bug!"
                  else
                     warnlog "Font is: " & FontEast.getselText & " and Size is: " & SizeEast.getselText
                  end if
               end if
            else
                if Font.getselText = "Albany" and SizeWest.getselText = "10" then
                  printlog "The Font and it'S size is OK"
               else
                  warnlog "Font is: " & FontWest.getselText & " and Size is: " & SizeWest.getselText
               end if
            end if
      Kontext
        TabFont.Cancel
   sleep 2
    printlog "Now open the contextmenu again, call the menuitem 'Standard'..."
    DocumentCalc.OpenContextMenu
   sleep 3  'test the contextmenu
      nid = MenuGetItemID (1)
      sleep 2
      MenuSelect nid
   sleep 2
   printlog "... and check the font(-size)"
   DocumentCalc.OpenContextMenu
   sleep 3  'test the contextmenu
      nid = MenuGetItemID (7)
      sleep 2
      MenuSelect nid
      sleep 2
      Kontext
      sleep 2
         Active.SetPage TabFont
            sleep 2
            Kontext "TabFont"
            if asian then
               if FontWest.getselText = "Albany" and SizeEast.getselText = "10" then
                  printlog "The Font and it'S size is OK"
               else
                  if iSprache = 82 then
                     QAErrorLog "Korean is behaving different. We're checking recently if this is a bug!"
                  else
                     warnlog "Font is: " & FontEast.getselText & " and Size is: " & SizeEast.getselText
                  end if
               end if
            else
                if Font.getselText = "Albany" and Size.getselText = "10" then
                  printlog "The Font and it'S size is OK"
               else
                  warnlog "Font is: " & Font.getselText & " and Size is: " & Size.getselText
               end if
            end if
      Kontext
        TabFont.Cancel
   sleep 2
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<ESC>"
   sleep 2
   call hCloseDocument

endcase

