'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_105_.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 14:56:14 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description  :  Detailed test of the functions in the Format menu - Part 1
'*
'*************************************************************************
'*
' #1 C_105_ ' Initial routine
' #1 tFormatCell
' #1 tFormatCellISO8601Recognition
' #1 tFormatRowHeigth
' #1 tFormatRowOptimalHeigth
' #1 tFormatColumnWidth
' #1 tFormatColumnOptimalWidth
' #1 tFormatRenameTable
' #1 tFormatHideDisplayTable
' #1 tFormatMergeCells
' #1 tFormatPage
' #1 tFormatPrintRange
' #1 tFormatUpperLowerCase
' #1 tFormatTemplateCatalog
' #1 tFormatStylist
' #1 tFormatAutoformat
' #1 tFormatConditionalFormatting
'*
'\************************************************************************

sub C_105_
Printlog "--------- C_105_ ---------"

   Call tFormatCell
   call tFormatCellISO8601Recognition
   Call tFormatRowHeigth
   Call tFormatRowOptimalHeigth
   Call tFormatColumnWidth
   Call tFormatColumnOptimalWidth
   Call tFormatRenameTable
   Call tFormatHideDisplayTable
   Call tFormatMergeCells
   Call tFormatPage
   Call tFormatPrintRange
   Call tFormatUpperLowerCase
   Call tFormatTemplateCatalog
   Call tFormatStylist
   Call tFormatAutoformat
   Call tFormatConditionalFormatting

End sub

dim stat_Apply as boolean, curr_Apply as boolean
'
'-----------------------------------------------------------
'
testcase tFormatCell
'/// This test checks the format cell function. At first several cells are marked ///
'/// and formatted. Then the cellproperties are checked. After saving, closing and ///
'/// reloading the document these properties are checked again. ///

   dim statEffects, currEffects, statFont, currFont as integer
   dim file as string
'/// Load a new calc document, select some cells and call the FormatCells dialog
   file = convertpath(gOfficePath & "user/work/tFormatCell" & Ext)
   Call hNewDocument
   call ZellenMarkieren (4,4)
   stat_Apply = false
    FormatCells
'/// goto tabpage TabNumbers and modify NumberFormat
    Kontext
    Active.SetPage TabZahlen
      Kontext "TabZahlen"
        ZahlenFormat.select 5
      Kontext
'/// goto tabpage TabFont and modify the Font
   Active.SetPage TabFont
      Kontext "TabFont"
      if asian or gCTLSup then
         currFont = FontWest.GetSelIndex
         FontWest.Select 10
       else
         currFont = Font.GetSelIndex
         Font.Select 10
       end if
   Kontext
'/// goto tabpage TabFontEffects and modify StrikeThrough
   Active.SetPage TabFontEffects
      Kontext "TabFontEffects"
      currEffects = StrikeThrough.GetSelIndex
      StrikeThrough.Select 5
      Kontext
'/// goto tabpage TabAlignment and modify the Alignment
   Active.SetPage TabAusrichtung
      Kontext "TabAusrichtung"
       ListeHAusrichtung.select 3
'/// Check the feature VerticalWriting by enableng the asian language support
   printlog "Now check the new feature 'UseVerticalLayout'"
   if NOT asian then
      if VertikaleAusrichtung.isvisible then
         warnlog "The checkbox 'UseVerticalLayout' is visible, although the asian language support is disabled"
      else
         printlog "OK, the checkbox 'UseVerticalLayout' is not visible"
      end if
      printlog "If asian language support isn't available it must be activated"
      TabAusrichtung.OK
      sleep 3
      ToolsOptions
      sleep 3
      hToolsOptions ( "LANGUAGESETTINGS", "LANGUAGES" )
      Aktivieren.check
      Kontext "OptionenDlg"
      asian = true
      OptionenDlg.OK
      sleep 3
      FormatCells
      sleep 3
      gosub checkUseVerticalLayout
   else
      gosub checkUseVerticalLayout
   end if

goto nextpoint
'/// If the asian language support is not enabled the checkbox 'UseAsianVerticalLAyoutMode' must not be
'/// vivible.
'/// If the button TextDirection isn't pressed, this checkbox must not be enabled.
checkUseVerticalLayout:
   Kontext
   Active.SetPage TabAusrichtung
      Kontext "TabAusrichtung"
      if VertikaleAusrichtung.isvisible then
         printlog "OK, the 'UseVerticalLayout' is visible"
         printlog "Now check, if this box is enabled (must not be,because the verticel text direction is not activated)"
         if Grad.isenabled then
            if VertikaleAusrichtung.isenabled then
               warnlog "The checkbox must not be enabled if the text direction vertical isn't pressed"
            else
               printlog "OK, the checkbox is not enabled"
            end if
            printlog "Now enable text direction vertical"
            Gestapelt.click
            if VertikaleAusrichtung.isenabled then
               printlog "OK, the checkbox is enabled"
            else
               warnlog "The checkox is not enabled but it must be"
            end if
         else
            warnlog "Vertical text direction is enabled by default, please check if this is correct"
            if VertikaleAusrichtung.isenabled then
               printlog "OK, the checkbox is enabled"
            else
               warnlog "The checkox is not enabled but it must be"
            end if
         end if
         printlog "Now disable the vertical textdirection again"
         Gestapelt.click
      else
         warnlog "Although the asian language support is activated, the checkbox 'UseVerticalLayout' is not visible"
         warnlog "This is a bug"
      end if
return

nextpoint:

      Kontext
   if asian then
      Active.SetPage TabAsianTypography
         Kontext "TabAsianTypography"
         if ApplyList.ischecked then
            curr_Apply = true
            warnlog "Checkbox Apply List of forbidden characters is per default checked!"
            ApplyList.uncheck
            stat_Apply = false
         else
            curr_Apply = false
            ApplyList.check
            stat_Apply = true
         end if
         Kontext
    end if
   Active.SetPage TabUmrandung
   Kontext
     Printlog "Check for '...Margin ... out of print range' message."
     if Active.Exists(2) then
      if Active.GetRT = 304 then
        Printlog Active.GetText
        Active.Yes
        sleep(2)
      end if
     end if
      Kontext "TabUmrandung"
        Vorgaben.typekeys "<RIGHT RIGHT RIGHT>"
        Vorgaben.typekeys "<SPACE>"
       StilFarbe.select 13
       sleep 2
      Kontext
   Active.SetPage TabHintergrund
      Kontext "TabHintergrund"
       Hintergrundfarbe.typekeys "<UP>"
        sleep 2
      Kontext
   Active.SetPage TabZellschutz
      Kontext "TabZellschutz"
       FuerAusdruckAusblenden.Check
      TabZellschutz.Ok
      dim str_Code as string
      FormatCells
        Kontext
    Active.SetPage TabZahlen
        Kontext "TabZahlen"
        str_Code = FormatCode.GetText
        FormatCode.SetText "/#"
        Kontext
        TabZahlen.OK
      ' Close the Dialog with OK!
'/// Call the cellformat dialog and check the settings
      ' Call the cellformat dialog and check the settings!
      call checkCellFormat(str_Code)
'/// Then save, close and reload the document and check the made settings again
      ' Save the document, reload it and check again.
      Call hSpeichernUnterMitFilterKill file, FileFormat
      Call hCloseDocument
      sleep 5
      Call hDateiOeffnen file
      sleep 3
      call checkCellFormat(str_Code)

      Call hCloseDocument
  TestExit
endcase
'
'-----------------------------------------------------------
'
testcase tFormatCellISO8601Recognition
'///<u><b>New feature SO8: Recognize ISO 8601 date formats in all languages</b></u>///

   dim iCount as INTEGER
   dim sDateString as STRING
   dim sCurrentCell as STRING
'///<ul>
   '///<li>Open new document</li>///
   Call hNewDocument
   '///<li>Loop for different kinds of date format</li>///
   for iCount = 1 to 3
       select case iCount
              case 1 : sDateString = "2003-01-31"
              case 2 : sDateString = "1950-12-01 03:59"
              case 3 : sDateString = "1978-11-11 11:11:11"
       end select
       '///<li>Enter a empty, unformatted cell</li>///
       sCurrentCell = "B" & trim(str(iCount))
       call fCalcSelectCell(sCurrentCell)
       Kontext "DocumentCalc"
       '///<li>Enter a date string depending on loop no.</li>///
       DocumentCalc.typeKeys sDateString
       '///<li>Finish edit using 'RETURN' key</li>///
       DocumentCalc.typeKeys "<RETURN>"
       '///<li>Go back to previous cell</li>///
       call fCalcSelectCell(sCurrentCell)
       '///<li>Invoke format::cells dialog</li>///
       FormatCells
       Kontext
       '///<li>Invoke number formats tabpage</li>///
       Active.SetPage TabZahlen
       Kontext "TabZahlen"
       '///<li>Lookup if selected category is item No. 6, date. True means success.</li>///
       if Kategorie.GetSelIndex = 6 then
           printlog "Recognition of ISO 8601 date format seems to work"
       else
           warnlog "Date recognition failed -> Check this out!"
       endif
       '///<li>Quit dialog</li>///
       TabZahlen.Cancel
       
   next iCount
   '///<li>Close document</li>///
   Call hCloseDocument
'///</ul>  
endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatRowHeigth
'/// This test check the made settings of the row height. After reload the ///
'/// file, the settings are checked again. ///

   dim file as string
   dim lager : dim optHeigth as integer : dim Heigth as integer
   select case iSystemSprache
      case 01   : Heigth = 1
      case else : Heigth = 2
   end select
   file = convertpath(gOfficePath & "user/work/tFormatRowHeigth" & Ext)

   Call  hNewDocument
'/// Load a new calc document and call the menuitem 'FormatRowHeightCalc'
'/// Then set the heigth to '2' and confirm the dialog.
   FormatRowHeightCalc
   Kontext "ZeilenHoehe"
   if ZeilenHoehe.exists then
      lager = val(Hoehe.gettext)
      Hoehe.settext "2"
      Hoehe.typekeys "<Up>"
      Hoehe.typekeys "<Down>"
      ZeilenHoehe.Ok
   else
      Warnlog "Dialog not shown"
   end if
'/// Check , if this setting was taken over
   gosub CheckHeight
   sleep 3
   Call hSpeichernUnterMitFilterKill file, FileFormat
   sleep 3
   Call hCloseDocument
   'Check the made settings after reload the file
   Call hDateiOeffnen file
   sleep 3
'/// Save, close, reopen the document and check the row heigth again.
   gosub CheckHeight
   sleep 3
   call hCloseDocument
goto endsub
CheckHeight:
   FormatRowHeightCalc
   Kontext "ZeilenHoehe"
   if clng(Hoehe.gettext) - 2.0 < 0.1 then
      'Standwardwert.check
        ZeilenHoehe.Ok
   else
       Warnlog "RowHeight not correct taken over " & left(Hoehe.gettext,len(Hoehe.gettext) - Heigth) & " instead of 2"
       ZeilenHoehe.cancel
   end if

return

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatRowOptimalHeigth
'/// This test check the made settings of the optimal row height. ///

   'Dim lager :
   dim optHeigth as integer
   dim SFile as String
   SFile = convertpath(gOfficePath & "user/work/tFormatRowOptimalHeigth" & Ext)
   select case iSystemSprache
   case 01   : optHeigth = clng("97,85")
   case else : optHeigth = clng("4,42")

   end select
'/// Open a new calc document and call the menuitem 'FormatRowHeightCalc'
'/// Then uncheck the standard value and confirm this dialog.
   Call  hNewDocument
   FormatRowHeightCalc
   Kontext "ZeilenHoehe"
   Standwardwert.uncheck
   ZeilenHoehe.Ok
   Kontext
'/// Insert in cell 'A1' a text and set the font size to '80'
   DocumentCalc.Typekeys "Hi Guys!<RETURN UP>"

   FormatCells
   Kontext
   active.setpage TabFont
   Kontext "TabFont"
   if asian then
      SizeWest.Select "80"
   else
      try
         SizeEast.Select "80"
      catch
         SizeEast.setText "80"
      endcatch
   end if
   TabFont.Ok
'/// Then call the menuitem 'FormatRowOptimalHeightCalc' and add '1' to the optimal height
'/// Then check if this modifying was taken over
   printlog "Check the row height, before saving the document"
   FormatRowOptimalHeightCalc
   Kontext "ZeileOptimaleHoehe"
   if ZeileOptimaleHoehe.exists then
      Extra.settext "1"
      ZeileOptimaleHoehe.Ok
      FormatRowHeightCalc
       Kontext "ZeilenHoehe"
        if clng(Hoehe.gettext) - optHeigth < 0.1 then
         Printlog "Optimal Height OK"
            ZeilenHoehe.Cancel
         else
         Warnlog "Optimal Height isn't correct " & Hoehe.gettext & " instead of: " & optHeigth
            ZeilenHoehe.Cancel
        end if
    else
      Warnlog "The Dialog didn't appaear!"
    end if

   call hSpeichernUnterMitFilterKill SFile, FileFormat
   call hCloseDocument
   sleep 3
   call hDateiOeffnen SFile
   sleep 3
'/// Check the settings agin after saving, closing and reloading the document
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   printlog "Check the row height after saving, closing and reloading the document"
   FormatRowOptimalHeightCalc
   Kontext "ZeileOptimaleHoehe"
   if ZeileOptimaleHoehe.exists then
      Extra.settext "1"
      ZeileOptimaleHoehe.Ok
      FormatRowHeightCalc
       Kontext "ZeilenHoehe"
        if clng(Hoehe.gettext) - optHeigth < 0.1 then
         Printlog "Optimal Height OK"
            ZeilenHoehe.Cancel
         else
         Warnlog "Optimal Height isn't correct " & Hoehe.gettext & " instead of: " & optHeigth
            ZeilenHoehe.Cancel
        end if
    else
      Warnlog "The Dialog didn't appaear!"
    end if
    sleep 5
   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatColumnWidth
'/// This test check the made settings of the row width. ///

   dim Lager as integer, SFile as String
   dim lng as boolean
   dim measurement as integer
   lng = false
   SFile = convertpath(gOfficePath & "user/work/tFormatColumnWidth" & Ext)

   Call hNewDocument
   sleep(2)
   if iSystemSprache = 01 then
      lng = true
      ToolsOptions
         hToolsOptions ( "SPREADSHEET", "GENERAL" )
         measurement = Masseinheit.getSelIndex
         Masseinheit.Select 2
         Kontext "OptionenDlg"
      OptionenDlg.OK
   end if
   Call hCloseDocument
   sleep(2)
'/// Open a new calc document and call the menuitem 'FormatColumnWidthCalc'
'/// Set the width to '5', confirm this dialog and check if this setting was taken over
   Call hNewDocument
   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
   if SpaltenbreiteCalc.exists then
      Lager = val(Breite.gettext)
      Breite.settext "5"
      SpaltenbreiteCalc.Ok
   else
      Warnlog "Dialog wasn't shown"
   end if
   printlog "Check the scolumn width before saving document"
   gosub CheckColumnWidth

   call hSpeichernUnterMitFilterKill SFile, FileFormat
   Call hCloseDocument
   sleep 3
   printlog "Reload the document and check the column width again"
   call hDateiOeffnen SFile
'/// Save this file, close it, reload it and check the column width again
   gosub CheckColumnWidth
   sleep 3
   if lng = true then
      ToolsOptions
      hToolsOptions ( "SPREADSHEET", "GENERAL" )
      Masseinheit.Select measurement
      Kontext "OptionenDlg"
      OptionenDlg.OK
   end if
   goto testend

CheckColumnWidth:
   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
   if SpaltenBreiteCalc.exists then
      if clng(Breite.gettext) - 5 < 0.1 then
         Standardwert.check
         SpaltenbreiteCalc.Ok
         FormatColumnWidthCalc
         Kontext "SpaltenbreiteCalc"
         if clng(Breite.gettext) - lager < 0.1 then
            Printlog "Column width OK"
            SpaltenbreiteCalc.Ok
         else
            Warnlog "Column width wasn't adapted " & Breite.gettext & " instead of 5"
         end if
      if SpaltenBreiteCalc.exists then SpaltenbreiteCalc.Cancel
      else
         Warnlog "Column width wasn't adapted" & Breite.gettext & " instead of 5"
      end if
   else
      Warnlog "Column width wasn't adapted" & Breite.gettext & " instead of 5"
   end if
   if SpaltenBreiteCalc.exists then SpaltenbreiteCalc.cancel
return

testend:
   call hCloseDocument
endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatColumnOptimalWidth
'/// This test checks the optimal column width. ///

   Printlog "FormatColumnOptimalWidth"
   dim lager : dim optWidth as string
   dim SFile as String
   dim opt_set as integer, opt_current as integer
   SFile = convertpath(gOfficePath & "user/work/tFormatColumnOptimalWidth" & Ext)

   select case iSystemSprache
      case 01     : optWidth = "8.44"
      case else   : optWidth = "18,73"
   end select

   opt_current = clng(optWidth)
'/// Open a new calc document and call the menuitem 'FormatColumnWidthCalc'
   Call  hNewDocument

   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
'/// uncheck the standard value and confirm this dialog
   Standardwert.uncheck
   SpaltenbreiteCalc.Ok
   Kontext
'/// Insert a text in cell 'A1' and set the font size to '40'
   DocumentCalc.Typekeys "There is no starfleet anymore!<RETURN UP>"

   FormatCells
   Kontext
   active.setpage TabFont
   Kontext "TabFont"
   if asian then
      SizeWest.Select "40"
   else
      try
         SizeEast.Select "40"
      catch
         SizeEast.setText "40"
      endcatch
   end if
   TabFont.Ok
'/// Call the menuitem 'FormatColumnOptimalWidthCalc' set add width to '1'
   FormatColumnOptimalWidthCalc
   Kontext "SpalteOptimaleBreite"
   if SpalteOptimaleBreite.exists then
      Extra.settext "1"
'/// Check if the column width has increased around this value
      SpalteOptimaleBreite.Ok
      printlog "Check the optimal column width before saving the document"
      FormatColumnWidthCalc
      Kontext "SpaltenbreiteCalc"
      opt_set = clng(Breite.gettext)
      printlog "opt_current: " & opt_current
      printlog "opt_set: " & opt_set
      if opt_set >= opt_current then
         Printlog "Optimal Width OK"
         SpaltenbreiteCalc.Cancel
      else
         Warnlog "Optimal Width isn't correct " & clng(Breite.gettext) & " instead of: " & opt_current
         SpaltenbreiteCalc.Cancel
      end if
   else
      Warnlog "Dialog didn't appear!"
   end if
'/// Save, close and reopen the document
   call hSpeichernUnterMitFilterKill SFile, FileFormat
   sleep 3
   Call hCloseDocument
   sleep 3
   call hDateiOeffnen SFile
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
'/// Check the optimal column width after saving the file
   printlog "Check the optimal column width after saving the document"
   FormatColumnWidthCalc
   Kontext "SpaltenbreiteCalc"
   opt_set = clng(Breite.gettext)
   printlog "opt_current: " & opt_current
   printlog "opt_set: " & opt_set
   if opt_set >= opt_current then
      Printlog "Optimal Width OK"
      SpaltenbreiteCalc.Cancel
   else
      Warnlog "Optimal Width isn't correct " & clng(Breite.gettext) & " instead of: " & opt_current
      SpaltenbreiteCalc.Cancel
   end if
   sleep 10
   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatRenameTable
'/// This test checks the FormatSheetRename function. Due to an occured bug in the office52, ///
'/// it is checked if the input of some special characters kill the office. ///

   dim file as string
   file = convertpath(gOfficePath & "user/work/tFormatRenameTable" & Ext)
'/// Open a new calc and rename the first sheet, then check if this sheetname has been taken over
   Call  hNewDocument

    FormatSheetRename
    Kontext "TabelleUmbenennen"
    TabellenName.SetText "Test"
    TabelleUmbenennen.Ok

    gosub CheckName
'/// Check if the input of special characters in the sheetname kills the office
'/// attempt special character like: #, /, ?, *, (, ), &, ?=)(/&%$!#~
   printlog "* Check now if the input of some special characters kill the office"
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   TabellenName.SetText "#"
   TabelleUmbenennen.Ok
   try
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "/"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "?"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "*"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "("
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText ")"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "&"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabellenName.SetText "?=)(/&%$!#~"
      TabelleUmbenennen.Ok
      Kontext
      if Active.exists then Active.OK
      Kontext "TabelleUmbenennen"
      TabelleUmbenennen.Cancel
      printlog "OK, the input of restricted characters isn't possible!"
   catch
      warnlog "It was possible to use restricted names for the table or another action has been happened"
   endcatch

   Call hSpeichernUnterMitFilterKill file, FileFormat
   sleep 10
   Call hCloseDocument
   sleep 3
   Call hDateiOeffnen file
   sleep 3
   gosub CheckName
   sleep 5
   Call hCloseDocument
   goto endsub

CheckName:
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   if TabellenName.GetText = "Test" then
      printlog "OK, the name has been modified"
   else
      warnlog "The name hasn't been modified"
   end if
   TabelleUmbenennen.Cancel
return

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatHideDisplayTable
'/// This test checks if it is possible hide and display a table. It is also tested ///
'/// if it is possible to rename hidden tables, or if it is possible to hide more ///
'/// tables as the sheet contents. ///

   Call  hNewDocument
'/// Open a new calcdocumentrename the first sheet and hide it
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   TabellenName.SetText "Sun"
   TabelleUmbenennen.Ok
   FormatSheetHide
'/// Attempt to rename the hidden sheet
   FormatSheetRename
   Kontext "TabelleUmbenennen"
   if TabellenName.GetText = "Sun" then
      Warnlog "Table Sun not hidden"
   else
      Printlog "OK, table 'Sun' is hidden"
   end if
   TabelleUmbenennen.Cancel
'/// Attempt to hide all sheet (it must not be possible)
   FormatSheetHide
   try
   FormatSheetHide
      Warnlog "Hidden is possible three times"
   catch
      Printlog "OK, it's not possible to hide the last table"
   endcatch
'/// Check, if it is possible to unhide two sheets and check, if the first sheet has the correct name.
   FormatSheetShow
   Kontext "TabelleEinblenden"
   if AusgeblendeteTabelle.getitemcount = 2 then
      Printlog "OK, it's possible to show two tables"
   else
        Warnlog "" & AusgeblendeteTabelle.getitemcount & " Tables possible to show"
   end if
   AusgeblendeteTabelle.select "Sun"
   TabelleEinblenden.Ok

   FormatSheetRename
   Kontext "TabelleUmbenennen"
   if TabellenName.GetText = "Sun" then
      Printlog "Table Sun is visible"
   else
      Warnlog "Table Sun isn't visible"
   end if
   TabelleUmbenennen.Cancel

   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatMergeCells
'/// Here it is tested if cells could be merge and if there appears ///
'/// a warning if it is tried to merge nested cells. ///

'   Call  hNewDocument

    qaErrorLog "Design testcase for new behaviour"

'   Call hCloseDocument

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatPage
'/// This test checks the settings of the page format options. First a new document is loaded
'/// and the format style catalog is called. Then a new style is created. In this created style
'/// the border color and the background is modified. After this the document with the pointed
'/// style is checked on their settings before and after reloading this document.

   dim file as string
   dim gallery as string
   if gNetzInst then
      gallery = convertpath(gNetzOfficePath & "share/gallery/photos/beach.jpg")
   else
      gallery = convertpath(gOfficePath & "share/gallery/photos/beach.jpg")
   end if
   file = convertpath(gOfficePath & "user/work/tFormatPage" & Ext)

    call hNewDocument

    '/// Create and delegate a new template for this document ///
    FormatStylesCatalog
    Kontext "Vorlagenkatalog"
    ' Choose templates for pages
    try
      Vorlagen.select 2
    catch
      warnlog "No page style available -> Bug?!"
      Vorlagenkatalog.close
      Kontext "DocumentCalc"
      warnlog "The test must end here"
      call hCloseDocument
      goto endsub
    endcatch
    Neu.Click
    Kontext
    Active.SetPage TabVerwalten
    Kontext "TabVerwalten"
    VorlagenName.settext "Zentis"
    TabVerwalten.OK
    Kontext "Vorlagenkatalog"
    Vorlagenkatalog.OK
    'Kontext "Vorlagenliste"
    FormatStylesCatalog
    Kontext "Vorlagenkatalog"
    if iSprache > 80 then
      Ansicht.TypeKeys "<PAGEUP><PAGEUP><PAGEUP>"
    else
       Ansicht.TypeKeys "<PAGEDOWN><PAGEDOWN><PAGEDOWN>"
   end if
    'Kontext "Vorlagenkatalog"
    Vorlagenkatalog.OK
    Kontext "DocumentCalc"

   '/// At first modify a view settings for this document ///
      FormatPageCalc
    Kontext
    active.SetPage TabVerwalten
    Kontext "TabVerwalten"
    if VorlagenName.getText <> "Zentis" then
      warnlog "Template name hasn't been taken over, it is : " & VorlagenName.getText & " instaed of Zentis"
    end if
    Kontext
    active.SetPage TabSeite
    Kontext "TabSeite"
    Horizontal.check
    Kontext
    active.SetPage TabUmrandung
    Kontext
     Printlog "Check for '...Margin ... out of print range' message."
     if Active.Exists(2) then
      if Active.GetRT = 304 then
        Printlog Active.GetText
        Active.Yes
        sleep(2)
      end if
     end if
    Kontext "TabUmrandung"
    Vorgaben.typekeys "<Right><RIGHT> "
    StilFarbe.select 13
    Kontext
    active.SetPage TabHintergrund
    Kontext "TabHintergrund"
    als.select 2
    Flaeche.check
    Durchsuchen.Click
    Kontext "GrafikEinfuegenDlg"
    Dateiname.settext gallery
    Oeffnen.Click
    Kontext
    sleep 3
    active.SetPage TabKopfzeile
    Kontext "TabKopfzeile"
    InhaltLinksRechtsGleich.uncheck
    Kontext
    active.SetPage TabFusszeile
    Kontext "TabFusszeile"
    InhaltLinksRechtsGleich.uncheck
    Kontext
    active.SetPage TabTabelleCalc
    Kontext "TabTabelleCalc"
    Formeln.Check
    TabTabelleCalc.Ok
   Kontext
   if active.exists then
         Warnlog "Messagebox:" &  active.gettext
      active.Ok
   end if

   '/// After modifying, the settings are checked first with the opened document ///
   printlog "Check the modified settings with the opened document"
   gosub CheckMod
   printlog "Save, close and reload the document and check the settings again"
   call hSpeichernUnterMitFilterKill file, FileFormat
   sleep 5
   call hCloseDocument
   sleep 5

   '/// Check the made settings with the saved document ///
   call hDateiOeffnen file
   sleep 20
   gosub CheckMod
   call hCloseDocument
   sleep 20
   goto endsub

CheckMod:
    FormatPageCalc
    sleep 5
    Kontext
    active.SetPage TabVerwalten
    Kontext "TabVerwalten"
    if VorlagenName.isenabled then
      if VorlagenName.GetText = "Zentis" then
            Printlog "TabOrganizern OK"
      else
            Warnlog "TabOrganizern new name hasn't been taken over"
      end if
   else
      Warnlog "No modifies in TabOrganizern possible"
   end if
    Kontext
    active.SetPage TabSeite
    Kontext "TabSeite"
    if Horizontal.IsChecked then
      printlog "TabPage Ok"
   else
      warnlog "Modify in TabPage hasn't been taken over"
   end if
    Kontext
    active.SetPage TabUmrandung
    Kontext
     Printlog "Check for '...Margin ... out of print range' message."
     if Active.Exists(2) then
      if Active.GetRT = 304 then
        Printlog Active.GetText
        Active.Yes
        sleep(2)
      end if
     end if
    Kontext "TabUmrandung"
   if StilFarbe.GetSelIndex = 13 then
      printlog "TabBorders OK"
   else
      warnlog "Modify in TabBorders hasn't been taken over"
   end if
   Kontext
    active.SetPage TabHintergrund
    Kontext "TabHintergrund"
    als.select 2
    if Flaeche.Ischecked then
      printlog "TabBackground OK"
    else
      warnlog "Modify in TabBackground hasn't been taken over"
    end if
    Kontext
    active.SetPage TabKopfzeile
    Kontext "TabKopfzeile"
    if InhaltLinksRechtsGleich.IsChecked then
      warnlog "Modification in Tab Header wasn't applied -> Bug?!"
   else
      printlog "TabHeader OK"
   end if
    Kontext
    active.SetPage TabFusszeile
    Kontext "TabFusszeile"
    if InhaltLinksRechtsGleich.IsChecked then
      warnlog "Modify in Tab Footer wasn't applied -> Bug?!"
   else
      printlog "TabFooter OK"
   end if
    Kontext
    active.SetPage TabTabelleCalc
    Kontext "TabTabelleCalc"
    if Formeln.IsChecked then
      printlog "TabTableCalc OK"
   else
      warnlog "Modify in TabTableCalc hasn't been taken over"
   end if
    TabTabelleCalc.Ok
    sleep 20
return

endcase
'
'-----------------------------------------------------------
'
testcase tFormatUpperLowerCase
'/// This test checks the transformation from Upper to Lower Case and back again.
'/// Some characters are inserted in a document, then this characters are transformed
'/// to Upper Case and checked if this action works. Then this characters are transformed
'/// to Lower case and checked again.
   dim upper as String, lower as String
   upper = "ABCDEFG"
   lower = "abcdefg"
   Call  hNewDocument
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "Abcdefg<RETURN>"
    DocumentCalc.TypeKeys "<UP>"
    FormatChangeCaseUpper
    if cZellwert("A1") = upper then
      printlog "OK, the transform to UpperCase works"
    else
      warnlog "The transform to UpperCase doesn't work. " & cZellwert("A1") & " instead of " & upper
    end if
    FormatChangeCaseLower
    if cZellwert("A1") = lower then
      printlog "OK, the transform to LowerCase works"
    else
      warnlog "The transform to LowerCase doesn't work. " & cZellwert("A1") & " instead of " & lower
    end if

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatPrintRange
'/// First a cellrange is selected, then this range is defined as printrange.
'/// The PagePreview is called and closed, and with calling the menuitem
'/// 'FormatPrintRangesEdit' is called and it is checked if the value in the
'/// TexFiled 'PrintRange' is "$A$1:$J$10" .

   printlog "FormatPrintRange"
   Call  hNewDocument
    call ZellenMarkieren (10,10)
    FormatPrintRangesDefine
    DocumentCalc.TypeKeys "<Down>"

    FilePageView
    kontext "Previewbar"
    try
      OL_SEITENANSICHT_NaechsteSeiteCalc
         wait 500
         OL_SEITENANSICHT_VorherigeSeiteCalc
         Printlog "Ok"
    catch
         Warnlog "Printer range not taken over"
    endcatch
    kontext "Previewbar"
    try
      Seitenansicht.click
    catch
      warnlog "Button 'ClosePreview' is disabled. Attempt to close with a second call of 'File|PagePreview'"
      FilePageView
    endcatch
    Kontext "DocumentCalc"
    try
      DocumentCalc.TypeKeys "<Down>"
    catch
      warnlog "This crash is probably BugID #118074#!"
      goto endsub
    endcatch
    FormatPrintRangesEdit
   Kontext "DruckbereicheBearbeiten"
    if Druckbereich.GetText = "$A$1:$J$10" then
      printlog "Printer range correct"
    else
      Warnlog "Printer range not correct " & Druckbereich.GetText & " instead of $A$1:$J$10"
    end if
   DruckbereicheBearbeiten.Ok
    Call hCloseDocument

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatTemplateCatalog
'/// The StylesCatalog is called, it is checke if this dialog exists, then it is closed.
'/// The functionality of the Templatecatalog in connection with FormatPage functionality
'/// is tested in the testcase 'tFormatPage'.

   printlog "FormatTemplateCatalog"
    Call  hNewDocument

      FormatStylesCatalog
    Kontext "Vorlagenkatalog"
    if Vorlagenkatalog.exists then
      printlog "Style Catalog OK"
         Vorlagenkatalog.Cancel
    else
      Warnlog "Dialog Format StyleCatalog not shown"
    end if
    Call hCloseDocument

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatStylist
'/// The Stylist is called, it is checked if this dialog exists, then it is closed.
'/// 1.) open a calc
'/// 2.) for cell a1 to a 6 insert '100' into it
'/// 2.) create a new celltemplate
'/// 3.) for cell a1 to a6 point to each cell a celltemplate
'/// 4.) for cell a1 to a6 check if the appropriate celltemplate has been pointed
'/// 5.) save the document, load it and check, if the celltemplates are still pointed
'/// correct to the appropriate cells.

   dim i as integer
   dim seltext as String, whoami as String, file as string

   file = convertpath (gOfficePath & "user/work/tFormatStylist" & Ext)

   printlog "FormatStylist"

    Call  hNewDocument
    'First insereting values in the first 6 cells
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 HOME>"
    for i = 1 to 6
      DocumentCalc.TypeKeys "100<RETURN>"
    next i

    'Then create a new celltemplate
    FormatStylesCatalog
    Kontext "Vorlagenkatalog"
    Neu.click
    sleep 2
    Kontext
    Active.setPage TabVerwalten
    sleep 2
    Kontext "TabVerwalten"
    Vorlagenname.setText "MyTemplate"
    sleep 2
    Kontext
    Active.setPage TabZahlen
    sleep 2
    Kontext "TabZahlen"
    Kategorie.select 8
    TabZahlen.OK
    sleep 2

    Kontext "Vorlagenkatalog"
    Vorlagenkatalog.OK
    sleep 2

    ' Now check, if the stylist is coming up
   Kontext "Gestalter"
   if Gestalter.exists (2) then
      Gestalter.close
   end if

    FormatStylist
   if Gestalter.exists (2) then
      printlog "Ok, the stylist is visible"
   else
      warnlog "Stylist not shown, attempt it again"
      FormatStylist
   end if

   'point the celltemplates to the cells
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   for i = 0 to 5
      FormatStylesCatalog
      Kontext "Vorlagenkatalog"
      Ansicht.TypeKeys "<PAGEUP>"
      Ansicht.TypeKeys "<DOWN>", i
      Vorlagenkatalog.OK
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<DOWN>"
    next i

   sleep 2
    printlog "Now check if the celltemplaes are correct pointed to the cells"
    gosub checktemplates

    sleep 2
    call hSpeichernUnterKill file
    sleep 2
    Call hCloseDocument
    sleep 2
    printlog "Now load the document again and check if the celltemplates are still correct pointed to the cells"
    call hDateiOeffnen file
    sleep 2
    gosub checktemplates
    Kontext "Gestalter"
    sleep 2
    Gestalter.close
    sleep 5
    goto finish

checktemplates:
    Kontext "Gestalter"
   if Gestalter.exists (2) then
      printlog "Ok, Stylist is available"
   else
      warnlog "Stylist hasn't been closed!"
      FormatStylist
   end if
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   for i = 1 to 6
      whoami = wobinich
      Kontext "Gestalter"
      seltext = Vorlagenliste.getSelText
      printlog "Selected Celltemplate for cell " & whoami &": " & seltext & " at position " & Vorlagenliste.getselIndex
      if right(whoami, 1) <> Vorlagenliste.getselIndex then
         warnlog "The celltemplate wasn't pointed correct to cell: " & whoami & "! Cellposition and Listindex must be the same"
      end if
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<DOWN>"
      ' Give the stylist time to update
      sleep 2
    next i
return
finish:
   call hCloseDocument
   sleep 2
endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatAutoformat
'/// A 4x4 cellrange is selcted, and the AutoFormat dialog is called. Then the second list entry
'/// from the formatlist is choosed. Then the font and the alignment of the first row
'/// of this selected cells is modified. Then the 4x4 range is selected and it is saved as
'/// new Format. In a new document a 4x4 cellrange is selected and is pointed to the new
'/// added format. Then it is tested if the cells have the settings of this format.

   Call  hNewDocument
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<SHIFT RIGHT RIGHT RIGHT DOWN DOWN DOWN>"
    FormatAutoFormat
    Kontext "AutoformatCalc"
    FormatListe.select 2
    AutoformatCalc.Ok
   Kontext
   DocumentCalc.typekeys "<UP><UP><UP>"
   DocumentCalc.typekeys "<SHIFT LEFT LEFT LEFT>"
   FormatCells
    Kontext
    Active.SetPage TabFont
    Kontext "TabFont"
    if asian then
      FontWest.Select 6
    else
      Font.Select 6
    end if
    Kontext
   Active.SetPage TabAusrichtung
   Kontext "TabAusrichtung"
   ListeHAusrichtung.select 3
   ListeVAusrichtung.select 4
   TabAusrichtung.Ok
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<SHIFT RIGHT RIGHT RIGHT DOWN DOWN DOWN>"
    FormatAutoFormatApplyAndEditChanges
    Kontext "AutoformatCalc"
    Einfuegen.Click
    Kontext "AutoformathinzufuegenCalc"
    TabellenName.settext "1st"
    AutoformathinzufuegenCalc.Ok
    Kontext
    If active.exists then Active.Cancel
    Kontext "AutoformatCalc"
    FormatListe.select 2
    '   end if
    if FormatListe.getseltext = "1st" then
      Printlog "  OK new Autoformat has been added correctly"
    else
      Warnlog "New AutoFormat hasn't been added correctly"
    end if
    AutoformatCalc.Ok
    call hCloseDocument
    call hNewDocument
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<SHIFT RIGHT RIGHT RIGHT DOWN DOWN DOWN>"
    FormatAutoFormat
    Kontext "AutoformatCalc"
    FormatListe.select "1st"
    AutoformatCalc.Ok
   Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Left><Left><UP><UP><UP>"
   FormatCells
    Kontext

   Kontext "TabAusrichtung"
   if ListeHAusrichtung.getselindex = 3 then
      if ListeVAusrichtung.getselindex = 4 then
         Kontext
            Active.SetPage TabFont
            Kontext "TabFont"
            if asian then
               if FontWest.getselindex = 6 then
                  Printlog "  OK Autoformat has been taken over"
               else
                  Warnlog "Autoformat hasn't been taken over (FontType)"
               end if
            else
               if Font.getselindex = 6 then
                  Printlog "  OK Autoformat has been taken over"
               else
                  Warnlog "Autoformat hasn't been taken over (FontType)"
               end if
            end if
        else
         warnlog "Autoformat hasn't been taken over (Alignment bottom), bugID:95354"
        end if
   else
      warnlog "Autoformat hasn't been applied (Alignment left)"
   end if
    Kontext
   Active.SetPage TabAusrichtung
   Kontext "TabAusrichtung"
   TabAusrichtung.cancel
   Kontext "DocumentCalc"
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<SHIFT RIGHT RIGHT RIGHT DOWN DOWN DOWN>"
    FormatAutoFormatApplyAndEditChanges
    Kontext "AutoformatCalc"
    FormatListe.select "1st"
    if FormatListe.getseltext = "1st" then
      Loeschen.Click
        Kontext
        If active.exists then
         Active.Yes
            Printlog "  OK message by deleting entry"
        else
         Warnlog "No message by deleting entry"
        end if
   else
      Warnlog "Added Autoformat hasn't been found"
      end if
    AutoformatCalc.Ok
   Call hCloseDocument

endcase
'
'----------------------------------------------------------------------------
'
testcase tFormatConditionalFormatting
'/// The cell A1 is selected. Then the dialog FormatConditionalFormatting is called.
'/// In this dialog there are select some entries for the PopupList, celltemplates, compares
'/// and it is set a value. Then the content of cell a1 is copied to cell a2, and it is checked
'/// if the made settings for the conditional formatting are taken over into cell a2.

   printlog "FormatConditionalFormatting"
   call hNewDocument
    FormatConditionalFormatting
    Kontext "BedingteFormatierung"
    PopupList1.select 1
    Vergleich1.select 1
    TextField1.SetText "1"
    Zellvorlage1.Select 1
    BedingteFormatierung.Ok
    EditCopy
    Kontext
    DocumentCalc.typekeys "<Down>"
    EditPaste
    FormatConditionalFormatting
    Kontext "BedingteFormatierung"
    if PopupList1.getselindex = 1 then
      if Vergleich1.getselindex = 1 then
         if TextField1.getText = "1" then
               if Zellvorlage1.getselindex = 1 then
                  Printlog "ConditionalFormatting has been copied"
               else
                  Warnlog "ConditionalFormatting hasn't been copied"
               end if
            else
               Warnlog "ConditionalFormatting hasn't been copied complete"
            end if
         else
         Warnlog "ConditionalFormatting hasn't been copied complete"
        end if
   else
      Warnlog "ConditionalFormatting hasn't been copied complete"
    end if
    BedingteFormatierung.Cancel
   Call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
sub checkCellFormat(str_Code as string)

   FormatCells
        Kontext
        Active.SetPage TabZahlen
        Kontext "TabZahlen"
        if ZahlenFormat.GetSelIndex = 5 then
         printlog "NumberFormat in TabNumbers OK"
       else
         Warnlog "NumberFormat in TabNumbers is " &  ZahlenFormat.GetSelIndex & " instead of 5"
       end if
      Kontext
   Active.SetPage TabFont
      Kontext "TabFont"
      if asian then
         if FontWest.GetSelIndex = 10 then
            printlog "Font in TabFont OK"
         else
            Warnlog "Font in TabFont is " & FontWest.GetSelIndex & " instead of 10"
         end if
       else
         if Font.GetSelIndex = 10 then
            printlog "Font in TabFont OK"
         else
            Warnlog "Font in TabFont is " &  Font.GetSelIndex & " instead of 10"
         end if
       end if
      Kontext
       Active.SetPage TabFontEffects
       Kontext "TabFontEffects"
       if StrikeThrough.GetSelIndex = 5 then
         printlog "StrikeThrough in TabFontEffects OK"
       else
         warnlog "StrikeThrough in TabFontEffects is " &  StrikeThrough.GetSelIndex & " instead of 5"
       end if
       Kontext
   Active.SetPage TabAusrichtung
      Kontext "TabAusrichtung"
       if ListeHAusrichtung.GetSelIndex = 3 then
         printlog "HoricontalCenter in TabAlignment OK"
       else
         Warnlog "HoricontalCenter in TabAusrichtung is " & ListeHAusrichtung.GetSelIndex & " instead of 3"
       end if
      Kontext
   if asian then
      Active.SetPage TabAsianTypography
         Kontext "TabAsianTypography"
         if NOT stat_Apply = curr_Apply then
            printlog "OK, the checkbox ApplyList has changed their state"
          else
            warnlog "The modify of the checkbox Apply List hasn't been detected"
         end if
        Kontext
    end if
   Active.SetPage TabUmrandung
      Kontext "TabUmrandung"
       if StilFarbe.GetSelIndex = 13 then
         printlog "FontWest in TabBorders OK"
       else
         Warnlog "FontWest in TabBorders hasn't been modified"
       end if
      Kontext
   Active.SetPage TabHintergrund
      Kontext "TabHintergrund"
      'TabPage TabHintergrund isn't testible, because no slot could be execute
      Kontext
   Active.SetPage TabZellschutz
      Kontext "TabZellschutz"
       if FuerAusdruckAusblenden.IsChecked then
         printlog "Hide when printing in TabCellProtection is OK"
       else
         Warnlog "Hide when printing in TabCellProtection hasn't been modified"
       end if
      TabZellschutz.Ok

        ' check if the modify has been taken over
        FormatCells
        Kontext
        Active.SetPage TabZahlen
        Kontext "TabZahlen"
        if FormatCode.GetText = str_Code then
        printlog "OK, it is impossible to use restricted characters for the formatcode"
        else
         warnlog "Something wrong happenes with the formatcode"
         warnlog "formatcode is: " & FormatCode.GetText & " instead of: " & str_Code
        end if
        Kontext
        TabZahlen.Cancel

end sub

