'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Property_Browser.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:06:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Property Browser
'*
'************************************************************************
'*
' #1 tPushButton
' #1 tTextBox
' #1 tListBox
' #1 tComboBox
' #1 tImageButton
' #1 tImageControl
' #1 tForms
'*
'\***********************************************************************

sub b_lvl1_Property_Browser
	
    call tPushButton
    call tTextBox
    call tListBox
    call tComboBox        
    call tImageButton    
    call tImageControl        
    call tForms

end sub
'--------------------------------------------------------------------------------------
testcase tPushButton

    call sCloseAllToolbars	

    '/// Open a new document
    printlog "Open a new document"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
  	Kontext "FormControls"   	
   	PushButton.Click
   	sleep(1)      
	'/// insert a Push Button
    printlog "insert a Push Button"    
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// change Buttontype to URL
    printlog "change Buttontype to URL"
	Kontext "TabGeneralControl"	
    fsetControlProperty("PushButton","ButtonType", "4")
    '/// check if the URLField property is enabled
    printlog "check if the URLField property is enabled"
    if NOT URL.isEnabled then
        warnlog "The URL fields doesn't gets enabled"  
    end if
    '/// add url to URLField
    printlog "add url to URLField"
    fsetControlProperty("PushButton","URL", "http://www.sun.com")
	'/// check if the Frame property is enabled
    printlog "check if the Frame property is enabled"
    if NOT Frame.isEnabled then
        warnlog "The Frame fields doesn't gets enabled"  
    end if
    sleep(1)
    '/// add graphicfile to URLField
    printlog "add graphicfile to URLField"
    fsetControlProperty("PushButton","Graphics", gOfficePath + ConvertPath("share/gallery/bullets/blkpearl.gif"))
    '/// check if the GraphicsAlignment property is enabled
    printlog "check if the GraphicsAlignment property is enabled"
    if NOT GraphicsAlignment.isEnabled then
        warnlog "The GraphicsAlignment doesn't gets enabled"
    end if
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    sleep(1)	
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tTextBox
    
    call sCloseAllToolbars
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
  	Kontext "FormControls"   	
   	Edit.Click
   	sleep(1)      
	'/// insert a text box
    printlog "insert a text box"                    
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// change the propety multiline to yes
    printlog "change the propety multiline to yes"    
    fsetControlProperty("TextBox","TextType","2")
    '/// check if the scrollbars property is enabled
    printlog "check if the scrollbars property is enabled"
    if NOT Scrollbars.isEnabled then
        warnlog "The scrollbars doesn't gets enabled"  
    end if
    '/// check if the password char is enabled
    printlog "check if the password char is enabled"
    if Password.isEnabled then
        warnlog "The pasword is enabled ( issue 29477 ) "  
    end if
        
    '/// change the propety multiline to no
    printlog "change the propety multiline to no"
    fsetControlProperty("TextBox","TextType","1")
    '/// check if the scrollbars property is disabled
    printlog "check if the scrollbars property is disabled"
    if Scrollbars.isEnabled then
        warnlog "The scrollbars is enabled"  
    end if
    '/// check if the password char is disabled
    printlog "check if the password char is disabled"
    if NOT Password.isEnabled then
        warnlog "The pasword doesn't gets enabled"  
    end if
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    '/// close the document
    printlog "close the document"                
    sleep(1)    	
    hCloseDocument  

endcase
'--------------------------------------------------------------------------------------
testcase tListBox  

    call sCloseAllToolbars   
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	    
  	Kontext "FormControls"
    ListBox.Click
    sleep(1)
    UseWizards.Click
   	sleep(1)
	'/// insert a list box
    printlog "insert a list box"                        
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// change the property DropDown to yes
    printlog "change the propety multiline to yes"    
    fsetControlProperty("ListBox","DropDown","2")
    '/// check if the scrollbars property is enabled
    printlog "check if the LineCount property is enabled"
    if NOT LineCount.isEnabled then
        warnlog "The LineCount doesn't gets enabled"  
    end if
    
        
    '/// change the propety multiline to no
    printlog "change the propety multiline to no"
    fsetControlProperty("ListBox","DropDown","1")
    '/// check if the scrollbars property is disabled
    printlog "check if the LineCount property is disabled"
    if LineCount.isEnabled then
        warnlog "The LineCount is enabled"  
    end if
    
    Kontext "FormControls" 
        UseWizards.Click
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close    
    '/// close the document
    printlog "close the document"                
    sleep(1)    	
    hCloseDocument  

endcase
'--------------------------------------------------------------------------------------
testcase tComboBox     

    call sCloseAllToolbars
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	    
  	Kontext "FormControls"    
   	ComboBox.Click
    sleep(1)          
    UseWizards.Click
   	sleep(1)
	'/// insert a list box
    printlog "insert a list box"                        
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// change the property DropDown to yes
    printlog "change the propety multiline to yes"    
    fsetControlProperty("ComboBox","DropDown","2")
    '/// check if the scrollbars property is enabled
    printlog "check if the LineCount property is enabled"
    if NOT LineCount.isEnabled then
        warnlog "The LineCount doesn't gets enabled"  
    end if
    
        
    '/// change the propety multiline to no
    printlog "change the propety multiline to no"
    fsetControlProperty("ComboBox","DropDown","1")
    '/// check if the scrollbars property is disabled
    printlog "check if the LineCount property is disabled"
    if LineCount.isEnabled then
        warnlog "The LineCount is enabled"  
    end if
    
    Kontext "FormControls" 
        UseWizards.Click    
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    '/// close the document
    printlog "close the document"                
    sleep(1)    	
    hCloseDocument  

endcase
'--------------------------------------------------------------------------------------
testcase tImageButton

    call sCloseAllToolbars
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)
	
  	call hToolbarSelect("MoreControls",true)

    Kontext "MoreControls"    
   	Imagebutton.Click
   	sleep(1)      
	'/// insert an image control
    printlog "insert an image control"                        
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
    call hToolbarSelect("FormControls",true)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// change the property ButtonType to URL
    fsetControlProperty("ImagesButton","ButtonType", "4")
    '/// check if the URL property is enabled
    if NOT URL.isEnabled then
        warnlog "The URL fields doesn't gets enabled"  
    end if
    '/// add url to URLField
    printlog "add url to URLField"
    'ISSUE: see i29478
    'fsetControlProperty("ImagesButton","URL", "www.sun.com")
    fsetControlProperty("ImagesButton","URL", "http://www.sun.com")
  	'/// check if the Frame property is enabled
    printlog "check if the Frame property is enabled"
	if NOT Frame.isEnabled then
        warnlog "The Frame fields doesn't gets enabled"  
    end if
    sleep(1)
    '/// add graphicfile to GraphicField
    fsetControlProperty("ImagesButton","Graphics", gOfficePath + ConvertPath("share/gallery/bullets/blkpearl.gif"))
    '/// check if the GraphicsAlignment property is enabled
    printlog "check if the Scale property is enabled"
    if NOT Scale.isEnabled then
        warnlog "The Scale doesn't gets enabled"
    end if
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    sleep(1)    	
    hCloseDocument  

endcase
'--------------------------------------------------------------------------------------
testcase tImageControl  

    call sCloseAllToolbars   
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)
	
    call hToolbarSelect("MoreControls",true)
    Kontext "MoreControls"
       	ImageControl.Click
    
   	sleep(1)      
	'/// insert an image control
    printlog "insert an image control"                        
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
    call hToolbarSelect("FormControls",true)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// add graphicfile to GraphicField
    printlog "add graphicfile to GraphicField"
    fsetControlProperty("ImagesButton","Graphics", gOfficePath + ConvertPath("share/gallery/bullets/blkpearl.gif"))
    '/// check if the Scale property is enabled
    printlog "check if the Scale property is enabled"
    if NOT Scale.isEnabled then
        warnlog "The Scale doesn't gets enabled"
    end if    
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    sleep(1)    
    hCloseDocument  

endcase
'--------------------------------------------------------------------------------------
testcase tForms

    call sCloseAllToolbars
	
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)

  	Kontext "FormControls"  	
   	PushButton.Click
   	sleep(1)      
	'/// insert a Push Button
    printlog "insert a Push Button"    
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	FormProperties.Click
	sleep(2)
    
    Kontext "FormPropertiesDialog"
        FormPropertiesTabControl.setPage TabGeneralForm
	
    Kontext "TabGeneralForm"	     
        '/// set encoding to Multipart
        printlog "set encoding to Multipart"
        Encoding.select 2
        '/// check if the SubmitMethod get enabled
        printlog "check if the SubmitMethod get enabled"        
        if SubmitMethod.isEnabled then
            warnlog "The SubmitMethod fields doesn't gets enabled"  
        end if
        '/// set encoding to URL
        printlog "set encoding to URL"        
        Encoding.select 1
        '/// check if the SubmitMethod get disabled
        printlog "check if the SubmitMethod get disabled"        
        if NOT SubmitMethod.isEnabled then
            warnlog "The SubmitMethod fields doesn't gets disabled"  
        end if
        '/// set URL
        printlog "set URL"         
        'ISSUE: see i29478
        'URL.setText("www.sun.com")
        URL.setText("http://www.sun.com")
        TabGeneralForm.TypeKeys("<RETURN>")
        '/// check if the frame property gets enabled
        printlog "check if the frame property gets enabled"
        if NOT Frame.isEnabled then
            warnlog "The frame fields doesn't gets enabled"  
        end if
        
    Kontext "FormPropertiesDialog"
		FormPropertiesTabControl.setPage TabDataForm
	
    Kontext "TabDataForm"
        '/// select first datasource
        printlog "select first datasource"
        DataSource.select 1
        '/// select SQL Command as Type
        printlog "select SQL Command as Type"
        ContentType.select 3
        '/// check if the SQL Design button gets enabled
        printlog "check if the SQL Design button gets enabled"
        if OpenQueryDesign.isenabled then
            '/// open the query design with the button
            printlog "open the query design with the button"
            OpenQueryDesign.click
            sleep(5)
            '/// check if the querydesign open
            printlog "check if the querydesign open"
            Kontext "QueryDesignTable"            
            if NOT QueryDesignTable.exists(3) then
                warnlog "The Query Design doesn't open."
            end if
            Kontext "AddTables"
                AddTables.Close
            Kontext "QueryDesignTable"
            QueryDesignTable.UseMenu
            hMenuSelectNr(1)
            hMenuSelectNr(4)           
            
        else    
            warnlog "the openQueryDesign button is not enabled"
        end if
    Kontext "TabDataForm"  
        printlog "select table as Type"
        ContentType.select 1
        Content.setText("biblio")
        TabDataForm.TypeKeys "<RETURN>" , true
    
    '/// close the FormProperty Browser
    printlog "close the FormProperty Browser"    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    
    '/// open the form property browser
    printlog "open the form property browser"
    Kontext "FormControls"
        FormProperties.Click
        sleep(2)

    Kontext "FormPropertiesDialog"
		FormPropertiesTabControl.setPage TabDataForm

    '/// click on the filter button
    Kontext "TabDataForm"
    FilterDLGButton.Click
    '/// check if the filter dialog appear
    Kontext "FilterDialog"
        FilterDialog.OK

    '/// click on the sort button
    Kontext "TabDataForm"
    SortDLGButton.click
    '/// check if the sort dialog appear
    Kontext "SortOrder"
        SortOrder.OK
        
    '/// close the controlproperty browser    
    Kontext "ControlPropertiesDialog"
    ControlPropertiesDialog.close
    sleep(1)	
    hCloseDocument
    
endcase
