/* fileLoader.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Creates a separate, file reading thread, using urlConnect().
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.net.*;
import java.io.*;

import Scroller;

public class fileLoader extends Thread
{
    static final String BAD_URL      =   "\r\nError: Malformed file URL";
    static final String FILE_ERROR   =   "\r\rError: Cannot load file.";   
    static final String FILE_LOADED  =   "\r\nFile loaded.";
    static final String FILE_LOADING =   "\r\nLoading file...";
    static final int BUF_SIZE        =   2048;
    
    
	String helpFileName;
	boolean loaded;
	Applet app;
	URL url;
	
	String fileName;
	Scroller s;
	
	String string;
	
	fileLoader(Applet a, String szName,Scroller scroller)
	{
		app=a;
		url=null;
		fileName=szName;
		s=scroller;
		
		
		string="";
	}

	public void run()
	{
	    int bytesRead;
	    byte buf[];
	    
		loaded=false;
		if(null != s)s.appendText(FILE_LOADING);
		try{
        	url=new URL(app.getCodeBase(),fileName);
           }catch(MalformedURLException e)
           		{
           			s.appendText(BAD_URL);
           			url=null;
           		}
		try	{
             URLConnection urlConnection = url.openConnection();
             urlConnection.connect();

             // if the file does not exist, the following will throw an exception:
             InputStream is = urlConnection.getInputStream();

             do{
                buf=new byte[BUF_SIZE];
                bytesRead = is.read(buf,0,BUF_SIZE);
                string = string + new String(buf,0);
             }while(bytesRead != -1);
     	}catch (Exception ex)
		     {
        	     string = "";
        	     s.appendText(FILE_ERROR);
        	     this.stop();
            	 return;
     		 }


		loaded=true;
		if(null != s)s.appendText(FILE_LOADED);

		this.stop();
	}

	String retrieveFileContent()
	{
		if(loaded)
			return string;
		else
			return null;
	}
}

