/* Geodetic2.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * This unit creates the initial applet panel and button with which the actual
 * dialogs that perform the calculations, or obtain data, are launched.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.net.*;

import geoWindow;

public class Geodetic2 extends Applet
{

    geoWindow geoWin;
    Button button;
    Image image=null;
    MediaTracker tracker=new MediaTracker(this);
    int width,height;
    
    public void init()
    {
        URL imageURL=null;
        
	    try{
		        imageURL=new URL(getCodeBase(),gwConst.LOGO);
           } catch (MalformedURLException e)
	                {
    	       		    imageURL=null;
        	    	    image=null;
	                }
		
		
        if(imageURL != null){
       		image=getImage(imageURL);
           	if(image != null)
 	           tracker.addImage(image,0);
	    }
	    
       	setFont(new Font(gwConst.FONTSTRING,Font.BOLD,gwConst.FONTHEIGHT));		        

	 	add (button = new Button(gwConst.BUTTON));
		width=size().width; height=size().height;
        button.move((width-button.size().width)/2,(width-button.size().width)/2);

        geoWin=new geoWindow(this);

        
	}

	public void paint(Graphics g)
	{
		Color color=g.getColor();
		
		g.setColor(Color.lightGray);
		
   		g.fill3DRect(0,0,size().width,size().height,true);

		g.setColor(color);

		if(image != null){
			try{
            	tracker.waitForID(0);
            }catch (InterruptedException e)
            	{
                	return;
                }
              
			g.drawImage(image,(width-image.getWidth(this))/2,button.size().height
				+ (height-image.getHeight(this)-button.size().height)/3,this);

        
        FontMetrics fm=g.getFontMetrics();
        g.drawString(gwConst.COPYRIGHT,(width-fm.stringWidth(gwConst.COPYRIGHT))/2,height-fm.getMaxDescent()-3);
					
				
		}
		
	}

    public boolean action(Event e, Object arg)
    {
		if(arg.equals(gwConst.BUTTON) && null != geoWin)
        {
			if(!geoWin.isShowing())
                geoWin.show();
  			return true;
        }

        
		else return false;  
    }
}

