/*
 * Copyright (c) 2007 Sebastian Benoit <benoit-lists@fb12.de>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "includes.h"
#include "ntpd.h"

/* RCSID("$Id: bsd-adjfreq.c,v 1.3 2007/11/16 13:13:53 robert Exp $"); */

#if (defined(__linux__) || defined(__FreeBSD__) || defined(__DragonFly__) \
	|| defined(__sun__)) \
	&& !defined(HAVE_ADJFREQ) && defined(HAVE_NTP_ADJTIME)

#include <sys/types.h>
#include <unistd.h>

#ifdef HAVE_SYS_TIMEX_H
# include <sys/timex.h>
#endif

#ifdef adjfreq
# undef adjfreq
#endif

/*
 * adjfreq (old)freq = nanosec. per seconds shifted left 32 bits
 * timex.freq is ppm / left shifted by SHIFT_USEC (16 bits), defined in timex.h
 */

int
_compat_adjfreq(const int64_t *freq, int64_t *oldfreq)
{
	struct timex txc;
	int64_t newfreq;

	if (freq != NULL) {
#if defined(__linux__)
		txc.modes = ADJ_FREQUENCY;
#else
		txc.modes = MOD_FREQUENCY;
#endif
		txc.freq = *freq / 1e3 / (1LL << 16);

		if ((ntp_adjtime(&txc)) == -1)
			log_warn("ntp_adjtime (2) failed");

		log_debug("ntp_adjtime adjusted frequency by %fppm",
			  ((txc.freq * 1e3) *  (1LL<<16) / 1e3 / (1LL << 32)));
	}
	if (oldfreq != NULL) {
		txc.modes = 0;
		if ((ntp_adjtime(&txc)) == -1) {
			log_warn("ntp_adjtime (1) failed");
			return -1;
		}
		newfreq = (txc.freq * 1e3) *  (1LL<<16);
		log_debug("ntp_adjtime returns frequency of %fppm",
			  newfreq / 1e3 / (1LL << 32));
		*oldfreq = newfreq;
	}

	return 0;
}
#endif
