// $Id: DebugCondition.hh 11371 2010-03-28 17:00:33Z m9710797 $

#ifndef DEBUGCONDITION_HH
#define DEBUGCONDITION_HH

#include "BreakPointBase.hh"

namespace openmsx {

/** General debugger condition
 *  Like breakpoints, but not tied to a specifc address.
 */
class DebugCondition : public BreakPointBase
{
public:
	DebugCondition(GlobalCliComm& CliComm,
	               std::auto_ptr<TclObject> command,
	               std::auto_ptr<TclObject> condition);
	unsigned getId() const;

private:
	const unsigned id;

	static unsigned lastId;
};

} // namespace openmsx

#endif
