// $Id: MSXEventRecorder.cc 8527 2009-01-29 17:06:52Z mfeingol $

#include "MSXEventRecorder.hh"
#include "MSXEventDistributor.hh"
#include "Event.hh"
#include "EmuTime.hh"
#include "FileException.hh"
#include "FileOperations.hh"

using std::string;

namespace openmsx {

MSXEventRecorder::MSXEventRecorder(MSXEventDistributor& eventDistributor_,
                                   const string& fileName)
	: eventDistributor(eventDistributor_)
{
	FileOperations::openofstream(logFileStream, fileName);
	if (!logFileStream.good()) {
		throw FileException("Can't open file " + fileName + " to log to");
	}
	eventDistributor.registerEventListener(*this);
}

MSXEventRecorder::~MSXEventRecorder()
{
	eventDistributor.unregisterEventListener(*this);
}

void MSXEventRecorder::signalEvent(shared_ptr<const Event> event,
                                   EmuTime::param time)
{
	logFileStream << time << ' ' << event->toString() << std::endl;
}

} // namespace openmsx
