// $Id: MSXTurboRPCM.hh 6623 2007-06-15 11:27:19Z m9710797 $

#ifndef MSXTURBORPCM_HH
#define MSXTURBORPCM_HH

#include "MSXDevice.hh"
#include "Clock.hh"
#include <memory>

namespace openmsx {

class MSXMixer;
class AudioInputConnector;
class DACSound8U;

class MSXTurboRPCM : public MSXDevice
{
public:
	MSXTurboRPCM(MSXMotherBoard& motherBoard, const XMLElement& config,
	             const EmuTime& time);
	virtual ~MSXTurboRPCM();

	virtual void reset(const EmuTime& time);
	virtual byte readIO(word port, const EmuTime& time);
	virtual byte peekIO(word port, const EmuTime& time) const;
	virtual void writeIO(word port, byte value, const EmuTime& time);

private:
	byte getSample(const EmuTime& time) const;
	bool getComp(const EmuTime& time) const;
	void hardwareMute(bool mute);

	MSXMixer& mixer;
        const std::auto_ptr<AudioInputConnector> connector;
	const std::auto_ptr<DACSound8U> dac;
	Clock<15750> reference;
	byte DValue;
	byte status;
	byte hold;
	bool hwMute;
};

} // namespace openmsx

#endif
