/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.embed;
import java.io.Serializable;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="TBL4A")
public class EntityA_Embed_Coll_Embed implements Serializable {
    @Id
    Integer id;

    @Column(length=30)
    String name;
    
    @Basic(fetch=FetchType.LAZY)
    int age;

    @Embedded
    @AttributeOverrides({
        @AttributeOverride(name="intVal1", column=@Column(name="A1")),
        @AttributeOverride(name="intVal2", column=@Column(name="A2")),
        @AttributeOverride(name="intVal3", column=@Column(name="A3"))
    })
    protected Embed_Coll_Embed embed;
    
    public int getAge() {
        return age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Embed_Coll_Embed getEmbed() {
        return embed;
    }
    
    public void setEmbed(Embed_Coll_Embed embed) {
        this.embed = embed;
    }
}

