/*
 *  Copyright (c) 2007-2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Function.h"

#include "Parameter.h"
#include "Debug.h"
#include "Function_p.h"
#include "Value.h"
#include "ScopedName.h"
#include "Type.h"
#include "FunctionCaller_p.h"

using namespace GTLCore;

Function::Function(const GTLCore::ScopedName& _name, const GTLCore::Type* _returnType, Data* _data) : d(new Private)
{
  d->name = _name;
  d->returnType = _returnType;
  GTL_ASSERT(_data);
  d->data = _data;
}
Function::~Function()
{
  delete d->functionsCaller;
  delete d->data;
  delete d;
}

GTLCore::ScopedName Function::name() const
{
  return d->name;
}

const std::vector< Parameter >& Function::parameters() const
{
  return d->data->parameters();
}

const GTLCore::Type* Function::returnType() const
{
  return d->returnType;
}

GTLCore::Value Function::call( const std::vector< GTLCore::Value>& _parameters) const
{
  std::vector< GTLCore::Value> parameters = _parameters;
  for(unsigned int i = parameters.size(); i < d->data->maximumParameters(); ++i)
  {
    parameters.push_back( d->data->parameters()[i].defaultValue() );
  }
  if(_parameters.size() > d->data->maximumParameters()) return GTLCore::Value();
  d->functionsCaller = new FunctionCaller( d->data->function(), this, d->data->module() );
  try {
    GTL_ASSERT(d->functionsCaller);
    return d->functionsCaller->call( parameters );
  } catch(...)
  {
    GTL_DEBUG("Exception raised");
    return GTLCore::Value();
  }
}
