/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _AST_CONSTANT_COUMPOUND_EXPRESSION_H_
#define _AST_CONSTANT_COUMPOUND_EXPRESSION_H_

#include <vector>
#include "GTLCore/AST/Expression.h"

namespace GTLCore {
  namespace AST {
    /**
     * @internal
     * @ingroup GTLCore_AST
     */
    class ConstantCompoundExpression : public Expression {
      public:
        ConstantCompoundExpression( const GTLCore::Type* _type, const std::vector<Expression*>& _expressions);
        ~ConstantCompoundExpression( );
        virtual const GTLCore::Type* type() const;
        virtual bool isConstant() const;
        virtual LLVMBackend::ExpressionResult generateValue( LLVMBackend::GenerationContext& _gc, LLVMBackend::ExpressionGenerationContext& _egc ) const;
        virtual ExpressionResultSP generateValue( GenerationVisitor* _generationVisitor) const;
        int size() { return m_expressions.size(); }
        void markAsReturnExpression();
        Expression* expressionAt(unsigned int _idx );
      private:
        std::vector<Expression*> m_expressions;
        const GTLCore::Type* m_type;
        bool m_constant;
    };
  }
}

#endif
