/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_METADATA_ENTRY_H_
#define _GTLCORE_METADATA_ENTRY_H_

#include <GTLCore/String.h>

namespace GTLCore {
  namespace Metadata {
    class Group;
    class ParameterEntry;
    class TextEntry;
    class ValueEntry;
    /**
     * @ingroup GTLCore_Metadata
     *
     * This class is the base class of Metadata entries.
     */
    class GTLCORE_EXPORT Entry {
      friend class Group;
      friend class ParameterEntry;
      friend class TextEntry;
      friend class ValueEntry;
      friend class Factory;
      private:
        Entry( const GTLCore::String& _name );
        virtual ~Entry();
      public:
        /**
         * @return the name of that entry.
         */
        const GTLCore::String& name() const;
      public:
        /**
         * @return this entry as a @ref Group or null if it is not a group
         */
        virtual const Group* asGroup() const;
        /**
         * @return this entry as a @ref ParameterEntry or null if it is not a group
         */
        virtual const ParameterEntry* asParameterEntry() const;
        /**
         * @return this entry as a @ref TextEntry or null if it is not a group
         */
        virtual const TextEntry* asTextEntry() const;
        /**
         * @return this entry as a @ref ValueEntry or null if it is not a group
         */
        virtual const ValueEntry* asValueEntry() const;
      private:
        struct Private;
        Private* const d;
    };
  }
}

#endif
