/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_GENERATION_CONTEXT_H_
#define _GTLCORE_GENERATION_CONTEXT_H_

#include <list>
#include <GTLCore/Export.h>
namespace llvm {
  class Function;
  class Module;
  class BasicBlock;
  class LLVMContext;
  class Value;
}

namespace GTLCore {
  class CodeGenerator;
  class Function;
  class ModuleData;
  namespace AST {
    class Statement;
  }
  /**
   * @internal
   * This class contains information needed to generate the code from an AST.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT GenerationContext {
    public:
      GenerationContext( GTLCore::CodeGenerator* _codeGenerator,
                         llvm::LLVMContext* _llvmContext,
                         llvm::Function* _llvmFunction, Function* _function, ModuleData* _module );
      CodeGenerator* codeGenerator();
      llvm::Function* llvmFunction();
      Function* function();
      llvm::Module* llvmModule();
      ModuleData* module();
      /**
       * Append a statement that will generated after the current statement has been finished.
       */
      void appendDelayedStatement( AST::Statement* _statement );
      /**
       * Generate the statement that were delayed
       */
      llvm::BasicBlock* flushDelayedStatement(llvm::BasicBlock*);
      /**
       * Create a new block and add it to the current function.
       */
      llvm::BasicBlock* createBasicBlock( );
      llvm::LLVMContext& llvmContext();
      void setReturnPointer( llvm::Value* );
      llvm::Value* returnPointer();
    private:
      GTLCore::CodeGenerator* m_codeGenerator;
      llvm::Function* m_llvmFunction;
      Function* m_function;
      ModuleData* m_module;
      llvm::LLVMContext* m_llvmContext;
      std::list< AST::Statement* > m_delayedStatements;
      llvm::Value* m_returnPointer;
  };

}

#endif
