/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "CategoriesManager.h"

#include <map>

#include "Category.h"
#include "String.h"

using namespace GTLCore;

struct CategoriesManager::Private {
  mutable std::map< String, const Category*> str2cat;
  static CategoriesManager* s_categoriesManager;
};

CategoriesManager* CategoriesManager::Private::s_categoriesManager = 0;

CategoriesManager::CategoriesManager() : d(new Private)
{
}

CategoriesManager::~CategoriesManager()
{
  delete d;
}

const CategoriesManager* CategoriesManager::instance()
{
  if( not Private::s_categoriesManager )
  {
    Private::s_categoriesManager = new CategoriesManager;
  }
  return Private::s_categoriesManager;
}

const Category* CategoriesManager::category( const GTLCore::String& _key ) const
{
  std::map< String, const Category*>::const_iterator it = d->str2cat.find( _key );
  if( it != d->str2cat.end() )
  {
    return it->second;
  }
  return 0;
}

const Category* CategoriesManager::category( const GTLCore::String& _key, const GTLCore::String& _label, const GTLCore::String& _description ) const
{
  const Category* cat = category( _key );
  if( not cat )
  {
    cat = new Category( _key, _label, _description );
    d->str2cat[ _key ]  = cat;
  }
  return cat;
}
