/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_RecordLogCapabilitiesAccess.h"

const string InstanceID="OpenDRIM:OpenDRIM_RecordLogCapabilities:1.0.1";

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_unload(string& errorMessage) {
	_E_;
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RecordLogCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RecordLogCapabilities instance;
	instance.setInstanceID(InstanceID);

	if (discriminant == "ei") {
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_populate(instance,errorMessage));
	}

	result.push_back(instance);
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RecordLogCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;

	if (instance.InstanceID != InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}


	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_populate(instance,errorMessage));

	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogCapabilities& newInstance, const OpenDRIM_RecordLogCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_CreateGoalSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogCapabilities& instance, unsigned short& returnValue, const OpenDRIM_RecordLogCapabilities_CreateGoalSettings_In& in, OpenDRIM_RecordLogCapabilities_CreateGoalSettings_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogCapabilities_populate(OpenDRIM_RecordLogCapabilities& instance, string& errorMessage) {
	_E_;

	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID				[KEY]
	 * [X] RequestedStatesSupported
	 * [X] ElementNameEditSupported
	 * + Conditional:
	 * [-] MaxElementNameLen
	 */

	vector<unsigned short> requestedStatesSupported;

	instance.setElementNameEditSupported(false);

	// Empty array as RequestStateChange is not (yet) supported
	instance.setRequestedStatesSupported(requestedStatesSupported);

	_L_;
	return OK;
}

