#
# amazonfr.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'amazonfr';
DELETE FROM s_site_plugin_conf WHERE site_type = 'amazonfr';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'amazonfr';
DELETE FROM s_site_plugin_link WHERE site_type = 'amazonfr';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'amazonfr';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'amazonfr';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('amazonfr', 'amazonfr', 1, 'Amazon.fr', 'amazonfr.gif', 'A good source of DVD (Region 2) and VHS.', 'http://www.amazon.fr', 25, 'http://www.amazon.fr/exec/obidos/ASIN/{amazfrasin}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonfr', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazonfr', 'amazfrasin', 2, '', 'ASIN Number', 'text', '', '{amazfrasin}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazonfr', '*', '*', 1, 'More Info', 'http://www.amazon.fr/exec/obidos/ASIN/{amazfrasin}', '');

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'CD', 'music-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'MP3', 'music-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'BOOK', 'books-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'GAME', 'video-games-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'VHS', 'vhs-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'DVD', 'dvd-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'VCD', 'dvd-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'DIVX', 'dvd-fr');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_type_to_index_map', '', 'LD', 'dvd-frs');

#
# title articles - overrides $CONFIG_VARS['item_input.title_articles']
# 
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_input.title_articles', '', '0', 'Un');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_input.title_articles', '', '1', 'Une');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_input.title_articles', '', '2', 'Le');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_input.title_articles', '', '3', 'La');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazonfr', 'item_input.title_articles', '', '4', 'L\'');

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonfr', 'alt_title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonfr', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonfr', 'genre', 'VIDEO', '*', 'MOVIEGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazonfr', 'blurb', 'VIDEO', '*', 'MOVIE_PLOT');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AMAZFRASIN', 'Amazon.fr Standard Item Number', 'Amazon.fr ASIN', 'hidden', 'hidden', NULL, 'amazonfr');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AMAZFRASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'AMAZFRASIN', '0', NULL, NULL);