#
# English language pack (System data)
#

##################################################################################################################
# S_ITEM_TYPE configuration
##################################################################################################################
# 
# The title_prompt and description need modifying.
#
UPDATE s_item_type SET description = 'Digital Video Disc'
WHERE s_item_type = 'DVD';

UPDATE s_item_type SET description = 'Laser Disc'
WHERE s_item_type = 'LD';

UPDATE s_item_type SET description = 'Video Disc'
WHERE s_item_type = 'VCD';

UPDATE s_item_type SET description = 'VHS Video'
WHERE s_item_type = 'VHS';

UPDATE s_item_type SET description = 'Compact Disc'
WHERE s_item_type = 'CD';

UPDATE s_item_type SET description = 'DivX Video'
WHERE s_item_type = 'DIVX';

##################################################################################################################
# S_ATTRIBUTE_TYPE configuration
##################################################################################################################
# Generally the input_type should only be set if it takes advantage of %field%
# to include plain text.
#
UPDATE s_attribute_type SET prompt = 'Title'
WHERE s_attribute_type = 'S_TITLE';

UPDATE s_attribute_type SET description = 'Alternate Title', prompt = 'Alternate Title'
WHERE s_attribute_type = 'ALT_TITLE';

UPDATE s_attribute_type SET description = 'List of Actors in a movie', prompt = 'Actors'
WHERE s_attribute_type = 'ACTORS';

UPDATE s_attribute_type SET description = 'Director of a Movie', prompt = 'Director'
WHERE s_attribute_type = 'DIRECTOR';

# This is the only attribute which requires input_type language conversion.  (For 'minutes')
UPDATE s_attribute_type SET description = 'Running time', prompt = 'Length', input_type = 'number(4, %field% <i>minutes</i>)'
WHERE s_attribute_type = 'RUN_TIME';

UPDATE s_attribute_type SET description = 'Audio Languages', prompt = 'Language'
WHERE s_attribute_type = 'AUDIO_LANG';

UPDATE s_attribute_type SET description = 'Subtitle languages', prompt = 'Subtitles'
WHERE s_attribute_type = 'SUBTITLES';

UPDATE s_attribute_type SET description = 'Age Recommendation', prompt = 'Age'
WHERE s_attribute_type = 'AGE_RATING';

UPDATE s_attribute_type SET description = 'Movie Genre', prompt = 'Genre'
WHERE s_attribute_type = 'MOVIEGENRE';

# Even though a hidden type, this may still appear in search page.
UPDATE s_attribute_type SET description = 'Item Image URL', prompt = 'Image'
WHERE s_attribute_type = 'IMAGEURL';

UPDATE s_attribute_type SET description = 'DVD Extra Features Details', prompt = 'Extras'
WHERE s_attribute_type = 'DVD_EXTRAS';

UPDATE s_attribute_type SET description = 'DVD Region', prompt = 'Region'
WHERE s_attribute_type = 'DVD_REGION';

UPDATE s_attribute_type SET description = 'Aspect Ratio of Movie', prompt = 'Aspect Ratio'
WHERE s_attribute_type = 'RATIO';

UPDATE s_attribute_type SET description = 'Encoding Format of Video', prompt = 'Video Format'
WHERE s_attribute_type = 'VID_FORMAT';

UPDATE s_attribute_type SET description = 'Video Type', prompt = 'VHS Format'
WHERE s_attribute_type = 'VHS_TYPE';

UPDATE s_attribute_type SET description = 'Quality of Video', prompt = 'Quality'
WHERE s_attribute_type = 'VIDQUALITY';

UPDATE s_attribute_type SET description = 'Extra Comments', prompt = 'Comments'
WHERE s_attribute_type = 'COMMENTS';

UPDATE s_attribute_type SET description = 'Plot of a Movie', prompt = 'Plot'
WHERE s_attribute_type = 'MOVIE_PLOT';

UPDATE s_attribute_type SET description = 'Year of Release', prompt = 'Year'
WHERE s_attribute_type = 'YEAR';

# CD Attributes
UPDATE s_attribute_type SET description = 'Music Artist', prompt = 'Artist'
WHERE s_attribute_type = 'ARTIST';

UPDATE s_attribute_type SET description = 'CD Track Title', prompt = 'Track'
WHERE s_attribute_type = 'CDTRACK';

UPDATE s_attribute_type SET description = 'CD Play Length', prompt = 'Time'
WHERE s_attribute_type = 'CDTIME';

UPDATE s_attribute_type SET description = 'Music Style', prompt = 'Style'
WHERE s_attribute_type = 'MUSICGENRE';

# DivX Attributes
UPDATE s_attribute_type SET description = 'Video Codec Version', prompt = 'Video Codec'
WHERE s_attribute_type = 'DIVXVIDVER';

UPDATE s_attribute_type SET description = 'Audio Codec Version', prompt = 'Audio Codec'
WHERE s_attribute_type = 'DIVXAUDVER';

UPDATE s_attribute_type SET description = 'DIVX Quality', prompt = 'Quality'
WHERE s_attribute_type = 'DIVXQUALIT';

# Freedb Site Attributes
UPDATE s_attribute_type SET description = 'CDDB Genre', prompt = 'Genre'
WHERE s_attribute_type = 'CDDBGENRE';

UPDATE s_attribute_type SET description = 'Freedb ID', prompt = 'Disc ID'
WHERE s_attribute_type = 'FREEDB_ID';

# IMDB Site Attributes
UPDATE s_attribute_type SET description = 'ImDb ID', prompt = 'ImDb ID'
WHERE s_attribute_type = 'IMDB_ID';

UPDATE s_attribute_type SET description = 'ImDb Trailer', prompt = 'Trailer'
WHERE s_attribute_type = 'TRAILER';

# Item Review special attribute type.
UPDATE s_attribute_type SET description = 'Item Rating', prompt = 'Rating'
WHERE s_attribute_type = 'S_RATING';

# Item ID special attribute.
UPDATE s_attribute_type SET description = 'OpenDb Item ID', prompt = 'ID#'
WHERE s_attribute_type = 'S_ITEM_ID';

# Amazon Site plugin attribute.
UPDATE s_attribute_type SET description = 'Amazon Standard Item Number', prompt = 'Amazon ASIN'
WHERE s_attribute_type = 'AMAZONASIN';

##################################################################################################################
# S_ITEM_ATTRIBUTE_TYPE configuration
##################################################################################################################
# Currently there are no overriding prompts (excepting CD`s).  In previous releases the MOVIE_PLOT 
# prompt was overridden, but always with the same value from the s_attribute_type
# record, so this has been removed.  If any overriding prompts are used, then further
# conversions would be necessary.
#
# Example:
# 	UPDATE s_item_attribute_type SET prompt = '' WHERE s_item_type = '' AND s_attribute_type = '' AND order_no = ''
#
UPDATE s_item_attribute_type SET prompt = 'Track 1' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '50';
UPDATE s_item_attribute_type SET prompt = 'Track 2' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '51';
UPDATE s_item_attribute_type SET prompt = 'Track 3' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '52';
UPDATE s_item_attribute_type SET prompt = 'Track 4' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '53';
UPDATE s_item_attribute_type SET prompt = 'Track 5' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '54';
UPDATE s_item_attribute_type SET prompt = 'Track 6' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '55';
UPDATE s_item_attribute_type SET prompt = 'Track 7' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '56';
UPDATE s_item_attribute_type SET prompt = 'Track 8' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '57';
UPDATE s_item_attribute_type SET prompt = 'Track 9' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '58';
UPDATE s_item_attribute_type SET prompt = 'Track 10' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '59';
UPDATE s_item_attribute_type SET prompt = 'Track 11' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '60';
UPDATE s_item_attribute_type SET prompt = 'Track 12' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '61';
UPDATE s_item_attribute_type SET prompt = 'Track 13' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '62';
UPDATE s_item_attribute_type SET prompt = 'Track 14' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '63';
UPDATE s_item_attribute_type SET prompt = 'Track 15' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '64';
UPDATE s_item_attribute_type SET prompt = 'Track 16' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '65';
UPDATE s_item_attribute_type SET prompt = 'Track 17' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '66';
UPDATE s_item_attribute_type SET prompt = 'Track 18' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '67';
UPDATE s_item_attribute_type SET prompt = 'Track 19' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '68';
UPDATE s_item_attribute_type SET prompt = 'Track 20' WHERE s_item_type = 'CD' AND s_attribute_type = 'CDTRACK' AND order_no = '69';

UPDATE s_item_attribute_type SET prompt = 'CD Title'
WHERE s_attribute_type = 'S_TITLE' AND s_item_type = 'CD';

##################################################################################################################
# S_ATTRIBUTE_TYPE_LOOKUP configuration
##################################################################################################################
#
# Most of these will be updates.  The 'AGE_RATING' are inserted here, because most languages would also
# have different ratings!
#

UPDATE s_attribute_type_lookup SET display = 'United States & Canada' WHERE s_attribute_type = 'DVD_REGION' AND value = '1';
UPDATE s_attribute_type_lookup SET display = 'Europe, Near East, South Africa & Japan' WHERE s_attribute_type = 'DVD_REGION' AND value = '2';
UPDATE s_attribute_type_lookup SET display = 'South East Asia' WHERE s_attribute_type = 'DVD_REGION' AND value = '3';
UPDATE s_attribute_type_lookup SET display = 'Australasia, Middle & South America' WHERE s_attribute_type = 'DVD_REGION' AND value = '4';
UPDATE s_attribute_type_lookup SET display = 'Africa, Asia, Eastern Europe' WHERE s_attribute_type = 'DVD_REGION' AND value = '5';
UPDATE s_attribute_type_lookup SET display = 'Peoples Republic of China' WHERE s_attribute_type = 'DVD_REGION' AND value = '6';
UPDATE s_attribute_type_lookup SET display = 'No Region Encoding' WHERE s_attribute_type = 'DVD_REGION' AND value = '0';

#
# Customize default region for country/language - if appropriate
#
UPDATE s_attribute_type_lookup
SET checked_ind = NULL
WHERE s_attribute_type = 'DVD_REGION';

# Set for Australasia at the moment!
UPDATE s_attribute_type_lookup
SET checked_ind = 'Y'
WHERE s_attribute_type = 'DVD_REGION' 
AND value = '4';

UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'RATIO' AND value = '1.33';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'RATIO' AND value = '1.78';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'RATIO' AND value = '1.85';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'RATIO' AND value = '2.35';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'RATIO' AND value = '2.78';

UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'VID_FORMAT' AND value = 'NTSC';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'VID_FORMAT' AND value = 'PAL';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'VID_FORMAT' AND value = 'SECAM';

#
# Customize default video format for country/language - if appropriate
#
UPDATE s_attribute_type_lookup
SET checked_ind = NULL
WHERE s_attribute_type = 'VID_FORMAT';

UPDATE s_attribute_type_lookup
SET checked_ind = 'Y'
WHERE s_attribute_type = 'VID_FORMAT' 
AND value = 'PAL';

UPDATE s_attribute_type_lookup SET display = 'Pirated/Copied' WHERE s_attribute_type = 'VHS_TYPE' AND value = 'PIRATED';
UPDATE s_attribute_type_lookup SET display = 'TV Recording' WHERE s_attribute_type = 'VHS_TYPE' AND value = 'TV';
UPDATE s_attribute_type_lookup SET display = 'Pre-Recorded' WHERE s_attribute_type = 'VHS_TYPE' AND value = 'PRERECORD';

UPDATE s_attribute_type_lookup SET display = 'Excellent' WHERE s_attribute_type = 'VIDQUALITY' AND value = '1';
UPDATE s_attribute_type_lookup SET display = 'Good' WHERE s_attribute_type = 'VIDQUALITY' AND value = '2';
UPDATE s_attribute_type_lookup SET display = 'Fair' WHERE s_attribute_type = 'VIDQUALITY' AND value = '3';
UPDATE s_attribute_type_lookup SET display = 'Poor' WHERE s_attribute_type = 'VIDQUALITY' AND value = '4';
UPDATE s_attribute_type_lookup SET display = 'Awful' WHERE s_attribute_type = 'VIDQUALITY' AND value = '5';

#
# Customize ratings for country
#
DELETE FROM s_attribute_type_lookup WHERE s_attribute_type = 'AGE_RATING';
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'G', 'General (Suitable for all ages)', 'G.gif', NULL, '0');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'PG', 'Parental Guidance Suggested (15+)', 'PG.gif', NULL, '1');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'M', 'Mature (15+)', 'M.gif', 'Y', '2');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'MA', 'Mature Accompanied (15+)', 'MA.gif', NULL, '3');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'R', 'Restricted (18+)', 'R.gif', NULL, '4');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'X', 'Explicit Sexual Content (18+)', 'X.gif', NULL, '5');
INSERT INTO s_attribute_type_lookup (s_attribute_type, value, display, img, checked_ind, order_no) VALUES ( 'AGE_RATING', 'NR', 'Unrated Content', 'NR.gif', NULL, '6');

UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Action';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Adventure';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Adult';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Animation';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Biblical';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Comedy';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Documentary';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Drama';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Horror';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Fantasy';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Music';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Musical';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Mystery';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Romance';
UPDATE s_attribute_type_lookup SET display = 'Science Fiction' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'ScienceFiction';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Suspense';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Thriller';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'War';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Western';
UPDATE s_attribute_type_lookup SET display = '' WHERE s_attribute_type = 'MOVIEGENRE' AND value = 'Other';

UPDATE s_attribute_type_lookup SET display = 'English(5.0)' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH_5.0';
UPDATE s_attribute_type_lookup SET display = 'English(5.1)' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH_5.1';
UPDATE s_attribute_type_lookup SET display = 'English(DTS)' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH_DTS';
# These two are new in 0.37p3
UPDATE s_attribute_type_lookup SET display = 'English(Surround)' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH_SR';
UPDATE s_attribute_type_lookup SET display = 'English(2.0)' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH_2.0';

UPDATE s_attribute_type_lookup SET display = 'English' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ENGLISH';
UPDATE s_attribute_type_lookup SET display = 'German' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'GERMAN';
UPDATE s_attribute_type_lookup SET display = 'French' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'FRENCH';
UPDATE s_attribute_type_lookup SET display = 'Spanish' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'SPANISH';
UPDATE s_attribute_type_lookup SET display = 'Italian' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'ITALIAN';
UPDATE s_attribute_type_lookup SET display = 'Director\'s Commentary' WHERE s_attribute_type = 'AUDIO_LANG' AND value = 'DIR_COMMENT';

UPDATE s_attribute_type_lookup SET display = 'English' WHERE s_attribute_type = 'SUBTITLES' AND value = 'ENGLISH';
UPDATE s_attribute_type_lookup SET display = 'French' WHERE s_attribute_type = 'SUBTITLES' AND value = 'FRENCH';
UPDATE s_attribute_type_lookup SET display = 'German' WHERE s_attribute_type = 'SUBTITLES' AND value = 'GERMAN';
UPDATE s_attribute_type_lookup SET display = 'Spanish' WHERE s_attribute_type = 'SUBTITLES' AND value = 'SPANISH';
UPDATE s_attribute_type_lookup SET display = 'Italian' WHERE s_attribute_type = 'SUBTITLES' AND value = 'ITALIAN';

# These actually match with the CDDB defined genres.
UPDATE s_attribute_type_lookup SET display = 'Blues' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'blues';
UPDATE s_attribute_type_lookup SET display = 'Classical' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'classical';
UPDATE s_attribute_type_lookup SET display = 'Country' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'country';
UPDATE s_attribute_type_lookup SET display = 'Folk' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'folk';
UPDATE s_attribute_type_lookup SET display = 'Jazz' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'jazz';
UPDATE s_attribute_type_lookup SET display = 'New Age' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'newage';
UPDATE s_attribute_type_lookup SET display = 'Reggae' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'reggae';
UPDATE s_attribute_type_lookup SET display = 'Rock' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'rock';
UPDATE s_attribute_type_lookup SET display = 'Popular' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'pop';
UPDATE s_attribute_type_lookup SET display = 'Soundtrack' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'soundtrack';
UPDATE s_attribute_type_lookup SET display = 'Miscellaneous' WHERE s_attribute_type = 'MUSICGENRE' AND value = 'misc';

# Divx audio and video
UPDATE s_attribute_type_lookup SET display = 'Mp3' WHERE s_attribute_type = 'DIVXAUDVER' AND value = 'mp3';
UPDATE s_attribute_type_lookup SET display = 'Mp2' WHERE s_attribute_type = 'DIVXAUDVER' AND value = 'mp2';
UPDATE s_attribute_type_lookup SET display = 'Ogg' WHERE s_attribute_type = 'DIVXAUDVER' AND value = 'ogg';

UPDATE s_attribute_type_lookup SET display = 'Divx4' WHERE s_attribute_type = 'DIVXVIDVER' AND value = 'divx4';
UPDATE s_attribute_type_lookup SET display = 'Divx3 3.11 Alpha' WHERE s_attribute_type = 'DIVXVIDVER' AND value = 'divx3';
UPDATE s_attribute_type_lookup SET display = 'Angel Potion Codec' WHERE s_attribute_type = 'DIVXVIDVER' AND value = 'angelpotion';

UPDATE s_attribute_type_lookup SET display = 'Poor' WHERE s_attribute_type = 'DIVXQUALIT' AND value = 'poor';
UPDATE s_attribute_type_lookup SET display = 'Medium' WHERE s_attribute_type = 'DIVXQUALIT' AND value = 'medium';
UPDATE s_attribute_type_lookup SET display = 'Good' WHERE s_attribute_type = 'DIVXQUALIT' AND value = 'good';

#
# This attribute is reserved for use in item_review.  Please do not use it for your own s_item_attribute_type structures.
#
UPDATE s_attribute_type_lookup SET display = 'Disgraceful!' WHERE s_attribute_type = 'S_RATING' AND value = '1';
UPDATE s_attribute_type_lookup SET display = 'Terrible!' WHERE s_attribute_type = 'S_RATING' AND value = '2';
UPDATE s_attribute_type_lookup SET display = 'Decent!' WHERE s_attribute_type = 'S_RATING' AND value = '3';
UPDATE s_attribute_type_lookup SET display = 'Great!' WHERE s_attribute_type = 'S_RATING' AND value = '4';
UPDATE s_attribute_type_lookup SET display = 'Sensational!' WHERE s_attribute_type = 'S_RATING' AND value = '5';

#
# Borrow Duration prompts.
#
UPDATE s_attribute_type_lookup SET display = 'Undefined' WHERE s_attribute_type = 'S_DURATION' AND value = '0';
UPDATE s_attribute_type_lookup SET display = 'One Day' WHERE s_attribute_type = 'S_DURATION' AND value = '1';
UPDATE s_attribute_type_lookup SET display = 'Three Days' WHERE s_attribute_type = 'S_DURATION' AND value = '3';
UPDATE s_attribute_type_lookup SET display = 'One Week' WHERE s_attribute_type = 'S_DURATION' AND value = '7';
UPDATE s_attribute_type_lookup SET display = 'Two Weeks' WHERE s_attribute_type = 'S_DURATION' AND value = '14';
UPDATE s_attribute_type_lookup SET display = 'One Month' WHERE s_attribute_type = 'S_DURATION' AND value = '28';

