<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
// This must be first - includes config.php
require_once("./include/begin.inc.php");
include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/last_items_list.php");

if($CONFIG_VARS['site.enable']!==FALSE)
{
	// no login required for marquee functionality.
	if($HTTP_VARS['op'] == 'marquee')
	{
		// You have to change the $owner_id, $s_item_type and number of items parameters.
		$list_item_rs = get_last_num_items_rs(
						$CONFIG_VARS['last_items_list.total_num_items'],// number of items to return
						NULL, //owner_id 
						NULL, // s_item_type
						NULL, //update_on
						NULL); // not_owner_id
						
  

		if(is_not_empty_array($list_item_rs))
		{
			echo get_popup_javascript();
			echo("<A name=\"scrollingCode\"/>");
			echo("<MARQUEE behavior=\"scroll\" align=\"center\" direction=\"up\" scrollamount=\"2\" width=\"200\" height=\"220\" scrolldelay=\"100\" onmouseover='this.stop()' onmouseout='this.start()'>");
		
			// if public access, no need to login
			if(!is_site_public_access_enabled())
			{
			    $vuserid = ifempty($HTTP_VARS['userid'], 'guest'); // guest user account userid to access item_display
			    $vpasswd = ifempty($HTTP_VARS['passwd'], 'passwd');
			}
			
			echo get_last_num_items_block(
					$list_item_rs, 
					$vuserid,
					$vpasswd,
					FALSE, //$use_opendb_table_classes
					TRUE,//$item_display_popup
					1, //$columns
					get_site_url()); //$site_url_prefix
					
			echo("</MARQUEE>");
		}
	}
	else
	{
		session_start(); 
		if (is_opendb_valid_session())
		{
			// You have to change the $owner_id, $s_item_type and number of items parameters.
			$list_item_rs = get_last_num_items_rs(
								$CONFIG_VARS['last_items_list.total_num_items'],// number of items to return
								NULL, //owner_id 
								NULL, // s_item_type
								NULL, //update_on
								NULL); // not_owner_id
			
			echo _theme_header($LANG_VARS['last_items_list']);
			echo('<h2>'.$LANG_VARS['last_items_list'].'</h2>');
				
			if(is_not_empty_array($list_item_rs))
			{
				echo get_last_num_items_block(
					$list_item_rs, 
					NULL, // guest user account userid to access item_display
					NULL, // guest user account passwd to access item_display
					TRUE, //$use_opendb_table_classes
					FALSE,//$item_display_popup
					$CONFIG_VARS['last_items_list.items_per_column'], //$columns
					NULL); //$site_url_prefix
			}
			else
			{
				echo("<div class=\"error\"><b>".$LANG_VARS['no_records_found']."</b></div>");
			}
		
			echo _theme_footer();
		}
		else
		{
			// invalid login, so login instead.
			include("./login.php");
		}
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
