<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/utils.php");

//
// This php file contains functions for updating item_attribute records.
//

/**
	Checks that the $s_attribute_type actually exists
*/
function is_exists_attribute_type($s_attribute_type)
{
	$query = "SELECT 'x' FROM s_attribute_type WHERE s_attribute_type = '".$s_attribute_type."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
* Check to see if s_item_type has at least one site_type
* specific s_item_attribute_record attached.
*/
function is_exists_site_item_attribute($site_type, $item_r)
{
	$query = "SELECT 'X' ".
			"FROM s_attribute_type sit, ".
			"	item_attribute ia ".
			"WHERE ia.s_attribute_type = sit.s_attribute_type AND ".
			"ia.item_id = '".$item_r['item_id']."' AND ".
			"sit.site_type = '".$site_type."'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Return a resultset of all lookup columns for the s_attribute_type

	@param s_attribute_type If this parameter is not defined (or FALSE), then
	all s_attribute_type_lookup records will be returned.  The select statement
	will also include s_attribute_type in this case.

	NOTE: If you want to use a '' (empty) option in your lookups, you must be
	sure that it will be encountered before any checked indicator option.
	
	@param $order_by
		order_no
		value
		display 
	
	The $order_by parameter will be ignored if $s_attribute_type is not specified.
*/
function fetch_attribute_type_lookup_rs($s_attribute_type=NULL, $order_by='value', $order='asc')
{
	if(strlen($s_attribute_type)==0)
		$query = "SELECT value, IF(LENGTH(display)>0,display,value) as display, img, checked_ind, s_attribute_type FROM s_attribute_type_lookup ORDER BY s_attribute_type $order";
	else
		$query = "SELECT value, IF(LENGTH(display)>0,display,value) as display, img, checked_ind FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."' ORDER BY order_no, $order_by $order";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
	This one selects FULL records from the table.
*/
function fetch_s_attribute_type_lookup_rs($s_attribute_type, $order_by = 'value', $order = 'asc')
{
	global $CONFIG_VARS;

	$query = "SELECT value, display, img, checked_ind, order_no FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."'";
	
	if(strlen($order_by)>0)
	{
		$query .= " ORDER BY order_no, $order_by $order";
	}
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_value_match_attribute_type_lookup_rs($s_attribute_type, $value_array, $order_by='value', $order='asc')
{
	$query = "SELECT value, IF(LENGTH(display)>0,display,value) as display, img, checked_ind ".
			"FROM s_attribute_type_lookup ".
			"WHERE s_attribute_type = '".$s_attribute_type."' AND value IN (".format_sql_in_clause($value_array).") ".
			"ORDER BY order_no, $order_by $order";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
	Return s_attribute_type_lookup record for the specified $s_attribute_type and $value
	parameters.
*/
function fetch_attribute_type_lookup_r($s_attribute_type, $value, $column=NULL)
{
	$query = "SELECT value, if(length(display)>0,display,value) as display, img FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."' AND value = '$value'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);

		if($column != NULL)
			return $found[$column];
		else
			return $found;
	}
	else
		return FALSE;
}

/**
* @param $value - if empty, query will not be executed, because it will
* cause unpredictable results.
*/
function fetch_exists_attribute_type_lookup_value($s_attribute_type, $value)
{
	if(strlen($value)>0)
	{
		$query = "SELECT value FROM s_attribute_type_lookup "
				."WHERE s_attribute_type = '".$s_attribute_type."' AND "
				."LOWER(value) = '".strtolower($value)."' OR LOWER(display) = '".strtolower($value)."'";

		$result = run_opendb_query($query);
		if($result && mysql_num_rows($result)>0)
		{
	    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
			mysql_free_result($result);
			return $found['value'];
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}
}

/*
* Check if value exists in s_attribute_type_lookup table, for specified
* s_attribute_type.
*/
function is_exists_lookup_value($s_attribute_type, $attribute_val)
{
	$query = "SELECT 'x' FROM s_attribute_type_lookup WHERE s_attribute_type = '$s_attribute_type' AND ".
			"value = '".addslashes($attribute_val)."' LIMIT 0,1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

function is_lookup_attribute_type($s_attribute_type)
{
	$query = "SELECT 'x' FROM s_attribute_type_lookup WHERE s_attribute_type = '$s_attribute_type' LIMIT 0,1";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		return TRUE;
	}

	//else
	return FALSE;
}

/**
	Returns a list of all s_attribute_types linked to a s_item_type.  Will return
	resultset ordered by s_item_attribute_type.order_no.

	Records consist of the following columns: s_attribute_type, order_no, prompt, input_type, compulsory_ind
	
	@param $s_item_type
	@param $order_by	- if 's_attribute_type' order by s_attribute_type.  if 'prompt'. $all_columns must
						be TRUE, otherwise SQL will be invalid.
	@param $all_columns
	@param $distinct
	
*/
function fetch_item_attribute_type_rs($s_item_type, $order_by = FALSE, $all_columns = FALSE, $distinct = FALSE)
{
	$query =
		"select".($distinct?" DISTINCT ":" ")."siat.s_attribute_type,".
       			"siat.order_no,".
				"UPPER(sat.s_field_type) as s_field_type";

	if($all_columns)
	{
		$query .= ",if(length(siat.prompt)>0,siat.prompt,sat.prompt) as prompt,".
				"sat.prompt as sat_prompt, ". // Return plain s_attribute_type prompt as well.
				"sat.description,".		      // For use in search.php primarily!
				"sat.display_type,".
				"sat.input_type,".
				"sat.display_type,".
				"siat.compulsory_ind";
	}
					
	$query .= " from s_item_attribute_type siat,".
				"s_attribute_type sat ".
		"where	siat.s_item_type = '".$s_item_type."' and ".
				"sat.s_attribute_type = siat.s_attribute_type ";
	
	if($distinct)
		$query .= "group by sat.s_attribute_type ";

	if(is_string($order_by))
	{
		switch($order_by)
		{
			case 's_attribute_type':
				$query .= "order by siat.s_attribute_type ASC";
				break;
			
			case 'prompt':
				// not supported unless all_columns, otherwise will result in SQL error.
				if($all_columns)
					$query .= "order by prompt ASC";
				break;
		}
	}
	else if($order_by === TRUE)
	{
		$query .= "order by siat.order_no ASC";
	}

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
    	return $result;
	else
		return FALSE;
}

/*
 * Return an array with attribute_val and prompt for the specified item_attribute
 * 
 * This function will return FALSE if the item_attribute does not exist.
 * 
 * Primarily used in item_display.php to display cover images.
 * 
 * NOTE: Does not support lookup attribute types
 */
function fetch_siat_with_prompt_and_val_r($s_item_type, $s_attribute_type, $order_no, $item_id)
{
	if(!is_lookup_attribute_type($s_attribute_type))
	{
		$query = "select siat.s_attribute_type, ".
			"siat.order_no, ".
			"sat.display_type, ".
			"if(length(siat.prompt)>0,siat.prompt,sat.prompt) as prompt, ".
			"ia.attribute_val ".
			"FROM	s_item_attribute_type siat,".
			"s_attribute_type sat, ".
			"item_attribute ia ".
			"WHERE siat.s_item_type = '$s_item_type' AND ".
			"siat.s_attribute_type = sat.s_attribute_type AND ".
			"siat.s_attribute_type = ia.s_attribute_type AND ".
			"siat.order_no = ia.order_no AND ".
			"ia.s_attribute_type = '$s_attribute_type' AND ".
			"ia.order_no = '$order_no' AND ".
			"ia.item_id = '$item_id'";

		$result = run_opendb_query($query);
		if($result && mysql_num_rows($result)>0)
		{
	    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
			mysql_free_result($result);
			return $found;
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		// does not support lookup attribute values
		return FALSE;
	}
}

/*
* Fetch 
*/
function fetch_s_item_type_attr_prompt($s_item_type, $s_attribute_type, $order_no=NULL)
{
	$query = "select if(length(siat.prompt)>0,siat.prompt,sat.prompt) as prompt ".
			"FROM s_item_attribute_type siat,".
			"s_attribute_type sat ".
			"WHERE siat.s_item_type = '$s_item_type' AND ".
			"siat.s_attribute_type = sat.s_attribute_type AND ".
			"sat.s_attribute_type = '$s_attribute_type' ";
			
	if(is_numeric($order_no))
		$query .= "AND sat.order_no = '$order_no' ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['prompt'];
	}
	else
		return FALSE;		
}

function fetch_s_attribute_type_prompt($s_attribute_type)
{
	$query = "select sat.prompt ".
			"FROM s_attribute_type sat ".
			"WHERE sat.s_attribute_type = '$s_attribute_type'";
			
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['prompt'];
	}
	else
		return FALSE;		
}

function fetch_s_attribute_type_display_type($s_attribute_type)
{
	$query = "select sat.display_type ".
			"FROM s_attribute_type sat ".
			"WHERE sat.s_attribute_type = '$s_attribute_type'";
			
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['display_type'];
	}
	else
		return FALSE;		
}

function fetch_s_item_attribute_type_next_order_no($s_item_type, $s_attribute_type, $order_no = NULL)
{
	$query ="SELECT order_no ".
			"FROM 	s_item_attribute_type ".
			"WHERE 	s_item_type = '$s_item_type' AND ".
			"		s_attribute_type = '$s_attribute_type' ";
			
	if(is_numeric($order_no))
	{	
		$query .= " AND	order_no > $order_no ";
	}
	
	$query .= "ORDER BY order_no ASC LIMIT 0,1";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['order_no'];
	}
	else
		return FALSE;		
}

//
// Get s_attribute_type record: s_attribute_type,prompt,description,input_type
//
function fetch_attribute_type_r($s_attribute_type)
{
	$query =
		"SELECT s_attribute_type,".
				"prompt,".
				"description,". 
                "input_type,".
                "display_type, ".
				"s_field_type ".
		"FROM	s_attribute_type ".
        "WHERE	s_attribute_type = '".$s_attribute_type."'";
 
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_attribute_type_cnt($s_attribute_type)
{
	$query = "SELECT count('x') as count FROM s_attribute_type_lookup WHERE s_attribute_type = '".$s_attribute_type."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!==FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
	Will return the attribute_val for the record, or FALSE if no found.
	
	Note: $s_attribute_type should be UPPERCASE
*/
function fetch_attribute_val($item_id, $s_attribute_type, $order_no = NULL)
{
	// select lookup_attribute_val as last resort.
	$query = "SELECT IFNULL(attribute_val,lookup_attribute_val) as attribute_val FROM item_attribute ".
    		"WHERE item_id = '$item_id' and ".
            	"s_attribute_type = '$s_attribute_type'";

	// Only add order_no where condition if order_no defined, otherwise we
	// will return the first instance of s_attribute_type.
	if(is_numeric($order_no))
		$query .= " AND order_no = '$order_no'";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['attribute_val'];
	}
	else
	{
		return FALSE;
	}
}

/**
* Return an array of ALL lookup_attribute_val for a $s_attribute_type / $order_no
* combo.
*/
function fetch_lookup_attribute_val_r($item_id, $s_attribute_type, $order_no = NULL)
{
	$query = "SELECT lookup_attribute_val FROM item_attribute ".
    		"WHERE item_id = '$item_id' and ".
            	"s_attribute_type = '$s_attribute_type'";

	// Only add order_no where condition if order_no defined, otherwise we
	// will return the first instance of s_attribute_type.
	if(is_numeric($order_no))
		$query .= " AND order_no = '$order_no'";

	$results = run_opendb_query($query);
	if($results && mysql_num_rows($results)>0)
	{
		$lookup_val_r = NULL;
		while($lookup_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$lookup_val_r[] = $lookup_r['lookup_attribute_val'];
		}
		
		mysql_free_result($results);
		return $lookup_val_r;
	}
	else
	{
		return FALSE;
	}
}

/**
	Will return a s_attribute_type_lookup record for a particular
	item_attribute.  You should only use this for fields populated
	by single_select, group_grid, etc.
	
	NOTE: Returns a single row only 

	@param $column One of 'value', 'img', or 'display'
*/
function fetch_sattr_type_lookup_for_item_attr($item_id, $s_attribute_type, $column = NULL)
{
	$query = "SELECT	satl.value, satl.img, if(length(satl.display)>0,satl.display,satl.value) as display ".
			"FROM		s_attribute_type_lookup satl,".
          	"			item_attribute ia ".
			"WHERE		ia.s_attribute_type = satl.s_attribute_type AND ".
			"			ia.lookup_attribute_val = satl.value AND ".
			"			ia.item_id = '$item_id' AND ".
			"			ia.s_attribute_type = '$s_attribute_type' ".
			"LIMIT 0,1";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if($column != NULL)
			return $found[$column];
		else
			return $found;
	}
	else
		return FALSE;
}

/**
	Will return a resultset of all s_item_type's that have the
	specified category s_attribute_type with a s_field_type of
	'CATEGORY'
*/
function fetch_category_itemtype_rs($s_attribute_type)
{
	$query = "SELECT DISTINCT siat.s_item_type FROM s_item_attribute_type siat, s_attribute_type sat WHERE siat.s_attribute_type = sat.s_attribute_type AND siat.s_attribute_type = '$s_attribute_type' AND sat.s_field_type = 'CATEGORY'"; 

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
    	return $result;
	else
		return FALSE;
}

//
// Give us a count of how many attributes are set for the item_id
//
function fetch_item_attribute_cnt($item_id)
{
	$query = "SELECT count(*) as count FROM item_attribute WHERE item_id = '".$item_id."'";
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!==FALSE)
			return $found['count'];
	}

	//else
	return FALSE;
}

/**
* If item_id has a item_attribure recorded for the $s_attribute_type and optional
* order_no, this function returns TRUE, otherwise it returns FALSE.
*/
function is_item_attribute_set($item_id, $s_attribute_type, $order_no=NULL)
{
	// Only load previous record if edit.
	$query = "SELECT count('x') as count FROM item_attribute ".
    		"WHERE item_id = '".$item_id."' and ".
            	"s_attribute_type = '".$s_attribute_type."' ";

	// Only add order_no where condition if order_no defined, otherwise we
	// will return the first instance of s_attribute_type.
	if(is_numeric($order_no))
		$query .= "and order_no = '".$order_no."'";
    
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		if ($found!==FALSE && $found['count']>0)
			return TRUE;
	}
	else
		return FALSE;
}

// Insert a item_attribute record.  Assumes that it does not already exist!
// 
// If successful will return TRUE, otherwise will return FALSE.
//
function insert_item_attribute($item_id, $s_attribute_type, $order_no, $attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	$attribute_val = addslashes(replace_newlines(trim($attribute_val)));
	
	$query = "INSERT INTO item_attribute (item_id, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
			"VALUES ('$item_id','$s_attribute_type','$order_no','','$attribute_val')";
			
	$insert = run_opendb_query($query);
	if ($insert && mysql_affected_rows() > 0)
	{
		opendb_log("Inserted item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to insert item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

/**
* If successful will return TRUE, otherwise will return FALSE.
* 
* @param $lookup_attribute_val_r - must be an array, otherwise will not be processed.
* 
* NOTE: Assumes that is_lookup_attribute_type check has been completed.
*/
function insert_lookup_item_attributes($item_id, $s_attribute_type, $order_no, $lookup_attribute_val_r)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES item_attribute WRITE"))
	{
		for($i=0; $i<count($lookup_attribute_val_r); $i++)
		{
			$lookup_attribute_val = addslashes($lookup_attribute_val_r[$i]);
	
			$query = "INSERT INTO item_attribute (item_id, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
				"VALUES ('$item_id','$s_attribute_type','$order_no','$lookup_attribute_val',NULL)";
				
			$insert = run_opendb_query($query);
			if ($insert && mysql_affected_rows() > 0)
			{
				opendb_log("Inserted lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			}
			else
			{
				opendb_log("Failed to insert lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
					
				run_opendb_query("UNLOCK TABLES");
				return FALSE;
			}
		}
			
		run_opendb_query("UNLOCK TABLES");
		return TRUE;
	}
	else
	{
		opendb_log("Could not lock item_attribute table for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

/**
* @param $attribute_val
*/
function update_item_attribute($item_id, $s_attribute_type, $order_no, $attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	$attribute_val = addslashes(replace_newlines(trim($attribute_val)));
	
	$query = "UPDATE item_attribute set attribute_val = '$attribute_val' ".
			 "WHERE item_id = '".$item_id."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
	$update = run_opendb_query($query);

	// We should not treat updates that were not actually updated because value did not change as failures.
	$rows_affected = mysql_affected_rows();
	if ($rows_affected !== -1)
	{
		if($rows_affected>0)
			opendb_log("Updated item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to update item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id']."). [".mysql_error()."]");
		return FALSE;
	}
}

/**
* If successful will return TRUE, otherwise will return FALSE.
* 
* @param $lookup_attribute_val_r - must be an array, otherwise will not be processed.
* 
* NOTE: Assumes that is_lookup_attribute_type check has been completed.
*/
function update_lookup_item_attributes($item_id, $s_attribute_type, $order_no, $lookup_attribute_val_r)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES item_attribute WRITE"))
	{
		// lets get a list of the current attributes for the item_id, s_attribute_type and order_no
		$query = "SELECT lookup_attribute_val FROM item_attribute WHERE item_id='".$item_id."' AND s_attribute_type = '".$s_attribute_type."' AND order_no = '".$order_no."'";
		$results = run_opendb_query($query);
		if($results)
		{
			while($item_attribute_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$lookup_key = array_search2($item_attribute_r['lookup_attribute_val'], $lookup_attribute_val_r, TRUE);
				if($lookup_key !== FALSE)
				{
					// Remove the matched element
					array_splice($lookup_attribute_val_r, $lookup_key, 1);
				}
				else
				{
					delete_lookup_item_attribute($item_id, $s_attribute_type, $order_no, $item_attribute_r['lookup_attribute_val']);
				}
			}
		}
			
		for($i=0; $i<count($lookup_attribute_val_r); $i++)
		{
			$lookup_attribute_val = addslashes($lookup_attribute_val_r[$i]);
			
			$query = "INSERT INTO item_attribute (item_id, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
				"VALUES ('$item_id','$s_attribute_type','$order_no','$lookup_attribute_val',NULL)";
				
			$insert = run_opendb_query($query);
			if ($insert && mysql_affected_rows() > 0)
			{
				opendb_log("Inserted lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			}
			else
			{
				opendb_log("Failed to insert lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
					
				run_opendb_query("UNLOCK TABLES");
				return FALSE;
			}
		}
		
		run_opendb_query("UNLOCK TABLES");
		return TRUE;
		
	}//if(run_opendb_query("LOCK TABLES item_attribute WRITE"))
	else
	{
		opendb_log("Could not lock item_attribute table for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return TRUE, otherwise will return FALSE.
//
function delete_item_attribute($item_id, $s_attribute_type, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM item_attribute ".
			 "WHERE item_id = '".$item_id."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
	$delete = run_opendb_query($query);
	// Even if no attributes were deleted, because there were none, this should still return true.
	if ( $delete )
	{
		opendb_log("Deleted item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

function delete_lookup_item_attribute($item_id, $s_attribute_type, $order_no, $lookup_attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM item_attribute ".
			 "WHERE item_id = '".$item_id."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."' AND lookup_attribute_val = '".$lookup_attribute_val."'";
	$delete = run_opendb_query($query);
	// Even if no attributes were deleted, because there were none, this should still return true.
	if ( $delete )
	{
		opendb_log("Deleted lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete lookup item attribute (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

/**
* 
*/
function delete_lookup_item_attributes($item_id, $s_attribute_type, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM item_attribute ".
			 "WHERE item_id = '".$item_id."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
	$delete = run_opendb_query($query);
	// Even if no attributes were deleted, because there were none, this should still return true.
	if ( $delete )
	{
		opendb_log("Deleted lookup item attributes (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete lookup item attributes (item_id=$item_id, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return TRUE, otherwise will return FALSE.
//
function delete_item_attributes($item_id)
{
	global $HTTP_SESSION_VARS;
	
	if(is_numeric($item_id))
	{
		$query = "DELETE FROM item_attribute ".
			 "WHERE item_id = '".$item_id."'";
		$delete = run_opendb_query($query);
	
		// Even if no attributes were deleted, because there were none, this should still return true.
		if( $delete )
		{
			opendb_log("Deleted ".mysql_affected_rows()." item attribute(s) (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return TRUE;
		}
		else
		{
			opendb_log("Failed to delete item attributes (item_id=$item_id, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		// invalid $item_id supplied.
		return FALSE;
	}
}
?>
