#
# Query if any Item records exist without matching Item_Instance (excluding linked items of course)
#
# Since MYSQL 3.23.XX does not support MINUS, we must resort to something a bit more
# messy - but equally effective (but probably not as afficient!)
#
SELECT COUNT(i.id) 
FROM item i
LEFT JOIN item_instance ii ON i.id = ii.item_id
WHERE ii.item_id IS NULL AND i.parent_id IS NULL
