<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/item_type.php");
include_once("./functions/item_type_group.php");

function display_s_item_type_group_row($item_type_group_r, $row)
{
	echo("\n<tr>");

	if(is_not_empty_array($item_type_group_r))
	{
		echo("<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">");
		echo("<td class=\"data\">".get_input_field("s_item_type_group[$row]", NULL, "Item Type Group", "readonly", "Y", $item_type_group_r['s_item_type_group'], FALSE)."</td>");
	}		
	else
	{
		echo("<input type=hidden name=\"exists_ind[$row]\" value=\"N\">");
		echo ("\n<td class=\"data\">".get_input_field("s_item_type_group[$row]", NULL, "Item Type Group", "text(10,10)", "Y", NULL, FALSE)."</td>");
	}
	
	echo("<td class=\"data\">".get_input_field("description[$row]", NULL, "Description", "text(30,255)", 'Y', $item_type_group_r['description'], FALSE)."</td>");
	echo("<td class=\"data\">".get_input_field("system_ind[$row]", NULL, "System Indicator", "value_radio_grid('Y,N',*)", 'Y', $item_type_group_r['system_ind'], FALSE)."</td>");

	echo("\n<td class=\"data\">&nbsp;");	
	if(is_not_empty_array($item_type_group_r))
	{
		echo("<input type=button onclick=\"".
			"document.forms['navigate']['s_item_type_group'].value=this.form['s_item_type_group[$row]'].value;".
			"document.forms['navigate'].op.value='edit_item_type_group_rltshps'; document.forms['navigate'].submit();\" value=\"Edit\">");
			
		echo("&nbsp;<input type=button onclick=\"".
			"document.forms['navigate']['s_item_type_group'].value=this.form['s_item_type_group[$row]'].value;".
			"document.forms['navigate'].op.value='delete_item_type_group'; document.forms['navigate'].submit();\" value=\"Delete\">");
	}
	echo("\n</td>");
	echo("</tr>");
}

function display_s_item_type_group_rltshp_row($item_type_group_rltshp_r, $row)
{
	echo("\n<tr>");
	if(is_not_empty_array($item_type_group_rltshp_r))
	{
		echo("<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">");
		echo("<td class=\"data\">".get_input_field("s_item_type[$row]", NULL, "Item Type", "readonly", "Y", $item_type_group_rltshp_r['s_item_type'], FALSE)."</td>");
	}		
	else
	{
		echo("<input type=hidden name=\"exists_ind[$row]\" value=\"N\">");
		
		$item_types[] = '';
		
		$results = fetch_item_type_rs();
		if($results)
		{
			while($item_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$item_types[] = $item_type_r['s_item_type'];
			}
			mysql_free_result($results);
		}
		echo ("\n<td class=\"data\">".format_field(NULL, NULL, custom_select("s_item_type[$row]", $item_types, "%value%", 1, $item_type_group_r['s_item_type']), FALSE)."</td>");
	}
	
	echo("\n<td class=\"data\">&nbsp;");	
	if(is_not_empty_array($item_type_group_rltshp_r))
	{
		echo("&nbsp;<input type=button onclick=\"".
			"document.forms['navigate']['s_item_type'].value=this.form['s_item_type[$row]'].value;".
			"document.forms['navigate'].op.value='delete_item_type_group_rltshp'; document.forms['navigate'].submit();\" value=\"Delete\">");
	}
	echo("\n</td>");
		
	echo("</tr>");
}

if (is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if(strlen($HTTP_VARS['op'])==0)
			$HTTP_VARS['op'] = 'edit_item_type_groups';
		
		if($HTTP_VARS['op'] == 'delete_item_type_group')
		{
			$item_type_group_r = fetch_item_type_group_r($HTTP_VARS['s_item_type_group']);
			if(is_not_empty_array($item_type_group_r))
			{
				if($HTTP_VARS['confirmed'] == 'false')
				{
					// return to edit form
					$HTTP_VARS['op'] = 'edit_item_type_groups';
				}
				else
				{
					if($HTTP_VARS['confirmed'] != 'true')
					{
						echo "<h3>Delete Item Type Group</h3>";
						
						echo get_op_confirm_form(
										$PHP_SELF, 
										'Are you sure you want to delete Item Type Group '.$HTTP_VARS['s_item_type_group'].'?',
										$HTTP_VARS);
					}
					else// $HTTP_VARS['confirmed'] == 'true'
					{
						if(delete_s_item_type_group_rltshp($HTTP_VARS['s_item_type_group']))
						{
							if(!delete_s_item_type_group($HTTP_VARS['s_item_type_group']))
								$errors[] = array('error'=>'Item Type Group not deleted','detail'=>mysql_error());
						}
						else
						{
							$errors[] = array('error'=>'Item Type Group not deleted','detail'=>mysql_error());
						}

						$HTTP_VARS['op'] = 'edit_item_type_groups';
					}
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type Group not found');
				$HTTP_VARS['op'] = 'edit_item_type_groups';
			}
		}
		else if($HTTP_VARS['op'] == 'delete_item_type_group_rltshp')
		{
			$item_type_group_r = fetch_item_type_group_r($HTTP_VARS['s_item_type_group']);
			if(is_not_empty_array($item_type_group_r))
			{
				if(strlen($HTTP_VARS['s_item_type'])>0)
				{
					if($HTTP_VARS['confirmed'] == 'false')
					{
						// return to edit form
						$HTTP_VARS['op'] = 'edit_item_type_group_rltshps';
					}
					else
					{
						if($HTTP_VARS['confirmed'] != 'true')
						{
							echo "<h3>Delete ".$HTTP_VARS['s_item_type_group']." Item Type Group Relationship</h3>";
							
							echo get_op_confirm_form(
											$PHP_SELF, 
											'Are you sure you want to delete Item Type Group Relationship '.$HTTP_VARS['s_item_type'].'?',
											$HTTP_VARS);
						}
						else// $HTTP_VARS['confirmed'] == 'true'
						{
							if(!delete_s_item_type_group_rltshp($HTTP_VARS['s_item_type_group'], $HTTP_VARS['s_item_type']))
								$errors[] = array('error'=>'Item Type Group Relationship not deleted','detail'=>mysql_error());
	
							$HTTP_VARS['op'] = 'edit_item_type_group_rltshps';
						}
					}
				}
				else
				{
					$errors[] = array('error'=>'Item Type Group Relationship not found');
					$HTTP_VARS['op'] = 'edit_item_type_group_rltshps';
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type Group not found');
				$HTTP_VARS['op'] = 'edit_item_type_groups';
			}
		}
		else if($HTTP_VARS['op'] == 'update_item_type_groups')
		{
			if(is_not_empty_array($HTTP_VARS['exists_ind']))
			{
				for($i=0; $i<count($HTTP_VARS['exists_ind']); $i++)
				{
					if(strlen($HTTP_VARS['s_item_type_group'][$i])>0 && strlen($HTTP_VARS['description'][$i])>0)
					{
						if($HTTP_VARS['exists_ind'][$i] == 'N')
						{
							$HTTP_VARS['s_item_type_group'][$i] = strtoupper(preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['s_item_type_group'][$i]))));
							if(!insert_s_item_type_group($HTTP_VARS['s_item_type_group'][$i], $HTTP_VARS['description'][$i], ifempty($HTTP_VARS['system_ind'][$i], 'N')))
								$errors[] = array('error'=>'Item Type Group not inserted','detail'=>mysql_error());
						}
						else
						{
							if(!update_s_item_type_group($HTTP_VARS['s_item_type_group'][$i], $HTTP_VARS['description'][$i], ifempty($HTTP_VARS['system_ind'][$i], 'N')))
								$errors[] = array('error'=>'Item Type Group not updated','detail'=>mysql_error());
						}
					}
				}
			}
			
			$HTTP_VARS['op'] = 'edit_item_type_groups';
		}
		else if($HTTP_VARS['op'] == 'update_item_type_group_rltshps')
		{
			$item_type_group_r = fetch_item_type_group_r($HTTP_VARS['s_item_type_group']);
			if(is_not_empty_array($item_type_group_r))
			{
				if(is_not_empty_array($HTTP_VARS['exists_ind']))
				{
					for($i=0; $i<count($HTTP_VARS['exists_ind']); $i++)
					{
						if($HTTP_VARS['exists_ind'][$i] == 'N')
						{
							if(is_exists_item_type($HTTP_VARS['s_item_type'][$i]))
							{
								if(!insert_s_item_type_group_rltshp($HTTP_VARS['s_item_type_group'], $HTTP_VARS['s_item_type'][$i]))
									$errors[] = array('error'=>'Item Type Group Relationship not inserted','detail'=>mysql_error());
							}
						}
					}
				}
			}
			$HTTP_VARS['op'] = 'edit_item_type_group_rltshps';
		}
		
		if($HTTP_VARS['op'] == 'edit_item_type_groups')
		{
			if(is_not_empty_array($errors))
				echo format_error_block($errors);
				
			echo("<table cellspacing=2 border=0>");
				
			echo("\n<form name=\"navigate\" action=\"$PHP_SELF\" method=\"get\">".
					"\n<input type=\"hidden\" name=\"type\" value=\"".$ADMIN_TYPE."\">".
					"\n<input type=\"hidden\" name=\"op\" value=\"".$HTTP_VARS['op']."\">".
					"\n<input type=\"hidden\" name=\"s_item_type_group\" value=\"\">".
					"\n</form>");
						
			echo("\n<form name=\"s_item_type_group\" action=\"$PHP_SELF\" method=\"post\">");
			echo("\n<input type=\"hidden\" name=\"op\" value=\"".$HTTP_VARS['op']."\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$ADMIN_TYPE."\">");
				
				echo("\n<tr>"
					."\n<td class=\"navbar\">Group</td>"
					."\n<td class=\"navbar\">Description</td>"
					."\n<td class=\"navbar\">System<br>Indicator</td>"
					."\n<td class=\"navbar\">&nbsp;</td>"
					."\n</tr>");	
				$column_count = 4;
		
				$results = fetch_s_item_type_group_rs();
				if($results)
				{
					$row = 0;
					while($item_type_group_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						display_s_item_type_group_row($item_type_group_r, $row);
		
						$row++;
					}
					mysql_free_result($results);
				}
				
				if(is_numeric($HTTP_VARS['blank_rows']))
					$blank_rows = (int)$HTTP_VARS['blank_rows'];
				else
					$blank_rows = 5;
		
				for($i=$row; $i<$row+$blank_rows; $i++)
				{
					display_s_item_type_group_row(array(), $i);	
				}
		
				echo("<tr>");
				echo("<td colspan=1 align=center>".
					get_input_field("blank_rows", NULL, NULL, "value_select(\"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20\",1)", "N", ifempty($HTTP_VARS['blank_rows'], "5"), FALSE, NULL, "this.form.submit();")
					."</td>");
		

				echo("<td colspan=".($column_count-1)." align=center><input type=button value=\"Refresh\" onclick=\"this.form['op'].value='".$HTTP_VARS['op']."'; this.form.submit();\">");
				echo("&nbsp;<input type=button value=\"Update\" onclick=\"this.form['op'].value='update_item_type_groups'; this.form.submit();\"></td>");
				echo("</tr>");
		
				echo("</form>");
				echo("</table>");
				
				echo(format_help_block($_FORM_HELP));
		}
		else if($HTTP_VARS['op'] == 'edit_item_type_group_rltshps')
		{
			$item_type_group_r = fetch_item_type_group_r($HTTP_VARS['s_item_type_group']);
			if(is_not_empty_array($item_type_group_r))
			{
				echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=$ADMIN_TYPE&op=edit_item_type_groups\">Back to Item Type Group List</a>]</div>");
				echo("\n<h3>Edit ".$HTTP_VARS['s_item_type_group']." Item Type Group Relationships</h3>");
				
				if(is_not_empty_array($errors))
					echo format_error_block($errors);
				
				echo("<table cellspacing=2 border=0>");
				
				echo("\n<form name=\"navigate\" action=\"$PHP_SELF\" method=\"get\">".
						"\n<input type=\"hidden\" name=\"type\" value=\"".$ADMIN_TYPE."\">".
						"\n<input type=\"hidden\" name=\"op\" value=\"".$HTTP_VARS['op']."\">".
						"\n<input type=\"hidden\" name=\"s_item_type\" value=\"\">".
						"\n<input type=\"hidden\" name=\"s_item_type_group\" value=\"".$HTTP_VARS['s_item_type_group']."\">".
						"\n</form>");
						
				echo("\n<form name=\"editform\" action=\"$PHP_SELF\" method=\"post\">");
				echo("\n<input type=\"hidden\" name=\"op\" value=\"".$HTTP_VARS['op']."\">");
				echo("\n<input type=\"hidden\" name=\"type\" value=\"".$ADMIN_TYPE."\">");
				echo("\n<input type=\"hidden\" name=\"s_item_type_group\" value=\"".$HTTP_VARS['s_item_type_group']."\">");
				
				echo("\n<tr>"
					."\n<td class=\"navbar\">Item Type</td>"
					."\n<td class=\"navbar\">&nbsp;</td>"
					."\n</tr>");	
				$column_count = 2;
		
				$results = fetch_s_item_type_group_rltshp_rs($HTTP_VARS['s_item_type_group']);
				if($results)
				{
					$row = 0;
					while($item_type_group_rltshp_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						display_s_item_type_group_rltshp_row($item_type_group_rltshp_r, $row);
		
						$row++;
					}
					mysql_free_result($results);
				}
				
				if(is_numeric($HTTP_VARS['blank_rows']))
					$blank_rows = (int)$HTTP_VARS['blank_rows'];
				else
					$blank_rows = 5;
		
				for($i=$row; $i<$row+$blank_rows; $i++)
				{
					display_s_item_type_group_rltshp_row(array(), $i);	
				}
		
				echo("<tr>");
				echo("<td colspan=1 align=center>".
					get_input_field("blank_rows", NULL, NULL, "value_select(\"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20\",1)", "N", ifempty($HTTP_VARS['blank_rows'], "5"), FALSE, NULL, "this.form.submit();")
					."</td>");
		
				echo("<td colspan=".($column_count-1)." align=center><input type=button value=\"Refresh\" onclick=\"this.form['op'].value='".$HTTP_VARS['op']."'; this.form.submit();\">");
				echo("&nbsp;<input type=button value=\"Update\" onclick=\"this.form['op'].value='update_item_type_group_rltshps'; this.form.submit();\"></td>");
				echo("</tr>");
		
				echo("</form>");
				echo("</table>");
			}
		}
	}
}
?>