// DisplayAnimationView.h : interface of the CDisplayAnimationView3D class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DISPLAYANIMATIONVIEW3D_H__79840E88_1001_11D2_B8C1_0000F87A77C1_3D_INCLUDED_)
#define AFX_DISPLAYANIMATIONVIEW3D_H__79840E88_1001_11D2_B8C1_0000F87A77C1_3D_INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "DisplayAnimationDoc.h"
#include "..\..\Common\res\OCC_Resource.h"


class CDisplayAnimationView3D : public CView
{
protected: // create from serialization only
	CDisplayAnimationView3D();
	DECLARE_DYNCREATE(CDisplayAnimationView3D)

// Attributes
public:
	CDisplayAnimationDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDisplayAnimationView3D)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate(); // CasCade
	protected:

	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDisplayAnimationView3D();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CDisplayAnimationView3D)
	afx_msg void OnBUTTONAxo();
	afx_msg void OnBUTTONBack();
	afx_msg void OnBUTTONBottom();
	afx_msg void OnBUTTONFront();
	afx_msg void OnBUTTONHlrOff();
	afx_msg void OnBUTTONHlrOn();
	afx_msg void OnBUTTONLeft();
	afx_msg void OnBUTTONPan();
	afx_msg void OnBUTTONPanGlo();
	afx_msg void OnBUTTONReset();
	afx_msg void OnBUTTONRight();
	afx_msg void OnBUTTONRot();
	afx_msg void OnBUTTONTop();
	afx_msg void OnBUTTONZoomAll();
    afx_msg void OnFileExportImage();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBUTTONZoomProg();
	afx_msg void OnBUTTONZoomWin();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnUpdateBUTTONHlrOff(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONHlrOn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONPanGlo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONPan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomProg(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomWin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONRot(CCmdUI* pCmdUI);

	afx_msg void OnChangeBackground();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	
public :
	afx_msg void OnStop();
	afx_msg void OnRestart();
protected:

	DECLARE_MESSAGE_MAP()
private:
	Handle_V3d_View     myView;
public:
	Handle_V3d_View&    GetView() { return myView;};
private:
    CurrentAction3d      myCurrentMode;
    Standard_Integer     myXmin;
    Standard_Integer     myYmin;  
    Standard_Integer     myXmax;
    Standard_Integer     myYmax;
    Quantity_Factor      myCurZoom;
    Standard_Boolean     myDegenerateModeIsOn;

private:
	enum LineStyle { Solid, Dot, ShortDash, LongDash, Default };
	CPen*  m_Pen;
    virtual void DrawRectangle (const Standard_Integer  MinX  ,
    					        const Standard_Integer  MinY  ,
                                const Standard_Integer  MaxX  ,
				    	        const Standard_Integer  MaxY  ,
					            const Standard_Boolean  Draw  ,
                                const LineStyle aLineStyle = Default  );
};

#ifndef _DEBUG  // debug version in DisplayAnimationView.cpp
inline CDisplayAnimationDoc* CDisplayAnimationView3D::GetDocument()
   { return (CDisplayAnimationDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DISPLAYANIMATIONVIEW3D_H__79840E88_1001_11D2_B8C1_0000F87A77C1_3D_INCLUDED_)
