// File:	StepToGeom_MakeAxis2Placement.cxx
// Created:	Thu Jul  1 16:41:35 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
// sln 22.10.2001. CTS23496: If problems with creation of direction occur default direction is used (StepToGeom_MakeAxis2Placement(...) function)

#include <StepToGeom_MakeAxis2Placement.ixx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <StepToGeom_MakeDirection.hxx>
#include <Geom_CartesianPoint.hxx>
#include <Geom_Direction.hxx>
#include <gp_Pnt.hxx>
#include <gp_Dir.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Axis2Placement de Geom a partir d' un axis2_placement_3d
// de Step
//=============================================================================

StepToGeom_MakeAxis2Placement::StepToGeom_MakeAxis2Placement
  ( const Handle(StepGeom_Axis2Placement3d)& A)
{
  Handle(StepGeom_CartesianPoint) P1;
  Handle(StepGeom_Direction)      V1,V2;
  Handle(Geom_CartesianPoint)  P;
  Handle(Geom_Direction)       N,Vx;
  gp_Pnt                       Pgp;
  gp_Dir                       Ngp,Vxgp;
  gp_Ax2                       gpAx2;

  P1 = A->Location();
  StepToGeom_MakeCartesianPoint MkPoint(P1);
  P = MkPoint.Value();
  Pgp = P->Pnt();
  
  // sln 22.10.2001. CTS23496: If problems with creation of direction occur default direction is used (StepToGeom_MakeLine(...) function)
  Standard_Boolean isDefaultDirectionUsed = Standard_True;
  if (A->HasAxis()) {
    V1 = A->Axis();
    StepToGeom_MakeDirection MkDir(V1);
    if(MkDir.IsDone()) {
      N  = MkDir.Value();
      Ngp = N->Dir();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    Ngp = gp_Dir(0.,0.,1.);
  
  isDefaultDirectionUsed = Standard_True;
  if (A->HasRefDirection()) {
    V2 = A->RefDirection();
    StepToGeom_MakeDirection MkDir(V2);
    if(MkDir.IsDone()) {
      Vx = MkDir.Value();
      Vxgp = Vx->Dir();
      gpAx2 = gp_Ax2(Pgp, Ngp, Vxgp);
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    gpAx2 = gp_Ax2(Pgp, Ngp);
  
  theAxis2Placement = new Geom_Axis2Placement(gpAx2);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Axis2Placement) &
      StepToGeom_MakeAxis2Placement::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theAxis2Placement;
}
