/***********************************************************************

     FONCTION :
     ----------
        File OpenGl_text :
 

     REMARQUES:
     ---------- 
      

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       xx-xx-xx : xxx ; Creation.
       05-03-96 : FMN ; Suppression code inutile:
       01-04-96 : CAL ; Integration MINSK portage WNT
       29-04-96 : FMN ; correction warning de compilation.
       21-10-96 : FMN ; Suppression LMC_COLOR fait dans OpenGl_execstruct.c
       30-11-98 : FMN ; S4069 : Textes toujours visibles
       02.14.100 : JR : Warnings on WNT truncations from double to float
       21.06.03 : SAN : Suppress text display while in animation mode (TEXT_DEGENER)
       22.01.04 : SAN : Implement texture mapped fonts on WNT only (OCC2934)

************************************************************************/

/*----------------------------------------------------------------------*/
/*
 * Includes
 */ 

#ifndef WNT
#include <X11/Xlib.h>
#endif
#include <OpenGl_tgl_all.h>

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGl_cmn_varargs.h>
#include <OpenGl_cmn_memory.h>
#include <OpenGl_telem_attri.h>
#include <OpenGl_tsm.h>
#include <OpenGl_telem.h>
#include <OpenGl_telem_highlight.h>
#include <OpenGl_telem_inquire.h>
#include <OpenGl_tXfm.h>
#include <OpenGl_tgl_funcs.h>
#include <OpenGl_Extension.h>

#ifndef OCC2934
#define OCC2934 /* SAN 22/01/04 Texture mapped fonts on WNT */
#endif

#ifndef OCC7667
#define OCC7667 /* ASL - Export view content to vector format file */
#endif

/*----------------------------------------------------------------------*/
/*
 * Fonctions statiques
 */

static  TStatus  TextDisplay( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextAdd( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextDelete( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextPrint( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  TextInquire( TSM_ELEM_DATA, Tint, cmn_key* );

extern void glBlendEquationEXT (GLenum mode);

/*----------------------------------------------------------------------*/
/*
 * Constantes 
 */

#if defined(__osf__) || defined (__sun) || defined(__hp9000s700) || defined(WNT)
#undef GL_EXT_blend_logic_op
#endif

/*----------------------------------------------------------------------*/
/*
 * Variables statiques
 */

/*static GLboolean lighting_mode;*/

static  TStatus  (*MtdTbl[])( TSM_ELEM_DATA, Tint, cmn_key* ) =
{
    TextDisplay,
    TextDisplay,
    TextAdd,
    TextDelete,
    TextPrint,
    TextInquire
};

static GLboolean    init_extension = GL_FALSE;
static GLboolean    use_blend_logic_op = GL_FALSE;

extern GLuint fontBase;
extern GLuint printerFontBase;

#define TEXT_DEGENER

#ifdef TEXT_DEGENER
extern int    g_nDegenerateModel;
extern float  g_fSkipRatio;
#endif
/*
#if defined(OCC2934) && defined(WNT)
void putText( Tchar* data, Tfloat x, Tfloat y, Tfloat z )
#else
void putText( Tchar* data )
#endif
*/

void putText( Tchar* data, Tfloat x, Tfloat y, Tfloat z )
{
#ifndef WNT
    tXfmprstr( (unsigned char*) data, fontBase, x, y, z );
#else
    /* check if we're going to send text to a printer */
    if ( printerFontBase > 0 )
#ifndef OCC2934
        WNTPuts ( data, printerFontBase - 32 );
    else
        WNTPuts ( data, fontBase );
#else
        WNTPuts ( data, printerFontBase - 32, 0, x, y, z );
    else
        WNTPuts ( data, fontBase, 0, x, y, z );
#endif
#endif
}

/*----------------------------------------------------------------------*/

MtblPtr
TelTextInitClass( TelType* el )
{
    *el = TelText;
    return MtdTbl;
}

/*----------------------------------------------------------------------*/

static  TStatus
TextAdd( TSM_ELEM_DATA d, Tint n, cmn_key *k )
{
    Tint           i;
    TEL_POINT      def_pt = {{ ( float )0.0, ( float )0.0, ( float )0.0 }};
    tel_point      pt = &def_pt;
    tel_text_data  data;
    Tchar          *str="";

    for( i = 0; i < n; i++ )
    {
       switch( k[i]->id )
       {
	  case TEXT_ATTACH_PT_ID:
	     pt = k[i]->data.pdata;
	     break;
	  case TEXT_STRING_ID:
	     str = k[i]->data.pdata;
	     break;
       }
    }

    i = strlen(str) + 1;

    data = cmn_getmem( 1, offsetof(TEL_TEXT_DATA, data)
			  + i * sizeof(Tchar), 0 );
    if( !data )
	return TFailure;

    data->attach_pt = *pt;
    data->length    = i;
    cmn_memcpy( data->data, str, i );

    ((tsm_elem_data)(d.pdata))->pdata = data;

    return TSuccess;
}

/*----------------------------------------------------------------------*/

static  TStatus
TextDisplay( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    tel_text_data   d;
    CMN_KEY         key, key1;
    TEL_COLOUR      colour,  colours;
    int             style,  display_type;
    GLboolean       flag_zbuffer = GL_FALSE;
    GLboolean       blend_state = GL_FALSE; 
    GLint           sWidth, sAscent, sDescent;
    GLdouble        modelMatrix[16], projMatrix[16];
    GLint           viewport[4];
    GLdouble        objrefX, objrefY, objrefZ;
    GLdouble        objX, objY, objZ;
    GLdouble        obj1X, obj1Y, obj1Z;
    GLdouble        obj2X, obj2Y, obj2Z;
    GLdouble        obj3X, obj3Y, obj3Z;
    GLdouble        winx1, winy1, winz1;
    GLdouble        winx, winy, winz;
    GLint           status;

#ifdef TEXT_DEGENER
    if ( g_nDegenerateModel > 0 && g_fSkipRatio == 1. )
      return TSuccess;
#endif

    d = data.pdata;

    if( k[0]->id == TOn )
    {                           /* Use highlight colours */
        TEL_HIGHLIGHT  hrep;

        key.id = TelHighlightIndex;
        TsmGetAttri( 1, &key );
        if( TelGetHighlightRep( TglActiveWs, key.data.ldata, &hrep )
                                                             == TSuccess )
            colour = hrep.col;
        else
        {
            TelGetHighlightRep( TglActiveWs, 0, &hrep );
            colour = hrep.col;
        }
    }
    else
    {
        key.id = TelTextColour;
        key.data.pdata = &colour;
        TsmGetAttri( 1, &key );
    }
    
    key.id = TelTextStyle;
    key1.id = TelTextDisplayType;
    TsmGetAttri( 2, &key, &key1 );
    style = key.data.ldata;
    display_type = key1.data.ldata;

    /* style annotation */
    if (style == ASPECT_TOST_ANNOTATION)
    {
        flag_zbuffer = glIsEnabled(GL_DEPTH_TEST);
        if (flag_zbuffer) glDisable(GL_DEPTH_TEST);
    }
   
    /* display type of text */
    if (display_type != ASPECT_TODT_NORMAL)
    {
        key.id = TelTextColourSubTitle;
        key.data.pdata = &colours;
        TsmGetAttri( 1, &key );

        /* Optimisation: il faudrait ne faire le Get qu'une fois par Redraw */
        glGetIntegerv (GL_VIEWPORT, viewport);
        glGetDoublev (GL_MODELVIEW_MATRIX, modelMatrix);
        glGetDoublev (GL_PROJECTION_MATRIX, projMatrix);

        switch (display_type) {
            case ASPECT_TODT_BLEND:
#if defined(GL_EXT_blend_logic_op) 
                if (!init_extension)
                {
                    use_blend_logic_op = QueryExtension("GL_EXT_blend_logic_op");
                    init_extension = GL_TRUE;
                }
                if (use_blend_logic_op)
                {
                    blend_state = glIsEnabled(GL_BLEND);
                    if (!blend_state) glEnable(GL_BLEND);
                    glBlendEquationEXT(GL_LOGIC_OP);
                    glLogicOp(GL_XOR); 
                }
#else
		blend_state = glIsEnabled(GL_BLEND);
		if (!blend_state) glEnable(GL_BLEND);
		glEnable(GL_COLOR_LOGIC_OP);
		glLogicOp(GL_XOR); 
	        
#endif
		break;
	    case ASPECT_TODT_SUBTITLE:
		sizeString((char *)d->data, &sWidth, &sAscent, &sDescent);
		objrefX = (float)d->attach_pt.xyz[0];   
		objrefY = (float)d->attach_pt.xyz[1];   
		objrefZ = (float)d->attach_pt.xyz[2];
		status = gluProject (objrefX, objrefY, objrefZ, modelMatrix, projMatrix, viewport,
		    &winx1, &winy1, &winz1);
		
		winx = winx1;
		winy = winy1-sDescent;
		winz = winz1+0.00001;			
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&objX, &objY, &objZ);

		winx = winx1 + sWidth;
		winy = winy1-sDescent;
		winz = winz1+0.00001; /* il vaut mieux F+B / 1000000 ? */			
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&obj1X, &obj1Y, &obj1Z);
		
		winx = winx1 + sWidth;
		winy = winy1 + sAscent;
		winz = winz1+0.00001;			
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&obj2X, &obj2Y, &obj2Z);
		
		winx = winx1;
		winy = winy1+ sAscent;
		winz = winz1+0.00001;		
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&obj3X, &obj3Y, &obj3Z);

		glColor3fv( colours.rgb );
		glBegin(GL_POLYGON);
		glVertex3d(objX, objY, objZ);
		glVertex3d(obj1X, obj1Y, obj1Z);
		glVertex3d(obj2X, obj2Y, obj2Z);
		glVertex3d(obj3X, obj3Y, obj3Z);
		glEnd();
		break;
		
	    case ASPECT_TODT_DEKALE:
		objrefX = (float)d->attach_pt.xyz[0];   
		objrefY = (float)d->attach_pt.xyz[1];   
		objrefZ = (float)d->attach_pt.xyz[2];
		status = gluProject (objrefX, objrefY, objrefZ, modelMatrix, projMatrix, viewport,
		    &winx1, &winy1, &winz1);
		winx = winx1+1;
		winy = winy1+1;
		winz = winz1+0.00001;			
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&objX, &objY, &objZ);		    
		glColor3fv( colours.rgb );
/*
#if defined(OCC2934) && defined(WNT)
                putText( d->data, (float)objX, (float)objY,(float)objZ );
#else
		glRasterPos3f((float ) objX, (float ) objY, (float ) objZ);

		putText( d->data );
#endif
*/
                putText( d->data, (float)objX, (float)objY,(float)objZ );
		winx = winx1-1;
		winy = winy1-1;
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&objX, &objY, &objZ);
/*
#if defined(OCC2934) && defined(WNT)
                putText( d->data, (float)objX, (float)objY,(float)objZ );
#else                
		glRasterPos3f((float ) objX, (float ) objY, (float ) objZ);

		putText( d->data );
#endif
*/
                putText( d->data, (float)objX, (float)objY,(float)objZ );
		winx = winx1-1;
		winy = winy1+1;
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&objX, &objY, &objZ);	
/*
#if defined(OCC2934) && defined(WNT)
                putText( d->data, (float)objX, (float)objY,(float)objZ );
#else                
		glRasterPos3f((float ) objX, (float ) objY, (float ) objZ);

		putText( d->data );
#endif
*/
                putText( d->data, (float)objX, (float)objY,(float)objZ );
		winx = winx1+1;
		winy = winy1-1;
		status = gluUnProject (winx, winy, winz, modelMatrix, projMatrix, viewport,
			&objX, &objY, &objZ);
/*
#if defined(OCC2934) && defined(WNT)
                putText( d->data, (float)objX, (float)objY,(float)objZ );
#else                
		glRasterPos3f((float ) objX, (float ) objY, (float ) objZ);
		putText( d->data );
#endif
*/
                putText( d->data, (float)objX, (float)objY,(float)objZ );
		break;
	}
    }
     
    glColor3fv( colour.rgb );
/*
#if defined(OCC2934) && defined(WNT)
    putText( d->data, (float)d->attach_pt.xyz[0], (float)d->attach_pt.xyz[1],(float)d->attach_pt.xyz[2] );
#else
    glRasterPos3f( (float)d->attach_pt.xyz[0],  (float)d->attach_pt.xyz[1],  (float)d->attach_pt.xyz[2] );

    putText( d->data );
#endif
*/
    putText( d->data, (float)d->attach_pt.xyz[0], (float)d->attach_pt.xyz[1],(float)d->attach_pt.xyz[2] );
    /* maj attributs */   
    if (flag_zbuffer) glEnable(GL_DEPTH_TEST); 
    if (display_type == ASPECT_TODT_BLEND) 
    {
#if defined(GL_EXT_blend_logic_op) 
        if ((!blend_state) && (use_blend_logic_op)) glDisable(GL_BLEND);
#else
        if (!blend_state) glDisable(GL_BLEND);
        glDisable(GL_COLOR_LOGIC_OP);
#endif
    }
    
    return TSuccess;
}

/*----------------------------------------------------------------------*/

static  TStatus
TextDelete( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    cmn_freemem( data.pdata );
    return TSuccess;
}

/*----------------------------------------------------------------------*/

static  TStatus
TextPrint( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    tel_text_data p;

    p = data.pdata;

    fprintf( stdout, "TelText.\n" );
    fprintf( stdout, "\t\tString : %s\n", p->data );
    fprintf( stdout, "\t\tAttach Point : %f %f %f\n", p->attach_pt.xyz[0],
		  				      p->attach_pt.xyz[1],
						      p->attach_pt.xyz[2] );
    fprintf( stdout, "\n" );

    return TSuccess;
}

/*----------------------------------------------------------------------*/

static TStatus
TextInquire( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
   Tint          i;
   tel_text_data d;
   Tint          size_reqd=0;
   TStatus       status = TSuccess;

   d = data.pdata;

   size_reqd = d->length;

   for( i = 0; i < n; i++ )
   {
      switch( k[i]->id )
      {
         case INQ_GET_SIZE_ID:
         {
            k[i]->data.ldata = size_reqd;
            break;
         }

         case INQ_GET_CONTENT_ID:
         {
            TEL_INQ_CONTENT *c;
            Teldata         *w;

            c = k[i]->data.pdata;
            c->act_size = size_reqd;
            w = c->data;

	    if( c->size >= size_reqd )
            {
		w->atext3.string = c->buf;
                w->atext3.ref_pt = d->attach_pt;
		w->atext3.anno.xyz[0] = ( float )0.0;
		w->atext3.anno.xyz[1] = ( float )0.0;
		w->atext3.anno.xyz[2] = ( float )0.0;
		strcpy( w->atext3.string, d->data );
                status = TSuccess;
            }
	    else
                status = TFailure;
            break;
         }
      }
   }
   return status;
}

/*----------------------------------------------------------------------*/
