// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WNT_ImageManager_HeaderFile
#define _WNT_ImageManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WNT_ImageManager_HeaderFile
#include <Handle_WNT_ImageManager.hxx>
#endif

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _WNT_SequenceOfImage_HeaderFile
#include <WNT_SequenceOfImage.hxx>
#endif
#ifndef _WNT_TypeOfImage_HeaderFile
#include <WNT_TypeOfImage.hxx>
#endif
#ifndef _Handle_WNT_Image_HeaderFile
#include <Handle_WNT_Image.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _WNT_WindowPtr_HeaderFile
#include <WNT_WindowPtr.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
class WNT_Image;
class WNT_WDriver;
class WNT_Window;


//! This class defines image management <br>
class WNT_ImageManager : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a class instance <br>
Standard_EXPORT WNT_ImageManager(const WNT_WindowPtr& aWindow);

//! Deletes all resources associated with the class instance. <br>
Standard_EXPORT virtual  void Destroy() ;
~WNT_ImageManager()
{
  Destroy();
}


//! Sets image format for output. <br>
Standard_EXPORT   void SetFormat(const WNT_TypeOfImage aFormat = WNT_TOI_XWD) ;

//! Adds <anImage> to manager. <br>
Standard_EXPORT   void Add(const Handle(WNT_Image)& anImage) ;

//! returns Image stored at <anIndex>. <br>
Standard_EXPORT   Handle_WNT_Image Image(const Standard_Integer anIndex) ;

//! Loads image from file and returns its index in the <br>
//!          sequence. <br>
//!  Warning: Returns 0 if loading was failed. <br>
Standard_EXPORT   Standard_Integer Load(const Standard_CString aFileName) ;

//! Stories image to the file according to <myFormat> <br>
//!          class field. Returns True on success, otherwise <br>
//!          returns False. <br>
Standard_EXPORT   Standard_Boolean Save(const Standard_CString aFileName,const Standard_Integer aX,const Standard_Integer aY,const Standard_Integer aWidth,const Standard_Integer aHeight) const;

//! Stories contents of the double buffer window pixmap. <br>
//!          See "Save" method. <br>
Standard_EXPORT   Standard_Boolean SaveBuffer(const Standard_CString aFileName,const Standard_Integer aX,const Standard_Integer aY,const Standard_Integer aWidth,const Standard_Integer aHeight) const;

//! Displays the image according to the DoubleBuffer state <br>
//!          of the associated window. <br>
Standard_EXPORT   void Draw(const Standard_Integer anIndex,const Standard_Integer Xc,const Standard_Integer Yc,const Standard_Integer aWidth,const Standard_Integer aHeight,const Standard_Real anAngle = 0.0) ;

//! Deletes an image at index <anIndex>. <br>
Standard_EXPORT   void Delete(const Standard_Integer anIndex) ;

//! Places an image to the trash <br>
Standard_EXPORT   void Discard(const Standard_Integer anIndex) ;

//! Scales the specified image. <br>
Standard_EXPORT   Aspect_Handle Scale(const Standard_Integer anIndex,const Standard_Real aScaleX,const Standard_Real aScaleY,const Standard_Boolean aReplace = Standard_False) ;

//! Returns number of loaded images. <br>
Standard_EXPORT   Standard_Integer Size() const;

//! Returns image handle. <br>
Standard_EXPORT   Aspect_Handle ImageHandle(const Standard_Integer anIndex) ;

//! Returns image dimensions. <br>
Standard_EXPORT   void Dim(const Standard_Integer anIndex,Standard_Integer& aWidth,Standard_Integer& aHeight) ;

//! Returns image's hash code. <br>
Standard_EXPORT   Standard_Integer HashCode(const Standard_Integer anIndex) ;

//! Returns image's index. <br>
Standard_EXPORT   Standard_Integer Index(const Standard_Integer aHashCode) ;

//! Returns hash code of the string. <br>
Standard_EXPORT   Standard_Integer StringHashCode(const Standard_CString aString) ;

//! Creates new empty image and returns its index <br>
Standard_EXPORT   Standard_Integer Open(const Aspect_Handle aDC,const Standard_Integer aWidth,const Standard_Integer aHeight,const Standard_Integer aHashCode) ;


friend class WNT_WDriver;
friend class WNT_Window;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Address myWindow;
WNT_SequenceOfImage myImages;
WNT_SequenceOfImage myTrash;
WNT_TypeOfImage myFormat;
Handle_WNT_Image myLastImage;
Standard_Integer myLastIndex;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
