#ifndef _VOXEL_VISDATA_H_
#define _VOXEL_VISDATA_H_

#include <Quantity_Color.hxx>
#include <Quantity_HArray1OfColor.hxx>
#include <TShort_HArray1OfShortReal.hxx>
#include <TColStd_HArray1OfReal.hxx>
#include <TColgp_HArray1OfDir.hxx>
#include <Poly_Triangulation.hxx>

#include <Voxel_BoolDS.hxx>
#include <Voxel_ColorDS.hxx>
#include <Voxel_VoxelDisplayMode.hxx>

enum VoxelDirection
{
    None,
	Xminus,
	Xplus,
	Yminus,
	Yplus,
	Zminus,
	Zplus
};

typedef struct
{

	/* Display mode */
	Voxel_VoxelDisplayMode myDisplayMode;

    /* Range of displayed values */
    /* BoolDS */
    /* No range */
    /* ColorDS */
    unsigned char  myColorMinValue;
    unsigned char  myColorMaxValue;

    /* Range of displayed size */
    double         myDisplayedXMin;
    double         myDisplayedXMax;
    double         myDisplayedYMin;
    double         myDisplayedYMax;
    double         myDisplayedZMin;
    double         myDisplayedZMax;

	/* Colors */
	Quantity_Color myColor;
    Handle(Quantity_HArray1OfColor) myColors;

	/* Size, width... */
	double         myPointSize;
    int            myQuadrangleSize; /* 0% .. 100% */
    unsigned char  mySmoothPoints;

    /* Transparency */
    double         myTransparency;

    /* GL lists of each display mode */
    /* BoolDS */
    /* POINTS */
    int            myBoolPointsList;
    unsigned char  myBoolPointsFirst;
    /* NEAREST POINTS */
    int            myBoolNearestPointsList[7];
    unsigned char  myBoolNearestPointsFirst;
    /* ColorDS */
    /* POINTS */
    int            myColorPointsList;
    unsigned char  myColorPointsFirst;
    /* NEAREST POINTS */
    int            myColorNearestPointsList[7];
    unsigned char  myColorNearestPointsFirst;
    /* TRIANGULATION */
    int            myTriangulationList;
    /* Usage of GL lists */
    unsigned char  myUsageOfGLlists;

    /* Degenerate mode */
    unsigned char  myDegenerateMode;

    /* Highlighted voxel */
    int            myHighlightx;
    int            myHighlighty;
    int            myHighlightz;

} DisplayData;

typedef struct
{

	// Voxels
	Voxel_BoolDS*  myBoolVoxels;
	Voxel_ColorDS* myColorVoxels;

    // Triangulation
    Handle(Poly_Triangulation) myTriangulation;
    Handle(TColgp_HArray1OfDir) myNormalsOfNodes;

	// Display
	DisplayData    myDisplay;

} Voxel_VisData;

#endif // _VOXEL_VISDATA_H_
