// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_SplineSurface_HeaderFile
#define _IGESGeom_SplineSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_SplineSurface_HeaderFile
#include <Handle_IGESGeom_SplineSurface.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray2OfHArray1OfReal_HeaderFile
#include <Handle_IGESBasic_HArray2OfHArray1OfReal.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TColStd_HArray1OfReal;
class IGESBasic_HArray2OfHArray1OfReal;
class Standard_DimensionMismatch;
class Standard_OutOfRange;


//! defines IGESSplineSurface, Type <114> Form <0> <br>
//!          in package IGESGeom <br>
//!          A parametric spline surface is a grid of polynomial <br>
//!          patches. Patch could be of the type Linear, Quadratic, <br>
//!          Cubic, Wilson-Fowler, Modified Wilson-Fowler, B-Spline <br>
//!          The M * N grid of patches is defined by the 'u' break <br>
//!          points TU(1), TU(2), ..., TU(M+1) and the 'v' break <br>
//!          points TV(1), TV(2), TV(3) ..., TV(N+1). <br>
class IGESGeom_SplineSurface : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_SplineSurface();

//! This method is used to set the fields of the class <br>
//!           SplineSurface <br>
//!       - aBoundaryType   : Type of Spline boundary <br>
//!                           1 = Linear <br>
//!                           2 = Quadratic <br>
//!                           3 = Cubic <br>
//!                           4 = Wilson-Fowler <br>
//!                           5 = Modified Wilson-Fowler <br>
//!                           6 = B-spline <br>
//!       - aPatchType      : Type of patch contained in the grid <br>
//!                           1 = Cartesian Product <br>
//!                           0 = Unspecified <br>
//!       - allUBreakpoints : u values of grid lines <br>
//!       - allVBreakpoints : v values of grid lines <br>
//!       - allXCoeffs      : X coefficients of M x N patches <br>
//!       - allYCoeffs      : Y coefficients of M x N patches <br>
//!       - allZCoeffs      : Z coefficients of M x N patches <br>
//! raises exception if allXCoeffs, allYCoeffs & allZCoeffs are not <br>
//! of the same size. <br>
//! or if the size of each element of the double array is not 16 <br>
Standard_EXPORT   void Init(const Standard_Integer aBoundaryType,const Standard_Integer aPatchType,const Handle(TColStd_HArray1OfReal)& allUBreakpoints,const Handle(TColStd_HArray1OfReal)& allVBreakpoints,const Handle(IGESBasic_HArray2OfHArray1OfReal)& allXCoeffs,const Handle(IGESBasic_HArray2OfHArray1OfReal)& allYCoeffs,const Handle(IGESBasic_HArray2OfHArray1OfReal)& allZCoeffs) ;

//! returns the number of U segments <br>
Standard_EXPORT   Standard_Integer NbUSegments() const;

//! returns the number of V segments <br>
Standard_EXPORT   Standard_Integer NbVSegments() const;

//! returns boundary type <br>
Standard_EXPORT   Standard_Integer BoundaryType() const;

//! returns patch type <br>
Standard_EXPORT   Standard_Integer PatchType() const;

//! returns U break point of the grid line referred to by anIndex <br>
//! raises exception if anIndex <= 0 or anIndex > NbUSegments() + 1 <br>
Standard_EXPORT   Standard_Real UBreakPoint(const Standard_Integer anIndex) const;

//! returns V break point of the grid line referred to by anIndex <br>
//! raises exception if anIndex <= 0 or anIndex > NbVSegments() + 1 <br>
Standard_EXPORT   Standard_Real VBreakPoint(const Standard_Integer anIndex) const;

//! returns X polynomial of patch referred to by anIndex1, anIndex2 <br>
//! raises exception if anIndex1 <= 0 or anIndex1 > NbUSegments() <br>
//!                  or anIndex2 <= 0 or anIndex2 > NbVSegments() <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal XPolynomial(const Standard_Integer anIndex1,const Standard_Integer anIndex2) const;

//! returns Y polynomial of patch referred to by anIndex1, anIndex2 <br>
//! raises exception if anIndex1 <= 0 or anIndex1 > NbUSegments() <br>
//!                  or anIndex2 <= 0 or anIndex2 > NbVSegments() <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal YPolynomial(const Standard_Integer anIndex1,const Standard_Integer anIndex2) const;

//! returns Z polynomial of patch referred to by anIndex1, anIndex2 <br>
//! raises exception if anIndex1 <= 0 or anIndex1 > NbUSegments() <br>
//!                  or anIndex2 <= 0 or anIndex2 > NbVSegments() <br>
Standard_EXPORT   Handle_TColStd_HArray1OfReal ZPolynomial(const Standard_Integer anIndex1,const Standard_Integer anIndex2) const;

//! returns in one all the polynomial values "in bulk" <br>
//!           usefull for massive treatements <br>
Standard_EXPORT   void Polynomials(Handle(IGESBasic_HArray2OfHArray1OfReal)& XCoef,Handle(IGESBasic_HArray2OfHArray1OfReal)& YCoef,Handle(IGESBasic_HArray2OfHArray1OfReal)& ZCoef) const;
//Standard_EXPORT ~IGESGeom_SplineSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theBoundaryType;
Standard_Integer thePatchType;
Handle_TColStd_HArray1OfReal theUBreakPoints;
Handle_TColStd_HArray1OfReal theVBreakPoints;
Handle_IGESBasic_HArray2OfHArray1OfReal theXCoeffs;
Handle_IGESBasic_HArray2OfHArray1OfReal theYCoeffs;
Handle_IGESBasic_HArray2OfHArray1OfReal theZCoeffs;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
